/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorFiltersRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorFiltersResponse;
import software.amazon.awssdk.services.ec2.model.TrafficMirrorFilter;

public class DescribeTrafficMirrorFiltersIterable
implements SdkIterable<DescribeTrafficMirrorFiltersResponse> {
    private final Ec2Client client;
    private final DescribeTrafficMirrorFiltersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeTrafficMirrorFiltersIterable(Ec2Client client, DescribeTrafficMirrorFiltersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeTrafficMirrorFiltersResponseFetcher();
    }

    public Iterator<DescribeTrafficMirrorFiltersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TrafficMirrorFilter> trafficMirrorFilters() {
        Function<DescribeTrafficMirrorFiltersResponse, Iterator> getIterator = response -> {
            if (response != null && response.trafficMirrorFilters() != null) {
                return response.trafficMirrorFilters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeTrafficMirrorFiltersResponseFetcher
    implements SyncPageFetcher<DescribeTrafficMirrorFiltersResponse> {
        private DescribeTrafficMirrorFiltersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTrafficMirrorFiltersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeTrafficMirrorFiltersResponse nextPage(DescribeTrafficMirrorFiltersResponse previousPage) {
            if (previousPage == null) {
                return DescribeTrafficMirrorFiltersIterable.this.client.describeTrafficMirrorFilters(DescribeTrafficMirrorFiltersIterable.this.firstRequest);
            }
            return DescribeTrafficMirrorFiltersIterable.this.client.describeTrafficMirrorFilters((DescribeTrafficMirrorFiltersRequest)((Object)DescribeTrafficMirrorFiltersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

