/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeDhcpOptionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeDhcpOptionsResponse;
import software.amazon.awssdk.services.ec2.model.DhcpOptions;

public class DescribeDhcpOptionsPublisher
implements SdkPublisher<DescribeDhcpOptionsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeDhcpOptionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDhcpOptionsPublisher(Ec2AsyncClient client, DescribeDhcpOptionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDhcpOptionsPublisher(Ec2AsyncClient client, DescribeDhcpOptionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDhcpOptionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDhcpOptionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DhcpOptions> dhcpOptions() {
        Function<DescribeDhcpOptionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dhcpOptions() != null) {
                return response.dhcpOptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeDhcpOptionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeDhcpOptionsResponseFetcher
    implements AsyncPageFetcher<DescribeDhcpOptionsResponse> {
        private DescribeDhcpOptionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDhcpOptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeDhcpOptionsResponse> nextPage(DescribeDhcpOptionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDhcpOptionsPublisher.this.client.describeDhcpOptions(DescribeDhcpOptionsPublisher.this.firstRequest);
            }
            return DescribeDhcpOptionsPublisher.this.client.describeDhcpOptions((DescribeDhcpOptionsRequest)((Object)DescribeDhcpOptionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

