/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2InstanceConnectEndpointState;
import software.amazon.awssdk.services.ec2.model.NetworkInterfaceIdSetCopier;
import software.amazon.awssdk.services.ec2.model.SecurityGroupIdSetCopier;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Ec2InstanceConnectEndpoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Ec2InstanceConnectEndpoint> {
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(Ec2InstanceConnectEndpoint.getter(Ec2InstanceConnectEndpoint::ownerId)).setter(Ec2InstanceConnectEndpoint.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<String> INSTANCE_CONNECT_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceConnectEndpointId").getter(Ec2InstanceConnectEndpoint.getter(Ec2InstanceConnectEndpoint::instanceConnectEndpointId)).setter(Ec2InstanceConnectEndpoint.setter(Builder::instanceConnectEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceConnectEndpointId").unmarshallLocationName("instanceConnectEndpointId").build()}).build();
    private static final SdkField<String> INSTANCE_CONNECT_ENDPOINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceConnectEndpointArn").getter(Ec2InstanceConnectEndpoint.getter(Ec2InstanceConnectEndpoint::instanceConnectEndpointArn)).setter(Ec2InstanceConnectEndpoint.setter(Builder::instanceConnectEndpointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceConnectEndpointArn").unmarshallLocationName("instanceConnectEndpointArn").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(Ec2InstanceConnectEndpoint.getter(Ec2InstanceConnectEndpoint::stateAsString)).setter(Ec2InstanceConnectEndpoint.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<String> STATE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateMessage").getter(Ec2InstanceConnectEndpoint.getter(Ec2InstanceConnectEndpoint::stateMessage)).setter(Ec2InstanceConnectEndpoint.setter(Builder::stateMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateMessage").unmarshallLocationName("stateMessage").build()}).build();
    private static final SdkField<String> DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DnsName").getter(Ec2InstanceConnectEndpoint.getter(Ec2InstanceConnectEndpoint::dnsName)).setter(Ec2InstanceConnectEndpoint.setter(Builder::dnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsName").unmarshallLocationName("dnsName").build()}).build();
    private static final SdkField<String> FIPS_DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FipsDnsName").getter(Ec2InstanceConnectEndpoint.getter(Ec2InstanceConnectEndpoint::fipsDnsName)).setter(Ec2InstanceConnectEndpoint.setter(Builder::fipsDnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FipsDnsName").unmarshallLocationName("fipsDnsName").build()}).build();
    private static final SdkField<List<String>> NETWORK_INTERFACE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NetworkInterfaceIds").getter(Ec2InstanceConnectEndpoint.getter(Ec2InstanceConnectEndpoint::networkInterfaceIds)).setter(Ec2InstanceConnectEndpoint.setter(Builder::networkInterfaceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceIdSet").unmarshallLocationName("networkInterfaceIdSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(Ec2InstanceConnectEndpoint.getter(Ec2InstanceConnectEndpoint::vpcId)).setter(Ec2InstanceConnectEndpoint.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").unmarshallLocationName("vpcId").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(Ec2InstanceConnectEndpoint.getter(Ec2InstanceConnectEndpoint::availabilityZone)).setter(Ec2InstanceConnectEndpoint.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("availabilityZone").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(Ec2InstanceConnectEndpoint.getter(Ec2InstanceConnectEndpoint::createdAt)).setter(Ec2InstanceConnectEndpoint.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").unmarshallLocationName("createdAt").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(Ec2InstanceConnectEndpoint.getter(Ec2InstanceConnectEndpoint::subnetId)).setter(Ec2InstanceConnectEndpoint.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").unmarshallLocationName("subnetId").build()}).build();
    private static final SdkField<Boolean> PRESERVE_CLIENT_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PreserveClientIp").getter(Ec2InstanceConnectEndpoint.getter(Ec2InstanceConnectEndpoint::preserveClientIp)).setter(Ec2InstanceConnectEndpoint.setter(Builder::preserveClientIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreserveClientIp").unmarshallLocationName("preserveClientIp").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIds").getter(Ec2InstanceConnectEndpoint.getter(Ec2InstanceConnectEndpoint::securityGroupIds)).setter(Ec2InstanceConnectEndpoint.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIdSet").unmarshallLocationName("securityGroupIdSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(Ec2InstanceConnectEndpoint.getter(Ec2InstanceConnectEndpoint::tags)).setter(Ec2InstanceConnectEndpoint.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_ID_FIELD, INSTANCE_CONNECT_ENDPOINT_ID_FIELD, INSTANCE_CONNECT_ENDPOINT_ARN_FIELD, STATE_FIELD, STATE_MESSAGE_FIELD, DNS_NAME_FIELD, FIPS_DNS_NAME_FIELD, NETWORK_INTERFACE_IDS_FIELD, VPC_ID_FIELD, AVAILABILITY_ZONE_FIELD, CREATED_AT_FIELD, SUBNET_ID_FIELD, PRESERVE_CLIENT_IP_FIELD, SECURITY_GROUP_IDS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Ec2InstanceConnectEndpoint.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String ownerId;
    private final String instanceConnectEndpointId;
    private final String instanceConnectEndpointArn;
    private final String state;
    private final String stateMessage;
    private final String dnsName;
    private final String fipsDnsName;
    private final List<String> networkInterfaceIds;
    private final String vpcId;
    private final String availabilityZone;
    private final Instant createdAt;
    private final String subnetId;
    private final Boolean preserveClientIp;
    private final List<String> securityGroupIds;
    private final List<Tag> tags;

    private Ec2InstanceConnectEndpoint(BuilderImpl builder) {
        this.ownerId = builder.ownerId;
        this.instanceConnectEndpointId = builder.instanceConnectEndpointId;
        this.instanceConnectEndpointArn = builder.instanceConnectEndpointArn;
        this.state = builder.state;
        this.stateMessage = builder.stateMessage;
        this.dnsName = builder.dnsName;
        this.fipsDnsName = builder.fipsDnsName;
        this.networkInterfaceIds = builder.networkInterfaceIds;
        this.vpcId = builder.vpcId;
        this.availabilityZone = builder.availabilityZone;
        this.createdAt = builder.createdAt;
        this.subnetId = builder.subnetId;
        this.preserveClientIp = builder.preserveClientIp;
        this.securityGroupIds = builder.securityGroupIds;
        this.tags = builder.tags;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final String instanceConnectEndpointId() {
        return this.instanceConnectEndpointId;
    }

    public final String instanceConnectEndpointArn() {
        return this.instanceConnectEndpointArn;
    }

    public final Ec2InstanceConnectEndpointState state() {
        return Ec2InstanceConnectEndpointState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String stateMessage() {
        return this.stateMessage;
    }

    public final String dnsName() {
        return this.dnsName;
    }

    public final String fipsDnsName() {
        return this.fipsDnsName;
    }

    public final boolean hasNetworkInterfaceIds() {
        return this.networkInterfaceIds != null && !(this.networkInterfaceIds instanceof SdkAutoConstructList);
    }

    public final List<String> networkInterfaceIds() {
        return this.networkInterfaceIds;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final Boolean preserveClientIp() {
        return this.preserveClientIp;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceConnectEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceConnectEndpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.fipsDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkInterfaceIds() ? this.networkInterfaceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.preserveClientIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ec2InstanceConnectEndpoint)) {
            return false;
        }
        Ec2InstanceConnectEndpoint other = (Ec2InstanceConnectEndpoint)obj;
        return Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.instanceConnectEndpointId(), other.instanceConnectEndpointId()) && Objects.equals(this.instanceConnectEndpointArn(), other.instanceConnectEndpointArn()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateMessage(), other.stateMessage()) && Objects.equals(this.dnsName(), other.dnsName()) && Objects.equals(this.fipsDnsName(), other.fipsDnsName()) && this.hasNetworkInterfaceIds() == other.hasNetworkInterfaceIds() && Objects.equals(this.networkInterfaceIds(), other.networkInterfaceIds()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.preserveClientIp(), other.preserveClientIp()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"Ec2InstanceConnectEndpoint").add("OwnerId", (Object)this.ownerId()).add("InstanceConnectEndpointId", (Object)this.instanceConnectEndpointId()).add("InstanceConnectEndpointArn", (Object)this.instanceConnectEndpointArn()).add("State", (Object)this.stateAsString()).add("StateMessage", (Object)this.stateMessage()).add("DnsName", (Object)this.dnsName()).add("FipsDnsName", (Object)this.fipsDnsName()).add("NetworkInterfaceIds", this.hasNetworkInterfaceIds() ? this.networkInterfaceIds() : null).add("VpcId", (Object)this.vpcId()).add("AvailabilityZone", (Object)this.availabilityZone()).add("CreatedAt", (Object)this.createdAt()).add("SubnetId", (Object)this.subnetId()).add("PreserveClientIp", (Object)this.preserveClientIp()).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "InstanceConnectEndpointId": {
                return Optional.ofNullable(clazz.cast(this.instanceConnectEndpointId()));
            }
            case "InstanceConnectEndpointArn": {
                return Optional.ofNullable(clazz.cast(this.instanceConnectEndpointArn()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StateMessage": {
                return Optional.ofNullable(clazz.cast(this.stateMessage()));
            }
            case "DnsName": {
                return Optional.ofNullable(clazz.cast(this.dnsName()));
            }
            case "FipsDnsName": {
                return Optional.ofNullable(clazz.cast(this.fipsDnsName()));
            }
            case "NetworkInterfaceIds": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceIds()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "PreserveClientIp": {
                return Optional.ofNullable(clazz.cast(this.preserveClientIp()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("InstanceConnectEndpointId", INSTANCE_CONNECT_ENDPOINT_ID_FIELD);
        map.put("InstanceConnectEndpointArn", INSTANCE_CONNECT_ENDPOINT_ARN_FIELD);
        map.put("State", STATE_FIELD);
        map.put("StateMessage", STATE_MESSAGE_FIELD);
        map.put("DnsName", DNS_NAME_FIELD);
        map.put("FipsDnsName", FIPS_DNS_NAME_FIELD);
        map.put("NetworkInterfaceIdSet", NETWORK_INTERFACE_IDS_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("PreserveClientIp", PRESERVE_CLIENT_IP_FIELD);
        map.put("SecurityGroupIdSet", SECURITY_GROUP_IDS_FIELD);
        map.put("TagSet", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Ec2InstanceConnectEndpoint, T> g) {
        return obj -> g.apply((Ec2InstanceConnectEndpoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ownerId;
        private String instanceConnectEndpointId;
        private String instanceConnectEndpointArn;
        private String state;
        private String stateMessage;
        private String dnsName;
        private String fipsDnsName;
        private List<String> networkInterfaceIds = DefaultSdkAutoConstructList.getInstance();
        private String vpcId;
        private String availabilityZone;
        private Instant createdAt;
        private String subnetId;
        private Boolean preserveClientIp;
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Ec2InstanceConnectEndpoint model) {
            this.ownerId(model.ownerId);
            this.instanceConnectEndpointId(model.instanceConnectEndpointId);
            this.instanceConnectEndpointArn(model.instanceConnectEndpointArn);
            this.state(model.state);
            this.stateMessage(model.stateMessage);
            this.dnsName(model.dnsName);
            this.fipsDnsName(model.fipsDnsName);
            this.networkInterfaceIds(model.networkInterfaceIds);
            this.vpcId(model.vpcId);
            this.availabilityZone(model.availabilityZone);
            this.createdAt(model.createdAt);
            this.subnetId(model.subnetId);
            this.preserveClientIp(model.preserveClientIp);
            this.securityGroupIds(model.securityGroupIds);
            this.tags(model.tags);
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getInstanceConnectEndpointId() {
            return this.instanceConnectEndpointId;
        }

        public final void setInstanceConnectEndpointId(String instanceConnectEndpointId) {
            this.instanceConnectEndpointId = instanceConnectEndpointId;
        }

        @Override
        public final Builder instanceConnectEndpointId(String instanceConnectEndpointId) {
            this.instanceConnectEndpointId = instanceConnectEndpointId;
            return this;
        }

        public final String getInstanceConnectEndpointArn() {
            return this.instanceConnectEndpointArn;
        }

        public final void setInstanceConnectEndpointArn(String instanceConnectEndpointArn) {
            this.instanceConnectEndpointArn = instanceConnectEndpointArn;
        }

        @Override
        public final Builder instanceConnectEndpointArn(String instanceConnectEndpointArn) {
            this.instanceConnectEndpointArn = instanceConnectEndpointArn;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(Ec2InstanceConnectEndpointState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateMessage() {
            return this.stateMessage;
        }

        public final void setStateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
        }

        @Override
        public final Builder stateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
            return this;
        }

        public final String getDnsName() {
            return this.dnsName;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final String getFipsDnsName() {
            return this.fipsDnsName;
        }

        public final void setFipsDnsName(String fipsDnsName) {
            this.fipsDnsName = fipsDnsName;
        }

        @Override
        public final Builder fipsDnsName(String fipsDnsName) {
            this.fipsDnsName = fipsDnsName;
            return this;
        }

        public final Collection<String> getNetworkInterfaceIds() {
            if (this.networkInterfaceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.networkInterfaceIds;
        }

        public final void setNetworkInterfaceIds(Collection<String> networkInterfaceIds) {
            this.networkInterfaceIds = NetworkInterfaceIdSetCopier.copy(networkInterfaceIds);
        }

        @Override
        public final Builder networkInterfaceIds(Collection<String> networkInterfaceIds) {
            this.networkInterfaceIds = NetworkInterfaceIdSetCopier.copy(networkInterfaceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaceIds(String ... networkInterfaceIds) {
            this.networkInterfaceIds(Arrays.asList(networkInterfaceIds));
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final Boolean getPreserveClientIp() {
            return this.preserveClientIp;
        }

        public final void setPreserveClientIp(Boolean preserveClientIp) {
            this.preserveClientIp = preserveClientIp;
        }

        @Override
        public final Builder preserveClientIp(Boolean preserveClientIp) {
            this.preserveClientIp = preserveClientIp;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdSetCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdSetCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Ec2InstanceConnectEndpoint build() {
            return new Ec2InstanceConnectEndpoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Ec2InstanceConnectEndpoint> {
        public Builder ownerId(String var1);

        public Builder instanceConnectEndpointId(String var1);

        public Builder instanceConnectEndpointArn(String var1);

        public Builder state(String var1);

        public Builder state(Ec2InstanceConnectEndpointState var1);

        public Builder stateMessage(String var1);

        public Builder dnsName(String var1);

        public Builder fipsDnsName(String var1);

        public Builder networkInterfaceIds(Collection<String> var1);

        public Builder networkInterfaceIds(String ... var1);

        public Builder vpcId(String var1);

        public Builder availabilityZone(String var1);

        public Builder createdAt(Instant var1);

        public Builder subnetId(String var1);

        public Builder preserveClientIp(Boolean var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

