/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.PerformanceFactorReference;
import software.amazon.awssdk.services.ec2.model.PerformanceFactorReferenceSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CpuPerformanceFactor
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CpuPerformanceFactor> {
    private static final SdkField<List<PerformanceFactorReference>> REFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("References").getter(CpuPerformanceFactor.getter(CpuPerformanceFactor::references)).setter(CpuPerformanceFactor.setter(Builder::references)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceSet").unmarshallLocationName("referenceSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PerformanceFactorReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REFERENCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CpuPerformanceFactor.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<PerformanceFactorReference> references;

    private CpuPerformanceFactor(BuilderImpl builder) {
        this.references = builder.references;
    }

    public final boolean hasReferences() {
        return this.references != null && !(this.references instanceof SdkAutoConstructList);
    }

    public final List<PerformanceFactorReference> references() {
        return this.references;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReferences() ? this.references() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CpuPerformanceFactor)) {
            return false;
        }
        CpuPerformanceFactor other = (CpuPerformanceFactor)obj;
        return this.hasReferences() == other.hasReferences() && Objects.equals(this.references(), other.references());
    }

    public final String toString() {
        return ToString.builder((String)"CpuPerformanceFactor").add("References", this.hasReferences() ? this.references() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "References": {
                return Optional.ofNullable(clazz.cast(this.references()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<PerformanceFactorReference>>> map = new HashMap<String, SdkField<List<PerformanceFactorReference>>>();
        map.put("ReferenceSet", REFERENCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CpuPerformanceFactor, T> g) {
        return obj -> g.apply((CpuPerformanceFactor)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<PerformanceFactorReference> references = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CpuPerformanceFactor model) {
            this.references(model.references);
        }

        public final List<PerformanceFactorReference.Builder> getReferences() {
            List<PerformanceFactorReference.Builder> result = PerformanceFactorReferenceSetCopier.copyToBuilder(this.references);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReferences(Collection<PerformanceFactorReference.BuilderImpl> references) {
            this.references = PerformanceFactorReferenceSetCopier.copyFromBuilder(references);
        }

        @Override
        public final Builder references(Collection<PerformanceFactorReference> references) {
            this.references = PerformanceFactorReferenceSetCopier.copy(references);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder references(PerformanceFactorReference ... references) {
            this.references(Arrays.asList(references));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder references(Consumer<PerformanceFactorReference.Builder> ... references) {
            this.references(Stream.of(references).map(c -> (PerformanceFactorReference)((PerformanceFactorReference.Builder)PerformanceFactorReference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CpuPerformanceFactor build() {
            return new CpuPerformanceFactor(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CpuPerformanceFactor> {
        public Builder references(Collection<PerformanceFactorReference> var1);

        public Builder references(PerformanceFactorReference ... var1);

        public Builder references(Consumer<PerformanceFactorReference.Builder> ... var1);
    }
}

