/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CapacityReservationFleet;
import software.amazon.awssdk.services.ec2.model.CapacityReservationFleetSetCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCapacityReservationFleetsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeCapacityReservationFleetsResponse> {
    private static final SdkField<List<CapacityReservationFleet>> CAPACITY_RESERVATION_FLEETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CapacityReservationFleets").getter(DescribeCapacityReservationFleetsResponse.getter(DescribeCapacityReservationFleetsResponse::capacityReservationFleets)).setter(DescribeCapacityReservationFleetsResponse.setter(Builder::capacityReservationFleets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationFleetSet").unmarshallLocationName("capacityReservationFleetSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CapacityReservationFleet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeCapacityReservationFleetsResponse.getter(DescribeCapacityReservationFleetsResponse::nextToken)).setter(DescribeCapacityReservationFleetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_RESERVATION_FLEETS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeCapacityReservationFleetsResponse.memberNameToFieldInitializer();
    private final List<CapacityReservationFleet> capacityReservationFleets;
    private final String nextToken;

    private DescribeCapacityReservationFleetsResponse(BuilderImpl builder) {
        super(builder);
        this.capacityReservationFleets = builder.capacityReservationFleets;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCapacityReservationFleets() {
        return this.capacityReservationFleets != null && !(this.capacityReservationFleets instanceof SdkAutoConstructList);
    }

    public final List<CapacityReservationFleet> capacityReservationFleets() {
        return this.capacityReservationFleets;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapacityReservationFleets() ? this.capacityReservationFleets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCapacityReservationFleetsResponse)) {
            return false;
        }
        DescribeCapacityReservationFleetsResponse other = (DescribeCapacityReservationFleetsResponse)((Object)obj);
        return this.hasCapacityReservationFleets() == other.hasCapacityReservationFleets() && Objects.equals(this.capacityReservationFleets(), other.capacityReservationFleets()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeCapacityReservationFleetsResponse").add("CapacityReservationFleets", this.hasCapacityReservationFleets() ? this.capacityReservationFleets() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CapacityReservationFleets": {
                return Optional.ofNullable(clazz.cast(this.capacityReservationFleets()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CapacityReservationFleetSet", CAPACITY_RESERVATION_FLEETS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeCapacityReservationFleetsResponse, T> g) {
        return obj -> g.apply((DescribeCapacityReservationFleetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<CapacityReservationFleet> capacityReservationFleets = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCapacityReservationFleetsResponse model) {
            super(model);
            this.capacityReservationFleets(model.capacityReservationFleets);
            this.nextToken(model.nextToken);
        }

        public final List<CapacityReservationFleet.Builder> getCapacityReservationFleets() {
            List<CapacityReservationFleet.Builder> result = CapacityReservationFleetSetCopier.copyToBuilder(this.capacityReservationFleets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapacityReservationFleets(Collection<CapacityReservationFleet.BuilderImpl> capacityReservationFleets) {
            this.capacityReservationFleets = CapacityReservationFleetSetCopier.copyFromBuilder(capacityReservationFleets);
        }

        @Override
        public final Builder capacityReservationFleets(Collection<CapacityReservationFleet> capacityReservationFleets) {
            this.capacityReservationFleets = CapacityReservationFleetSetCopier.copy(capacityReservationFleets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityReservationFleets(CapacityReservationFleet ... capacityReservationFleets) {
            this.capacityReservationFleets(Arrays.asList(capacityReservationFleets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityReservationFleets(Consumer<CapacityReservationFleet.Builder> ... capacityReservationFleets) {
            this.capacityReservationFleets(Stream.of(capacityReservationFleets).map(c -> (CapacityReservationFleet)((CapacityReservationFleet.Builder)CapacityReservationFleet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeCapacityReservationFleetsResponse build() {
            return new DescribeCapacityReservationFleetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCapacityReservationFleetsResponse> {
        public Builder capacityReservationFleets(Collection<CapacityReservationFleet> var1);

        public Builder capacityReservationFleets(CapacityReservationFleet ... var1);

        public Builder capacityReservationFleets(Consumer<CapacityReservationFleet.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

