/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.OperatorRequest;
import software.amazon.awssdk.services.ec2.model.RequestLaunchTemplateData;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLaunchTemplateRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateLaunchTemplateRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(CreateLaunchTemplateRequest.getter(CreateLaunchTemplateRequest::dryRun)).setter(CreateLaunchTemplateRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateLaunchTemplateRequest.getter(CreateLaunchTemplateRequest::clientToken)).setter(CreateLaunchTemplateRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> LAUNCH_TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LaunchTemplateName").getter(CreateLaunchTemplateRequest.getter(CreateLaunchTemplateRequest::launchTemplateName)).setter(CreateLaunchTemplateRequest.setter(Builder::launchTemplateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateName").unmarshallLocationName("LaunchTemplateName").build()}).build();
    private static final SdkField<String> VERSION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionDescription").getter(CreateLaunchTemplateRequest.getter(CreateLaunchTemplateRequest::versionDescription)).setter(CreateLaunchTemplateRequest.setter(Builder::versionDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionDescription").unmarshallLocationName("VersionDescription").build()}).build();
    private static final SdkField<RequestLaunchTemplateData> LAUNCH_TEMPLATE_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LaunchTemplateData").getter(CreateLaunchTemplateRequest.getter(CreateLaunchTemplateRequest::launchTemplateData)).setter(CreateLaunchTemplateRequest.setter(Builder::launchTemplateData)).constructor(RequestLaunchTemplateData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateData").unmarshallLocationName("LaunchTemplateData").build()}).build();
    private static final SdkField<OperatorRequest> OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Operator").getter(CreateLaunchTemplateRequest.getter(CreateLaunchTemplateRequest::operator)).setter(CreateLaunchTemplateRequest.setter(Builder::operator)).constructor(OperatorRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").unmarshallLocationName("Operator").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreateLaunchTemplateRequest.getter(CreateLaunchTemplateRequest::tagSpecifications)).setter(CreateLaunchTemplateRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, CLIENT_TOKEN_FIELD, LAUNCH_TEMPLATE_NAME_FIELD, VERSION_DESCRIPTION_FIELD, LAUNCH_TEMPLATE_DATA_FIELD, OPERATOR_FIELD, TAG_SPECIFICATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateLaunchTemplateRequest.memberNameToFieldInitializer();
    private final Boolean dryRun;
    private final String clientToken;
    private final String launchTemplateName;
    private final String versionDescription;
    private final RequestLaunchTemplateData launchTemplateData;
    private final OperatorRequest operator;
    private final List<TagSpecification> tagSpecifications;

    private CreateLaunchTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.clientToken = builder.clientToken;
        this.launchTemplateName = builder.launchTemplateName;
        this.versionDescription = builder.versionDescription;
        this.launchTemplateData = builder.launchTemplateData;
        this.operator = builder.operator;
        this.tagSpecifications = builder.tagSpecifications;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String launchTemplateName() {
        return this.launchTemplateName;
    }

    public final String versionDescription() {
        return this.versionDescription;
    }

    public final RequestLaunchTemplateData launchTemplateData() {
        return this.launchTemplateData;
    }

    public final OperatorRequest operator() {
        return this.operator;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplateData());
        hashCode = 31 * hashCode + Objects.hashCode(this.operator());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLaunchTemplateRequest)) {
            return false;
        }
        CreateLaunchTemplateRequest other = (CreateLaunchTemplateRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.launchTemplateName(), other.launchTemplateName()) && Objects.equals(this.versionDescription(), other.versionDescription()) && Objects.equals(this.launchTemplateData(), other.launchTemplateData()) && Objects.equals(this.operator(), other.operator()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLaunchTemplateRequest").add("DryRun", (Object)this.dryRun()).add("ClientToken", (Object)this.clientToken()).add("LaunchTemplateName", (Object)this.launchTemplateName()).add("VersionDescription", (Object)this.versionDescription()).add("LaunchTemplateData", (Object)this.launchTemplateData()).add("Operator", (Object)this.operator()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "LaunchTemplateName": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateName()));
            }
            case "VersionDescription": {
                return Optional.ofNullable(clazz.cast(this.versionDescription()));
            }
            case "LaunchTemplateData": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateData()));
            }
            case "Operator": {
                return Optional.ofNullable(clazz.cast(this.operator()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("LaunchTemplateName", LAUNCH_TEMPLATE_NAME_FIELD);
        map.put("VersionDescription", VERSION_DESCRIPTION_FIELD);
        map.put("LaunchTemplateData", LAUNCH_TEMPLATE_DATA_FIELD);
        map.put("Operator", OPERATOR_FIELD);
        map.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateLaunchTemplateRequest, T> g) {
        return obj -> g.apply((CreateLaunchTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private String clientToken;
        private String launchTemplateName;
        private String versionDescription;
        private RequestLaunchTemplateData launchTemplateData;
        private OperatorRequest operator;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLaunchTemplateRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.clientToken(model.clientToken);
            this.launchTemplateName(model.launchTemplateName);
            this.versionDescription(model.versionDescription);
            this.launchTemplateData(model.launchTemplateData);
            this.operator(model.operator);
            this.tagSpecifications(model.tagSpecifications);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getLaunchTemplateName() {
            return this.launchTemplateName;
        }

        public final void setLaunchTemplateName(String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
        }

        @Override
        public final Builder launchTemplateName(String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
            return this;
        }

        public final String getVersionDescription() {
            return this.versionDescription;
        }

        public final void setVersionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
        }

        @Override
        public final Builder versionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
            return this;
        }

        public final RequestLaunchTemplateData.Builder getLaunchTemplateData() {
            return this.launchTemplateData != null ? this.launchTemplateData.toBuilder() : null;
        }

        public final void setLaunchTemplateData(RequestLaunchTemplateData.BuilderImpl launchTemplateData) {
            this.launchTemplateData = launchTemplateData != null ? launchTemplateData.build() : null;
        }

        @Override
        public final Builder launchTemplateData(RequestLaunchTemplateData launchTemplateData) {
            this.launchTemplateData = launchTemplateData;
            return this;
        }

        public final OperatorRequest.Builder getOperator() {
            return this.operator != null ? this.operator.toBuilder() : null;
        }

        public final void setOperator(OperatorRequest.BuilderImpl operator) {
            this.operator = operator != null ? operator.build() : null;
        }

        @Override
        public final Builder operator(OperatorRequest operator) {
            this.operator = operator;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLaunchTemplateRequest build() {
            return new CreateLaunchTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLaunchTemplateRequest> {
        public Builder dryRun(Boolean var1);

        public Builder clientToken(String var1);

        public Builder launchTemplateName(String var1);

        public Builder versionDescription(String var1);

        public Builder launchTemplateData(RequestLaunchTemplateData var1);

        default public Builder launchTemplateData(Consumer<RequestLaunchTemplateData.Builder> launchTemplateData) {
            return this.launchTemplateData((RequestLaunchTemplateData)((RequestLaunchTemplateData.Builder)RequestLaunchTemplateData.builder().applyMutation(launchTemplateData)).build());
        }

        public Builder operator(OperatorRequest var1);

        default public Builder operator(Consumer<OperatorRequest.Builder> operator) {
            return this.operator((OperatorRequest)((OperatorRequest.Builder)OperatorRequest.builder().applyMutation(operator)).build());
        }

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

