/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeIpv6PoolsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIpv6PoolsResponse;
import software.amazon.awssdk.services.ec2.model.Ipv6Pool;

public class DescribeIpv6PoolsIterable
implements SdkIterable<DescribeIpv6PoolsResponse> {
    private final Ec2Client client;
    private final DescribeIpv6PoolsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeIpv6PoolsIterable(Ec2Client client, DescribeIpv6PoolsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeIpv6PoolsResponseFetcher();
    }

    public Iterator<DescribeIpv6PoolsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Ipv6Pool> ipv6Pools() {
        Function<DescribeIpv6PoolsResponse, Iterator> getIterator = response -> {
            if (response != null && response.ipv6Pools() != null) {
                return response.ipv6Pools().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeIpv6PoolsResponseFetcher
    implements SyncPageFetcher<DescribeIpv6PoolsResponse> {
        private DescribeIpv6PoolsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeIpv6PoolsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeIpv6PoolsResponse nextPage(DescribeIpv6PoolsResponse previousPage) {
            if (previousPage == null) {
                return DescribeIpv6PoolsIterable.this.client.describeIpv6Pools(DescribeIpv6PoolsIterable.this.firstRequest);
            }
            return DescribeIpv6PoolsIterable.this.client.describeIpv6Pools((DescribeIpv6PoolsRequest)((Object)DescribeIpv6PoolsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

