/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.RouteServerBfdStatus;
import software.amazon.awssdk.services.ec2.model.RouteServerBgpOptions;
import software.amazon.awssdk.services.ec2.model.RouteServerBgpStatus;
import software.amazon.awssdk.services.ec2.model.RouteServerPeerState;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteServerPeer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteServerPeer> {
    private static final SdkField<String> ROUTE_SERVER_PEER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouteServerPeerId").getter(RouteServerPeer.getter(RouteServerPeer::routeServerPeerId)).setter(RouteServerPeer.setter(Builder::routeServerPeerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteServerPeerId").unmarshallLocationName("routeServerPeerId").build()}).build();
    private static final SdkField<String> ROUTE_SERVER_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouteServerEndpointId").getter(RouteServerPeer.getter(RouteServerPeer::routeServerEndpointId)).setter(RouteServerPeer.setter(Builder::routeServerEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteServerEndpointId").unmarshallLocationName("routeServerEndpointId").build()}).build();
    private static final SdkField<String> ROUTE_SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouteServerId").getter(RouteServerPeer.getter(RouteServerPeer::routeServerId)).setter(RouteServerPeer.setter(Builder::routeServerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteServerId").unmarshallLocationName("routeServerId").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(RouteServerPeer.getter(RouteServerPeer::vpcId)).setter(RouteServerPeer.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").unmarshallLocationName("vpcId").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(RouteServerPeer.getter(RouteServerPeer::subnetId)).setter(RouteServerPeer.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").unmarshallLocationName("subnetId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(RouteServerPeer.getter(RouteServerPeer::stateAsString)).setter(RouteServerPeer.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(RouteServerPeer.getter(RouteServerPeer::failureReason)).setter(RouteServerPeer.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").unmarshallLocationName("failureReason").build()}).build();
    private static final SdkField<String> ENDPOINT_ENI_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointEniId").getter(RouteServerPeer.getter(RouteServerPeer::endpointEniId)).setter(RouteServerPeer.setter(Builder::endpointEniId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointEniId").unmarshallLocationName("endpointEniId").build()}).build();
    private static final SdkField<String> ENDPOINT_ENI_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointEniAddress").getter(RouteServerPeer.getter(RouteServerPeer::endpointEniAddress)).setter(RouteServerPeer.setter(Builder::endpointEniAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointEniAddress").unmarshallLocationName("endpointEniAddress").build()}).build();
    private static final SdkField<String> PEER_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PeerAddress").getter(RouteServerPeer.getter(RouteServerPeer::peerAddress)).setter(RouteServerPeer.setter(Builder::peerAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerAddress").unmarshallLocationName("peerAddress").build()}).build();
    private static final SdkField<RouteServerBgpOptions> BGP_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BgpOptions").getter(RouteServerPeer.getter(RouteServerPeer::bgpOptions)).setter(RouteServerPeer.setter(Builder::bgpOptions)).constructor(RouteServerBgpOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BgpOptions").unmarshallLocationName("bgpOptions").build()}).build();
    private static final SdkField<RouteServerBgpStatus> BGP_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BgpStatus").getter(RouteServerPeer.getter(RouteServerPeer::bgpStatus)).setter(RouteServerPeer.setter(Builder::bgpStatus)).constructor(RouteServerBgpStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BgpStatus").unmarshallLocationName("bgpStatus").build()}).build();
    private static final SdkField<RouteServerBfdStatus> BFD_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BfdStatus").getter(RouteServerPeer.getter(RouteServerPeer::bfdStatus)).setter(RouteServerPeer.setter(Builder::bfdStatus)).constructor(RouteServerBfdStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BfdStatus").unmarshallLocationName("bfdStatus").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(RouteServerPeer.getter(RouteServerPeer::tags)).setter(RouteServerPeer.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTE_SERVER_PEER_ID_FIELD, ROUTE_SERVER_ENDPOINT_ID_FIELD, ROUTE_SERVER_ID_FIELD, VPC_ID_FIELD, SUBNET_ID_FIELD, STATE_FIELD, FAILURE_REASON_FIELD, ENDPOINT_ENI_ID_FIELD, ENDPOINT_ENI_ADDRESS_FIELD, PEER_ADDRESS_FIELD, BGP_OPTIONS_FIELD, BGP_STATUS_FIELD, BFD_STATUS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouteServerPeer.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String routeServerPeerId;
    private final String routeServerEndpointId;
    private final String routeServerId;
    private final String vpcId;
    private final String subnetId;
    private final String state;
    private final String failureReason;
    private final String endpointEniId;
    private final String endpointEniAddress;
    private final String peerAddress;
    private final RouteServerBgpOptions bgpOptions;
    private final RouteServerBgpStatus bgpStatus;
    private final RouteServerBfdStatus bfdStatus;
    private final List<Tag> tags;

    private RouteServerPeer(BuilderImpl builder) {
        this.routeServerPeerId = builder.routeServerPeerId;
        this.routeServerEndpointId = builder.routeServerEndpointId;
        this.routeServerId = builder.routeServerId;
        this.vpcId = builder.vpcId;
        this.subnetId = builder.subnetId;
        this.state = builder.state;
        this.failureReason = builder.failureReason;
        this.endpointEniId = builder.endpointEniId;
        this.endpointEniAddress = builder.endpointEniAddress;
        this.peerAddress = builder.peerAddress;
        this.bgpOptions = builder.bgpOptions;
        this.bgpStatus = builder.bgpStatus;
        this.bfdStatus = builder.bfdStatus;
        this.tags = builder.tags;
    }

    public final String routeServerPeerId() {
        return this.routeServerPeerId;
    }

    public final String routeServerEndpointId() {
        return this.routeServerEndpointId;
    }

    public final String routeServerId() {
        return this.routeServerId;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final RouteServerPeerState state() {
        return RouteServerPeerState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final String endpointEniId() {
        return this.endpointEniId;
    }

    public final String endpointEniAddress() {
        return this.endpointEniAddress;
    }

    public final String peerAddress() {
        return this.peerAddress;
    }

    public final RouteServerBgpOptions bgpOptions() {
        return this.bgpOptions;
    }

    public final RouteServerBgpStatus bgpStatus() {
        return this.bgpStatus;
    }

    public final RouteServerBfdStatus bfdStatus() {
        return this.bfdStatus;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.routeServerPeerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeServerEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeServerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointEniId());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointEniAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.peerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.bgpOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.bgpStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.bfdStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteServerPeer)) {
            return false;
        }
        RouteServerPeer other = (RouteServerPeer)obj;
        return Objects.equals(this.routeServerPeerId(), other.routeServerPeerId()) && Objects.equals(this.routeServerEndpointId(), other.routeServerEndpointId()) && Objects.equals(this.routeServerId(), other.routeServerId()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.endpointEniId(), other.endpointEniId()) && Objects.equals(this.endpointEniAddress(), other.endpointEniAddress()) && Objects.equals(this.peerAddress(), other.peerAddress()) && Objects.equals(this.bgpOptions(), other.bgpOptions()) && Objects.equals(this.bgpStatus(), other.bgpStatus()) && Objects.equals(this.bfdStatus(), other.bfdStatus()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"RouteServerPeer").add("RouteServerPeerId", (Object)this.routeServerPeerId()).add("RouteServerEndpointId", (Object)this.routeServerEndpointId()).add("RouteServerId", (Object)this.routeServerId()).add("VpcId", (Object)this.vpcId()).add("SubnetId", (Object)this.subnetId()).add("State", (Object)this.stateAsString()).add("FailureReason", (Object)this.failureReason()).add("EndpointEniId", (Object)this.endpointEniId()).add("EndpointEniAddress", (Object)this.endpointEniAddress()).add("PeerAddress", (Object)this.peerAddress()).add("BgpOptions", (Object)this.bgpOptions()).add("BgpStatus", (Object)this.bgpStatus()).add("BfdStatus", (Object)this.bfdStatus()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RouteServerPeerId": {
                return Optional.ofNullable(clazz.cast(this.routeServerPeerId()));
            }
            case "RouteServerEndpointId": {
                return Optional.ofNullable(clazz.cast(this.routeServerEndpointId()));
            }
            case "RouteServerId": {
                return Optional.ofNullable(clazz.cast(this.routeServerId()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "EndpointEniId": {
                return Optional.ofNullable(clazz.cast(this.endpointEniId()));
            }
            case "EndpointEniAddress": {
                return Optional.ofNullable(clazz.cast(this.endpointEniAddress()));
            }
            case "PeerAddress": {
                return Optional.ofNullable(clazz.cast(this.peerAddress()));
            }
            case "BgpOptions": {
                return Optional.ofNullable(clazz.cast(this.bgpOptions()));
            }
            case "BgpStatus": {
                return Optional.ofNullable(clazz.cast(this.bgpStatus()));
            }
            case "BfdStatus": {
                return Optional.ofNullable(clazz.cast(this.bfdStatus()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RouteServerPeerId", ROUTE_SERVER_PEER_ID_FIELD);
        map.put("RouteServerEndpointId", ROUTE_SERVER_ENDPOINT_ID_FIELD);
        map.put("RouteServerId", ROUTE_SERVER_ID_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("State", STATE_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        map.put("EndpointEniId", ENDPOINT_ENI_ID_FIELD);
        map.put("EndpointEniAddress", ENDPOINT_ENI_ADDRESS_FIELD);
        map.put("PeerAddress", PEER_ADDRESS_FIELD);
        map.put("BgpOptions", BGP_OPTIONS_FIELD);
        map.put("BgpStatus", BGP_STATUS_FIELD);
        map.put("BfdStatus", BFD_STATUS_FIELD);
        map.put("TagSet", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteServerPeer, T> g) {
        return obj -> g.apply((RouteServerPeer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String routeServerPeerId;
        private String routeServerEndpointId;
        private String routeServerId;
        private String vpcId;
        private String subnetId;
        private String state;
        private String failureReason;
        private String endpointEniId;
        private String endpointEniAddress;
        private String peerAddress;
        private RouteServerBgpOptions bgpOptions;
        private RouteServerBgpStatus bgpStatus;
        private RouteServerBfdStatus bfdStatus;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RouteServerPeer model) {
            this.routeServerPeerId(model.routeServerPeerId);
            this.routeServerEndpointId(model.routeServerEndpointId);
            this.routeServerId(model.routeServerId);
            this.vpcId(model.vpcId);
            this.subnetId(model.subnetId);
            this.state(model.state);
            this.failureReason(model.failureReason);
            this.endpointEniId(model.endpointEniId);
            this.endpointEniAddress(model.endpointEniAddress);
            this.peerAddress(model.peerAddress);
            this.bgpOptions(model.bgpOptions);
            this.bgpStatus(model.bgpStatus);
            this.bfdStatus(model.bfdStatus);
            this.tags(model.tags);
        }

        public final String getRouteServerPeerId() {
            return this.routeServerPeerId;
        }

        public final void setRouteServerPeerId(String routeServerPeerId) {
            this.routeServerPeerId = routeServerPeerId;
        }

        @Override
        public final Builder routeServerPeerId(String routeServerPeerId) {
            this.routeServerPeerId = routeServerPeerId;
            return this;
        }

        public final String getRouteServerEndpointId() {
            return this.routeServerEndpointId;
        }

        public final void setRouteServerEndpointId(String routeServerEndpointId) {
            this.routeServerEndpointId = routeServerEndpointId;
        }

        @Override
        public final Builder routeServerEndpointId(String routeServerEndpointId) {
            this.routeServerEndpointId = routeServerEndpointId;
            return this;
        }

        public final String getRouteServerId() {
            return this.routeServerId;
        }

        public final void setRouteServerId(String routeServerId) {
            this.routeServerId = routeServerId;
        }

        @Override
        public final Builder routeServerId(String routeServerId) {
            this.routeServerId = routeServerId;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(RouteServerPeerState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getEndpointEniId() {
            return this.endpointEniId;
        }

        public final void setEndpointEniId(String endpointEniId) {
            this.endpointEniId = endpointEniId;
        }

        @Override
        public final Builder endpointEniId(String endpointEniId) {
            this.endpointEniId = endpointEniId;
            return this;
        }

        public final String getEndpointEniAddress() {
            return this.endpointEniAddress;
        }

        public final void setEndpointEniAddress(String endpointEniAddress) {
            this.endpointEniAddress = endpointEniAddress;
        }

        @Override
        public final Builder endpointEniAddress(String endpointEniAddress) {
            this.endpointEniAddress = endpointEniAddress;
            return this;
        }

        public final String getPeerAddress() {
            return this.peerAddress;
        }

        public final void setPeerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
        }

        @Override
        public final Builder peerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
            return this;
        }

        public final RouteServerBgpOptions.Builder getBgpOptions() {
            return this.bgpOptions != null ? this.bgpOptions.toBuilder() : null;
        }

        public final void setBgpOptions(RouteServerBgpOptions.BuilderImpl bgpOptions) {
            this.bgpOptions = bgpOptions != null ? bgpOptions.build() : null;
        }

        @Override
        public final Builder bgpOptions(RouteServerBgpOptions bgpOptions) {
            this.bgpOptions = bgpOptions;
            return this;
        }

        public final RouteServerBgpStatus.Builder getBgpStatus() {
            return this.bgpStatus != null ? this.bgpStatus.toBuilder() : null;
        }

        public final void setBgpStatus(RouteServerBgpStatus.BuilderImpl bgpStatus) {
            this.bgpStatus = bgpStatus != null ? bgpStatus.build() : null;
        }

        @Override
        public final Builder bgpStatus(RouteServerBgpStatus bgpStatus) {
            this.bgpStatus = bgpStatus;
            return this;
        }

        public final RouteServerBfdStatus.Builder getBfdStatus() {
            return this.bfdStatus != null ? this.bfdStatus.toBuilder() : null;
        }

        public final void setBfdStatus(RouteServerBfdStatus.BuilderImpl bfdStatus) {
            this.bfdStatus = bfdStatus != null ? bfdStatus.build() : null;
        }

        @Override
        public final Builder bfdStatus(RouteServerBfdStatus bfdStatus) {
            this.bfdStatus = bfdStatus;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public RouteServerPeer build() {
            return new RouteServerPeer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteServerPeer> {
        public Builder routeServerPeerId(String var1);

        public Builder routeServerEndpointId(String var1);

        public Builder routeServerId(String var1);

        public Builder vpcId(String var1);

        public Builder subnetId(String var1);

        public Builder state(String var1);

        public Builder state(RouteServerPeerState var1);

        public Builder failureReason(String var1);

        public Builder endpointEniId(String var1);

        public Builder endpointEniAddress(String var1);

        public Builder peerAddress(String var1);

        public Builder bgpOptions(RouteServerBgpOptions var1);

        default public Builder bgpOptions(Consumer<RouteServerBgpOptions.Builder> bgpOptions) {
            return this.bgpOptions((RouteServerBgpOptions)((RouteServerBgpOptions.Builder)RouteServerBgpOptions.builder().applyMutation(bgpOptions)).build());
        }

        public Builder bgpStatus(RouteServerBgpStatus var1);

        default public Builder bgpStatus(Consumer<RouteServerBgpStatus.Builder> bgpStatus) {
            return this.bgpStatus((RouteServerBgpStatus)((RouteServerBgpStatus.Builder)RouteServerBgpStatus.builder().applyMutation(bgpStatus)).build());
        }

        public Builder bfdStatus(RouteServerBfdStatus var1);

        default public Builder bfdStatus(Consumer<RouteServerBfdStatus.Builder> bfdStatus) {
            return this.bfdStatus((RouteServerBfdStatus)((RouteServerBfdStatus.Builder)RouteServerBfdStatus.builder().applyMutation(bfdStatus)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

