/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RequestSpotFleetResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, RequestSpotFleetResponse> {
    private static final SdkField<String> SPOT_FLEET_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpotFleetRequestId").getter(RequestSpotFleetResponse.getter(RequestSpotFleetResponse::spotFleetRequestId)).setter(RequestSpotFleetResponse.setter(Builder::spotFleetRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotFleetRequestId").unmarshallLocationName("spotFleetRequestId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPOT_FLEET_REQUEST_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RequestSpotFleetResponse.memberNameToFieldInitializer();
    private final String spotFleetRequestId;

    private RequestSpotFleetResponse(BuilderImpl builder) {
        super(builder);
        this.spotFleetRequestId = builder.spotFleetRequestId;
    }

    public final String spotFleetRequestId() {
        return this.spotFleetRequestId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.spotFleetRequestId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestSpotFleetResponse)) {
            return false;
        }
        RequestSpotFleetResponse other = (RequestSpotFleetResponse)((Object)obj);
        return Objects.equals(this.spotFleetRequestId(), other.spotFleetRequestId());
    }

    public final String toString() {
        return ToString.builder((String)"RequestSpotFleetResponse").add("SpotFleetRequestId", (Object)this.spotFleetRequestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SpotFleetRequestId": {
                return Optional.ofNullable(clazz.cast(this.spotFleetRequestId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("SpotFleetRequestId", SPOT_FLEET_REQUEST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RequestSpotFleetResponse, T> g) {
        return obj -> g.apply((RequestSpotFleetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String spotFleetRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestSpotFleetResponse model) {
            super(model);
            this.spotFleetRequestId(model.spotFleetRequestId);
        }

        public final String getSpotFleetRequestId() {
            return this.spotFleetRequestId;
        }

        public final void setSpotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
        }

        @Override
        public final Builder spotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
            return this;
        }

        @Override
        public RequestSpotFleetResponse build() {
            return new RequestSpotFleetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RequestSpotFleetResponse> {
        public Builder spotFleetRequestId(String var1);
    }
}

