/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for RunScheduledInstances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RunScheduledInstancesRequest extends Ec2Request implements
        ToCopyableBuilder<RunScheduledInstancesRequest.Builder, RunScheduledInstancesRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(RunScheduledInstancesRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(RunScheduledInstancesRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstanceCount")
            .getter(getter(RunScheduledInstancesRequest::instanceCount))
            .setter(setter(Builder::instanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount")
                    .unmarshallLocationName("InstanceCount").build()).build();

    private static final SdkField<ScheduledInstancesLaunchSpecification> LAUNCH_SPECIFICATION_FIELD = SdkField
            .<ScheduledInstancesLaunchSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("LaunchSpecification")
            .getter(getter(RunScheduledInstancesRequest::launchSpecification))
            .setter(setter(Builder::launchSpecification))
            .constructor(ScheduledInstancesLaunchSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchSpecification")
                    .unmarshallLocationName("LaunchSpecification").build()).build();

    private static final SdkField<String> SCHEDULED_INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ScheduledInstanceId")
            .getter(getter(RunScheduledInstancesRequest::scheduledInstanceId))
            .setter(setter(Builder::scheduledInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledInstanceId")
                    .unmarshallLocationName("ScheduledInstanceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DRY_RUN_FIELD, INSTANCE_COUNT_FIELD, LAUNCH_SPECIFICATION_FIELD, SCHEDULED_INSTANCE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final Boolean dryRun;

    private final Integer instanceCount;

    private final ScheduledInstancesLaunchSpecification launchSpecification;

    private final String scheduledInstanceId;

    private RunScheduledInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.dryRun = builder.dryRun;
        this.instanceCount = builder.instanceCount;
        this.launchSpecification = builder.launchSpecification;
        this.scheduledInstanceId = builder.scheduledInstanceId;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that ensures the idempotency of the request. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * Idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that ensures the idempotency of the request. For more information, see
     *         <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         Idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The number of instances.
     * </p>
     * <p>
     * Default: 1
     * </p>
     * 
     * @return The number of instances.</p>
     *         <p>
     *         Default: 1
     */
    public final Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * The launch specification. You must match the instance type, Availability Zone, network, and platform of the
     * schedule that you purchased.
     * </p>
     * 
     * @return The launch specification. You must match the instance type, Availability Zone, network, and platform of
     *         the schedule that you purchased.
     */
    public final ScheduledInstancesLaunchSpecification launchSpecification() {
        return launchSpecification;
    }

    /**
     * <p>
     * The Scheduled Instance ID.
     * </p>
     * 
     * @return The Scheduled Instance ID.
     */
    public final String scheduledInstanceId() {
        return scheduledInstanceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(launchSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledInstanceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunScheduledInstancesRequest)) {
            return false;
        }
        RunScheduledInstancesRequest other = (RunScheduledInstancesRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(dryRun(), other.dryRun())
                && Objects.equals(instanceCount(), other.instanceCount())
                && Objects.equals(launchSpecification(), other.launchSpecification())
                && Objects.equals(scheduledInstanceId(), other.scheduledInstanceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RunScheduledInstancesRequest").add("ClientToken", clientToken()).add("DryRun", dryRun())
                .add("InstanceCount", instanceCount())
                .add("LaunchSpecification", launchSpecification() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ScheduledInstanceId", scheduledInstanceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "InstanceCount":
            return Optional.ofNullable(clazz.cast(instanceCount()));
        case "LaunchSpecification":
            return Optional.ofNullable(clazz.cast(launchSpecification()));
        case "ScheduledInstanceId":
            return Optional.ofNullable(clazz.cast(scheduledInstanceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("InstanceCount", INSTANCE_COUNT_FIELD);
        map.put("LaunchSpecification", LAUNCH_SPECIFICATION_FIELD);
        map.put("ScheduledInstanceId", SCHEDULED_INSTANCE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RunScheduledInstancesRequest, T> g) {
        return obj -> g.apply((RunScheduledInstancesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, RunScheduledInstancesRequest> {
        /**
         * <p>
         * Unique, case-sensitive identifier that ensures the idempotency of the request. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that ensures the idempotency of the request. For more information,
         *        see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The number of instances.
         * </p>
         * <p>
         * Default: 1
         * </p>
         * 
         * @param instanceCount
         *        The number of instances.</p>
         *        <p>
         *        Default: 1
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * The launch specification. You must match the instance type, Availability Zone, network, and platform of the
         * schedule that you purchased.
         * </p>
         * 
         * @param launchSpecification
         *        The launch specification. You must match the instance type, Availability Zone, network, and platform
         *        of the schedule that you purchased.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchSpecification(ScheduledInstancesLaunchSpecification launchSpecification);

        /**
         * <p>
         * The launch specification. You must match the instance type, Availability Zone, network, and platform of the
         * schedule that you purchased.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ScheduledInstancesLaunchSpecification.Builder} avoiding the need to create one manually via
         * {@link ScheduledInstancesLaunchSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScheduledInstancesLaunchSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #launchSpecification(ScheduledInstancesLaunchSpecification)}.
         * 
         * @param launchSpecification
         *        a consumer that will call methods on {@link ScheduledInstancesLaunchSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchSpecification(ScheduledInstancesLaunchSpecification)
         */
        default Builder launchSpecification(Consumer<ScheduledInstancesLaunchSpecification.Builder> launchSpecification) {
            return launchSpecification(ScheduledInstancesLaunchSpecification.builder().applyMutation(launchSpecification).build());
        }

        /**
         * <p>
         * The Scheduled Instance ID.
         * </p>
         * 
         * @param scheduledInstanceId
         *        The Scheduled Instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledInstanceId(String scheduledInstanceId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String clientToken;

        private Boolean dryRun;

        private Integer instanceCount;

        private ScheduledInstancesLaunchSpecification launchSpecification;

        private String scheduledInstanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(RunScheduledInstancesRequest model) {
            super(model);
            clientToken(model.clientToken);
            dryRun(model.dryRun);
            instanceCount(model.instanceCount);
            launchSpecification(model.launchSpecification);
            scheduledInstanceId(model.scheduledInstanceId);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final ScheduledInstancesLaunchSpecification.Builder getLaunchSpecification() {
            return launchSpecification != null ? launchSpecification.toBuilder() : null;
        }

        public final void setLaunchSpecification(ScheduledInstancesLaunchSpecification.BuilderImpl launchSpecification) {
            this.launchSpecification = launchSpecification != null ? launchSpecification.build() : null;
        }

        @Override
        public final Builder launchSpecification(ScheduledInstancesLaunchSpecification launchSpecification) {
            this.launchSpecification = launchSpecification;
            return this;
        }

        public final String getScheduledInstanceId() {
            return scheduledInstanceId;
        }

        public final void setScheduledInstanceId(String scheduledInstanceId) {
            this.scheduledInstanceId = scheduledInstanceId;
        }

        @Override
        public final Builder scheduledInstanceId(String scheduledInstanceId) {
            this.scheduledInstanceId = scheduledInstanceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RunScheduledInstancesRequest build() {
            return new RunScheduledInstancesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
