/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeSpotFleetInstances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSpotFleetInstancesResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeSpotFleetInstancesResponse.Builder, DescribeSpotFleetInstancesResponse> {
    private static final SdkField<List<ActiveInstance>> ACTIVE_INSTANCES_FIELD = SdkField
            .<List<ActiveInstance>> builder(MarshallingType.LIST)
            .memberName("ActiveInstances")
            .getter(getter(DescribeSpotFleetInstancesResponse::activeInstances))
            .setter(setter(Builder::activeInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveInstanceSet")
                    .unmarshallLocationName("activeInstanceSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ActiveInstance> builder(MarshallingType.SDK_POJO)
                                            .constructor(ActiveInstance::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeSpotFleetInstancesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final SdkField<String> SPOT_FLEET_REQUEST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SpotFleetRequestId")
            .getter(getter(DescribeSpotFleetInstancesResponse::spotFleetRequestId))
            .setter(setter(Builder::spotFleetRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotFleetRequestId")
                    .unmarshallLocationName("spotFleetRequestId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_INSTANCES_FIELD,
            NEXT_TOKEN_FIELD, SPOT_FLEET_REQUEST_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ActiveInstance> activeInstances;

    private final String nextToken;

    private final String spotFleetRequestId;

    private DescribeSpotFleetInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.activeInstances = builder.activeInstances;
        this.nextToken = builder.nextToken;
        this.spotFleetRequestId = builder.spotFleetRequestId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ActiveInstances property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasActiveInstances() {
        return activeInstances != null && !(activeInstances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The running instances. This list is refreshed periodically and might be out of date.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActiveInstances} method.
     * </p>
     * 
     * @return The running instances. This list is refreshed periodically and might be out of date.
     */
    public final List<ActiveInstance> activeInstances() {
        return activeInstances;
    }

    /**
     * <p>
     * The token to include in another request to get the next page of items. This value is <code>null</code> when there
     * are no more items to return.
     * </p>
     * 
     * @return The token to include in another request to get the next page of items. This value is <code>null</code>
     *         when there are no more items to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The ID of the Spot Fleet request.
     * </p>
     * 
     * @return The ID of the Spot Fleet request.
     */
    public final String spotFleetRequestId() {
        return spotFleetRequestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasActiveInstances() ? activeInstances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(spotFleetRequestId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSpotFleetInstancesResponse)) {
            return false;
        }
        DescribeSpotFleetInstancesResponse other = (DescribeSpotFleetInstancesResponse) obj;
        return hasActiveInstances() == other.hasActiveInstances() && Objects.equals(activeInstances(), other.activeInstances())
                && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(spotFleetRequestId(), other.spotFleetRequestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSpotFleetInstancesResponse")
                .add("ActiveInstances", hasActiveInstances() ? activeInstances() : null).add("NextToken", nextToken())
                .add("SpotFleetRequestId", spotFleetRequestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActiveInstances":
            return Optional.ofNullable(clazz.cast(activeInstances()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "SpotFleetRequestId":
            return Optional.ofNullable(clazz.cast(spotFleetRequestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ActiveInstanceSet", ACTIVE_INSTANCES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("SpotFleetRequestId", SPOT_FLEET_REQUEST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeSpotFleetInstancesResponse, T> g) {
        return obj -> g.apply((DescribeSpotFleetInstancesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSpotFleetInstancesResponse> {
        /**
         * <p>
         * The running instances. This list is refreshed periodically and might be out of date.
         * </p>
         * 
         * @param activeInstances
         *        The running instances. This list is refreshed periodically and might be out of date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeInstances(Collection<ActiveInstance> activeInstances);

        /**
         * <p>
         * The running instances. This list is refreshed periodically and might be out of date.
         * </p>
         * 
         * @param activeInstances
         *        The running instances. This list is refreshed periodically and might be out of date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeInstances(ActiveInstance... activeInstances);

        /**
         * <p>
         * The running instances. This list is refreshed periodically and might be out of date.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.ActiveInstance.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.ActiveInstance#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.ActiveInstance.Builder#build()} is called immediately and
         * its result is passed to {@link #activeInstances(List<ActiveInstance>)}.
         * 
         * @param activeInstances
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.ActiveInstance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activeInstances(java.util.Collection<ActiveInstance>)
         */
        Builder activeInstances(Consumer<ActiveInstance.Builder>... activeInstances);

        /**
         * <p>
         * The token to include in another request to get the next page of items. This value is <code>null</code> when
         * there are no more items to return.
         * </p>
         * 
         * @param nextToken
         *        The token to include in another request to get the next page of items. This value is <code>null</code>
         *        when there are no more items to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The ID of the Spot Fleet request.
         * </p>
         * 
         * @param spotFleetRequestId
         *        The ID of the Spot Fleet request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotFleetRequestId(String spotFleetRequestId);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<ActiveInstance> activeInstances = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private String spotFleetRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSpotFleetInstancesResponse model) {
            super(model);
            activeInstances(model.activeInstances);
            nextToken(model.nextToken);
            spotFleetRequestId(model.spotFleetRequestId);
        }

        public final List<ActiveInstance.Builder> getActiveInstances() {
            List<ActiveInstance.Builder> result = ActiveInstanceSetCopier.copyToBuilder(this.activeInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActiveInstances(Collection<ActiveInstance.BuilderImpl> activeInstances) {
            this.activeInstances = ActiveInstanceSetCopier.copyFromBuilder(activeInstances);
        }

        @Override
        public final Builder activeInstances(Collection<ActiveInstance> activeInstances) {
            this.activeInstances = ActiveInstanceSetCopier.copy(activeInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activeInstances(ActiveInstance... activeInstances) {
            activeInstances(Arrays.asList(activeInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activeInstances(Consumer<ActiveInstance.Builder>... activeInstances) {
            activeInstances(Stream.of(activeInstances).map(c -> ActiveInstance.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getSpotFleetRequestId() {
            return spotFleetRequestId;
        }

        public final void setSpotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
        }

        @Override
        public final Builder spotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
            return this;
        }

        @Override
        public DescribeSpotFleetInstancesResponse build() {
            return new DescribeSpotFleetInstancesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
