/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.MacHost;
import software.amazon.awssdk.services.ec2.model.MacHostListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMacHostsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeMacHostsResponse> {
    private static final SdkField<List<MacHost>> MAC_HOSTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MacHosts").getter(DescribeMacHostsResponse.getter(DescribeMacHostsResponse::macHosts)).setter(DescribeMacHostsResponse.setter(Builder::macHosts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MacHostSet").unmarshallLocationName("macHostSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MacHost::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeMacHostsResponse.getter(DescribeMacHostsResponse::nextToken)).setter(DescribeMacHostsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAC_HOSTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeMacHostsResponse.memberNameToFieldInitializer();
    private final List<MacHost> macHosts;
    private final String nextToken;

    private DescribeMacHostsResponse(BuilderImpl builder) {
        super(builder);
        this.macHosts = builder.macHosts;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasMacHosts() {
        return this.macHosts != null && !(this.macHosts instanceof SdkAutoConstructList);
    }

    public final List<MacHost> macHosts() {
        return this.macHosts;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMacHosts() ? this.macHosts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMacHostsResponse)) {
            return false;
        }
        DescribeMacHostsResponse other = (DescribeMacHostsResponse)((Object)obj);
        return this.hasMacHosts() == other.hasMacHosts() && Objects.equals(this.macHosts(), other.macHosts()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeMacHostsResponse").add("MacHosts", this.hasMacHosts() ? this.macHosts() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MacHosts": {
                return Optional.ofNullable(clazz.cast(this.macHosts()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MacHostSet", MAC_HOSTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeMacHostsResponse, T> g) {
        return obj -> g.apply((DescribeMacHostsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<MacHost> macHosts = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMacHostsResponse model) {
            super(model);
            this.macHosts(model.macHosts);
            this.nextToken(model.nextToken);
        }

        public final List<MacHost.Builder> getMacHosts() {
            List<MacHost.Builder> result = MacHostListCopier.copyToBuilder(this.macHosts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMacHosts(Collection<MacHost.BuilderImpl> macHosts) {
            this.macHosts = MacHostListCopier.copyFromBuilder(macHosts);
        }

        @Override
        public final Builder macHosts(Collection<MacHost> macHosts) {
            this.macHosts = MacHostListCopier.copy(macHosts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder macHosts(MacHost ... macHosts) {
            this.macHosts(Arrays.asList(macHosts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder macHosts(Consumer<MacHost.Builder> ... macHosts) {
            this.macHosts(Stream.of(macHosts).map(c -> (MacHost)((MacHost.Builder)MacHost.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeMacHostsResponse build() {
            return new DescribeMacHostsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeMacHostsResponse> {
        public Builder macHosts(Collection<MacHost> var1);

        public Builder macHosts(MacHost ... var1);

        public Builder macHosts(Consumer<MacHost.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

