/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the installation status of a route in a route table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteServerRouteInstallationDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteServerRouteInstallationDetail.Builder, RouteServerRouteInstallationDetail> {
    private static final SdkField<String> ROUTE_TABLE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RouteTableId")
            .getter(getter(RouteServerRouteInstallationDetail::routeTableId))
            .setter(setter(Builder::routeTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableId")
                    .unmarshallLocationName("routeTableId").build()).build();

    private static final SdkField<String> ROUTE_INSTALLATION_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RouteInstallationStatus")
            .getter(getter(RouteServerRouteInstallationDetail::routeInstallationStatusAsString))
            .setter(setter(Builder::routeInstallationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteInstallationStatus")
                    .unmarshallLocationName("routeInstallationStatus").build()).build();

    private static final SdkField<String> ROUTE_INSTALLATION_STATUS_REASON_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RouteInstallationStatusReason")
            .getter(getter(RouteServerRouteInstallationDetail::routeInstallationStatusReason))
            .setter(setter(Builder::routeInstallationStatusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteInstallationStatusReason")
                    .unmarshallLocationName("routeInstallationStatusReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTE_TABLE_ID_FIELD,
            ROUTE_INSTALLATION_STATUS_FIELD, ROUTE_INSTALLATION_STATUS_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String routeTableId;

    private final String routeInstallationStatus;

    private final String routeInstallationStatusReason;

    private RouteServerRouteInstallationDetail(BuilderImpl builder) {
        this.routeTableId = builder.routeTableId;
        this.routeInstallationStatus = builder.routeInstallationStatus;
        this.routeInstallationStatusReason = builder.routeInstallationStatusReason;
    }

    /**
     * <p>
     * The ID of the route table where the route is being installed.
     * </p>
     * 
     * @return The ID of the route table where the route is being installed.
     */
    public final String routeTableId() {
        return routeTableId;
    }

    /**
     * <p>
     * The current installation status of the route in the route table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #routeInstallationStatus} will return {@link RouteServerRouteInstallationStatus#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #routeInstallationStatusAsString}.
     * </p>
     * 
     * @return The current installation status of the route in the route table.
     * @see RouteServerRouteInstallationStatus
     */
    public final RouteServerRouteInstallationStatus routeInstallationStatus() {
        return RouteServerRouteInstallationStatus.fromValue(routeInstallationStatus);
    }

    /**
     * <p>
     * The current installation status of the route in the route table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #routeInstallationStatus} will return {@link RouteServerRouteInstallationStatus#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #routeInstallationStatusAsString}.
     * </p>
     * 
     * @return The current installation status of the route in the route table.
     * @see RouteServerRouteInstallationStatus
     */
    public final String routeInstallationStatusAsString() {
        return routeInstallationStatus;
    }

    /**
     * <p>
     * The reason for the current installation status of the route.
     * </p>
     * 
     * @return The reason for the current installation status of the route.
     */
    public final String routeInstallationStatusReason() {
        return routeInstallationStatusReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(routeTableId());
        hashCode = 31 * hashCode + Objects.hashCode(routeInstallationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(routeInstallationStatusReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteServerRouteInstallationDetail)) {
            return false;
        }
        RouteServerRouteInstallationDetail other = (RouteServerRouteInstallationDetail) obj;
        return Objects.equals(routeTableId(), other.routeTableId())
                && Objects.equals(routeInstallationStatusAsString(), other.routeInstallationStatusAsString())
                && Objects.equals(routeInstallationStatusReason(), other.routeInstallationStatusReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteServerRouteInstallationDetail").add("RouteTableId", routeTableId())
                .add("RouteInstallationStatus", routeInstallationStatusAsString())
                .add("RouteInstallationStatusReason", routeInstallationStatusReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RouteTableId":
            return Optional.ofNullable(clazz.cast(routeTableId()));
        case "RouteInstallationStatus":
            return Optional.ofNullable(clazz.cast(routeInstallationStatusAsString()));
        case "RouteInstallationStatusReason":
            return Optional.ofNullable(clazz.cast(routeInstallationStatusReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RouteTableId", ROUTE_TABLE_ID_FIELD);
        map.put("RouteInstallationStatus", ROUTE_INSTALLATION_STATUS_FIELD);
        map.put("RouteInstallationStatusReason", ROUTE_INSTALLATION_STATUS_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteServerRouteInstallationDetail, T> g) {
        return obj -> g.apply((RouteServerRouteInstallationDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteServerRouteInstallationDetail> {
        /**
         * <p>
         * The ID of the route table where the route is being installed.
         * </p>
         * 
         * @param routeTableId
         *        The ID of the route table where the route is being installed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTableId(String routeTableId);

        /**
         * <p>
         * The current installation status of the route in the route table.
         * </p>
         * 
         * @param routeInstallationStatus
         *        The current installation status of the route in the route table.
         * @see RouteServerRouteInstallationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteServerRouteInstallationStatus
         */
        Builder routeInstallationStatus(String routeInstallationStatus);

        /**
         * <p>
         * The current installation status of the route in the route table.
         * </p>
         * 
         * @param routeInstallationStatus
         *        The current installation status of the route in the route table.
         * @see RouteServerRouteInstallationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteServerRouteInstallationStatus
         */
        Builder routeInstallationStatus(RouteServerRouteInstallationStatus routeInstallationStatus);

        /**
         * <p>
         * The reason for the current installation status of the route.
         * </p>
         * 
         * @param routeInstallationStatusReason
         *        The reason for the current installation status of the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeInstallationStatusReason(String routeInstallationStatusReason);
    }

    static final class BuilderImpl implements Builder {
        private String routeTableId;

        private String routeInstallationStatus;

        private String routeInstallationStatusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteServerRouteInstallationDetail model) {
            routeTableId(model.routeTableId);
            routeInstallationStatus(model.routeInstallationStatus);
            routeInstallationStatusReason(model.routeInstallationStatusReason);
        }

        public final String getRouteTableId() {
            return routeTableId;
        }

        public final void setRouteTableId(String routeTableId) {
            this.routeTableId = routeTableId;
        }

        @Override
        public final Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public final String getRouteInstallationStatus() {
            return routeInstallationStatus;
        }

        public final void setRouteInstallationStatus(String routeInstallationStatus) {
            this.routeInstallationStatus = routeInstallationStatus;
        }

        @Override
        public final Builder routeInstallationStatus(String routeInstallationStatus) {
            this.routeInstallationStatus = routeInstallationStatus;
            return this;
        }

        @Override
        public final Builder routeInstallationStatus(RouteServerRouteInstallationStatus routeInstallationStatus) {
            this.routeInstallationStatus(routeInstallationStatus == null ? null : routeInstallationStatus.toString());
            return this;
        }

        public final String getRouteInstallationStatusReason() {
            return routeInstallationStatusReason;
        }

        public final void setRouteInstallationStatusReason(String routeInstallationStatusReason) {
            this.routeInstallationStatusReason = routeInstallationStatusReason;
        }

        @Override
        public final Builder routeInstallationStatusReason(String routeInstallationStatusReason) {
            this.routeInstallationStatusReason = routeInstallationStatusReason;
            return this;
        }

        @Override
        public RouteServerRouteInstallationDetail build() {
            return new RouteServerRouteInstallationDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
