/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyAvailabilityZoneGroupRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyAvailabilityZoneGroupRequest.Builder, ModifyAvailabilityZoneGroupRequest> {
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GroupName")
            .getter(getter(ModifyAvailabilityZoneGroupRequest::groupName))
            .setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName")
                    .unmarshallLocationName("GroupName").build()).build();

    private static final SdkField<String> OPT_IN_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OptInStatus")
            .getter(getter(ModifyAvailabilityZoneGroupRequest::optInStatusAsString))
            .setter(setter(Builder::optInStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptInStatus")
                    .unmarshallLocationName("OptInStatus").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(ModifyAvailabilityZoneGroupRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_FIELD,
            OPT_IN_STATUS_FIELD, DRY_RUN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String groupName;

    private final String optInStatus;

    private final Boolean dryRun;

    private ModifyAvailabilityZoneGroupRequest(BuilderImpl builder) {
        super(builder);
        this.groupName = builder.groupName;
        this.optInStatus = builder.optInStatus;
        this.dryRun = builder.dryRun;
    }

    /**
     * <p>
     * The name of the Availability Zone group, Local Zone group, or Wavelength Zone group.
     * </p>
     * 
     * @return The name of the Availability Zone group, Local Zone group, or Wavelength Zone group.
     */
    public final String groupName() {
        return groupName;
    }

    /**
     * <p>
     * Indicates whether to opt in to the zone group. The only valid value is <code>opted-in</code>. You must contact
     * Amazon Web Services Support to opt out of a Local Zone or Wavelength Zone group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #optInStatus} will
     * return {@link ModifyAvailabilityZoneOptInStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #optInStatusAsString}.
     * </p>
     * 
     * @return Indicates whether to opt in to the zone group. The only valid value is <code>opted-in</code>. You must
     *         contact Amazon Web Services Support to opt out of a Local Zone or Wavelength Zone group.
     * @see ModifyAvailabilityZoneOptInStatus
     */
    public final ModifyAvailabilityZoneOptInStatus optInStatus() {
        return ModifyAvailabilityZoneOptInStatus.fromValue(optInStatus);
    }

    /**
     * <p>
     * Indicates whether to opt in to the zone group. The only valid value is <code>opted-in</code>. You must contact
     * Amazon Web Services Support to opt out of a Local Zone or Wavelength Zone group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #optInStatus} will
     * return {@link ModifyAvailabilityZoneOptInStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #optInStatusAsString}.
     * </p>
     * 
     * @return Indicates whether to opt in to the zone group. The only valid value is <code>opted-in</code>. You must
     *         contact Amazon Web Services Support to opt out of a Local Zone or Wavelength Zone group.
     * @see ModifyAvailabilityZoneOptInStatus
     */
    public final String optInStatusAsString() {
        return optInStatus;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(optInStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyAvailabilityZoneGroupRequest)) {
            return false;
        }
        ModifyAvailabilityZoneGroupRequest other = (ModifyAvailabilityZoneGroupRequest) obj;
        return Objects.equals(groupName(), other.groupName())
                && Objects.equals(optInStatusAsString(), other.optInStatusAsString()) && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyAvailabilityZoneGroupRequest").add("GroupName", groupName())
                .add("OptInStatus", optInStatusAsString()).add("DryRun", dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "OptInStatus":
            return Optional.ofNullable(clazz.cast(optInStatusAsString()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GroupName", GROUP_NAME_FIELD);
        map.put("OptInStatus", OPT_IN_STATUS_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyAvailabilityZoneGroupRequest, T> g) {
        return obj -> g.apply((ModifyAvailabilityZoneGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyAvailabilityZoneGroupRequest> {
        /**
         * <p>
         * The name of the Availability Zone group, Local Zone group, or Wavelength Zone group.
         * </p>
         * 
         * @param groupName
         *        The name of the Availability Zone group, Local Zone group, or Wavelength Zone group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * Indicates whether to opt in to the zone group. The only valid value is <code>opted-in</code>. You must
         * contact Amazon Web Services Support to opt out of a Local Zone or Wavelength Zone group.
         * </p>
         * 
         * @param optInStatus
         *        Indicates whether to opt in to the zone group. The only valid value is <code>opted-in</code>. You must
         *        contact Amazon Web Services Support to opt out of a Local Zone or Wavelength Zone group.
         * @see ModifyAvailabilityZoneOptInStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModifyAvailabilityZoneOptInStatus
         */
        Builder optInStatus(String optInStatus);

        /**
         * <p>
         * Indicates whether to opt in to the zone group. The only valid value is <code>opted-in</code>. You must
         * contact Amazon Web Services Support to opt out of a Local Zone or Wavelength Zone group.
         * </p>
         * 
         * @param optInStatus
         *        Indicates whether to opt in to the zone group. The only valid value is <code>opted-in</code>. You must
         *        contact Amazon Web Services Support to opt out of a Local Zone or Wavelength Zone group.
         * @see ModifyAvailabilityZoneOptInStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModifyAvailabilityZoneOptInStatus
         */
        Builder optInStatus(ModifyAvailabilityZoneOptInStatus optInStatus);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String groupName;

        private String optInStatus;

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyAvailabilityZoneGroupRequest model) {
            super(model);
            groupName(model.groupName);
            optInStatus(model.optInStatus);
            dryRun(model.dryRun);
        }

        public final String getGroupName() {
            return groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getOptInStatus() {
            return optInStatus;
        }

        public final void setOptInStatus(String optInStatus) {
            this.optInStatus = optInStatus;
        }

        @Override
        public final Builder optInStatus(String optInStatus) {
            this.optInStatus = optInStatus;
            return this;
        }

        @Override
        public final Builder optInStatus(ModifyAvailabilityZoneOptInStatus optInStatus) {
            this.optInStatus(optInStatus == null ? null : optInStatus.toString());
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyAvailabilityZoneGroupRequest build() {
            return new ModifyAvailabilityZoneGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
