/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSecurityGroupsForVpcResponse extends Ec2Response implements
        ToCopyableBuilder<GetSecurityGroupsForVpcResponse.Builder, GetSecurityGroupsForVpcResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(GetSecurityGroupsForVpcResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final SdkField<List<SecurityGroupForVpc>> SECURITY_GROUP_FOR_VPCS_FIELD = SdkField
            .<List<SecurityGroupForVpc>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupForVpcs")
            .getter(getter(GetSecurityGroupsForVpcResponse::securityGroupForVpcs))
            .setter(setter(Builder::securityGroupForVpcs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupForVpcSet")
                    .unmarshallLocationName("securityGroupForVpcSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<SecurityGroupForVpc> builder(MarshallingType.SDK_POJO)
                                            .constructor(SecurityGroupForVpc::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SECURITY_GROUP_FOR_VPCS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<SecurityGroupForVpc> securityGroupForVpcs;

    private GetSecurityGroupsForVpcResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.securityGroupForVpcs = builder.securityGroupForVpcs;
    }

    /**
     * <p>
     * The token to include in another request to get the next page of items. This value is <code>null</code> when there
     * are no more items to return.
     * </p>
     * 
     * @return The token to include in another request to get the next page of items. This value is <code>null</code>
     *         when there are no more items to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupForVpcs property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupForVpcs() {
        return securityGroupForVpcs != null && !(securityGroupForVpcs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The security group that can be used by interfaces in the VPC.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupForVpcs} method.
     * </p>
     * 
     * @return The security group that can be used by interfaces in the VPC.
     */
    public final List<SecurityGroupForVpc> securityGroupForVpcs() {
        return securityGroupForVpcs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupForVpcs() ? securityGroupForVpcs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSecurityGroupsForVpcResponse)) {
            return false;
        }
        GetSecurityGroupsForVpcResponse other = (GetSecurityGroupsForVpcResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasSecurityGroupForVpcs() == other.hasSecurityGroupForVpcs()
                && Objects.equals(securityGroupForVpcs(), other.securityGroupForVpcs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSecurityGroupsForVpcResponse").add("NextToken", nextToken())
                .add("SecurityGroupForVpcs", hasSecurityGroupForVpcs() ? securityGroupForVpcs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "SecurityGroupForVpcs":
            return Optional.ofNullable(clazz.cast(securityGroupForVpcs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("SecurityGroupForVpcSet", SECURITY_GROUP_FOR_VPCS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSecurityGroupsForVpcResponse, T> g) {
        return obj -> g.apply((GetSecurityGroupsForVpcResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetSecurityGroupsForVpcResponse> {
        /**
         * <p>
         * The token to include in another request to get the next page of items. This value is <code>null</code> when
         * there are no more items to return.
         * </p>
         * 
         * @param nextToken
         *        The token to include in another request to get the next page of items. This value is <code>null</code>
         *        when there are no more items to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The security group that can be used by interfaces in the VPC.
         * </p>
         * 
         * @param securityGroupForVpcs
         *        The security group that can be used by interfaces in the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupForVpcs(Collection<SecurityGroupForVpc> securityGroupForVpcs);

        /**
         * <p>
         * The security group that can be used by interfaces in the VPC.
         * </p>
         * 
         * @param securityGroupForVpcs
         *        The security group that can be used by interfaces in the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupForVpcs(SecurityGroupForVpc... securityGroupForVpcs);

        /**
         * <p>
         * The security group that can be used by interfaces in the VPC.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.SecurityGroupForVpc.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.SecurityGroupForVpc#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.SecurityGroupForVpc.Builder#build()} is called immediately
         * and its result is passed to {@link #securityGroupForVpcs(List<SecurityGroupForVpc>)}.
         * 
         * @param securityGroupForVpcs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.SecurityGroupForVpc.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityGroupForVpcs(java.util.Collection<SecurityGroupForVpc>)
         */
        Builder securityGroupForVpcs(Consumer<SecurityGroupForVpc.Builder>... securityGroupForVpcs);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String nextToken;

        private List<SecurityGroupForVpc> securityGroupForVpcs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSecurityGroupsForVpcResponse model) {
            super(model);
            nextToken(model.nextToken);
            securityGroupForVpcs(model.securityGroupForVpcs);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SecurityGroupForVpc.Builder> getSecurityGroupForVpcs() {
            List<SecurityGroupForVpc.Builder> result = SecurityGroupForVpcListCopier.copyToBuilder(this.securityGroupForVpcs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityGroupForVpcs(Collection<SecurityGroupForVpc.BuilderImpl> securityGroupForVpcs) {
            this.securityGroupForVpcs = SecurityGroupForVpcListCopier.copyFromBuilder(securityGroupForVpcs);
        }

        @Override
        public final Builder securityGroupForVpcs(Collection<SecurityGroupForVpc> securityGroupForVpcs) {
            this.securityGroupForVpcs = SecurityGroupForVpcListCopier.copy(securityGroupForVpcs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupForVpcs(SecurityGroupForVpc... securityGroupForVpcs) {
            securityGroupForVpcs(Arrays.asList(securityGroupForVpcs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupForVpcs(Consumer<SecurityGroupForVpc.Builder>... securityGroupForVpcs) {
            securityGroupForVpcs(Stream.of(securityGroupForVpcs).map(c -> SecurityGroupForVpc.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetSecurityGroupsForVpcResponse build() {
            return new GetSecurityGroupsForVpcResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
