/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeVpcEndpointAssociationsResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeVpcEndpointAssociationsResponse.Builder, DescribeVpcEndpointAssociationsResponse> {
    private static final SdkField<List<VpcEndpointAssociation>> VPC_ENDPOINT_ASSOCIATIONS_FIELD = SdkField
            .<List<VpcEndpointAssociation>> builder(MarshallingType.LIST)
            .memberName("VpcEndpointAssociations")
            .getter(getter(DescribeVpcEndpointAssociationsResponse::vpcEndpointAssociations))
            .setter(setter(Builder::vpcEndpointAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointAssociationSet")
                    .unmarshallLocationName("vpcEndpointAssociationSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<VpcEndpointAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(VpcEndpointAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeVpcEndpointAssociationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VPC_ENDPOINT_ASSOCIATIONS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<VpcEndpointAssociation> vpcEndpointAssociations;

    private final String nextToken;

    private DescribeVpcEndpointAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.vpcEndpointAssociations = builder.vpcEndpointAssociations;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcEndpointAssociations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasVpcEndpointAssociations() {
        return vpcEndpointAssociations != null && !(vpcEndpointAssociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details of the endpoint associations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcEndpointAssociations} method.
     * </p>
     * 
     * @return Details of the endpoint associations.
     */
    public final List<VpcEndpointAssociation> vpcEndpointAssociations() {
        return vpcEndpointAssociations;
    }

    /**
     * <p>
     * The pagination token.
     * </p>
     * 
     * @return The pagination token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcEndpointAssociations() ? vpcEndpointAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcEndpointAssociationsResponse)) {
            return false;
        }
        DescribeVpcEndpointAssociationsResponse other = (DescribeVpcEndpointAssociationsResponse) obj;
        return hasVpcEndpointAssociations() == other.hasVpcEndpointAssociations()
                && Objects.equals(vpcEndpointAssociations(), other.vpcEndpointAssociations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeVpcEndpointAssociationsResponse")
                .add("VpcEndpointAssociations", hasVpcEndpointAssociations() ? vpcEndpointAssociations() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcEndpointAssociations":
            return Optional.ofNullable(clazz.cast(vpcEndpointAssociations()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VpcEndpointAssociationSet", VPC_ENDPOINT_ASSOCIATIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeVpcEndpointAssociationsResponse, T> g) {
        return obj -> g.apply((DescribeVpcEndpointAssociationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeVpcEndpointAssociationsResponse> {
        /**
         * <p>
         * Details of the endpoint associations.
         * </p>
         * 
         * @param vpcEndpointAssociations
         *        Details of the endpoint associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointAssociations(Collection<VpcEndpointAssociation> vpcEndpointAssociations);

        /**
         * <p>
         * Details of the endpoint associations.
         * </p>
         * 
         * @param vpcEndpointAssociations
         *        Details of the endpoint associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointAssociations(VpcEndpointAssociation... vpcEndpointAssociations);

        /**
         * <p>
         * Details of the endpoint associations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.VpcEndpointAssociation.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ec2.model.VpcEndpointAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.VpcEndpointAssociation.Builder#build()} is called
         * immediately and its result is passed to {@link #vpcEndpointAssociations(List<VpcEndpointAssociation>)}.
         * 
         * @param vpcEndpointAssociations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.VpcEndpointAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcEndpointAssociations(java.util.Collection<VpcEndpointAssociation>)
         */
        Builder vpcEndpointAssociations(Consumer<VpcEndpointAssociation.Builder>... vpcEndpointAssociations);

        /**
         * <p>
         * The pagination token.
         * </p>
         * 
         * @param nextToken
         *        The pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<VpcEndpointAssociation> vpcEndpointAssociations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcEndpointAssociationsResponse model) {
            super(model);
            vpcEndpointAssociations(model.vpcEndpointAssociations);
            nextToken(model.nextToken);
        }

        public final List<VpcEndpointAssociation.Builder> getVpcEndpointAssociations() {
            List<VpcEndpointAssociation.Builder> result = VpcEndpointAssociationSetCopier
                    .copyToBuilder(this.vpcEndpointAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcEndpointAssociations(Collection<VpcEndpointAssociation.BuilderImpl> vpcEndpointAssociations) {
            this.vpcEndpointAssociations = VpcEndpointAssociationSetCopier.copyFromBuilder(vpcEndpointAssociations);
        }

        @Override
        public final Builder vpcEndpointAssociations(Collection<VpcEndpointAssociation> vpcEndpointAssociations) {
            this.vpcEndpointAssociations = VpcEndpointAssociationSetCopier.copy(vpcEndpointAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpointAssociations(VpcEndpointAssociation... vpcEndpointAssociations) {
            vpcEndpointAssociations(Arrays.asList(vpcEndpointAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpointAssociations(Consumer<VpcEndpointAssociation.Builder>... vpcEndpointAssociations) {
            vpcEndpointAssociations(Stream.of(vpcEndpointAssociations)
                    .map(c -> VpcEndpointAssociation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeVpcEndpointAssociationsResponse build() {
            return new DescribeVpcEndpointAssociationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
