/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRouteServerEndpointsResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeRouteServerEndpointsResponse.Builder, DescribeRouteServerEndpointsResponse> {
    private static final SdkField<List<RouteServerEndpoint>> ROUTE_SERVER_ENDPOINTS_FIELD = SdkField
            .<List<RouteServerEndpoint>> builder(MarshallingType.LIST)
            .memberName("RouteServerEndpoints")
            .getter(getter(DescribeRouteServerEndpointsResponse::routeServerEndpoints))
            .setter(setter(Builder::routeServerEndpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteServerEndpointSet")
                    .unmarshallLocationName("routeServerEndpointSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<RouteServerEndpoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteServerEndpoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeRouteServerEndpointsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTE_SERVER_ENDPOINTS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<RouteServerEndpoint> routeServerEndpoints;

    private final String nextToken;

    private DescribeRouteServerEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.routeServerEndpoints = builder.routeServerEndpoints;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the RouteServerEndpoints property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRouteServerEndpoints() {
        return routeServerEndpoints != null && !(routeServerEndpoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the described route server endpoints.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRouteServerEndpoints} method.
     * </p>
     * 
     * @return Information about the described route server endpoints.
     */
    public final List<RouteServerEndpoint> routeServerEndpoints() {
        return routeServerEndpoints;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRouteServerEndpoints() ? routeServerEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRouteServerEndpointsResponse)) {
            return false;
        }
        DescribeRouteServerEndpointsResponse other = (DescribeRouteServerEndpointsResponse) obj;
        return hasRouteServerEndpoints() == other.hasRouteServerEndpoints()
                && Objects.equals(routeServerEndpoints(), other.routeServerEndpoints())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeRouteServerEndpointsResponse")
                .add("RouteServerEndpoints", hasRouteServerEndpoints() ? routeServerEndpoints() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RouteServerEndpoints":
            return Optional.ofNullable(clazz.cast(routeServerEndpoints()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RouteServerEndpointSet", ROUTE_SERVER_ENDPOINTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeRouteServerEndpointsResponse, T> g) {
        return obj -> g.apply((DescribeRouteServerEndpointsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeRouteServerEndpointsResponse> {
        /**
         * <p>
         * Information about the described route server endpoints.
         * </p>
         * 
         * @param routeServerEndpoints
         *        Information about the described route server endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeServerEndpoints(Collection<RouteServerEndpoint> routeServerEndpoints);

        /**
         * <p>
         * Information about the described route server endpoints.
         * </p>
         * 
         * @param routeServerEndpoints
         *        Information about the described route server endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeServerEndpoints(RouteServerEndpoint... routeServerEndpoints);

        /**
         * <p>
         * Information about the described route server endpoints.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.RouteServerEndpoint.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.RouteServerEndpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.RouteServerEndpoint.Builder#build()} is called immediately
         * and its result is passed to {@link #routeServerEndpoints(List<RouteServerEndpoint>)}.
         * 
         * @param routeServerEndpoints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.RouteServerEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routeServerEndpoints(java.util.Collection<RouteServerEndpoint>)
         */
        Builder routeServerEndpoints(Consumer<RouteServerEndpoint.Builder>... routeServerEndpoints);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<RouteServerEndpoint> routeServerEndpoints = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRouteServerEndpointsResponse model) {
            super(model);
            routeServerEndpoints(model.routeServerEndpoints);
            nextToken(model.nextToken);
        }

        public final List<RouteServerEndpoint.Builder> getRouteServerEndpoints() {
            List<RouteServerEndpoint.Builder> result = RouteServerEndpointsListCopier.copyToBuilder(this.routeServerEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRouteServerEndpoints(Collection<RouteServerEndpoint.BuilderImpl> routeServerEndpoints) {
            this.routeServerEndpoints = RouteServerEndpointsListCopier.copyFromBuilder(routeServerEndpoints);
        }

        @Override
        public final Builder routeServerEndpoints(Collection<RouteServerEndpoint> routeServerEndpoints) {
            this.routeServerEndpoints = RouteServerEndpointsListCopier.copy(routeServerEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeServerEndpoints(RouteServerEndpoint... routeServerEndpoints) {
            routeServerEndpoints(Arrays.asList(routeServerEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeServerEndpoints(Consumer<RouteServerEndpoint.Builder>... routeServerEndpoints) {
            routeServerEndpoints(Stream.of(routeServerEndpoints).map(c -> RouteServerEndpoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeRouteServerEndpointsResponse build() {
            return new DescribeRouteServerEndpointsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
