/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an association between a branch network interface with a trunk network interface.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrunkInterfaceAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<TrunkInterfaceAssociation.Builder, TrunkInterfaceAssociation> {
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AssociationId")
            .getter(getter(TrunkInterfaceAssociation::associationId))
            .setter(setter(Builder::associationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId")
                    .unmarshallLocationName("associationId").build()).build();

    private static final SdkField<String> BRANCH_INTERFACE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("BranchInterfaceId")
            .getter(getter(TrunkInterfaceAssociation::branchInterfaceId))
            .setter(setter(Builder::branchInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BranchInterfaceId")
                    .unmarshallLocationName("branchInterfaceId").build()).build();

    private static final SdkField<String> TRUNK_INTERFACE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TrunkInterfaceId")
            .getter(getter(TrunkInterfaceAssociation::trunkInterfaceId))
            .setter(setter(Builder::trunkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrunkInterfaceId")
                    .unmarshallLocationName("trunkInterfaceId").build()).build();

    private static final SdkField<String> INTERFACE_PROTOCOL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InterfaceProtocol")
            .getter(getter(TrunkInterfaceAssociation::interfaceProtocolAsString))
            .setter(setter(Builder::interfaceProtocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InterfaceProtocol")
                    .unmarshallLocationName("interfaceProtocol").build()).build();

    private static final SdkField<Integer> VLAN_ID_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("VlanId")
            .getter(getter(TrunkInterfaceAssociation::vlanId))
            .setter(setter(Builder::vlanId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VlanId")
                    .unmarshallLocationName("vlanId").build()).build();

    private static final SdkField<Integer> GRE_KEY_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("GreKey")
            .getter(getter(TrunkInterfaceAssociation::greKey))
            .setter(setter(Builder::greKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GreKey")
                    .unmarshallLocationName("greKey").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(TrunkInterfaceAssociation::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ID_FIELD,
            BRANCH_INTERFACE_ID_FIELD, TRUNK_INTERFACE_ID_FIELD, INTERFACE_PROTOCOL_FIELD, VLAN_ID_FIELD, GRE_KEY_FIELD,
            TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String associationId;

    private final String branchInterfaceId;

    private final String trunkInterfaceId;

    private final String interfaceProtocol;

    private final Integer vlanId;

    private final Integer greKey;

    private final List<Tag> tags;

    private TrunkInterfaceAssociation(BuilderImpl builder) {
        this.associationId = builder.associationId;
        this.branchInterfaceId = builder.branchInterfaceId;
        this.trunkInterfaceId = builder.trunkInterfaceId;
        this.interfaceProtocol = builder.interfaceProtocol;
        this.vlanId = builder.vlanId;
        this.greKey = builder.greKey;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the association.
     * </p>
     * 
     * @return The ID of the association.
     */
    public final String associationId() {
        return associationId;
    }

    /**
     * <p>
     * The ID of the branch network interface.
     * </p>
     * 
     * @return The ID of the branch network interface.
     */
    public final String branchInterfaceId() {
        return branchInterfaceId;
    }

    /**
     * <p>
     * The ID of the trunk network interface.
     * </p>
     * 
     * @return The ID of the trunk network interface.
     */
    public final String trunkInterfaceId() {
        return trunkInterfaceId;
    }

    /**
     * <p>
     * The interface protocol. Valid values are <code>VLAN</code> and <code>GRE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interfaceProtocol}
     * will return {@link InterfaceProtocolType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #interfaceProtocolAsString}.
     * </p>
     * 
     * @return The interface protocol. Valid values are <code>VLAN</code> and <code>GRE</code>.
     * @see InterfaceProtocolType
     */
    public final InterfaceProtocolType interfaceProtocol() {
        return InterfaceProtocolType.fromValue(interfaceProtocol);
    }

    /**
     * <p>
     * The interface protocol. Valid values are <code>VLAN</code> and <code>GRE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interfaceProtocol}
     * will return {@link InterfaceProtocolType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #interfaceProtocolAsString}.
     * </p>
     * 
     * @return The interface protocol. Valid values are <code>VLAN</code> and <code>GRE</code>.
     * @see InterfaceProtocolType
     */
    public final String interfaceProtocolAsString() {
        return interfaceProtocol;
    }

    /**
     * <p>
     * The ID of the VLAN when you use the VLAN protocol.
     * </p>
     * 
     * @return The ID of the VLAN when you use the VLAN protocol.
     */
    public final Integer vlanId() {
        return vlanId;
    }

    /**
     * <p>
     * The application key when you use the GRE protocol.
     * </p>
     * 
     * @return The application key when you use the GRE protocol.
     */
    public final Integer greKey() {
        return greKey;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags for the trunk interface association.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags for the trunk interface association.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(associationId());
        hashCode = 31 * hashCode + Objects.hashCode(branchInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(trunkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(interfaceProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vlanId());
        hashCode = 31 * hashCode + Objects.hashCode(greKey());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrunkInterfaceAssociation)) {
            return false;
        }
        TrunkInterfaceAssociation other = (TrunkInterfaceAssociation) obj;
        return Objects.equals(associationId(), other.associationId())
                && Objects.equals(branchInterfaceId(), other.branchInterfaceId())
                && Objects.equals(trunkInterfaceId(), other.trunkInterfaceId())
                && Objects.equals(interfaceProtocolAsString(), other.interfaceProtocolAsString())
                && Objects.equals(vlanId(), other.vlanId()) && Objects.equals(greKey(), other.greKey())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrunkInterfaceAssociation").add("AssociationId", associationId())
                .add("BranchInterfaceId", branchInterfaceId()).add("TrunkInterfaceId", trunkInterfaceId())
                .add("InterfaceProtocol", interfaceProtocolAsString()).add("VlanId", vlanId()).add("GreKey", greKey())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociationId":
            return Optional.ofNullable(clazz.cast(associationId()));
        case "BranchInterfaceId":
            return Optional.ofNullable(clazz.cast(branchInterfaceId()));
        case "TrunkInterfaceId":
            return Optional.ofNullable(clazz.cast(trunkInterfaceId()));
        case "InterfaceProtocol":
            return Optional.ofNullable(clazz.cast(interfaceProtocolAsString()));
        case "VlanId":
            return Optional.ofNullable(clazz.cast(vlanId()));
        case "GreKey":
            return Optional.ofNullable(clazz.cast(greKey()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AssociationId", ASSOCIATION_ID_FIELD);
        map.put("BranchInterfaceId", BRANCH_INTERFACE_ID_FIELD);
        map.put("TrunkInterfaceId", TRUNK_INTERFACE_ID_FIELD);
        map.put("InterfaceProtocol", INTERFACE_PROTOCOL_FIELD);
        map.put("VlanId", VLAN_ID_FIELD);
        map.put("GreKey", GRE_KEY_FIELD);
        map.put("TagSet", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrunkInterfaceAssociation, T> g) {
        return obj -> g.apply((TrunkInterfaceAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrunkInterfaceAssociation> {
        /**
         * <p>
         * The ID of the association.
         * </p>
         * 
         * @param associationId
         *        The ID of the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationId(String associationId);

        /**
         * <p>
         * The ID of the branch network interface.
         * </p>
         * 
         * @param branchInterfaceId
         *        The ID of the branch network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branchInterfaceId(String branchInterfaceId);

        /**
         * <p>
         * The ID of the trunk network interface.
         * </p>
         * 
         * @param trunkInterfaceId
         *        The ID of the trunk network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trunkInterfaceId(String trunkInterfaceId);

        /**
         * <p>
         * The interface protocol. Valid values are <code>VLAN</code> and <code>GRE</code>.
         * </p>
         * 
         * @param interfaceProtocol
         *        The interface protocol. Valid values are <code>VLAN</code> and <code>GRE</code>.
         * @see InterfaceProtocolType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InterfaceProtocolType
         */
        Builder interfaceProtocol(String interfaceProtocol);

        /**
         * <p>
         * The interface protocol. Valid values are <code>VLAN</code> and <code>GRE</code>.
         * </p>
         * 
         * @param interfaceProtocol
         *        The interface protocol. Valid values are <code>VLAN</code> and <code>GRE</code>.
         * @see InterfaceProtocolType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InterfaceProtocolType
         */
        Builder interfaceProtocol(InterfaceProtocolType interfaceProtocol);

        /**
         * <p>
         * The ID of the VLAN when you use the VLAN protocol.
         * </p>
         * 
         * @param vlanId
         *        The ID of the VLAN when you use the VLAN protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vlanId(Integer vlanId);

        /**
         * <p>
         * The application key when you use the GRE protocol.
         * </p>
         * 
         * @param greKey
         *        The application key when you use the GRE protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder greKey(Integer greKey);

        /**
         * <p>
         * The tags for the trunk interface association.
         * </p>
         * 
         * @param tags
         *        The tags for the trunk interface association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags for the trunk interface association.
         * </p>
         * 
         * @param tags
         *        The tags for the trunk interface association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags for the trunk interface association.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String associationId;

        private String branchInterfaceId;

        private String trunkInterfaceId;

        private String interfaceProtocol;

        private Integer vlanId;

        private Integer greKey;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TrunkInterfaceAssociation model) {
            associationId(model.associationId);
            branchInterfaceId(model.branchInterfaceId);
            trunkInterfaceId(model.trunkInterfaceId);
            interfaceProtocol(model.interfaceProtocol);
            vlanId(model.vlanId);
            greKey(model.greKey);
            tags(model.tags);
        }

        public final String getAssociationId() {
            return associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getBranchInterfaceId() {
            return branchInterfaceId;
        }

        public final void setBranchInterfaceId(String branchInterfaceId) {
            this.branchInterfaceId = branchInterfaceId;
        }

        @Override
        public final Builder branchInterfaceId(String branchInterfaceId) {
            this.branchInterfaceId = branchInterfaceId;
            return this;
        }

        public final String getTrunkInterfaceId() {
            return trunkInterfaceId;
        }

        public final void setTrunkInterfaceId(String trunkInterfaceId) {
            this.trunkInterfaceId = trunkInterfaceId;
        }

        @Override
        public final Builder trunkInterfaceId(String trunkInterfaceId) {
            this.trunkInterfaceId = trunkInterfaceId;
            return this;
        }

        public final String getInterfaceProtocol() {
            return interfaceProtocol;
        }

        public final void setInterfaceProtocol(String interfaceProtocol) {
            this.interfaceProtocol = interfaceProtocol;
        }

        @Override
        public final Builder interfaceProtocol(String interfaceProtocol) {
            this.interfaceProtocol = interfaceProtocol;
            return this;
        }

        @Override
        public final Builder interfaceProtocol(InterfaceProtocolType interfaceProtocol) {
            this.interfaceProtocol(interfaceProtocol == null ? null : interfaceProtocol.toString());
            return this;
        }

        public final Integer getVlanId() {
            return vlanId;
        }

        public final void setVlanId(Integer vlanId) {
            this.vlanId = vlanId;
        }

        @Override
        public final Builder vlanId(Integer vlanId) {
            this.vlanId = vlanId;
            return this;
        }

        public final Integer getGreKey() {
            return greKey;
        }

        public final void setGreKey(Integer greKey) {
            this.greKey = greKey;
        }

        @Override
        public final Builder greKey(Integer greKey) {
            this.greKey = greKey;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public TrunkInterfaceAssociation build() {
            return new TrunkInterfaceAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
