/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <note>
 * <p>
 * Amazon Elastic Inference is no longer available.
 * </p>
 * </note>
 * <p>
 * Describes the association between an instance and an elastic inference accelerator.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ElasticInferenceAcceleratorAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<ElasticInferenceAcceleratorAssociation.Builder, ElasticInferenceAcceleratorAssociation> {
    private static final SdkField<String> ELASTIC_INFERENCE_ACCELERATOR_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ElasticInferenceAcceleratorArn")
            .getter(getter(ElasticInferenceAcceleratorAssociation::elasticInferenceAcceleratorArn))
            .setter(setter(Builder::elasticInferenceAcceleratorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticInferenceAcceleratorArn")
                    .unmarshallLocationName("elasticInferenceAcceleratorArn").build()).build();

    private static final SdkField<String> ELASTIC_INFERENCE_ACCELERATOR_ASSOCIATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ElasticInferenceAcceleratorAssociationId")
            .getter(getter(ElasticInferenceAcceleratorAssociation::elasticInferenceAcceleratorAssociationId))
            .setter(setter(Builder::elasticInferenceAcceleratorAssociationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ElasticInferenceAcceleratorAssociationId")
                    .unmarshallLocationName("elasticInferenceAcceleratorAssociationId").build()).build();

    private static final SdkField<String> ELASTIC_INFERENCE_ACCELERATOR_ASSOCIATION_STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ElasticInferenceAcceleratorAssociationState")
            .getter(getter(ElasticInferenceAcceleratorAssociation::elasticInferenceAcceleratorAssociationState))
            .setter(setter(Builder::elasticInferenceAcceleratorAssociationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ElasticInferenceAcceleratorAssociationState")
                    .unmarshallLocationName("elasticInferenceAcceleratorAssociationState").build()).build();

    private static final SdkField<Instant> ELASTIC_INFERENCE_ACCELERATOR_ASSOCIATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ElasticInferenceAcceleratorAssociationTime")
            .getter(getter(ElasticInferenceAcceleratorAssociation::elasticInferenceAcceleratorAssociationTime))
            .setter(setter(Builder::elasticInferenceAcceleratorAssociationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ElasticInferenceAcceleratorAssociationTime")
                    .unmarshallLocationName("elasticInferenceAcceleratorAssociationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ELASTIC_INFERENCE_ACCELERATOR_ARN_FIELD, ELASTIC_INFERENCE_ACCELERATOR_ASSOCIATION_ID_FIELD,
            ELASTIC_INFERENCE_ACCELERATOR_ASSOCIATION_STATE_FIELD, ELASTIC_INFERENCE_ACCELERATOR_ASSOCIATION_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String elasticInferenceAcceleratorArn;

    private final String elasticInferenceAcceleratorAssociationId;

    private final String elasticInferenceAcceleratorAssociationState;

    private final Instant elasticInferenceAcceleratorAssociationTime;

    private ElasticInferenceAcceleratorAssociation(BuilderImpl builder) {
        this.elasticInferenceAcceleratorArn = builder.elasticInferenceAcceleratorArn;
        this.elasticInferenceAcceleratorAssociationId = builder.elasticInferenceAcceleratorAssociationId;
        this.elasticInferenceAcceleratorAssociationState = builder.elasticInferenceAcceleratorAssociationState;
        this.elasticInferenceAcceleratorAssociationTime = builder.elasticInferenceAcceleratorAssociationTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the elastic inference accelerator.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the elastic inference accelerator.
     */
    public final String elasticInferenceAcceleratorArn() {
        return elasticInferenceAcceleratorArn;
    }

    /**
     * <p>
     * The ID of the association.
     * </p>
     * 
     * @return The ID of the association.
     */
    public final String elasticInferenceAcceleratorAssociationId() {
        return elasticInferenceAcceleratorAssociationId;
    }

    /**
     * <p>
     * The state of the elastic inference accelerator.
     * </p>
     * 
     * @return The state of the elastic inference accelerator.
     */
    public final String elasticInferenceAcceleratorAssociationState() {
        return elasticInferenceAcceleratorAssociationState;
    }

    /**
     * <p>
     * The time at which the elastic inference accelerator is associated with an instance.
     * </p>
     * 
     * @return The time at which the elastic inference accelerator is associated with an instance.
     */
    public final Instant elasticInferenceAcceleratorAssociationTime() {
        return elasticInferenceAcceleratorAssociationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(elasticInferenceAcceleratorArn());
        hashCode = 31 * hashCode + Objects.hashCode(elasticInferenceAcceleratorAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(elasticInferenceAcceleratorAssociationState());
        hashCode = 31 * hashCode + Objects.hashCode(elasticInferenceAcceleratorAssociationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticInferenceAcceleratorAssociation)) {
            return false;
        }
        ElasticInferenceAcceleratorAssociation other = (ElasticInferenceAcceleratorAssociation) obj;
        return Objects.equals(elasticInferenceAcceleratorArn(), other.elasticInferenceAcceleratorArn())
                && Objects.equals(elasticInferenceAcceleratorAssociationId(), other.elasticInferenceAcceleratorAssociationId())
                && Objects.equals(elasticInferenceAcceleratorAssociationState(),
                        other.elasticInferenceAcceleratorAssociationState())
                && Objects.equals(elasticInferenceAcceleratorAssociationTime(),
                        other.elasticInferenceAcceleratorAssociationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ElasticInferenceAcceleratorAssociation")
                .add("ElasticInferenceAcceleratorArn", elasticInferenceAcceleratorArn())
                .add("ElasticInferenceAcceleratorAssociationId", elasticInferenceAcceleratorAssociationId())
                .add("ElasticInferenceAcceleratorAssociationState", elasticInferenceAcceleratorAssociationState())
                .add("ElasticInferenceAcceleratorAssociationTime", elasticInferenceAcceleratorAssociationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ElasticInferenceAcceleratorArn":
            return Optional.ofNullable(clazz.cast(elasticInferenceAcceleratorArn()));
        case "ElasticInferenceAcceleratorAssociationId":
            return Optional.ofNullable(clazz.cast(elasticInferenceAcceleratorAssociationId()));
        case "ElasticInferenceAcceleratorAssociationState":
            return Optional.ofNullable(clazz.cast(elasticInferenceAcceleratorAssociationState()));
        case "ElasticInferenceAcceleratorAssociationTime":
            return Optional.ofNullable(clazz.cast(elasticInferenceAcceleratorAssociationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ElasticInferenceAcceleratorArn", ELASTIC_INFERENCE_ACCELERATOR_ARN_FIELD);
        map.put("ElasticInferenceAcceleratorAssociationId", ELASTIC_INFERENCE_ACCELERATOR_ASSOCIATION_ID_FIELD);
        map.put("ElasticInferenceAcceleratorAssociationState", ELASTIC_INFERENCE_ACCELERATOR_ASSOCIATION_STATE_FIELD);
        map.put("ElasticInferenceAcceleratorAssociationTime", ELASTIC_INFERENCE_ACCELERATOR_ASSOCIATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ElasticInferenceAcceleratorAssociation, T> g) {
        return obj -> g.apply((ElasticInferenceAcceleratorAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ElasticInferenceAcceleratorAssociation> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the elastic inference accelerator.
         * </p>
         * 
         * @param elasticInferenceAcceleratorArn
         *        The Amazon Resource Name (ARN) of the elastic inference accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticInferenceAcceleratorArn(String elasticInferenceAcceleratorArn);

        /**
         * <p>
         * The ID of the association.
         * </p>
         * 
         * @param elasticInferenceAcceleratorAssociationId
         *        The ID of the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticInferenceAcceleratorAssociationId(String elasticInferenceAcceleratorAssociationId);

        /**
         * <p>
         * The state of the elastic inference accelerator.
         * </p>
         * 
         * @param elasticInferenceAcceleratorAssociationState
         *        The state of the elastic inference accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticInferenceAcceleratorAssociationState(String elasticInferenceAcceleratorAssociationState);

        /**
         * <p>
         * The time at which the elastic inference accelerator is associated with an instance.
         * </p>
         * 
         * @param elasticInferenceAcceleratorAssociationTime
         *        The time at which the elastic inference accelerator is associated with an instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticInferenceAcceleratorAssociationTime(Instant elasticInferenceAcceleratorAssociationTime);
    }

    static final class BuilderImpl implements Builder {
        private String elasticInferenceAcceleratorArn;

        private String elasticInferenceAcceleratorAssociationId;

        private String elasticInferenceAcceleratorAssociationState;

        private Instant elasticInferenceAcceleratorAssociationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticInferenceAcceleratorAssociation model) {
            elasticInferenceAcceleratorArn(model.elasticInferenceAcceleratorArn);
            elasticInferenceAcceleratorAssociationId(model.elasticInferenceAcceleratorAssociationId);
            elasticInferenceAcceleratorAssociationState(model.elasticInferenceAcceleratorAssociationState);
            elasticInferenceAcceleratorAssociationTime(model.elasticInferenceAcceleratorAssociationTime);
        }

        public final String getElasticInferenceAcceleratorArn() {
            return elasticInferenceAcceleratorArn;
        }

        public final void setElasticInferenceAcceleratorArn(String elasticInferenceAcceleratorArn) {
            this.elasticInferenceAcceleratorArn = elasticInferenceAcceleratorArn;
        }

        @Override
        public final Builder elasticInferenceAcceleratorArn(String elasticInferenceAcceleratorArn) {
            this.elasticInferenceAcceleratorArn = elasticInferenceAcceleratorArn;
            return this;
        }

        public final String getElasticInferenceAcceleratorAssociationId() {
            return elasticInferenceAcceleratorAssociationId;
        }

        public final void setElasticInferenceAcceleratorAssociationId(String elasticInferenceAcceleratorAssociationId) {
            this.elasticInferenceAcceleratorAssociationId = elasticInferenceAcceleratorAssociationId;
        }

        @Override
        public final Builder elasticInferenceAcceleratorAssociationId(String elasticInferenceAcceleratorAssociationId) {
            this.elasticInferenceAcceleratorAssociationId = elasticInferenceAcceleratorAssociationId;
            return this;
        }

        public final String getElasticInferenceAcceleratorAssociationState() {
            return elasticInferenceAcceleratorAssociationState;
        }

        public final void setElasticInferenceAcceleratorAssociationState(String elasticInferenceAcceleratorAssociationState) {
            this.elasticInferenceAcceleratorAssociationState = elasticInferenceAcceleratorAssociationState;
        }

        @Override
        public final Builder elasticInferenceAcceleratorAssociationState(String elasticInferenceAcceleratorAssociationState) {
            this.elasticInferenceAcceleratorAssociationState = elasticInferenceAcceleratorAssociationState;
            return this;
        }

        public final Instant getElasticInferenceAcceleratorAssociationTime() {
            return elasticInferenceAcceleratorAssociationTime;
        }

        public final void setElasticInferenceAcceleratorAssociationTime(Instant elasticInferenceAcceleratorAssociationTime) {
            this.elasticInferenceAcceleratorAssociationTime = elasticInferenceAcceleratorAssociationTime;
        }

        @Override
        public final Builder elasticInferenceAcceleratorAssociationTime(Instant elasticInferenceAcceleratorAssociationTime) {
            this.elasticInferenceAcceleratorAssociationTime = elasticInferenceAcceleratorAssociationTime;
            return this;
        }

        @Override
        public ElasticInferenceAcceleratorAssociation build() {
            return new ElasticInferenceAcceleratorAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
