/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateIpamByoasnResponse extends Ec2Response implements
        ToCopyableBuilder<DisassociateIpamByoasnResponse.Builder, DisassociateIpamByoasnResponse> {
    private static final SdkField<AsnAssociation> ASN_ASSOCIATION_FIELD = SdkField
            .<AsnAssociation> builder(MarshallingType.SDK_POJO)
            .memberName("AsnAssociation")
            .getter(getter(DisassociateIpamByoasnResponse::asnAssociation))
            .setter(setter(Builder::asnAssociation))
            .constructor(AsnAssociation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AsnAssociation")
                    .unmarshallLocationName("asnAssociation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASN_ASSOCIATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AsnAssociation asnAssociation;

    private DisassociateIpamByoasnResponse(BuilderImpl builder) {
        super(builder);
        this.asnAssociation = builder.asnAssociation;
    }

    /**
     * <p>
     * An ASN and BYOIP CIDR association.
     * </p>
     * 
     * @return An ASN and BYOIP CIDR association.
     */
    public final AsnAssociation asnAssociation() {
        return asnAssociation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(asnAssociation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateIpamByoasnResponse)) {
            return false;
        }
        DisassociateIpamByoasnResponse other = (DisassociateIpamByoasnResponse) obj;
        return Objects.equals(asnAssociation(), other.asnAssociation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisassociateIpamByoasnResponse").add("AsnAssociation", asnAssociation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AsnAssociation":
            return Optional.ofNullable(clazz.cast(asnAssociation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AsnAssociation", ASN_ASSOCIATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisassociateIpamByoasnResponse, T> g) {
        return obj -> g.apply((DisassociateIpamByoasnResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DisassociateIpamByoasnResponse> {
        /**
         * <p>
         * An ASN and BYOIP CIDR association.
         * </p>
         * 
         * @param asnAssociation
         *        An ASN and BYOIP CIDR association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder asnAssociation(AsnAssociation asnAssociation);

        /**
         * <p>
         * An ASN and BYOIP CIDR association.
         * </p>
         * This is a convenience method that creates an instance of the {@link AsnAssociation.Builder} avoiding the need
         * to create one manually via {@link AsnAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AsnAssociation.Builder#build()} is called immediately and its
         * result is passed to {@link #asnAssociation(AsnAssociation)}.
         * 
         * @param asnAssociation
         *        a consumer that will call methods on {@link AsnAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #asnAssociation(AsnAssociation)
         */
        default Builder asnAssociation(Consumer<AsnAssociation.Builder> asnAssociation) {
            return asnAssociation(AsnAssociation.builder().applyMutation(asnAssociation).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private AsnAssociation asnAssociation;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateIpamByoasnResponse model) {
            super(model);
            asnAssociation(model.asnAssociation);
        }

        public final AsnAssociation.Builder getAsnAssociation() {
            return asnAssociation != null ? asnAssociation.toBuilder() : null;
        }

        public final void setAsnAssociation(AsnAssociation.BuilderImpl asnAssociation) {
            this.asnAssociation = asnAssociation != null ? asnAssociation.build() : null;
        }

        @Override
        public final Builder asnAssociation(AsnAssociation asnAssociation) {
            this.asnAssociation = asnAssociation;
            return this;
        }

        @Override
        public DisassociateIpamByoasnResponse build() {
            return new DisassociateIpamByoasnResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
