/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteNetworkInsightsAccessScopeResponse extends Ec2Response implements
        ToCopyableBuilder<DeleteNetworkInsightsAccessScopeResponse.Builder, DeleteNetworkInsightsAccessScopeResponse> {
    private static final SdkField<String> NETWORK_INSIGHTS_ACCESS_SCOPE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInsightsAccessScopeId")
            .getter(getter(DeleteNetworkInsightsAccessScopeResponse::networkInsightsAccessScopeId))
            .setter(setter(Builder::networkInsightsAccessScopeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInsightsAccessScopeId")
                    .unmarshallLocationName("networkInsightsAccessScopeId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(NETWORK_INSIGHTS_ACCESS_SCOPE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String networkInsightsAccessScopeId;

    private DeleteNetworkInsightsAccessScopeResponse(BuilderImpl builder) {
        super(builder);
        this.networkInsightsAccessScopeId = builder.networkInsightsAccessScopeId;
    }

    /**
     * <p>
     * The ID of the Network Access Scope.
     * </p>
     * 
     * @return The ID of the Network Access Scope.
     */
    public final String networkInsightsAccessScopeId() {
        return networkInsightsAccessScopeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(networkInsightsAccessScopeId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteNetworkInsightsAccessScopeResponse)) {
            return false;
        }
        DeleteNetworkInsightsAccessScopeResponse other = (DeleteNetworkInsightsAccessScopeResponse) obj;
        return Objects.equals(networkInsightsAccessScopeId(), other.networkInsightsAccessScopeId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteNetworkInsightsAccessScopeResponse")
                .add("NetworkInsightsAccessScopeId", networkInsightsAccessScopeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkInsightsAccessScopeId":
            return Optional.ofNullable(clazz.cast(networkInsightsAccessScopeId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NetworkInsightsAccessScopeId", NETWORK_INSIGHTS_ACCESS_SCOPE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteNetworkInsightsAccessScopeResponse, T> g) {
        return obj -> g.apply((DeleteNetworkInsightsAccessScopeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteNetworkInsightsAccessScopeResponse> {
        /**
         * <p>
         * The ID of the Network Access Scope.
         * </p>
         * 
         * @param networkInsightsAccessScopeId
         *        The ID of the Network Access Scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInsightsAccessScopeId(String networkInsightsAccessScopeId);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String networkInsightsAccessScopeId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteNetworkInsightsAccessScopeResponse model) {
            super(model);
            networkInsightsAccessScopeId(model.networkInsightsAccessScopeId);
        }

        public final String getNetworkInsightsAccessScopeId() {
            return networkInsightsAccessScopeId;
        }

        public final void setNetworkInsightsAccessScopeId(String networkInsightsAccessScopeId) {
            this.networkInsightsAccessScopeId = networkInsightsAccessScopeId;
        }

        @Override
        public final Builder networkInsightsAccessScopeId(String networkInsightsAccessScopeId) {
            this.networkInsightsAccessScopeId = networkInsightsAccessScopeId;
            return this;
        }

        @Override
        public DeleteNetworkInsightsAccessScopeResponse build() {
            return new DeleteNetworkInsightsAccessScopeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
