/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.PrefixListAssociation;
import software.amazon.awssdk.services.ec2.model.PrefixListAssociationSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetManagedPrefixListAssociationsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, GetManagedPrefixListAssociationsResponse> {
    private static final SdkField<List<PrefixListAssociation>> PREFIX_LIST_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PrefixListAssociations").getter(GetManagedPrefixListAssociationsResponse.getter(GetManagedPrefixListAssociationsResponse::prefixListAssociations)).setter(GetManagedPrefixListAssociationsResponse.setter(Builder::prefixListAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListAssociationSet").unmarshallLocationName("prefixListAssociationSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PrefixListAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetManagedPrefixListAssociationsResponse.getter(GetManagedPrefixListAssociationsResponse::nextToken)).setter(GetManagedPrefixListAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREFIX_LIST_ASSOCIATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetManagedPrefixListAssociationsResponse.memberNameToFieldInitializer();
    private final List<PrefixListAssociation> prefixListAssociations;
    private final String nextToken;

    private GetManagedPrefixListAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.prefixListAssociations = builder.prefixListAssociations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPrefixListAssociations() {
        return this.prefixListAssociations != null && !(this.prefixListAssociations instanceof SdkAutoConstructList);
    }

    public final List<PrefixListAssociation> prefixListAssociations() {
        return this.prefixListAssociations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrefixListAssociations() ? this.prefixListAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetManagedPrefixListAssociationsResponse)) {
            return false;
        }
        GetManagedPrefixListAssociationsResponse other = (GetManagedPrefixListAssociationsResponse)((Object)obj);
        return this.hasPrefixListAssociations() == other.hasPrefixListAssociations() && Objects.equals(this.prefixListAssociations(), other.prefixListAssociations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetManagedPrefixListAssociationsResponse").add("PrefixListAssociations", this.hasPrefixListAssociations() ? this.prefixListAssociations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PrefixListAssociations": {
                return Optional.ofNullable(clazz.cast(this.prefixListAssociations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PrefixListAssociationSet", PREFIX_LIST_ASSOCIATIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetManagedPrefixListAssociationsResponse, T> g) {
        return obj -> g.apply((GetManagedPrefixListAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<PrefixListAssociation> prefixListAssociations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetManagedPrefixListAssociationsResponse model) {
            super(model);
            this.prefixListAssociations(model.prefixListAssociations);
            this.nextToken(model.nextToken);
        }

        public final List<PrefixListAssociation.Builder> getPrefixListAssociations() {
            List<PrefixListAssociation.Builder> result = PrefixListAssociationSetCopier.copyToBuilder(this.prefixListAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrefixListAssociations(Collection<PrefixListAssociation.BuilderImpl> prefixListAssociations) {
            this.prefixListAssociations = PrefixListAssociationSetCopier.copyFromBuilder(prefixListAssociations);
        }

        @Override
        public final Builder prefixListAssociations(Collection<PrefixListAssociation> prefixListAssociations) {
            this.prefixListAssociations = PrefixListAssociationSetCopier.copy(prefixListAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder prefixListAssociations(PrefixListAssociation ... prefixListAssociations) {
            this.prefixListAssociations(Arrays.asList(prefixListAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder prefixListAssociations(Consumer<PrefixListAssociation.Builder> ... prefixListAssociations) {
            this.prefixListAssociations(Stream.of(prefixListAssociations).map(c -> (PrefixListAssociation)((PrefixListAssociation.Builder)PrefixListAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetManagedPrefixListAssociationsResponse build() {
            return new GetManagedPrefixListAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetManagedPrefixListAssociationsResponse> {
        public Builder prefixListAssociations(Collection<PrefixListAssociation> var1);

        public Builder prefixListAssociations(PrefixListAssociation ... var1);

        public Builder prefixListAssociations(Consumer<PrefixListAssociation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

