/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the trust provider.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VerifiedAccessInstanceUserTrustProviderClientConfiguration
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<VerifiedAccessInstanceUserTrustProviderClientConfiguration.Builder, VerifiedAccessInstanceUserTrustProviderClientConfiguration> {
    private static final SdkField<String> TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Type")
            .getter(getter(VerifiedAccessInstanceUserTrustProviderClientConfiguration::typeAsString))
            .setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type")
                    .unmarshallLocationName("type").build()).build();

    private static final SdkField<String> SCOPES_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Scopes")
            .getter(getter(VerifiedAccessInstanceUserTrustProviderClientConfiguration::scopes))
            .setter(setter(Builder::scopes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scopes")
                    .unmarshallLocationName("scopes").build()).build();

    private static final SdkField<String> ISSUER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Issuer")
            .getter(getter(VerifiedAccessInstanceUserTrustProviderClientConfiguration::issuer))
            .setter(setter(Builder::issuer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Issuer")
                    .unmarshallLocationName("issuer").build()).build();

    private static final SdkField<String> AUTHORIZATION_ENDPOINT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AuthorizationEndpoint")
            .getter(getter(VerifiedAccessInstanceUserTrustProviderClientConfiguration::authorizationEndpoint))
            .setter(setter(Builder::authorizationEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationEndpoint")
                    .unmarshallLocationName("authorizationEndpoint").build()).build();

    private static final SdkField<String> PUBLIC_SIGNING_KEY_ENDPOINT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PublicSigningKeyEndpoint")
            .getter(getter(VerifiedAccessInstanceUserTrustProviderClientConfiguration::publicSigningKeyEndpoint))
            .setter(setter(Builder::publicSigningKeyEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicSigningKeyEndpoint")
                    .unmarshallLocationName("publicSigningKeyEndpoint").build()).build();

    private static final SdkField<String> TOKEN_ENDPOINT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TokenEndpoint")
            .getter(getter(VerifiedAccessInstanceUserTrustProviderClientConfiguration::tokenEndpoint))
            .setter(setter(Builder::tokenEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenEndpoint")
                    .unmarshallLocationName("tokenEndpoint").build()).build();

    private static final SdkField<String> USER_INFO_ENDPOINT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("UserInfoEndpoint")
            .getter(getter(VerifiedAccessInstanceUserTrustProviderClientConfiguration::userInfoEndpoint))
            .setter(setter(Builder::userInfoEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserInfoEndpoint")
                    .unmarshallLocationName("userInfoEndpoint").build()).build();

    private static final SdkField<String> CLIENT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientId")
            .getter(getter(VerifiedAccessInstanceUserTrustProviderClientConfiguration::clientId))
            .setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId")
                    .unmarshallLocationName("clientId").build()).build();

    private static final SdkField<String> CLIENT_SECRET_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientSecret")
            .getter(getter(VerifiedAccessInstanceUserTrustProviderClientConfiguration::clientSecret))
            .setter(setter(Builder::clientSecret))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientSecret")
                    .unmarshallLocationName("clientSecret").build()).build();

    private static final SdkField<Boolean> PKCE_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PkceEnabled")
            .getter(getter(VerifiedAccessInstanceUserTrustProviderClientConfiguration::pkceEnabled))
            .setter(setter(Builder::pkceEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PkceEnabled")
                    .unmarshallLocationName("pkceEnabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, SCOPES_FIELD,
            ISSUER_FIELD, AUTHORIZATION_ENDPOINT_FIELD, PUBLIC_SIGNING_KEY_ENDPOINT_FIELD, TOKEN_ENDPOINT_FIELD,
            USER_INFO_ENDPOINT_FIELD, CLIENT_ID_FIELD, CLIENT_SECRET_FIELD, PKCE_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String scopes;

    private final String issuer;

    private final String authorizationEndpoint;

    private final String publicSigningKeyEndpoint;

    private final String tokenEndpoint;

    private final String userInfoEndpoint;

    private final String clientId;

    private final String clientSecret;

    private final Boolean pkceEnabled;

    private VerifiedAccessInstanceUserTrustProviderClientConfiguration(BuilderImpl builder) {
        this.type = builder.type;
        this.scopes = builder.scopes;
        this.issuer = builder.issuer;
        this.authorizationEndpoint = builder.authorizationEndpoint;
        this.publicSigningKeyEndpoint = builder.publicSigningKeyEndpoint;
        this.tokenEndpoint = builder.tokenEndpoint;
        this.userInfoEndpoint = builder.userInfoEndpoint;
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.pkceEnabled = builder.pkceEnabled;
    }

    /**
     * <p>
     * The trust provider type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link UserTrustProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The trust provider type.
     * @see UserTrustProviderType
     */
    public final UserTrustProviderType type() {
        return UserTrustProviderType.fromValue(type);
    }

    /**
     * <p>
     * The trust provider type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link UserTrustProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The trust provider type.
     * @see UserTrustProviderType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The set of user claims to be requested from the IdP.
     * </p>
     * 
     * @return The set of user claims to be requested from the IdP.
     */
    public final String scopes() {
        return scopes;
    }

    /**
     * <p>
     * The OIDC issuer identifier of the IdP.
     * </p>
     * 
     * @return The OIDC issuer identifier of the IdP.
     */
    public final String issuer() {
        return issuer;
    }

    /**
     * <p>
     * The authorization endpoint of the IdP.
     * </p>
     * 
     * @return The authorization endpoint of the IdP.
     */
    public final String authorizationEndpoint() {
        return authorizationEndpoint;
    }

    /**
     * <p>
     * The public signing key endpoint.
     * </p>
     * 
     * @return The public signing key endpoint.
     */
    public final String publicSigningKeyEndpoint() {
        return publicSigningKeyEndpoint;
    }

    /**
     * <p>
     * The token endpoint of the IdP.
     * </p>
     * 
     * @return The token endpoint of the IdP.
     */
    public final String tokenEndpoint() {
        return tokenEndpoint;
    }

    /**
     * <p>
     * The user info endpoint of the IdP.
     * </p>
     * 
     * @return The user info endpoint of the IdP.
     */
    public final String userInfoEndpoint() {
        return userInfoEndpoint;
    }

    /**
     * <p>
     * The OAuth 2.0 client identifier.
     * </p>
     * 
     * @return The OAuth 2.0 client identifier.
     */
    public final String clientId() {
        return clientId;
    }

    /**
     * <p>
     * The OAuth 2.0 client secret.
     * </p>
     * 
     * @return The OAuth 2.0 client secret.
     */
    public final String clientSecret() {
        return clientSecret;
    }

    /**
     * <p>
     * Indicates whether Proof of Key Code Exchange (PKCE) is enabled.
     * </p>
     * 
     * @return Indicates whether Proof of Key Code Exchange (PKCE) is enabled.
     */
    public final Boolean pkceEnabled() {
        return pkceEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scopes());
        hashCode = 31 * hashCode + Objects.hashCode(issuer());
        hashCode = 31 * hashCode + Objects.hashCode(authorizationEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(publicSigningKeyEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(tokenEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(userInfoEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(clientSecret());
        hashCode = 31 * hashCode + Objects.hashCode(pkceEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifiedAccessInstanceUserTrustProviderClientConfiguration)) {
            return false;
        }
        VerifiedAccessInstanceUserTrustProviderClientConfiguration other = (VerifiedAccessInstanceUserTrustProviderClientConfiguration) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(scopes(), other.scopes())
                && Objects.equals(issuer(), other.issuer())
                && Objects.equals(authorizationEndpoint(), other.authorizationEndpoint())
                && Objects.equals(publicSigningKeyEndpoint(), other.publicSigningKeyEndpoint())
                && Objects.equals(tokenEndpoint(), other.tokenEndpoint())
                && Objects.equals(userInfoEndpoint(), other.userInfoEndpoint()) && Objects.equals(clientId(), other.clientId())
                && Objects.equals(clientSecret(), other.clientSecret()) && Objects.equals(pkceEnabled(), other.pkceEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VerifiedAccessInstanceUserTrustProviderClientConfiguration").add("Type", typeAsString())
                .add("Scopes", scopes()).add("Issuer", issuer()).add("AuthorizationEndpoint", authorizationEndpoint())
                .add("PublicSigningKeyEndpoint", publicSigningKeyEndpoint()).add("TokenEndpoint", tokenEndpoint())
                .add("UserInfoEndpoint", userInfoEndpoint()).add("ClientId", clientId())
                .add("ClientSecret", clientSecret() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PkceEnabled", pkceEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Scopes":
            return Optional.ofNullable(clazz.cast(scopes()));
        case "Issuer":
            return Optional.ofNullable(clazz.cast(issuer()));
        case "AuthorizationEndpoint":
            return Optional.ofNullable(clazz.cast(authorizationEndpoint()));
        case "PublicSigningKeyEndpoint":
            return Optional.ofNullable(clazz.cast(publicSigningKeyEndpoint()));
        case "TokenEndpoint":
            return Optional.ofNullable(clazz.cast(tokenEndpoint()));
        case "UserInfoEndpoint":
            return Optional.ofNullable(clazz.cast(userInfoEndpoint()));
        case "ClientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "ClientSecret":
            return Optional.ofNullable(clazz.cast(clientSecret()));
        case "PkceEnabled":
            return Optional.ofNullable(clazz.cast(pkceEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("Scopes", SCOPES_FIELD);
        map.put("Issuer", ISSUER_FIELD);
        map.put("AuthorizationEndpoint", AUTHORIZATION_ENDPOINT_FIELD);
        map.put("PublicSigningKeyEndpoint", PUBLIC_SIGNING_KEY_ENDPOINT_FIELD);
        map.put("TokenEndpoint", TOKEN_ENDPOINT_FIELD);
        map.put("UserInfoEndpoint", USER_INFO_ENDPOINT_FIELD);
        map.put("ClientId", CLIENT_ID_FIELD);
        map.put("ClientSecret", CLIENT_SECRET_FIELD);
        map.put("PkceEnabled", PKCE_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VerifiedAccessInstanceUserTrustProviderClientConfiguration, T> g) {
        return obj -> g.apply((VerifiedAccessInstanceUserTrustProviderClientConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo,
            CopyableBuilder<Builder, VerifiedAccessInstanceUserTrustProviderClientConfiguration> {
        /**
         * <p>
         * The trust provider type.
         * </p>
         * 
         * @param type
         *        The trust provider type.
         * @see UserTrustProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserTrustProviderType
         */
        Builder type(String type);

        /**
         * <p>
         * The trust provider type.
         * </p>
         * 
         * @param type
         *        The trust provider type.
         * @see UserTrustProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserTrustProviderType
         */
        Builder type(UserTrustProviderType type);

        /**
         * <p>
         * The set of user claims to be requested from the IdP.
         * </p>
         * 
         * @param scopes
         *        The set of user claims to be requested from the IdP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopes(String scopes);

        /**
         * <p>
         * The OIDC issuer identifier of the IdP.
         * </p>
         * 
         * @param issuer
         *        The OIDC issuer identifier of the IdP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuer(String issuer);

        /**
         * <p>
         * The authorization endpoint of the IdP.
         * </p>
         * 
         * @param authorizationEndpoint
         *        The authorization endpoint of the IdP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationEndpoint(String authorizationEndpoint);

        /**
         * <p>
         * The public signing key endpoint.
         * </p>
         * 
         * @param publicSigningKeyEndpoint
         *        The public signing key endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicSigningKeyEndpoint(String publicSigningKeyEndpoint);

        /**
         * <p>
         * The token endpoint of the IdP.
         * </p>
         * 
         * @param tokenEndpoint
         *        The token endpoint of the IdP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenEndpoint(String tokenEndpoint);

        /**
         * <p>
         * The user info endpoint of the IdP.
         * </p>
         * 
         * @param userInfoEndpoint
         *        The user info endpoint of the IdP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userInfoEndpoint(String userInfoEndpoint);

        /**
         * <p>
         * The OAuth 2.0 client identifier.
         * </p>
         * 
         * @param clientId
         *        The OAuth 2.0 client identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * The OAuth 2.0 client secret.
         * </p>
         * 
         * @param clientSecret
         *        The OAuth 2.0 client secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientSecret(String clientSecret);

        /**
         * <p>
         * Indicates whether Proof of Key Code Exchange (PKCE) is enabled.
         * </p>
         * 
         * @param pkceEnabled
         *        Indicates whether Proof of Key Code Exchange (PKCE) is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pkceEnabled(Boolean pkceEnabled);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String scopes;

        private String issuer;

        private String authorizationEndpoint;

        private String publicSigningKeyEndpoint;

        private String tokenEndpoint;

        private String userInfoEndpoint;

        private String clientId;

        private String clientSecret;

        private Boolean pkceEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifiedAccessInstanceUserTrustProviderClientConfiguration model) {
            type(model.type);
            scopes(model.scopes);
            issuer(model.issuer);
            authorizationEndpoint(model.authorizationEndpoint);
            publicSigningKeyEndpoint(model.publicSigningKeyEndpoint);
            tokenEndpoint(model.tokenEndpoint);
            userInfoEndpoint(model.userInfoEndpoint);
            clientId(model.clientId);
            clientSecret(model.clientSecret);
            pkceEnabled(model.pkceEnabled);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(UserTrustProviderType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getScopes() {
            return scopes;
        }

        public final void setScopes(String scopes) {
            this.scopes = scopes;
        }

        @Override
        public final Builder scopes(String scopes) {
            this.scopes = scopes;
            return this;
        }

        public final String getIssuer() {
            return issuer;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final String getAuthorizationEndpoint() {
            return authorizationEndpoint;
        }

        public final void setAuthorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
        }

        @Override
        public final Builder authorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
            return this;
        }

        public final String getPublicSigningKeyEndpoint() {
            return publicSigningKeyEndpoint;
        }

        public final void setPublicSigningKeyEndpoint(String publicSigningKeyEndpoint) {
            this.publicSigningKeyEndpoint = publicSigningKeyEndpoint;
        }

        @Override
        public final Builder publicSigningKeyEndpoint(String publicSigningKeyEndpoint) {
            this.publicSigningKeyEndpoint = publicSigningKeyEndpoint;
            return this;
        }

        public final String getTokenEndpoint() {
            return tokenEndpoint;
        }

        public final void setTokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
        }

        @Override
        public final Builder tokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
            return this;
        }

        public final String getUserInfoEndpoint() {
            return userInfoEndpoint;
        }

        public final void setUserInfoEndpoint(String userInfoEndpoint) {
            this.userInfoEndpoint = userInfoEndpoint;
        }

        @Override
        public final Builder userInfoEndpoint(String userInfoEndpoint) {
            this.userInfoEndpoint = userInfoEndpoint;
            return this;
        }

        public final String getClientId() {
            return clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final String getClientSecret() {
            return clientSecret;
        }

        public final void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        @Override
        public final Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public final Boolean getPkceEnabled() {
            return pkceEnabled;
        }

        public final void setPkceEnabled(Boolean pkceEnabled) {
            this.pkceEnabled = pkceEnabled;
        }

        @Override
        public final Builder pkceEnabled(Boolean pkceEnabled) {
            this.pkceEnabled = pkceEnabled;
            return this;
        }

        @Override
        public VerifiedAccessInstanceUserTrustProviderClientConfiguration build() {
            return new VerifiedAccessInstanceUserTrustProviderClientConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
