/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the targets for the specified Verified Access endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VerifiedAccessEndpointTarget implements SdkPojo, Serializable,
        ToCopyableBuilder<VerifiedAccessEndpointTarget.Builder, VerifiedAccessEndpointTarget> {
    private static final SdkField<String> VERIFIED_ACCESS_ENDPOINT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VerifiedAccessEndpointId")
            .getter(getter(VerifiedAccessEndpointTarget::verifiedAccessEndpointId))
            .setter(setter(Builder::verifiedAccessEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessEndpointId")
                    .unmarshallLocationName("verifiedAccessEndpointId").build()).build();

    private static final SdkField<String> VERIFIED_ACCESS_ENDPOINT_TARGET_IP_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VerifiedAccessEndpointTargetIpAddress")
            .getter(getter(VerifiedAccessEndpointTarget::verifiedAccessEndpointTargetIpAddress))
            .setter(setter(Builder::verifiedAccessEndpointTargetIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("VerifiedAccessEndpointTargetIpAddress")
                    .unmarshallLocationName("verifiedAccessEndpointTargetIpAddress").build()).build();

    private static final SdkField<String> VERIFIED_ACCESS_ENDPOINT_TARGET_DNS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VerifiedAccessEndpointTargetDns")
            .getter(getter(VerifiedAccessEndpointTarget::verifiedAccessEndpointTargetDns))
            .setter(setter(Builder::verifiedAccessEndpointTargetDns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessEndpointTargetDns")
                    .unmarshallLocationName("verifiedAccessEndpointTargetDns").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VERIFIED_ACCESS_ENDPOINT_ID_FIELD, VERIFIED_ACCESS_ENDPOINT_TARGET_IP_ADDRESS_FIELD,
            VERIFIED_ACCESS_ENDPOINT_TARGET_DNS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String verifiedAccessEndpointId;

    private final String verifiedAccessEndpointTargetIpAddress;

    private final String verifiedAccessEndpointTargetDns;

    private VerifiedAccessEndpointTarget(BuilderImpl builder) {
        this.verifiedAccessEndpointId = builder.verifiedAccessEndpointId;
        this.verifiedAccessEndpointTargetIpAddress = builder.verifiedAccessEndpointTargetIpAddress;
        this.verifiedAccessEndpointTargetDns = builder.verifiedAccessEndpointTargetDns;
    }

    /**
     * <p>
     * The ID of the Verified Access endpoint.
     * </p>
     * 
     * @return The ID of the Verified Access endpoint.
     */
    public final String verifiedAccessEndpointId() {
        return verifiedAccessEndpointId;
    }

    /**
     * <p>
     * The IP address of the target.
     * </p>
     * 
     * @return The IP address of the target.
     */
    public final String verifiedAccessEndpointTargetIpAddress() {
        return verifiedAccessEndpointTargetIpAddress;
    }

    /**
     * <p>
     * The DNS name of the target.
     * </p>
     * 
     * @return The DNS name of the target.
     */
    public final String verifiedAccessEndpointTargetDns() {
        return verifiedAccessEndpointTargetDns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(verifiedAccessEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(verifiedAccessEndpointTargetIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(verifiedAccessEndpointTargetDns());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifiedAccessEndpointTarget)) {
            return false;
        }
        VerifiedAccessEndpointTarget other = (VerifiedAccessEndpointTarget) obj;
        return Objects.equals(verifiedAccessEndpointId(), other.verifiedAccessEndpointId())
                && Objects.equals(verifiedAccessEndpointTargetIpAddress(), other.verifiedAccessEndpointTargetIpAddress())
                && Objects.equals(verifiedAccessEndpointTargetDns(), other.verifiedAccessEndpointTargetDns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VerifiedAccessEndpointTarget").add("VerifiedAccessEndpointId", verifiedAccessEndpointId())
                .add("VerifiedAccessEndpointTargetIpAddress", verifiedAccessEndpointTargetIpAddress())
                .add("VerifiedAccessEndpointTargetDns", verifiedAccessEndpointTargetDns()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VerifiedAccessEndpointId":
            return Optional.ofNullable(clazz.cast(verifiedAccessEndpointId()));
        case "VerifiedAccessEndpointTargetIpAddress":
            return Optional.ofNullable(clazz.cast(verifiedAccessEndpointTargetIpAddress()));
        case "VerifiedAccessEndpointTargetDns":
            return Optional.ofNullable(clazz.cast(verifiedAccessEndpointTargetDns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VerifiedAccessEndpointId", VERIFIED_ACCESS_ENDPOINT_ID_FIELD);
        map.put("VerifiedAccessEndpointTargetIpAddress", VERIFIED_ACCESS_ENDPOINT_TARGET_IP_ADDRESS_FIELD);
        map.put("VerifiedAccessEndpointTargetDns", VERIFIED_ACCESS_ENDPOINT_TARGET_DNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VerifiedAccessEndpointTarget, T> g) {
        return obj -> g.apply((VerifiedAccessEndpointTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VerifiedAccessEndpointTarget> {
        /**
         * <p>
         * The ID of the Verified Access endpoint.
         * </p>
         * 
         * @param verifiedAccessEndpointId
         *        The ID of the Verified Access endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedAccessEndpointId(String verifiedAccessEndpointId);

        /**
         * <p>
         * The IP address of the target.
         * </p>
         * 
         * @param verifiedAccessEndpointTargetIpAddress
         *        The IP address of the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedAccessEndpointTargetIpAddress(String verifiedAccessEndpointTargetIpAddress);

        /**
         * <p>
         * The DNS name of the target.
         * </p>
         * 
         * @param verifiedAccessEndpointTargetDns
         *        The DNS name of the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedAccessEndpointTargetDns(String verifiedAccessEndpointTargetDns);
    }

    static final class BuilderImpl implements Builder {
        private String verifiedAccessEndpointId;

        private String verifiedAccessEndpointTargetIpAddress;

        private String verifiedAccessEndpointTargetDns;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifiedAccessEndpointTarget model) {
            verifiedAccessEndpointId(model.verifiedAccessEndpointId);
            verifiedAccessEndpointTargetIpAddress(model.verifiedAccessEndpointTargetIpAddress);
            verifiedAccessEndpointTargetDns(model.verifiedAccessEndpointTargetDns);
        }

        public final String getVerifiedAccessEndpointId() {
            return verifiedAccessEndpointId;
        }

        public final void setVerifiedAccessEndpointId(String verifiedAccessEndpointId) {
            this.verifiedAccessEndpointId = verifiedAccessEndpointId;
        }

        @Override
        public final Builder verifiedAccessEndpointId(String verifiedAccessEndpointId) {
            this.verifiedAccessEndpointId = verifiedAccessEndpointId;
            return this;
        }

        public final String getVerifiedAccessEndpointTargetIpAddress() {
            return verifiedAccessEndpointTargetIpAddress;
        }

        public final void setVerifiedAccessEndpointTargetIpAddress(String verifiedAccessEndpointTargetIpAddress) {
            this.verifiedAccessEndpointTargetIpAddress = verifiedAccessEndpointTargetIpAddress;
        }

        @Override
        public final Builder verifiedAccessEndpointTargetIpAddress(String verifiedAccessEndpointTargetIpAddress) {
            this.verifiedAccessEndpointTargetIpAddress = verifiedAccessEndpointTargetIpAddress;
            return this;
        }

        public final String getVerifiedAccessEndpointTargetDns() {
            return verifiedAccessEndpointTargetDns;
        }

        public final void setVerifiedAccessEndpointTargetDns(String verifiedAccessEndpointTargetDns) {
            this.verifiedAccessEndpointTargetDns = verifiedAccessEndpointTargetDns;
        }

        @Override
        public final Builder verifiedAccessEndpointTargetDns(String verifiedAccessEndpointTargetDns) {
            this.verifiedAccessEndpointTargetDns = verifiedAccessEndpointTargetDns;
            return this;
        }

        @Override
        public VerifiedAccessEndpointTarget build() {
            return new VerifiedAccessEndpointTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
