/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the transit gateway peering attachment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransitGatewayPeeringAttachment implements SdkPojo, Serializable,
        ToCopyableBuilder<TransitGatewayPeeringAttachment.Builder, TransitGatewayPeeringAttachment> {
    private static final SdkField<String> TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayAttachmentId")
            .getter(getter(TransitGatewayPeeringAttachment::transitGatewayAttachmentId))
            .setter(setter(Builder::transitGatewayAttachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAttachmentId")
                    .unmarshallLocationName("transitGatewayAttachmentId").build()).build();

    private static final SdkField<String> ACCEPTER_TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AccepterTransitGatewayAttachmentId")
            .getter(getter(TransitGatewayPeeringAttachment::accepterTransitGatewayAttachmentId))
            .setter(setter(Builder::accepterTransitGatewayAttachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccepterTransitGatewayAttachmentId")
                    .unmarshallLocationName("accepterTransitGatewayAttachmentId").build()).build();

    private static final SdkField<PeeringTgwInfo> REQUESTER_TGW_INFO_FIELD = SdkField
            .<PeeringTgwInfo> builder(MarshallingType.SDK_POJO)
            .memberName("RequesterTgwInfo")
            .getter(getter(TransitGatewayPeeringAttachment::requesterTgwInfo))
            .setter(setter(Builder::requesterTgwInfo))
            .constructor(PeeringTgwInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterTgwInfo")
                    .unmarshallLocationName("requesterTgwInfo").build()).build();

    private static final SdkField<PeeringTgwInfo> ACCEPTER_TGW_INFO_FIELD = SdkField
            .<PeeringTgwInfo> builder(MarshallingType.SDK_POJO)
            .memberName("AccepterTgwInfo")
            .getter(getter(TransitGatewayPeeringAttachment::accepterTgwInfo))
            .setter(setter(Builder::accepterTgwInfo))
            .constructor(PeeringTgwInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccepterTgwInfo")
                    .unmarshallLocationName("accepterTgwInfo").build()).build();

    private static final SdkField<TransitGatewayPeeringAttachmentOptions> OPTIONS_FIELD = SdkField
            .<TransitGatewayPeeringAttachmentOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Options")
            .getter(getter(TransitGatewayPeeringAttachment::options))
            .setter(setter(Builder::options))
            .constructor(TransitGatewayPeeringAttachmentOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options")
                    .unmarshallLocationName("options").build()).build();

    private static final SdkField<PeeringAttachmentStatus> STATUS_FIELD = SdkField
            .<PeeringAttachmentStatus> builder(MarshallingType.SDK_POJO)
            .memberName("Status")
            .getter(getter(TransitGatewayPeeringAttachment::status))
            .setter(setter(Builder::status))
            .constructor(PeeringAttachmentStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("status").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(TransitGatewayPeeringAttachment::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime")
            .getter(getter(TransitGatewayPeeringAttachment::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime")
                    .unmarshallLocationName("creationTime").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(TransitGatewayPeeringAttachment::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD, ACCEPTER_TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD, REQUESTER_TGW_INFO_FIELD,
            ACCEPTER_TGW_INFO_FIELD, OPTIONS_FIELD, STATUS_FIELD, STATE_FIELD, CREATION_TIME_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String transitGatewayAttachmentId;

    private final String accepterTransitGatewayAttachmentId;

    private final PeeringTgwInfo requesterTgwInfo;

    private final PeeringTgwInfo accepterTgwInfo;

    private final TransitGatewayPeeringAttachmentOptions options;

    private final PeeringAttachmentStatus status;

    private final String state;

    private final Instant creationTime;

    private final List<Tag> tags;

    private TransitGatewayPeeringAttachment(BuilderImpl builder) {
        this.transitGatewayAttachmentId = builder.transitGatewayAttachmentId;
        this.accepterTransitGatewayAttachmentId = builder.accepterTransitGatewayAttachmentId;
        this.requesterTgwInfo = builder.requesterTgwInfo;
        this.accepterTgwInfo = builder.accepterTgwInfo;
        this.options = builder.options;
        this.status = builder.status;
        this.state = builder.state;
        this.creationTime = builder.creationTime;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the transit gateway peering attachment.
     * </p>
     * 
     * @return The ID of the transit gateway peering attachment.
     */
    public final String transitGatewayAttachmentId() {
        return transitGatewayAttachmentId;
    }

    /**
     * <p>
     * The ID of the accepter transit gateway attachment.
     * </p>
     * 
     * @return The ID of the accepter transit gateway attachment.
     */
    public final String accepterTransitGatewayAttachmentId() {
        return accepterTransitGatewayAttachmentId;
    }

    /**
     * <p>
     * Information about the requester transit gateway.
     * </p>
     * 
     * @return Information about the requester transit gateway.
     */
    public final PeeringTgwInfo requesterTgwInfo() {
        return requesterTgwInfo;
    }

    /**
     * <p>
     * Information about the accepter transit gateway.
     * </p>
     * 
     * @return Information about the accepter transit gateway.
     */
    public final PeeringTgwInfo accepterTgwInfo() {
        return accepterTgwInfo;
    }

    /**
     * <p>
     * Details about the transit gateway peering attachment.
     * </p>
     * 
     * @return Details about the transit gateway peering attachment.
     */
    public final TransitGatewayPeeringAttachmentOptions options() {
        return options;
    }

    /**
     * <p>
     * The status of the transit gateway peering attachment.
     * </p>
     * 
     * @return The status of the transit gateway peering attachment.
     */
    public final PeeringAttachmentStatus status() {
        return status;
    }

    /**
     * <p>
     * The state of the transit gateway peering attachment. Note that the <code>initiating</code> state has been
     * deprecated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link TransitGatewayAttachmentState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the transit gateway peering attachment. Note that the <code>initiating</code> state has been
     *         deprecated.
     * @see TransitGatewayAttachmentState
     */
    public final TransitGatewayAttachmentState state() {
        return TransitGatewayAttachmentState.fromValue(state);
    }

    /**
     * <p>
     * The state of the transit gateway peering attachment. Note that the <code>initiating</code> state has been
     * deprecated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link TransitGatewayAttachmentState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the transit gateway peering attachment. Note that the <code>initiating</code> state has been
     *         deprecated.
     * @see TransitGatewayAttachmentState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The time the transit gateway peering attachment was created.
     * </p>
     * 
     * @return The time the transit gateway peering attachment was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags for the transit gateway peering attachment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags for the transit gateway peering attachment.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(accepterTransitGatewayAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(requesterTgwInfo());
        hashCode = 31 * hashCode + Objects.hashCode(accepterTgwInfo());
        hashCode = 31 * hashCode + Objects.hashCode(options());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayPeeringAttachment)) {
            return false;
        }
        TransitGatewayPeeringAttachment other = (TransitGatewayPeeringAttachment) obj;
        return Objects.equals(transitGatewayAttachmentId(), other.transitGatewayAttachmentId())
                && Objects.equals(accepterTransitGatewayAttachmentId(), other.accepterTransitGatewayAttachmentId())
                && Objects.equals(requesterTgwInfo(), other.requesterTgwInfo())
                && Objects.equals(accepterTgwInfo(), other.accepterTgwInfo()) && Objects.equals(options(), other.options())
                && Objects.equals(status(), other.status()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(creationTime(), other.creationTime()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransitGatewayPeeringAttachment")
                .add("TransitGatewayAttachmentId", transitGatewayAttachmentId())
                .add("AccepterTransitGatewayAttachmentId", accepterTransitGatewayAttachmentId())
                .add("RequesterTgwInfo", requesterTgwInfo()).add("AccepterTgwInfo", accepterTgwInfo()).add("Options", options())
                .add("Status", status()).add("State", stateAsString()).add("CreationTime", creationTime())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayAttachmentId":
            return Optional.ofNullable(clazz.cast(transitGatewayAttachmentId()));
        case "AccepterTransitGatewayAttachmentId":
            return Optional.ofNullable(clazz.cast(accepterTransitGatewayAttachmentId()));
        case "RequesterTgwInfo":
            return Optional.ofNullable(clazz.cast(requesterTgwInfo()));
        case "AccepterTgwInfo":
            return Optional.ofNullable(clazz.cast(accepterTgwInfo()));
        case "Options":
            return Optional.ofNullable(clazz.cast(options()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TransitGatewayAttachmentId", TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD);
        map.put("AccepterTransitGatewayAttachmentId", ACCEPTER_TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD);
        map.put("RequesterTgwInfo", REQUESTER_TGW_INFO_FIELD);
        map.put("AccepterTgwInfo", ACCEPTER_TGW_INFO_FIELD);
        map.put("Options", OPTIONS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("State", STATE_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("TagSet", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayPeeringAttachment, T> g) {
        return obj -> g.apply((TransitGatewayPeeringAttachment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransitGatewayPeeringAttachment> {
        /**
         * <p>
         * The ID of the transit gateway peering attachment.
         * </p>
         * 
         * @param transitGatewayAttachmentId
         *        The ID of the transit gateway peering attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayAttachmentId(String transitGatewayAttachmentId);

        /**
         * <p>
         * The ID of the accepter transit gateway attachment.
         * </p>
         * 
         * @param accepterTransitGatewayAttachmentId
         *        The ID of the accepter transit gateway attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accepterTransitGatewayAttachmentId(String accepterTransitGatewayAttachmentId);

        /**
         * <p>
         * Information about the requester transit gateway.
         * </p>
         * 
         * @param requesterTgwInfo
         *        Information about the requester transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterTgwInfo(PeeringTgwInfo requesterTgwInfo);

        /**
         * <p>
         * Information about the requester transit gateway.
         * </p>
         * This is a convenience method that creates an instance of the {@link PeeringTgwInfo.Builder} avoiding the need
         * to create one manually via {@link PeeringTgwInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PeeringTgwInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #requesterTgwInfo(PeeringTgwInfo)}.
         * 
         * @param requesterTgwInfo
         *        a consumer that will call methods on {@link PeeringTgwInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requesterTgwInfo(PeeringTgwInfo)
         */
        default Builder requesterTgwInfo(Consumer<PeeringTgwInfo.Builder> requesterTgwInfo) {
            return requesterTgwInfo(PeeringTgwInfo.builder().applyMutation(requesterTgwInfo).build());
        }

        /**
         * <p>
         * Information about the accepter transit gateway.
         * </p>
         * 
         * @param accepterTgwInfo
         *        Information about the accepter transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accepterTgwInfo(PeeringTgwInfo accepterTgwInfo);

        /**
         * <p>
         * Information about the accepter transit gateway.
         * </p>
         * This is a convenience method that creates an instance of the {@link PeeringTgwInfo.Builder} avoiding the need
         * to create one manually via {@link PeeringTgwInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PeeringTgwInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #accepterTgwInfo(PeeringTgwInfo)}.
         * 
         * @param accepterTgwInfo
         *        a consumer that will call methods on {@link PeeringTgwInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accepterTgwInfo(PeeringTgwInfo)
         */
        default Builder accepterTgwInfo(Consumer<PeeringTgwInfo.Builder> accepterTgwInfo) {
            return accepterTgwInfo(PeeringTgwInfo.builder().applyMutation(accepterTgwInfo).build());
        }

        /**
         * <p>
         * Details about the transit gateway peering attachment.
         * </p>
         * 
         * @param options
         *        Details about the transit gateway peering attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(TransitGatewayPeeringAttachmentOptions options);

        /**
         * <p>
         * Details about the transit gateway peering attachment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link TransitGatewayPeeringAttachmentOptions.Builder} avoiding the need to create one manually via
         * {@link TransitGatewayPeeringAttachmentOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TransitGatewayPeeringAttachmentOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #options(TransitGatewayPeeringAttachmentOptions)}.
         * 
         * @param options
         *        a consumer that will call methods on {@link TransitGatewayPeeringAttachmentOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #options(TransitGatewayPeeringAttachmentOptions)
         */
        default Builder options(Consumer<TransitGatewayPeeringAttachmentOptions.Builder> options) {
            return options(TransitGatewayPeeringAttachmentOptions.builder().applyMutation(options).build());
        }

        /**
         * <p>
         * The status of the transit gateway peering attachment.
         * </p>
         * 
         * @param status
         *        The status of the transit gateway peering attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(PeeringAttachmentStatus status);

        /**
         * <p>
         * The status of the transit gateway peering attachment.
         * </p>
         * This is a convenience method that creates an instance of the {@link PeeringAttachmentStatus.Builder} avoiding
         * the need to create one manually via {@link PeeringAttachmentStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PeeringAttachmentStatus.Builder#build()} is called immediately
         * and its result is passed to {@link #status(PeeringAttachmentStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link PeeringAttachmentStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(PeeringAttachmentStatus)
         */
        default Builder status(Consumer<PeeringAttachmentStatus.Builder> status) {
            return status(PeeringAttachmentStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * The state of the transit gateway peering attachment. Note that the <code>initiating</code> state has been
         * deprecated.
         * </p>
         * 
         * @param state
         *        The state of the transit gateway peering attachment. Note that the <code>initiating</code> state has
         *        been deprecated.
         * @see TransitGatewayAttachmentState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayAttachmentState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the transit gateway peering attachment. Note that the <code>initiating</code> state has been
         * deprecated.
         * </p>
         * 
         * @param state
         *        The state of the transit gateway peering attachment. Note that the <code>initiating</code> state has
         *        been deprecated.
         * @see TransitGatewayAttachmentState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayAttachmentState
         */
        Builder state(TransitGatewayAttachmentState state);

        /**
         * <p>
         * The time the transit gateway peering attachment was created.
         * </p>
         * 
         * @param creationTime
         *        The time the transit gateway peering attachment was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The tags for the transit gateway peering attachment.
         * </p>
         * 
         * @param tags
         *        The tags for the transit gateway peering attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags for the transit gateway peering attachment.
         * </p>
         * 
         * @param tags
         *        The tags for the transit gateway peering attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags for the transit gateway peering attachment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String transitGatewayAttachmentId;

        private String accepterTransitGatewayAttachmentId;

        private PeeringTgwInfo requesterTgwInfo;

        private PeeringTgwInfo accepterTgwInfo;

        private TransitGatewayPeeringAttachmentOptions options;

        private PeeringAttachmentStatus status;

        private String state;

        private Instant creationTime;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayPeeringAttachment model) {
            transitGatewayAttachmentId(model.transitGatewayAttachmentId);
            accepterTransitGatewayAttachmentId(model.accepterTransitGatewayAttachmentId);
            requesterTgwInfo(model.requesterTgwInfo);
            accepterTgwInfo(model.accepterTgwInfo);
            options(model.options);
            status(model.status);
            state(model.state);
            creationTime(model.creationTime);
            tags(model.tags);
        }

        public final String getTransitGatewayAttachmentId() {
            return transitGatewayAttachmentId;
        }

        public final void setTransitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
        }

        @Override
        public final Builder transitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
            return this;
        }

        public final String getAccepterTransitGatewayAttachmentId() {
            return accepterTransitGatewayAttachmentId;
        }

        public final void setAccepterTransitGatewayAttachmentId(String accepterTransitGatewayAttachmentId) {
            this.accepterTransitGatewayAttachmentId = accepterTransitGatewayAttachmentId;
        }

        @Override
        public final Builder accepterTransitGatewayAttachmentId(String accepterTransitGatewayAttachmentId) {
            this.accepterTransitGatewayAttachmentId = accepterTransitGatewayAttachmentId;
            return this;
        }

        public final PeeringTgwInfo.Builder getRequesterTgwInfo() {
            return requesterTgwInfo != null ? requesterTgwInfo.toBuilder() : null;
        }

        public final void setRequesterTgwInfo(PeeringTgwInfo.BuilderImpl requesterTgwInfo) {
            this.requesterTgwInfo = requesterTgwInfo != null ? requesterTgwInfo.build() : null;
        }

        @Override
        public final Builder requesterTgwInfo(PeeringTgwInfo requesterTgwInfo) {
            this.requesterTgwInfo = requesterTgwInfo;
            return this;
        }

        public final PeeringTgwInfo.Builder getAccepterTgwInfo() {
            return accepterTgwInfo != null ? accepterTgwInfo.toBuilder() : null;
        }

        public final void setAccepterTgwInfo(PeeringTgwInfo.BuilderImpl accepterTgwInfo) {
            this.accepterTgwInfo = accepterTgwInfo != null ? accepterTgwInfo.build() : null;
        }

        @Override
        public final Builder accepterTgwInfo(PeeringTgwInfo accepterTgwInfo) {
            this.accepterTgwInfo = accepterTgwInfo;
            return this;
        }

        public final TransitGatewayPeeringAttachmentOptions.Builder getOptions() {
            return options != null ? options.toBuilder() : null;
        }

        public final void setOptions(TransitGatewayPeeringAttachmentOptions.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        @Override
        public final Builder options(TransitGatewayPeeringAttachmentOptions options) {
            this.options = options;
            return this;
        }

        public final PeeringAttachmentStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(PeeringAttachmentStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(PeeringAttachmentStatus status) {
            this.status = status;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(TransitGatewayAttachmentState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public TransitGatewayPeeringAttachment build() {
            return new TransitGatewayPeeringAttachment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
