/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a set of filters for a path analysis. Use path filters to scope the analysis when there can be multiple
 * resulting paths.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PathRequestFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<PathRequestFilter.Builder, PathRequestFilter> {
    private static final SdkField<String> SOURCE_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceAddress")
            .getter(getter(PathRequestFilter::sourceAddress))
            .setter(setter(Builder::sourceAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceAddress")
                    .unmarshallLocationName("SourceAddress").build()).build();

    private static final SdkField<RequestFilterPortRange> SOURCE_PORT_RANGE_FIELD = SdkField
            .<RequestFilterPortRange> builder(MarshallingType.SDK_POJO)
            .memberName("SourcePortRange")
            .getter(getter(PathRequestFilter::sourcePortRange))
            .setter(setter(Builder::sourcePortRange))
            .constructor(RequestFilterPortRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePortRange")
                    .unmarshallLocationName("SourcePortRange").build()).build();

    private static final SdkField<String> DESTINATION_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DestinationAddress")
            .getter(getter(PathRequestFilter::destinationAddress))
            .setter(setter(Builder::destinationAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationAddress")
                    .unmarshallLocationName("DestinationAddress").build()).build();

    private static final SdkField<RequestFilterPortRange> DESTINATION_PORT_RANGE_FIELD = SdkField
            .<RequestFilterPortRange> builder(MarshallingType.SDK_POJO)
            .memberName("DestinationPortRange")
            .getter(getter(PathRequestFilter::destinationPortRange))
            .setter(setter(Builder::destinationPortRange))
            .constructor(RequestFilterPortRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPortRange")
                    .unmarshallLocationName("DestinationPortRange").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ADDRESS_FIELD,
            SOURCE_PORT_RANGE_FIELD, DESTINATION_ADDRESS_FIELD, DESTINATION_PORT_RANGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourceAddress;

    private final RequestFilterPortRange sourcePortRange;

    private final String destinationAddress;

    private final RequestFilterPortRange destinationPortRange;

    private PathRequestFilter(BuilderImpl builder) {
        this.sourceAddress = builder.sourceAddress;
        this.sourcePortRange = builder.sourcePortRange;
        this.destinationAddress = builder.destinationAddress;
        this.destinationPortRange = builder.destinationPortRange;
    }

    /**
     * <p>
     * The source IPv4 address.
     * </p>
     * 
     * @return The source IPv4 address.
     */
    public final String sourceAddress() {
        return sourceAddress;
    }

    /**
     * <p>
     * The source port range.
     * </p>
     * 
     * @return The source port range.
     */
    public final RequestFilterPortRange sourcePortRange() {
        return sourcePortRange;
    }

    /**
     * <p>
     * The destination IPv4 address.
     * </p>
     * 
     * @return The destination IPv4 address.
     */
    public final String destinationAddress() {
        return destinationAddress;
    }

    /**
     * <p>
     * The destination port range.
     * </p>
     * 
     * @return The destination port range.
     */
    public final RequestFilterPortRange destinationPortRange() {
        return destinationPortRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceAddress());
        hashCode = 31 * hashCode + Objects.hashCode(sourcePortRange());
        hashCode = 31 * hashCode + Objects.hashCode(destinationAddress());
        hashCode = 31 * hashCode + Objects.hashCode(destinationPortRange());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PathRequestFilter)) {
            return false;
        }
        PathRequestFilter other = (PathRequestFilter) obj;
        return Objects.equals(sourceAddress(), other.sourceAddress())
                && Objects.equals(sourcePortRange(), other.sourcePortRange())
                && Objects.equals(destinationAddress(), other.destinationAddress())
                && Objects.equals(destinationPortRange(), other.destinationPortRange());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PathRequestFilter").add("SourceAddress", sourceAddress())
                .add("SourcePortRange", sourcePortRange()).add("DestinationAddress", destinationAddress())
                .add("DestinationPortRange", destinationPortRange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceAddress":
            return Optional.ofNullable(clazz.cast(sourceAddress()));
        case "SourcePortRange":
            return Optional.ofNullable(clazz.cast(sourcePortRange()));
        case "DestinationAddress":
            return Optional.ofNullable(clazz.cast(destinationAddress()));
        case "DestinationPortRange":
            return Optional.ofNullable(clazz.cast(destinationPortRange()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SourceAddress", SOURCE_ADDRESS_FIELD);
        map.put("SourcePortRange", SOURCE_PORT_RANGE_FIELD);
        map.put("DestinationAddress", DESTINATION_ADDRESS_FIELD);
        map.put("DestinationPortRange", DESTINATION_PORT_RANGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PathRequestFilter, T> g) {
        return obj -> g.apply((PathRequestFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PathRequestFilter> {
        /**
         * <p>
         * The source IPv4 address.
         * </p>
         * 
         * @param sourceAddress
         *        The source IPv4 address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAddress(String sourceAddress);

        /**
         * <p>
         * The source port range.
         * </p>
         * 
         * @param sourcePortRange
         *        The source port range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcePortRange(RequestFilterPortRange sourcePortRange);

        /**
         * <p>
         * The source port range.
         * </p>
         * This is a convenience method that creates an instance of the {@link RequestFilterPortRange.Builder} avoiding
         * the need to create one manually via {@link RequestFilterPortRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RequestFilterPortRange.Builder#build()} is called immediately and
         * its result is passed to {@link #sourcePortRange(RequestFilterPortRange)}.
         * 
         * @param sourcePortRange
         *        a consumer that will call methods on {@link RequestFilterPortRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourcePortRange(RequestFilterPortRange)
         */
        default Builder sourcePortRange(Consumer<RequestFilterPortRange.Builder> sourcePortRange) {
            return sourcePortRange(RequestFilterPortRange.builder().applyMutation(sourcePortRange).build());
        }

        /**
         * <p>
         * The destination IPv4 address.
         * </p>
         * 
         * @param destinationAddress
         *        The destination IPv4 address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationAddress(String destinationAddress);

        /**
         * <p>
         * The destination port range.
         * </p>
         * 
         * @param destinationPortRange
         *        The destination port range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPortRange(RequestFilterPortRange destinationPortRange);

        /**
         * <p>
         * The destination port range.
         * </p>
         * This is a convenience method that creates an instance of the {@link RequestFilterPortRange.Builder} avoiding
         * the need to create one manually via {@link RequestFilterPortRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RequestFilterPortRange.Builder#build()} is called immediately and
         * its result is passed to {@link #destinationPortRange(RequestFilterPortRange)}.
         * 
         * @param destinationPortRange
         *        a consumer that will call methods on {@link RequestFilterPortRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationPortRange(RequestFilterPortRange)
         */
        default Builder destinationPortRange(Consumer<RequestFilterPortRange.Builder> destinationPortRange) {
            return destinationPortRange(RequestFilterPortRange.builder().applyMutation(destinationPortRange).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String sourceAddress;

        private RequestFilterPortRange sourcePortRange;

        private String destinationAddress;

        private RequestFilterPortRange destinationPortRange;

        private BuilderImpl() {
        }

        private BuilderImpl(PathRequestFilter model) {
            sourceAddress(model.sourceAddress);
            sourcePortRange(model.sourcePortRange);
            destinationAddress(model.destinationAddress);
            destinationPortRange(model.destinationPortRange);
        }

        public final String getSourceAddress() {
            return sourceAddress;
        }

        public final void setSourceAddress(String sourceAddress) {
            this.sourceAddress = sourceAddress;
        }

        @Override
        public final Builder sourceAddress(String sourceAddress) {
            this.sourceAddress = sourceAddress;
            return this;
        }

        public final RequestFilterPortRange.Builder getSourcePortRange() {
            return sourcePortRange != null ? sourcePortRange.toBuilder() : null;
        }

        public final void setSourcePortRange(RequestFilterPortRange.BuilderImpl sourcePortRange) {
            this.sourcePortRange = sourcePortRange != null ? sourcePortRange.build() : null;
        }

        @Override
        public final Builder sourcePortRange(RequestFilterPortRange sourcePortRange) {
            this.sourcePortRange = sourcePortRange;
            return this;
        }

        public final String getDestinationAddress() {
            return destinationAddress;
        }

        public final void setDestinationAddress(String destinationAddress) {
            this.destinationAddress = destinationAddress;
        }

        @Override
        public final Builder destinationAddress(String destinationAddress) {
            this.destinationAddress = destinationAddress;
            return this;
        }

        public final RequestFilterPortRange.Builder getDestinationPortRange() {
            return destinationPortRange != null ? destinationPortRange.toBuilder() : null;
        }

        public final void setDestinationPortRange(RequestFilterPortRange.BuilderImpl destinationPortRange) {
            this.destinationPortRange = destinationPortRange != null ? destinationPortRange.build() : null;
        }

        @Override
        public final Builder destinationPortRange(RequestFilterPortRange destinationPortRange) {
            this.destinationPortRange = destinationPortRange;
            return this;
        }

        @Override
        public PathRequestFilter build() {
            return new PathRequestFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
