/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyVpcBlockPublicAccessOptionsRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyVpcBlockPublicAccessOptionsRequest.Builder, ModifyVpcBlockPublicAccessOptionsRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(ModifyVpcBlockPublicAccessOptionsRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<String> INTERNET_GATEWAY_BLOCK_MODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InternetGatewayBlockMode")
            .getter(getter(ModifyVpcBlockPublicAccessOptionsRequest::internetGatewayBlockModeAsString))
            .setter(setter(Builder::internetGatewayBlockMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InternetGatewayBlockMode")
                    .unmarshallLocationName("InternetGatewayBlockMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD,
            INTERNET_GATEWAY_BLOCK_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean dryRun;

    private final String internetGatewayBlockMode;

    private ModifyVpcBlockPublicAccessOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.internetGatewayBlockMode = builder.internetGatewayBlockMode;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The mode of VPC BPA.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>off</code>: VPC BPA is not enabled and traffic is allowed to and from internet gateways and egress-only
     * internet gateways in this Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>block-bidirectional</code>: Block all traffic to and from internet gateways and egress-only internet
     * gateways in this Region (except for excluded VPCs and subnets).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>block-ingress</code>: Block all internet traffic to the VPCs in this Region (except for VPCs or subnets
     * which are excluded). Only traffic to and from NAT gateways and egress-only internet gateways is allowed because
     * these gateways only allow outbound connections to be established.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #internetGatewayBlockMode} will return {@link InternetGatewayBlockMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #internetGatewayBlockModeAsString}.
     * </p>
     * 
     * @return The mode of VPC BPA.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>off</code>: VPC BPA is not enabled and traffic is allowed to and from internet gateways and
     *         egress-only internet gateways in this Region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>block-bidirectional</code>: Block all traffic to and from internet gateways and egress-only
     *         internet gateways in this Region (except for excluded VPCs and subnets).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>block-ingress</code>: Block all internet traffic to the VPCs in this Region (except for VPCs or
     *         subnets which are excluded). Only traffic to and from NAT gateways and egress-only internet gateways is
     *         allowed because these gateways only allow outbound connections to be established.
     *         </p>
     *         </li>
     * @see InternetGatewayBlockMode
     */
    public final InternetGatewayBlockMode internetGatewayBlockMode() {
        return InternetGatewayBlockMode.fromValue(internetGatewayBlockMode);
    }

    /**
     * <p>
     * The mode of VPC BPA.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>off</code>: VPC BPA is not enabled and traffic is allowed to and from internet gateways and egress-only
     * internet gateways in this Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>block-bidirectional</code>: Block all traffic to and from internet gateways and egress-only internet
     * gateways in this Region (except for excluded VPCs and subnets).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>block-ingress</code>: Block all internet traffic to the VPCs in this Region (except for VPCs or subnets
     * which are excluded). Only traffic to and from NAT gateways and egress-only internet gateways is allowed because
     * these gateways only allow outbound connections to be established.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #internetGatewayBlockMode} will return {@link InternetGatewayBlockMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #internetGatewayBlockModeAsString}.
     * </p>
     * 
     * @return The mode of VPC BPA.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>off</code>: VPC BPA is not enabled and traffic is allowed to and from internet gateways and
     *         egress-only internet gateways in this Region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>block-bidirectional</code>: Block all traffic to and from internet gateways and egress-only
     *         internet gateways in this Region (except for excluded VPCs and subnets).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>block-ingress</code>: Block all internet traffic to the VPCs in this Region (except for VPCs or
     *         subnets which are excluded). Only traffic to and from NAT gateways and egress-only internet gateways is
     *         allowed because these gateways only allow outbound connections to be established.
     *         </p>
     *         </li>
     * @see InternetGatewayBlockMode
     */
    public final String internetGatewayBlockModeAsString() {
        return internetGatewayBlockMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(internetGatewayBlockModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpcBlockPublicAccessOptionsRequest)) {
            return false;
        }
        ModifyVpcBlockPublicAccessOptionsRequest other = (ModifyVpcBlockPublicAccessOptionsRequest) obj;
        return Objects.equals(dryRun(), other.dryRun())
                && Objects.equals(internetGatewayBlockModeAsString(), other.internetGatewayBlockModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyVpcBlockPublicAccessOptionsRequest").add("DryRun", dryRun())
                .add("InternetGatewayBlockMode", internetGatewayBlockModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "InternetGatewayBlockMode":
            return Optional.ofNullable(clazz.cast(internetGatewayBlockModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("InternetGatewayBlockMode", INTERNET_GATEWAY_BLOCK_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyVpcBlockPublicAccessOptionsRequest, T> g) {
        return obj -> g.apply((ModifyVpcBlockPublicAccessOptionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyVpcBlockPublicAccessOptionsRequest> {
        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The mode of VPC BPA.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>off</code>: VPC BPA is not enabled and traffic is allowed to and from internet gateways and egress-only
         * internet gateways in this Region.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-bidirectional</code>: Block all traffic to and from internet gateways and egress-only internet
         * gateways in this Region (except for excluded VPCs and subnets).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-ingress</code>: Block all internet traffic to the VPCs in this Region (except for VPCs or subnets
         * which are excluded). Only traffic to and from NAT gateways and egress-only internet gateways is allowed
         * because these gateways only allow outbound connections to be established.
         * </p>
         * </li>
         * </ul>
         * 
         * @param internetGatewayBlockMode
         *        The mode of VPC BPA.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>off</code>: VPC BPA is not enabled and traffic is allowed to and from internet gateways and
         *        egress-only internet gateways in this Region.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-bidirectional</code>: Block all traffic to and from internet gateways and egress-only
         *        internet gateways in this Region (except for excluded VPCs and subnets).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-ingress</code>: Block all internet traffic to the VPCs in this Region (except for VPCs or
         *        subnets which are excluded). Only traffic to and from NAT gateways and egress-only internet gateways
         *        is allowed because these gateways only allow outbound connections to be established.
         *        </p>
         *        </li>
         * @see InternetGatewayBlockMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InternetGatewayBlockMode
         */
        Builder internetGatewayBlockMode(String internetGatewayBlockMode);

        /**
         * <p>
         * The mode of VPC BPA.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>off</code>: VPC BPA is not enabled and traffic is allowed to and from internet gateways and egress-only
         * internet gateways in this Region.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-bidirectional</code>: Block all traffic to and from internet gateways and egress-only internet
         * gateways in this Region (except for excluded VPCs and subnets).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-ingress</code>: Block all internet traffic to the VPCs in this Region (except for VPCs or subnets
         * which are excluded). Only traffic to and from NAT gateways and egress-only internet gateways is allowed
         * because these gateways only allow outbound connections to be established.
         * </p>
         * </li>
         * </ul>
         * 
         * @param internetGatewayBlockMode
         *        The mode of VPC BPA.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>off</code>: VPC BPA is not enabled and traffic is allowed to and from internet gateways and
         *        egress-only internet gateways in this Region.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-bidirectional</code>: Block all traffic to and from internet gateways and egress-only
         *        internet gateways in this Region (except for excluded VPCs and subnets).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-ingress</code>: Block all internet traffic to the VPCs in this Region (except for VPCs or
         *        subnets which are excluded). Only traffic to and from NAT gateways and egress-only internet gateways
         *        is allowed because these gateways only allow outbound connections to be established.
         *        </p>
         *        </li>
         * @see InternetGatewayBlockMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InternetGatewayBlockMode
         */
        Builder internetGatewayBlockMode(InternetGatewayBlockMode internetGatewayBlockMode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Boolean dryRun;

        private String internetGatewayBlockMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpcBlockPublicAccessOptionsRequest model) {
            super(model);
            dryRun(model.dryRun);
            internetGatewayBlockMode(model.internetGatewayBlockMode);
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getInternetGatewayBlockMode() {
            return internetGatewayBlockMode;
        }

        public final void setInternetGatewayBlockMode(String internetGatewayBlockMode) {
            this.internetGatewayBlockMode = internetGatewayBlockMode;
        }

        @Override
        public final Builder internetGatewayBlockMode(String internetGatewayBlockMode) {
            this.internetGatewayBlockMode = internetGatewayBlockMode;
            return this;
        }

        @Override
        public final Builder internetGatewayBlockMode(InternetGatewayBlockMode internetGatewayBlockMode) {
            this.internetGatewayBlockMode(internetGatewayBlockMode == null ? null : internetGatewayBlockMode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyVpcBlockPublicAccessOptionsRequest build() {
            return new ModifyVpcBlockPublicAccessOptionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
