/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyLocalGatewayRouteRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyLocalGatewayRouteRequest.Builder, ModifyLocalGatewayRouteRequest> {
    private static final SdkField<String> DESTINATION_CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DestinationCidrBlock")
            .getter(getter(ModifyLocalGatewayRouteRequest::destinationCidrBlock))
            .setter(setter(Builder::destinationCidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidrBlock")
                    .unmarshallLocationName("DestinationCidrBlock").build()).build();

    private static final SdkField<String> LOCAL_GATEWAY_ROUTE_TABLE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalGatewayRouteTableId")
            .getter(getter(ModifyLocalGatewayRouteRequest::localGatewayRouteTableId))
            .setter(setter(Builder::localGatewayRouteTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayRouteTableId")
                    .unmarshallLocationName("LocalGatewayRouteTableId").build()).build();

    private static final SdkField<String> LOCAL_GATEWAY_VIRTUAL_INTERFACE_GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalGatewayVirtualInterfaceGroupId")
            .getter(getter(ModifyLocalGatewayRouteRequest::localGatewayVirtualInterfaceGroupId))
            .setter(setter(Builder::localGatewayVirtualInterfaceGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("LocalGatewayVirtualInterfaceGroupId")
                    .unmarshallLocationName("LocalGatewayVirtualInterfaceGroupId").build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceId")
            .getter(getter(ModifyLocalGatewayRouteRequest::networkInterfaceId))
            .setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId")
                    .unmarshallLocationName("NetworkInterfaceId").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(ModifyLocalGatewayRouteRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<String> DESTINATION_PREFIX_LIST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DestinationPrefixListId")
            .getter(getter(ModifyLocalGatewayRouteRequest::destinationPrefixListId))
            .setter(setter(Builder::destinationPrefixListId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPrefixListId")
                    .unmarshallLocationName("DestinationPrefixListId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_CIDR_BLOCK_FIELD,
            LOCAL_GATEWAY_ROUTE_TABLE_ID_FIELD, LOCAL_GATEWAY_VIRTUAL_INTERFACE_GROUP_ID_FIELD, NETWORK_INTERFACE_ID_FIELD,
            DRY_RUN_FIELD, DESTINATION_PREFIX_LIST_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String destinationCidrBlock;

    private final String localGatewayRouteTableId;

    private final String localGatewayVirtualInterfaceGroupId;

    private final String networkInterfaceId;

    private final Boolean dryRun;

    private final String destinationPrefixListId;

    private ModifyLocalGatewayRouteRequest(BuilderImpl builder) {
        super(builder);
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.localGatewayRouteTableId = builder.localGatewayRouteTableId;
        this.localGatewayVirtualInterfaceGroupId = builder.localGatewayVirtualInterfaceGroupId;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.dryRun = builder.dryRun;
        this.destinationPrefixListId = builder.destinationPrefixListId;
    }

    /**
     * <p>
     * The CIDR block used for destination matches. The value that you provide must match the CIDR of an existing route
     * in the table.
     * </p>
     * 
     * @return The CIDR block used for destination matches. The value that you provide must match the CIDR of an
     *         existing route in the table.
     */
    public final String destinationCidrBlock() {
        return destinationCidrBlock;
    }

    /**
     * <p>
     * The ID of the local gateway route table.
     * </p>
     * 
     * @return The ID of the local gateway route table.
     */
    public final String localGatewayRouteTableId() {
        return localGatewayRouteTableId;
    }

    /**
     * <p>
     * The ID of the virtual interface group.
     * </p>
     * 
     * @return The ID of the virtual interface group.
     */
    public final String localGatewayVirtualInterfaceGroupId() {
        return localGatewayVirtualInterfaceGroupId;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public final String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The ID of the prefix list. Use a prefix list in place of <code>DestinationCidrBlock</code>. You cannot use
     * <code>DestinationPrefixListId</code> and <code>DestinationCidrBlock</code> in the same request.
     * </p>
     * 
     * @return The ID of the prefix list. Use a prefix list in place of <code>DestinationCidrBlock</code>. You cannot
     *         use <code>DestinationPrefixListId</code> and <code>DestinationCidrBlock</code> in the same request.
     */
    public final String destinationPrefixListId() {
        return destinationPrefixListId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(destinationCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(localGatewayRouteTableId());
        hashCode = 31 * hashCode + Objects.hashCode(localGatewayVirtualInterfaceGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(destinationPrefixListId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyLocalGatewayRouteRequest)) {
            return false;
        }
        ModifyLocalGatewayRouteRequest other = (ModifyLocalGatewayRouteRequest) obj;
        return Objects.equals(destinationCidrBlock(), other.destinationCidrBlock())
                && Objects.equals(localGatewayRouteTableId(), other.localGatewayRouteTableId())
                && Objects.equals(localGatewayVirtualInterfaceGroupId(), other.localGatewayVirtualInterfaceGroupId())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(dryRun(), other.dryRun())
                && Objects.equals(destinationPrefixListId(), other.destinationPrefixListId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyLocalGatewayRouteRequest").add("DestinationCidrBlock", destinationCidrBlock())
                .add("LocalGatewayRouteTableId", localGatewayRouteTableId())
                .add("LocalGatewayVirtualInterfaceGroupId", localGatewayVirtualInterfaceGroupId())
                .add("NetworkInterfaceId", networkInterfaceId()).add("DryRun", dryRun())
                .add("DestinationPrefixListId", destinationPrefixListId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationCidrBlock":
            return Optional.ofNullable(clazz.cast(destinationCidrBlock()));
        case "LocalGatewayRouteTableId":
            return Optional.ofNullable(clazz.cast(localGatewayRouteTableId()));
        case "LocalGatewayVirtualInterfaceGroupId":
            return Optional.ofNullable(clazz.cast(localGatewayVirtualInterfaceGroupId()));
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "DestinationPrefixListId":
            return Optional.ofNullable(clazz.cast(destinationPrefixListId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DestinationCidrBlock", DESTINATION_CIDR_BLOCK_FIELD);
        map.put("LocalGatewayRouteTableId", LOCAL_GATEWAY_ROUTE_TABLE_ID_FIELD);
        map.put("LocalGatewayVirtualInterfaceGroupId", LOCAL_GATEWAY_VIRTUAL_INTERFACE_GROUP_ID_FIELD);
        map.put("NetworkInterfaceId", NETWORK_INTERFACE_ID_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("DestinationPrefixListId", DESTINATION_PREFIX_LIST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyLocalGatewayRouteRequest, T> g) {
        return obj -> g.apply((ModifyLocalGatewayRouteRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyLocalGatewayRouteRequest> {
        /**
         * <p>
         * The CIDR block used for destination matches. The value that you provide must match the CIDR of an existing
         * route in the table.
         * </p>
         * 
         * @param destinationCidrBlock
         *        The CIDR block used for destination matches. The value that you provide must match the CIDR of an
         *        existing route in the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCidrBlock(String destinationCidrBlock);

        /**
         * <p>
         * The ID of the local gateway route table.
         * </p>
         * 
         * @param localGatewayRouteTableId
         *        The ID of the local gateway route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayRouteTableId(String localGatewayRouteTableId);

        /**
         * <p>
         * The ID of the virtual interface group.
         * </p>
         * 
         * @param localGatewayVirtualInterfaceGroupId
         *        The ID of the virtual interface group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayVirtualInterfaceGroupId(String localGatewayVirtualInterfaceGroupId);

        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The ID of the prefix list. Use a prefix list in place of <code>DestinationCidrBlock</code>. You cannot use
         * <code>DestinationPrefixListId</code> and <code>DestinationCidrBlock</code> in the same request.
         * </p>
         * 
         * @param destinationPrefixListId
         *        The ID of the prefix list. Use a prefix list in place of <code>DestinationCidrBlock</code>. You cannot
         *        use <code>DestinationPrefixListId</code> and <code>DestinationCidrBlock</code> in the same request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPrefixListId(String destinationPrefixListId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String destinationCidrBlock;

        private String localGatewayRouteTableId;

        private String localGatewayVirtualInterfaceGroupId;

        private String networkInterfaceId;

        private Boolean dryRun;

        private String destinationPrefixListId;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyLocalGatewayRouteRequest model) {
            super(model);
            destinationCidrBlock(model.destinationCidrBlock);
            localGatewayRouteTableId(model.localGatewayRouteTableId);
            localGatewayVirtualInterfaceGroupId(model.localGatewayVirtualInterfaceGroupId);
            networkInterfaceId(model.networkInterfaceId);
            dryRun(model.dryRun);
            destinationPrefixListId(model.destinationPrefixListId);
        }

        public final String getDestinationCidrBlock() {
            return destinationCidrBlock;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        @Override
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final String getLocalGatewayRouteTableId() {
            return localGatewayRouteTableId;
        }

        public final void setLocalGatewayRouteTableId(String localGatewayRouteTableId) {
            this.localGatewayRouteTableId = localGatewayRouteTableId;
        }

        @Override
        public final Builder localGatewayRouteTableId(String localGatewayRouteTableId) {
            this.localGatewayRouteTableId = localGatewayRouteTableId;
            return this;
        }

        public final String getLocalGatewayVirtualInterfaceGroupId() {
            return localGatewayVirtualInterfaceGroupId;
        }

        public final void setLocalGatewayVirtualInterfaceGroupId(String localGatewayVirtualInterfaceGroupId) {
            this.localGatewayVirtualInterfaceGroupId = localGatewayVirtualInterfaceGroupId;
        }

        @Override
        public final Builder localGatewayVirtualInterfaceGroupId(String localGatewayVirtualInterfaceGroupId) {
            this.localGatewayVirtualInterfaceGroupId = localGatewayVirtualInterfaceGroupId;
            return this;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getDestinationPrefixListId() {
            return destinationPrefixListId;
        }

        public final void setDestinationPrefixListId(String destinationPrefixListId) {
            this.destinationPrefixListId = destinationPrefixListId;
        }

        @Override
        public final Builder destinationPrefixListId(String destinationPrefixListId) {
            this.destinationPrefixListId = destinationPrefixListId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyLocalGatewayRouteRequest build() {
            return new ModifyLocalGatewayRouteRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
