/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyIpamResourceDiscoveryRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyIpamResourceDiscoveryRequest.Builder, ModifyIpamResourceDiscoveryRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(ModifyIpamResourceDiscoveryRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<String> IPAM_RESOURCE_DISCOVERY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpamResourceDiscoveryId")
            .getter(getter(ModifyIpamResourceDiscoveryRequest::ipamResourceDiscoveryId))
            .setter(setter(Builder::ipamResourceDiscoveryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamResourceDiscoveryId")
                    .unmarshallLocationName("IpamResourceDiscoveryId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(ModifyIpamResourceDiscoveryRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final SdkField<List<AddIpamOperatingRegion>> ADD_OPERATING_REGIONS_FIELD = SdkField
            .<List<AddIpamOperatingRegion>> builder(MarshallingType.LIST)
            .memberName("AddOperatingRegions")
            .getter(getter(ModifyIpamResourceDiscoveryRequest::addOperatingRegions))
            .setter(setter(Builder::addOperatingRegions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddOperatingRegion")
                    .unmarshallLocationName("AddOperatingRegion").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AddIpamOperatingRegion> builder(MarshallingType.SDK_POJO)
                                            .constructor(AddIpamOperatingRegion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<List<RemoveIpamOperatingRegion>> REMOVE_OPERATING_REGIONS_FIELD = SdkField
            .<List<RemoveIpamOperatingRegion>> builder(MarshallingType.LIST)
            .memberName("RemoveOperatingRegions")
            .getter(getter(ModifyIpamResourceDiscoveryRequest::removeOperatingRegions))
            .setter(setter(Builder::removeOperatingRegions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveOperatingRegion")
                    .unmarshallLocationName("RemoveOperatingRegion").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RemoveIpamOperatingRegion> builder(MarshallingType.SDK_POJO)
                                            .constructor(RemoveIpamOperatingRegion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<List<AddIpamOrganizationalUnitExclusion>> ADD_ORGANIZATIONAL_UNIT_EXCLUSIONS_FIELD = SdkField
            .<List<AddIpamOrganizationalUnitExclusion>> builder(MarshallingType.LIST)
            .memberName("AddOrganizationalUnitExclusions")
            .getter(getter(ModifyIpamResourceDiscoveryRequest::addOrganizationalUnitExclusions))
            .setter(setter(Builder::addOrganizationalUnitExclusions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddOrganizationalUnitExclusion")
                    .unmarshallLocationName("AddOrganizationalUnitExclusion").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AddIpamOrganizationalUnitExclusion> builder(MarshallingType.SDK_POJO)
                                            .constructor(AddIpamOrganizationalUnitExclusion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<List<RemoveIpamOrganizationalUnitExclusion>> REMOVE_ORGANIZATIONAL_UNIT_EXCLUSIONS_FIELD = SdkField
            .<List<RemoveIpamOrganizationalUnitExclusion>> builder(MarshallingType.LIST)
            .memberName("RemoveOrganizationalUnitExclusions")
            .getter(getter(ModifyIpamResourceDiscoveryRequest::removeOrganizationalUnitExclusions))
            .setter(setter(Builder::removeOrganizationalUnitExclusions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveOrganizationalUnitExclusion")
                    .unmarshallLocationName("RemoveOrganizationalUnitExclusion").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RemoveIpamOrganizationalUnitExclusion> builder(MarshallingType.SDK_POJO)
                                            .constructor(RemoveIpamOrganizationalUnitExclusion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD,
            IPAM_RESOURCE_DISCOVERY_ID_FIELD, DESCRIPTION_FIELD, ADD_OPERATING_REGIONS_FIELD, REMOVE_OPERATING_REGIONS_FIELD,
            ADD_ORGANIZATIONAL_UNIT_EXCLUSIONS_FIELD, REMOVE_ORGANIZATIONAL_UNIT_EXCLUSIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean dryRun;

    private final String ipamResourceDiscoveryId;

    private final String description;

    private final List<AddIpamOperatingRegion> addOperatingRegions;

    private final List<RemoveIpamOperatingRegion> removeOperatingRegions;

    private final List<AddIpamOrganizationalUnitExclusion> addOrganizationalUnitExclusions;

    private final List<RemoveIpamOrganizationalUnitExclusion> removeOrganizationalUnitExclusions;

    private ModifyIpamResourceDiscoveryRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.ipamResourceDiscoveryId = builder.ipamResourceDiscoveryId;
        this.description = builder.description;
        this.addOperatingRegions = builder.addOperatingRegions;
        this.removeOperatingRegions = builder.removeOperatingRegions;
        this.addOrganizationalUnitExclusions = builder.addOrganizationalUnitExclusions;
        this.removeOrganizationalUnitExclusions = builder.removeOrganizationalUnitExclusions;
    }

    /**
     * <p>
     * A check for whether you have the required permissions for the action without actually making the request and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return A check for whether you have the required permissions for the action without actually making the request
     *         and provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * A resource discovery ID.
     * </p>
     * 
     * @return A resource discovery ID.
     */
    public final String ipamResourceDiscoveryId() {
        return ipamResourceDiscoveryId;
    }

    /**
     * <p>
     * A resource discovery description.
     * </p>
     * 
     * @return A resource discovery description.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddOperatingRegions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAddOperatingRegions() {
        return addOperatingRegions != null && !(addOperatingRegions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Add operating Regions to the resource discovery. Operating Regions are Amazon Web Services Regions where the IPAM
     * is allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in the Amazon Web Services
     * Regions you select as operating Regions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddOperatingRegions} method.
     * </p>
     * 
     * @return Add operating Regions to the resource discovery. Operating Regions are Amazon Web Services Regions where
     *         the IPAM is allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in the Amazon
     *         Web Services Regions you select as operating Regions.
     */
    public final List<AddIpamOperatingRegion> addOperatingRegions() {
        return addOperatingRegions;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoveOperatingRegions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRemoveOperatingRegions() {
        return removeOperatingRegions != null && !(removeOperatingRegions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Remove operating Regions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoveOperatingRegions} method.
     * </p>
     * 
     * @return Remove operating Regions.
     */
    public final List<RemoveIpamOperatingRegion> removeOperatingRegions() {
        return removeOperatingRegions;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddOrganizationalUnitExclusions
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasAddOrganizationalUnitExclusions() {
        return addOrganizationalUnitExclusions != null && !(addOrganizationalUnitExclusions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Add an Organizational Unit (OU) exclusion to your IPAM. If your IPAM is integrated with Amazon Web Services
     * Organizations and you add an organizational unit (OU) exclusion, IPAM will not manage the IP addresses in
     * accounts in that OU exclusion. There is a limit on the number of exclusions you can create. For more information,
     * see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/quotas-ipam.html">Quotas for your IPAM</a> in the
     * <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     * <note>
     * <p>
     * The resulting set of exclusions must not result in "overlap", meaning two or more OU exclusions must not exclude
     * the same OU. For more information and examples, see the Amazon Web Services CLI request process in <a
     * href="https://docs.aws.amazon.com/vpc/latest/ipam/exclude-ous.html#exclude-ous-create-delete">Add or remove OU
     * exclusions </a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddOrganizationalUnitExclusions}
     * method.
     * </p>
     * 
     * @return Add an Organizational Unit (OU) exclusion to your IPAM. If your IPAM is integrated with Amazon Web
     *         Services Organizations and you add an organizational unit (OU) exclusion, IPAM will not manage the IP
     *         addresses in accounts in that OU exclusion. There is a limit on the number of exclusions you can create.
     *         For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/quotas-ipam.html">Quotas
     *         for your IPAM</a> in the <i>Amazon VPC IPAM User Guide</i>.</p> <note>
     *         <p>
     *         The resulting set of exclusions must not result in "overlap", meaning two or more OU exclusions must not
     *         exclude the same OU. For more information and examples, see the Amazon Web Services CLI request process
     *         in <a href="https://docs.aws.amazon.com/vpc/latest/ipam/exclude-ous.html#exclude-ous-create-delete">Add
     *         or remove OU exclusions </a> in the <i>Amazon VPC User Guide</i>.
     *         </p>
     */
    public final List<AddIpamOrganizationalUnitExclusion> addOrganizationalUnitExclusions() {
        return addOrganizationalUnitExclusions;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoveOrganizationalUnitExclusions
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasRemoveOrganizationalUnitExclusions() {
        return removeOrganizationalUnitExclusions != null
                && !(removeOrganizationalUnitExclusions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Remove an Organizational Unit (OU) exclusion to your IPAM. If your IPAM is integrated with Amazon Web Services
     * Organizations and you add an organizational unit (OU) exclusion, IPAM will not manage the IP addresses in
     * accounts in that OU exclusion. There is a limit on the number of exclusions you can create. For more information,
     * see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/quotas-ipam.html">Quotas for your IPAM</a> in the
     * <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     * <note>
     * <p>
     * The resulting set of exclusions must not result in "overlap", meaning two or more OU exclusions must not exclude
     * the same OU. For more information and examples, see the Amazon Web Services CLI request process in <a
     * href="https://docs.aws.amazon.com/vpc/latest/ipam/exclude-ous.html#exclude-ous-create-delete">Add or remove OU
     * exclusions </a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoveOrganizationalUnitExclusions}
     * method.
     * </p>
     * 
     * @return Remove an Organizational Unit (OU) exclusion to your IPAM. If your IPAM is integrated with Amazon Web
     *         Services Organizations and you add an organizational unit (OU) exclusion, IPAM will not manage the IP
     *         addresses in accounts in that OU exclusion. There is a limit on the number of exclusions you can create.
     *         For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/quotas-ipam.html">Quotas
     *         for your IPAM</a> in the <i>Amazon VPC IPAM User Guide</i>.</p> <note>
     *         <p>
     *         The resulting set of exclusions must not result in "overlap", meaning two or more OU exclusions must not
     *         exclude the same OU. For more information and examples, see the Amazon Web Services CLI request process
     *         in <a href="https://docs.aws.amazon.com/vpc/latest/ipam/exclude-ous.html#exclude-ous-create-delete">Add
     *         or remove OU exclusions </a> in the <i>Amazon VPC User Guide</i>.
     *         </p>
     */
    public final List<RemoveIpamOrganizationalUnitExclusion> removeOrganizationalUnitExclusions() {
        return removeOrganizationalUnitExclusions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(ipamResourceDiscoveryId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasAddOperatingRegions() ? addOperatingRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoveOperatingRegions() ? removeOperatingRegions() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasAddOrganizationalUnitExclusions() ? addOrganizationalUnitExclusions() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasRemoveOrganizationalUnitExclusions() ? removeOrganizationalUnitExclusions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyIpamResourceDiscoveryRequest)) {
            return false;
        }
        ModifyIpamResourceDiscoveryRequest other = (ModifyIpamResourceDiscoveryRequest) obj;
        return Objects.equals(dryRun(), other.dryRun())
                && Objects.equals(ipamResourceDiscoveryId(), other.ipamResourceDiscoveryId())
                && Objects.equals(description(), other.description())
                && hasAddOperatingRegions() == other.hasAddOperatingRegions()
                && Objects.equals(addOperatingRegions(), other.addOperatingRegions())
                && hasRemoveOperatingRegions() == other.hasRemoveOperatingRegions()
                && Objects.equals(removeOperatingRegions(), other.removeOperatingRegions())
                && hasAddOrganizationalUnitExclusions() == other.hasAddOrganizationalUnitExclusions()
                && Objects.equals(addOrganizationalUnitExclusions(), other.addOrganizationalUnitExclusions())
                && hasRemoveOrganizationalUnitExclusions() == other.hasRemoveOrganizationalUnitExclusions()
                && Objects.equals(removeOrganizationalUnitExclusions(), other.removeOrganizationalUnitExclusions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ModifyIpamResourceDiscoveryRequest")
                .add("DryRun", dryRun())
                .add("IpamResourceDiscoveryId", ipamResourceDiscoveryId())
                .add("Description", description())
                .add("AddOperatingRegions", hasAddOperatingRegions() ? addOperatingRegions() : null)
                .add("RemoveOperatingRegions", hasRemoveOperatingRegions() ? removeOperatingRegions() : null)
                .add("AddOrganizationalUnitExclusions",
                        hasAddOrganizationalUnitExclusions() ? addOrganizationalUnitExclusions() : null)
                .add("RemoveOrganizationalUnitExclusions",
                        hasRemoveOrganizationalUnitExclusions() ? removeOrganizationalUnitExclusions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "IpamResourceDiscoveryId":
            return Optional.ofNullable(clazz.cast(ipamResourceDiscoveryId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "AddOperatingRegions":
            return Optional.ofNullable(clazz.cast(addOperatingRegions()));
        case "RemoveOperatingRegions":
            return Optional.ofNullable(clazz.cast(removeOperatingRegions()));
        case "AddOrganizationalUnitExclusions":
            return Optional.ofNullable(clazz.cast(addOrganizationalUnitExclusions()));
        case "RemoveOrganizationalUnitExclusions":
            return Optional.ofNullable(clazz.cast(removeOrganizationalUnitExclusions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("IpamResourceDiscoveryId", IPAM_RESOURCE_DISCOVERY_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("AddOperatingRegion", ADD_OPERATING_REGIONS_FIELD);
        map.put("RemoveOperatingRegion", REMOVE_OPERATING_REGIONS_FIELD);
        map.put("AddOrganizationalUnitExclusion", ADD_ORGANIZATIONAL_UNIT_EXCLUSIONS_FIELD);
        map.put("RemoveOrganizationalUnitExclusion", REMOVE_ORGANIZATIONAL_UNIT_EXCLUSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyIpamResourceDiscoveryRequest, T> g) {
        return obj -> g.apply((ModifyIpamResourceDiscoveryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyIpamResourceDiscoveryRequest> {
        /**
         * <p>
         * A check for whether you have the required permissions for the action without actually making the request and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        A check for whether you have the required permissions for the action without actually making the
         *        request and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * A resource discovery ID.
         * </p>
         * 
         * @param ipamResourceDiscoveryId
         *        A resource discovery ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamResourceDiscoveryId(String ipamResourceDiscoveryId);

        /**
         * <p>
         * A resource discovery description.
         * </p>
         * 
         * @param description
         *        A resource discovery description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Add operating Regions to the resource discovery. Operating Regions are Amazon Web Services Regions where the
         * IPAM is allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in the Amazon Web
         * Services Regions you select as operating Regions.
         * </p>
         * 
         * @param addOperatingRegions
         *        Add operating Regions to the resource discovery. Operating Regions are Amazon Web Services Regions
         *        where the IPAM is allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in
         *        the Amazon Web Services Regions you select as operating Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addOperatingRegions(Collection<AddIpamOperatingRegion> addOperatingRegions);

        /**
         * <p>
         * Add operating Regions to the resource discovery. Operating Regions are Amazon Web Services Regions where the
         * IPAM is allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in the Amazon Web
         * Services Regions you select as operating Regions.
         * </p>
         * 
         * @param addOperatingRegions
         *        Add operating Regions to the resource discovery. Operating Regions are Amazon Web Services Regions
         *        where the IPAM is allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in
         *        the Amazon Web Services Regions you select as operating Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addOperatingRegions(AddIpamOperatingRegion... addOperatingRegions);

        /**
         * <p>
         * Add operating Regions to the resource discovery. Operating Regions are Amazon Web Services Regions where the
         * IPAM is allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in the Amazon Web
         * Services Regions you select as operating Regions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.AddIpamOperatingRegion.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ec2.model.AddIpamOperatingRegion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.AddIpamOperatingRegion.Builder#build()} is called
         * immediately and its result is passed to {@link #addOperatingRegions(List<AddIpamOperatingRegion>)}.
         * 
         * @param addOperatingRegions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.AddIpamOperatingRegion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addOperatingRegions(java.util.Collection<AddIpamOperatingRegion>)
         */
        Builder addOperatingRegions(Consumer<AddIpamOperatingRegion.Builder>... addOperatingRegions);

        /**
         * <p>
         * Remove operating Regions.
         * </p>
         * 
         * @param removeOperatingRegions
         *        Remove operating Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeOperatingRegions(Collection<RemoveIpamOperatingRegion> removeOperatingRegions);

        /**
         * <p>
         * Remove operating Regions.
         * </p>
         * 
         * @param removeOperatingRegions
         *        Remove operating Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeOperatingRegions(RemoveIpamOperatingRegion... removeOperatingRegions);

        /**
         * <p>
         * Remove operating Regions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.RemoveIpamOperatingRegion.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.ec2.model.RemoveIpamOperatingRegion#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.RemoveIpamOperatingRegion.Builder#build()} is called
         * immediately and its result is passed to {@link #removeOperatingRegions(List<RemoveIpamOperatingRegion>)}.
         * 
         * @param removeOperatingRegions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.RemoveIpamOperatingRegion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #removeOperatingRegions(java.util.Collection<RemoveIpamOperatingRegion>)
         */
        Builder removeOperatingRegions(Consumer<RemoveIpamOperatingRegion.Builder>... removeOperatingRegions);

        /**
         * <p>
         * Add an Organizational Unit (OU) exclusion to your IPAM. If your IPAM is integrated with Amazon Web Services
         * Organizations and you add an organizational unit (OU) exclusion, IPAM will not manage the IP addresses in
         * accounts in that OU exclusion. There is a limit on the number of exclusions you can create. For more
         * information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/quotas-ipam.html">Quotas for your
         * IPAM</a> in the <i>Amazon VPC IPAM User Guide</i>.
         * </p>
         * <note>
         * <p>
         * The resulting set of exclusions must not result in "overlap", meaning two or more OU exclusions must not
         * exclude the same OU. For more information and examples, see the Amazon Web Services CLI request process in <a
         * href="https://docs.aws.amazon.com/vpc/latest/ipam/exclude-ous.html#exclude-ous-create-delete">Add or remove
         * OU exclusions </a> in the <i>Amazon VPC User Guide</i>.
         * </p>
         * </note>
         * 
         * @param addOrganizationalUnitExclusions
         *        Add an Organizational Unit (OU) exclusion to your IPAM. If your IPAM is integrated with Amazon Web
         *        Services Organizations and you add an organizational unit (OU) exclusion, IPAM will not manage the IP
         *        addresses in accounts in that OU exclusion. There is a limit on the number of exclusions you can
         *        create. For more information, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/ipam/quotas-ipam.html">Quotas for your IPAM</a> in the
         *        <i>Amazon VPC IPAM User Guide</i>.</p> <note>
         *        <p>
         *        The resulting set of exclusions must not result in "overlap", meaning two or more OU exclusions must
         *        not exclude the same OU. For more information and examples, see the Amazon Web Services CLI request
         *        process in <a
         *        href="https://docs.aws.amazon.com/vpc/latest/ipam/exclude-ous.html#exclude-ous-create-delete">Add or
         *        remove OU exclusions </a> in the <i>Amazon VPC User Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addOrganizationalUnitExclusions(Collection<AddIpamOrganizationalUnitExclusion> addOrganizationalUnitExclusions);

        /**
         * <p>
         * Add an Organizational Unit (OU) exclusion to your IPAM. If your IPAM is integrated with Amazon Web Services
         * Organizations and you add an organizational unit (OU) exclusion, IPAM will not manage the IP addresses in
         * accounts in that OU exclusion. There is a limit on the number of exclusions you can create. For more
         * information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/quotas-ipam.html">Quotas for your
         * IPAM</a> in the <i>Amazon VPC IPAM User Guide</i>.
         * </p>
         * <note>
         * <p>
         * The resulting set of exclusions must not result in "overlap", meaning two or more OU exclusions must not
         * exclude the same OU. For more information and examples, see the Amazon Web Services CLI request process in <a
         * href="https://docs.aws.amazon.com/vpc/latest/ipam/exclude-ous.html#exclude-ous-create-delete">Add or remove
         * OU exclusions </a> in the <i>Amazon VPC User Guide</i>.
         * </p>
         * </note>
         * 
         * @param addOrganizationalUnitExclusions
         *        Add an Organizational Unit (OU) exclusion to your IPAM. If your IPAM is integrated with Amazon Web
         *        Services Organizations and you add an organizational unit (OU) exclusion, IPAM will not manage the IP
         *        addresses in accounts in that OU exclusion. There is a limit on the number of exclusions you can
         *        create. For more information, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/ipam/quotas-ipam.html">Quotas for your IPAM</a> in the
         *        <i>Amazon VPC IPAM User Guide</i>.</p> <note>
         *        <p>
         *        The resulting set of exclusions must not result in "overlap", meaning two or more OU exclusions must
         *        not exclude the same OU. For more information and examples, see the Amazon Web Services CLI request
         *        process in <a
         *        href="https://docs.aws.amazon.com/vpc/latest/ipam/exclude-ous.html#exclude-ous-create-delete">Add or
         *        remove OU exclusions </a> in the <i>Amazon VPC User Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addOrganizationalUnitExclusions(AddIpamOrganizationalUnitExclusion... addOrganizationalUnitExclusions);

        /**
         * <p>
         * Add an Organizational Unit (OU) exclusion to your IPAM. If your IPAM is integrated with Amazon Web Services
         * Organizations and you add an organizational unit (OU) exclusion, IPAM will not manage the IP addresses in
         * accounts in that OU exclusion. There is a limit on the number of exclusions you can create. For more
         * information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/quotas-ipam.html">Quotas for your
         * IPAM</a> in the <i>Amazon VPC IPAM User Guide</i>.
         * </p>
         * <note>
         * <p>
         * The resulting set of exclusions must not result in "overlap", meaning two or more OU exclusions must not
         * exclude the same OU. For more information and examples, see the Amazon Web Services CLI request process in <a
         * href="https://docs.aws.amazon.com/vpc/latest/ipam/exclude-ous.html#exclude-ous-create-delete">Add or remove
         * OU exclusions </a> in the <i>Amazon VPC User Guide</i>.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.AddIpamOrganizationalUnitExclusion.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.AddIpamOrganizationalUnitExclusion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.AddIpamOrganizationalUnitExclusion.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #addOrganizationalUnitExclusions(List<AddIpamOrganizationalUnitExclusion>)}.
         * 
         * @param addOrganizationalUnitExclusions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.AddIpamOrganizationalUnitExclusion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addOrganizationalUnitExclusions(java.util.Collection<AddIpamOrganizationalUnitExclusion>)
         */
        Builder addOrganizationalUnitExclusions(
                Consumer<AddIpamOrganizationalUnitExclusion.Builder>... addOrganizationalUnitExclusions);

        /**
         * <p>
         * Remove an Organizational Unit (OU) exclusion to your IPAM. If your IPAM is integrated with Amazon Web
         * Services Organizations and you add an organizational unit (OU) exclusion, IPAM will not manage the IP
         * addresses in accounts in that OU exclusion. There is a limit on the number of exclusions you can create. For
         * more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/quotas-ipam.html">Quotas for your
         * IPAM</a> in the <i>Amazon VPC IPAM User Guide</i>.
         * </p>
         * <note>
         * <p>
         * The resulting set of exclusions must not result in "overlap", meaning two or more OU exclusions must not
         * exclude the same OU. For more information and examples, see the Amazon Web Services CLI request process in <a
         * href="https://docs.aws.amazon.com/vpc/latest/ipam/exclude-ous.html#exclude-ous-create-delete">Add or remove
         * OU exclusions </a> in the <i>Amazon VPC User Guide</i>.
         * </p>
         * </note>
         * 
         * @param removeOrganizationalUnitExclusions
         *        Remove an Organizational Unit (OU) exclusion to your IPAM. If your IPAM is integrated with Amazon Web
         *        Services Organizations and you add an organizational unit (OU) exclusion, IPAM will not manage the IP
         *        addresses in accounts in that OU exclusion. There is a limit on the number of exclusions you can
         *        create. For more information, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/ipam/quotas-ipam.html">Quotas for your IPAM</a> in the
         *        <i>Amazon VPC IPAM User Guide</i>.</p> <note>
         *        <p>
         *        The resulting set of exclusions must not result in "overlap", meaning two or more OU exclusions must
         *        not exclude the same OU. For more information and examples, see the Amazon Web Services CLI request
         *        process in <a
         *        href="https://docs.aws.amazon.com/vpc/latest/ipam/exclude-ous.html#exclude-ous-create-delete">Add or
         *        remove OU exclusions </a> in the <i>Amazon VPC User Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeOrganizationalUnitExclusions(
                Collection<RemoveIpamOrganizationalUnitExclusion> removeOrganizationalUnitExclusions);

        /**
         * <p>
         * Remove an Organizational Unit (OU) exclusion to your IPAM. If your IPAM is integrated with Amazon Web
         * Services Organizations and you add an organizational unit (OU) exclusion, IPAM will not manage the IP
         * addresses in accounts in that OU exclusion. There is a limit on the number of exclusions you can create. For
         * more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/quotas-ipam.html">Quotas for your
         * IPAM</a> in the <i>Amazon VPC IPAM User Guide</i>.
         * </p>
         * <note>
         * <p>
         * The resulting set of exclusions must not result in "overlap", meaning two or more OU exclusions must not
         * exclude the same OU. For more information and examples, see the Amazon Web Services CLI request process in <a
         * href="https://docs.aws.amazon.com/vpc/latest/ipam/exclude-ous.html#exclude-ous-create-delete">Add or remove
         * OU exclusions </a> in the <i>Amazon VPC User Guide</i>.
         * </p>
         * </note>
         * 
         * @param removeOrganizationalUnitExclusions
         *        Remove an Organizational Unit (OU) exclusion to your IPAM. If your IPAM is integrated with Amazon Web
         *        Services Organizations and you add an organizational unit (OU) exclusion, IPAM will not manage the IP
         *        addresses in accounts in that OU exclusion. There is a limit on the number of exclusions you can
         *        create. For more information, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/ipam/quotas-ipam.html">Quotas for your IPAM</a> in the
         *        <i>Amazon VPC IPAM User Guide</i>.</p> <note>
         *        <p>
         *        The resulting set of exclusions must not result in "overlap", meaning two or more OU exclusions must
         *        not exclude the same OU. For more information and examples, see the Amazon Web Services CLI request
         *        process in <a
         *        href="https://docs.aws.amazon.com/vpc/latest/ipam/exclude-ous.html#exclude-ous-create-delete">Add or
         *        remove OU exclusions </a> in the <i>Amazon VPC User Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeOrganizationalUnitExclusions(RemoveIpamOrganizationalUnitExclusion... removeOrganizationalUnitExclusions);

        /**
         * <p>
         * Remove an Organizational Unit (OU) exclusion to your IPAM. If your IPAM is integrated with Amazon Web
         * Services Organizations and you add an organizational unit (OU) exclusion, IPAM will not manage the IP
         * addresses in accounts in that OU exclusion. There is a limit on the number of exclusions you can create. For
         * more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/quotas-ipam.html">Quotas for your
         * IPAM</a> in the <i>Amazon VPC IPAM User Guide</i>.
         * </p>
         * <note>
         * <p>
         * The resulting set of exclusions must not result in "overlap", meaning two or more OU exclusions must not
         * exclude the same OU. For more information and examples, see the Amazon Web Services CLI request process in <a
         * href="https://docs.aws.amazon.com/vpc/latest/ipam/exclude-ous.html#exclude-ous-create-delete">Add or remove
         * OU exclusions </a> in the <i>Amazon VPC User Guide</i>.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.RemoveIpamOrganizationalUnitExclusion.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.RemoveIpamOrganizationalUnitExclusion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.RemoveIpamOrganizationalUnitExclusion.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #removeOrganizationalUnitExclusions(List<RemoveIpamOrganizationalUnitExclusion>)}.
         * 
         * @param removeOrganizationalUnitExclusions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.RemoveIpamOrganizationalUnitExclusion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #removeOrganizationalUnitExclusions(java.util.Collection<RemoveIpamOrganizationalUnitExclusion>)
         */
        Builder removeOrganizationalUnitExclusions(
                Consumer<RemoveIpamOrganizationalUnitExclusion.Builder>... removeOrganizationalUnitExclusions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Boolean dryRun;

        private String ipamResourceDiscoveryId;

        private String description;

        private List<AddIpamOperatingRegion> addOperatingRegions = DefaultSdkAutoConstructList.getInstance();

        private List<RemoveIpamOperatingRegion> removeOperatingRegions = DefaultSdkAutoConstructList.getInstance();

        private List<AddIpamOrganizationalUnitExclusion> addOrganizationalUnitExclusions = DefaultSdkAutoConstructList
                .getInstance();

        private List<RemoveIpamOrganizationalUnitExclusion> removeOrganizationalUnitExclusions = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyIpamResourceDiscoveryRequest model) {
            super(model);
            dryRun(model.dryRun);
            ipamResourceDiscoveryId(model.ipamResourceDiscoveryId);
            description(model.description);
            addOperatingRegions(model.addOperatingRegions);
            removeOperatingRegions(model.removeOperatingRegions);
            addOrganizationalUnitExclusions(model.addOrganizationalUnitExclusions);
            removeOrganizationalUnitExclusions(model.removeOrganizationalUnitExclusions);
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getIpamResourceDiscoveryId() {
            return ipamResourceDiscoveryId;
        }

        public final void setIpamResourceDiscoveryId(String ipamResourceDiscoveryId) {
            this.ipamResourceDiscoveryId = ipamResourceDiscoveryId;
        }

        @Override
        public final Builder ipamResourceDiscoveryId(String ipamResourceDiscoveryId) {
            this.ipamResourceDiscoveryId = ipamResourceDiscoveryId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<AddIpamOperatingRegion.Builder> getAddOperatingRegions() {
            List<AddIpamOperatingRegion.Builder> result = AddIpamOperatingRegionSetCopier.copyToBuilder(this.addOperatingRegions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddOperatingRegions(Collection<AddIpamOperatingRegion.BuilderImpl> addOperatingRegions) {
            this.addOperatingRegions = AddIpamOperatingRegionSetCopier.copyFromBuilder(addOperatingRegions);
        }

        @Override
        public final Builder addOperatingRegions(Collection<AddIpamOperatingRegion> addOperatingRegions) {
            this.addOperatingRegions = AddIpamOperatingRegionSetCopier.copy(addOperatingRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addOperatingRegions(AddIpamOperatingRegion... addOperatingRegions) {
            addOperatingRegions(Arrays.asList(addOperatingRegions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addOperatingRegions(Consumer<AddIpamOperatingRegion.Builder>... addOperatingRegions) {
            addOperatingRegions(Stream.of(addOperatingRegions)
                    .map(c -> AddIpamOperatingRegion.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RemoveIpamOperatingRegion.Builder> getRemoveOperatingRegions() {
            List<RemoveIpamOperatingRegion.Builder> result = RemoveIpamOperatingRegionSetCopier
                    .copyToBuilder(this.removeOperatingRegions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRemoveOperatingRegions(Collection<RemoveIpamOperatingRegion.BuilderImpl> removeOperatingRegions) {
            this.removeOperatingRegions = RemoveIpamOperatingRegionSetCopier.copyFromBuilder(removeOperatingRegions);
        }

        @Override
        public final Builder removeOperatingRegions(Collection<RemoveIpamOperatingRegion> removeOperatingRegions) {
            this.removeOperatingRegions = RemoveIpamOperatingRegionSetCopier.copy(removeOperatingRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeOperatingRegions(RemoveIpamOperatingRegion... removeOperatingRegions) {
            removeOperatingRegions(Arrays.asList(removeOperatingRegions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeOperatingRegions(Consumer<RemoveIpamOperatingRegion.Builder>... removeOperatingRegions) {
            removeOperatingRegions(Stream.of(removeOperatingRegions)
                    .map(c -> RemoveIpamOperatingRegion.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AddIpamOrganizationalUnitExclusion.Builder> getAddOrganizationalUnitExclusions() {
            List<AddIpamOrganizationalUnitExclusion.Builder> result = AddIpamOrganizationalUnitExclusionSetCopier
                    .copyToBuilder(this.addOrganizationalUnitExclusions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddOrganizationalUnitExclusions(
                Collection<AddIpamOrganizationalUnitExclusion.BuilderImpl> addOrganizationalUnitExclusions) {
            this.addOrganizationalUnitExclusions = AddIpamOrganizationalUnitExclusionSetCopier
                    .copyFromBuilder(addOrganizationalUnitExclusions);
        }

        @Override
        public final Builder addOrganizationalUnitExclusions(
                Collection<AddIpamOrganizationalUnitExclusion> addOrganizationalUnitExclusions) {
            this.addOrganizationalUnitExclusions = AddIpamOrganizationalUnitExclusionSetCopier
                    .copy(addOrganizationalUnitExclusions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addOrganizationalUnitExclusions(
                AddIpamOrganizationalUnitExclusion... addOrganizationalUnitExclusions) {
            addOrganizationalUnitExclusions(Arrays.asList(addOrganizationalUnitExclusions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addOrganizationalUnitExclusions(
                Consumer<AddIpamOrganizationalUnitExclusion.Builder>... addOrganizationalUnitExclusions) {
            addOrganizationalUnitExclusions(Stream.of(addOrganizationalUnitExclusions)
                    .map(c -> AddIpamOrganizationalUnitExclusion.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RemoveIpamOrganizationalUnitExclusion.Builder> getRemoveOrganizationalUnitExclusions() {
            List<RemoveIpamOrganizationalUnitExclusion.Builder> result = RemoveIpamOrganizationalUnitExclusionSetCopier
                    .copyToBuilder(this.removeOrganizationalUnitExclusions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRemoveOrganizationalUnitExclusions(
                Collection<RemoveIpamOrganizationalUnitExclusion.BuilderImpl> removeOrganizationalUnitExclusions) {
            this.removeOrganizationalUnitExclusions = RemoveIpamOrganizationalUnitExclusionSetCopier
                    .copyFromBuilder(removeOrganizationalUnitExclusions);
        }

        @Override
        public final Builder removeOrganizationalUnitExclusions(
                Collection<RemoveIpamOrganizationalUnitExclusion> removeOrganizationalUnitExclusions) {
            this.removeOrganizationalUnitExclusions = RemoveIpamOrganizationalUnitExclusionSetCopier
                    .copy(removeOrganizationalUnitExclusions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeOrganizationalUnitExclusions(
                RemoveIpamOrganizationalUnitExclusion... removeOrganizationalUnitExclusions) {
            removeOrganizationalUnitExclusions(Arrays.asList(removeOrganizationalUnitExclusions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeOrganizationalUnitExclusions(
                Consumer<RemoveIpamOrganizationalUnitExclusion.Builder>... removeOrganizationalUnitExclusions) {
            removeOrganizationalUnitExclusions(Stream.of(removeOrganizationalUnitExclusions)
                    .map(c -> RemoveIpamOrganizationalUnitExclusion.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyIpamResourceDiscoveryRequest build() {
            return new ModifyIpamResourceDiscoveryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
