/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyCapacityReservationRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyCapacityReservationRequest.Builder, ModifyCapacityReservationRequest> {
    private static final SdkField<String> CAPACITY_RESERVATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CapacityReservationId")
            .getter(getter(ModifyCapacityReservationRequest::capacityReservationId))
            .setter(setter(Builder::capacityReservationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationId")
                    .unmarshallLocationName("CapacityReservationId").build()).build();

    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstanceCount")
            .getter(getter(ModifyCapacityReservationRequest::instanceCount))
            .setter(setter(Builder::instanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount")
                    .unmarshallLocationName("InstanceCount").build()).build();

    private static final SdkField<Instant> END_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndDate")
            .getter(getter(ModifyCapacityReservationRequest::endDate))
            .setter(setter(Builder::endDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate")
                    .unmarshallLocationName("EndDate").build()).build();

    private static final SdkField<String> END_DATE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EndDateType")
            .getter(getter(ModifyCapacityReservationRequest::endDateTypeAsString))
            .setter(setter(Builder::endDateType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDateType")
                    .unmarshallLocationName("EndDateType").build()).build();

    private static final SdkField<Boolean> ACCEPT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Accept")
            .getter(getter(ModifyCapacityReservationRequest::accept))
            .setter(setter(Builder::accept))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accept")
                    .unmarshallLocationName("Accept").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(ModifyCapacityReservationRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<String> ADDITIONAL_INFO_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AdditionalInfo")
            .getter(getter(ModifyCapacityReservationRequest::additionalInfo))
            .setter(setter(Builder::additionalInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalInfo")
                    .unmarshallLocationName("AdditionalInfo").build()).build();

    private static final SdkField<String> INSTANCE_MATCH_CRITERIA_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceMatchCriteria")
            .getter(getter(ModifyCapacityReservationRequest::instanceMatchCriteriaAsString))
            .setter(setter(Builder::instanceMatchCriteria))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceMatchCriteria")
                    .unmarshallLocationName("InstanceMatchCriteria").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_RESERVATION_ID_FIELD,
            INSTANCE_COUNT_FIELD, END_DATE_FIELD, END_DATE_TYPE_FIELD, ACCEPT_FIELD, DRY_RUN_FIELD, ADDITIONAL_INFO_FIELD,
            INSTANCE_MATCH_CRITERIA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String capacityReservationId;

    private final Integer instanceCount;

    private final Instant endDate;

    private final String endDateType;

    private final Boolean accept;

    private final Boolean dryRun;

    private final String additionalInfo;

    private final String instanceMatchCriteria;

    private ModifyCapacityReservationRequest(BuilderImpl builder) {
        super(builder);
        this.capacityReservationId = builder.capacityReservationId;
        this.instanceCount = builder.instanceCount;
        this.endDate = builder.endDate;
        this.endDateType = builder.endDateType;
        this.accept = builder.accept;
        this.dryRun = builder.dryRun;
        this.additionalInfo = builder.additionalInfo;
        this.instanceMatchCriteria = builder.instanceMatchCriteria;
    }

    /**
     * <p>
     * The ID of the Capacity Reservation.
     * </p>
     * 
     * @return The ID of the Capacity Reservation.
     */
    public final String capacityReservationId() {
        return capacityReservationId;
    }

    /**
     * <p>
     * The number of instances for which to reserve capacity. The number of instances can't be increased or decreased by
     * more than <code>1000</code> in a single request.
     * </p>
     * 
     * @return The number of instances for which to reserve capacity. The number of instances can't be increased or
     *         decreased by more than <code>1000</code> in a single request.
     */
    public final Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved
     * capacity is released and you can no longer launch instances into it. The Capacity Reservation's state changes to
     * <code>expired</code> when it reaches its end date and time.
     * </p>
     * <p>
     * The Capacity Reservation is cancelled within an hour from the specified time. For example, if you specify
     * 5/31/2019, 13:30:55, the Capacity Reservation is guaranteed to end between 13:30:55 and 14:30:55 on 5/31/2019.
     * </p>
     * <p>
     * You must provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>limited</code>. Omit
     * <code>EndDate</code> if <code>EndDateType</code> is <code>unlimited</code>.
     * </p>
     * 
     * @return The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the
     *         reserved capacity is released and you can no longer launch instances into it. The Capacity Reservation's
     *         state changes to <code>expired</code> when it reaches its end date and time.</p>
     *         <p>
     *         The Capacity Reservation is cancelled within an hour from the specified time. For example, if you specify
     *         5/31/2019, 13:30:55, the Capacity Reservation is guaranteed to end between 13:30:55 and 14:30:55 on
     *         5/31/2019.
     *         </p>
     *         <p>
     *         You must provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>limited</code>. Omit
     *         <code>EndDate</code> if <code>EndDateType</code> is <code>unlimited</code>.
     */
    public final Instant endDate() {
        return endDate;
    }

    /**
     * <p>
     * Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following
     * end types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it. Do not provide
     * an <code>EndDate</code> value if <code>EndDateType</code> is <code>unlimited</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time. You must
     * provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>limited</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endDateType} will
     * return {@link EndDateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #endDateTypeAsString}.
     * </p>
     * 
     * @return Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the
     *         following end types:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it. Do not
     *         provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>unlimited</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time. You
     *         must provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>limited</code>.
     *         </p>
     *         </li>
     * @see EndDateType
     */
    public final EndDateType endDateType() {
        return EndDateType.fromValue(endDateType);
    }

    /**
     * <p>
     * Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following
     * end types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it. Do not provide
     * an <code>EndDate</code> value if <code>EndDateType</code> is <code>unlimited</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time. You must
     * provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>limited</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endDateType} will
     * return {@link EndDateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #endDateTypeAsString}.
     * </p>
     * 
     * @return Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the
     *         following end types:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it. Do not
     *         provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>unlimited</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time. You
     *         must provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>limited</code>.
     *         </p>
     *         </li>
     * @see EndDateType
     */
    public final String endDateTypeAsString() {
        return endDateType;
    }

    /**
     * <p>
     * Reserved. Capacity Reservations you have created are accepted by default.
     * </p>
     * 
     * @return Reserved. Capacity Reservations you have created are accepted by default.
     */
    public final Boolean accept() {
        return accept;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public final String additionalInfo() {
        return additionalInfo;
    }

    /**
     * <p>
     * The matching criteria (instance eligibility) that you want to use in the modified Capacity Reservation. If you
     * change the instance eligibility of an existing Capacity Reservation from <code>targeted</code> to
     * <code>open</code>, any running instances that match the attributes of the Capacity Reservation, have the
     * <code>CapacityReservationPreference</code> set to <code>open</code>, and are not yet running in the Capacity
     * Reservation, will automatically use the modified Capacity Reservation.
     * </p>
     * <p>
     * To modify the instance eligibility, the Capacity Reservation must be completely idle (zero usage).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #instanceMatchCriteria} will return {@link InstanceMatchCriteria#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #instanceMatchCriteriaAsString}.
     * </p>
     * 
     * @return The matching criteria (instance eligibility) that you want to use in the modified Capacity Reservation.
     *         If you change the instance eligibility of an existing Capacity Reservation from <code>targeted</code> to
     *         <code>open</code>, any running instances that match the attributes of the Capacity Reservation, have the
     *         <code>CapacityReservationPreference</code> set to <code>open</code>, and are not yet running in the
     *         Capacity Reservation, will automatically use the modified Capacity Reservation. </p>
     *         <p>
     *         To modify the instance eligibility, the Capacity Reservation must be completely idle (zero usage).
     * @see InstanceMatchCriteria
     */
    public final InstanceMatchCriteria instanceMatchCriteria() {
        return InstanceMatchCriteria.fromValue(instanceMatchCriteria);
    }

    /**
     * <p>
     * The matching criteria (instance eligibility) that you want to use in the modified Capacity Reservation. If you
     * change the instance eligibility of an existing Capacity Reservation from <code>targeted</code> to
     * <code>open</code>, any running instances that match the attributes of the Capacity Reservation, have the
     * <code>CapacityReservationPreference</code> set to <code>open</code>, and are not yet running in the Capacity
     * Reservation, will automatically use the modified Capacity Reservation.
     * </p>
     * <p>
     * To modify the instance eligibility, the Capacity Reservation must be completely idle (zero usage).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #instanceMatchCriteria} will return {@link InstanceMatchCriteria#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #instanceMatchCriteriaAsString}.
     * </p>
     * 
     * @return The matching criteria (instance eligibility) that you want to use in the modified Capacity Reservation.
     *         If you change the instance eligibility of an existing Capacity Reservation from <code>targeted</code> to
     *         <code>open</code>, any running instances that match the attributes of the Capacity Reservation, have the
     *         <code>CapacityReservationPreference</code> set to <code>open</code>, and are not yet running in the
     *         Capacity Reservation, will automatically use the modified Capacity Reservation. </p>
     *         <p>
     *         To modify the instance eligibility, the Capacity Reservation must be completely idle (zero usage).
     * @see InstanceMatchCriteria
     */
    public final String instanceMatchCriteriaAsString() {
        return instanceMatchCriteria;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(endDate());
        hashCode = 31 * hashCode + Objects.hashCode(endDateTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(accept());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(additionalInfo());
        hashCode = 31 * hashCode + Objects.hashCode(instanceMatchCriteriaAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyCapacityReservationRequest)) {
            return false;
        }
        ModifyCapacityReservationRequest other = (ModifyCapacityReservationRequest) obj;
        return Objects.equals(capacityReservationId(), other.capacityReservationId())
                && Objects.equals(instanceCount(), other.instanceCount()) && Objects.equals(endDate(), other.endDate())
                && Objects.equals(endDateTypeAsString(), other.endDateTypeAsString()) && Objects.equals(accept(), other.accept())
                && Objects.equals(dryRun(), other.dryRun()) && Objects.equals(additionalInfo(), other.additionalInfo())
                && Objects.equals(instanceMatchCriteriaAsString(), other.instanceMatchCriteriaAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyCapacityReservationRequest").add("CapacityReservationId", capacityReservationId())
                .add("InstanceCount", instanceCount()).add("EndDate", endDate()).add("EndDateType", endDateTypeAsString())
                .add("Accept", accept()).add("DryRun", dryRun()).add("AdditionalInfo", additionalInfo())
                .add("InstanceMatchCriteria", instanceMatchCriteriaAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CapacityReservationId":
            return Optional.ofNullable(clazz.cast(capacityReservationId()));
        case "InstanceCount":
            return Optional.ofNullable(clazz.cast(instanceCount()));
        case "EndDate":
            return Optional.ofNullable(clazz.cast(endDate()));
        case "EndDateType":
            return Optional.ofNullable(clazz.cast(endDateTypeAsString()));
        case "Accept":
            return Optional.ofNullable(clazz.cast(accept()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "AdditionalInfo":
            return Optional.ofNullable(clazz.cast(additionalInfo()));
        case "InstanceMatchCriteria":
            return Optional.ofNullable(clazz.cast(instanceMatchCriteriaAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CapacityReservationId", CAPACITY_RESERVATION_ID_FIELD);
        map.put("InstanceCount", INSTANCE_COUNT_FIELD);
        map.put("EndDate", END_DATE_FIELD);
        map.put("EndDateType", END_DATE_TYPE_FIELD);
        map.put("Accept", ACCEPT_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("AdditionalInfo", ADDITIONAL_INFO_FIELD);
        map.put("InstanceMatchCriteria", INSTANCE_MATCH_CRITERIA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyCapacityReservationRequest, T> g) {
        return obj -> g.apply((ModifyCapacityReservationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyCapacityReservationRequest> {
        /**
         * <p>
         * The ID of the Capacity Reservation.
         * </p>
         * 
         * @param capacityReservationId
         *        The ID of the Capacity Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationId(String capacityReservationId);

        /**
         * <p>
         * The number of instances for which to reserve capacity. The number of instances can't be increased or
         * decreased by more than <code>1000</code> in a single request.
         * </p>
         * 
         * @param instanceCount
         *        The number of instances for which to reserve capacity. The number of instances can't be increased or
         *        decreased by more than <code>1000</code> in a single request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the
         * reserved capacity is released and you can no longer launch instances into it. The Capacity Reservation's
         * state changes to <code>expired</code> when it reaches its end date and time.
         * </p>
         * <p>
         * The Capacity Reservation is cancelled within an hour from the specified time. For example, if you specify
         * 5/31/2019, 13:30:55, the Capacity Reservation is guaranteed to end between 13:30:55 and 14:30:55 on
         * 5/31/2019.
         * </p>
         * <p>
         * You must provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>limited</code>. Omit
         * <code>EndDate</code> if <code>EndDateType</code> is <code>unlimited</code>.
         * </p>
         * 
         * @param endDate
         *        The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the
         *        reserved capacity is released and you can no longer launch instances into it. The Capacity
         *        Reservation's state changes to <code>expired</code> when it reaches its end date and time.</p>
         *        <p>
         *        The Capacity Reservation is cancelled within an hour from the specified time. For example, if you
         *        specify 5/31/2019, 13:30:55, the Capacity Reservation is guaranteed to end between 13:30:55 and
         *        14:30:55 on 5/31/2019.
         *        </p>
         *        <p>
         *        You must provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>limited</code>.
         *        Omit <code>EndDate</code> if <code>EndDateType</code> is <code>unlimited</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDate(Instant endDate);

        /**
         * <p>
         * Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the
         * following end types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it. Do not
         * provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>unlimited</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time. You must
         * provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>limited</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param endDateType
         *        Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the
         *        following end types:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it. Do
         *        not provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>unlimited</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time.
         *        You must provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>limited</code>.
         *        </p>
         *        </li>
         * @see EndDateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndDateType
         */
        Builder endDateType(String endDateType);

        /**
         * <p>
         * Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the
         * following end types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it. Do not
         * provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>unlimited</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time. You must
         * provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>limited</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param endDateType
         *        Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the
         *        following end types:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it. Do
         *        not provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>unlimited</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time.
         *        You must provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>limited</code>.
         *        </p>
         *        </li>
         * @see EndDateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndDateType
         */
        Builder endDateType(EndDateType endDateType);

        /**
         * <p>
         * Reserved. Capacity Reservations you have created are accepted by default.
         * </p>
         * 
         * @param accept
         *        Reserved. Capacity Reservations you have created are accepted by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accept(Boolean accept);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param additionalInfo
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalInfo(String additionalInfo);

        /**
         * <p>
         * The matching criteria (instance eligibility) that you want to use in the modified Capacity Reservation. If
         * you change the instance eligibility of an existing Capacity Reservation from <code>targeted</code> to
         * <code>open</code>, any running instances that match the attributes of the Capacity Reservation, have the
         * <code>CapacityReservationPreference</code> set to <code>open</code>, and are not yet running in the Capacity
         * Reservation, will automatically use the modified Capacity Reservation.
         * </p>
         * <p>
         * To modify the instance eligibility, the Capacity Reservation must be completely idle (zero usage).
         * </p>
         * 
         * @param instanceMatchCriteria
         *        The matching criteria (instance eligibility) that you want to use in the modified Capacity
         *        Reservation. If you change the instance eligibility of an existing Capacity Reservation from
         *        <code>targeted</code> to <code>open</code>, any running instances that match the attributes of the
         *        Capacity Reservation, have the <code>CapacityReservationPreference</code> set to <code>open</code>,
         *        and are not yet running in the Capacity Reservation, will automatically use the modified Capacity
         *        Reservation. </p>
         *        <p>
         *        To modify the instance eligibility, the Capacity Reservation must be completely idle (zero usage).
         * @see InstanceMatchCriteria
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceMatchCriteria
         */
        Builder instanceMatchCriteria(String instanceMatchCriteria);

        /**
         * <p>
         * The matching criteria (instance eligibility) that you want to use in the modified Capacity Reservation. If
         * you change the instance eligibility of an existing Capacity Reservation from <code>targeted</code> to
         * <code>open</code>, any running instances that match the attributes of the Capacity Reservation, have the
         * <code>CapacityReservationPreference</code> set to <code>open</code>, and are not yet running in the Capacity
         * Reservation, will automatically use the modified Capacity Reservation.
         * </p>
         * <p>
         * To modify the instance eligibility, the Capacity Reservation must be completely idle (zero usage).
         * </p>
         * 
         * @param instanceMatchCriteria
         *        The matching criteria (instance eligibility) that you want to use in the modified Capacity
         *        Reservation. If you change the instance eligibility of an existing Capacity Reservation from
         *        <code>targeted</code> to <code>open</code>, any running instances that match the attributes of the
         *        Capacity Reservation, have the <code>CapacityReservationPreference</code> set to <code>open</code>,
         *        and are not yet running in the Capacity Reservation, will automatically use the modified Capacity
         *        Reservation. </p>
         *        <p>
         *        To modify the instance eligibility, the Capacity Reservation must be completely idle (zero usage).
         * @see InstanceMatchCriteria
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceMatchCriteria
         */
        Builder instanceMatchCriteria(InstanceMatchCriteria instanceMatchCriteria);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String capacityReservationId;

        private Integer instanceCount;

        private Instant endDate;

        private String endDateType;

        private Boolean accept;

        private Boolean dryRun;

        private String additionalInfo;

        private String instanceMatchCriteria;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyCapacityReservationRequest model) {
            super(model);
            capacityReservationId(model.capacityReservationId);
            instanceCount(model.instanceCount);
            endDate(model.endDate);
            endDateType(model.endDateType);
            accept(model.accept);
            dryRun(model.dryRun);
            additionalInfo(model.additionalInfo);
            instanceMatchCriteria(model.instanceMatchCriteria);
        }

        public final String getCapacityReservationId() {
            return capacityReservationId;
        }

        public final void setCapacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
        }

        @Override
        public final Builder capacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
            return this;
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final Instant getEndDate() {
            return endDate;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public final String getEndDateType() {
            return endDateType;
        }

        public final void setEndDateType(String endDateType) {
            this.endDateType = endDateType;
        }

        @Override
        public final Builder endDateType(String endDateType) {
            this.endDateType = endDateType;
            return this;
        }

        @Override
        public final Builder endDateType(EndDateType endDateType) {
            this.endDateType(endDateType == null ? null : endDateType.toString());
            return this;
        }

        public final Boolean getAccept() {
            return accept;
        }

        public final void setAccept(Boolean accept) {
            this.accept = accept;
        }

        @Override
        public final Builder accept(Boolean accept) {
            this.accept = accept;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getAdditionalInfo() {
            return additionalInfo;
        }

        public final void setAdditionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
        }

        @Override
        public final Builder additionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        public final String getInstanceMatchCriteria() {
            return instanceMatchCriteria;
        }

        public final void setInstanceMatchCriteria(String instanceMatchCriteria) {
            this.instanceMatchCriteria = instanceMatchCriteria;
        }

        @Override
        public final Builder instanceMatchCriteria(String instanceMatchCriteria) {
            this.instanceMatchCriteria = instanceMatchCriteria;
            return this;
        }

        @Override
        public final Builder instanceMatchCriteria(InstanceMatchCriteria instanceMatchCriteria) {
            this.instanceMatchCriteria(instanceMatchCriteria == null ? null : instanceMatchCriteria.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyCapacityReservationRequest build() {
            return new ModifyCapacityReservationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
