/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the AMI.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageMetadata implements SdkPojo, Serializable, ToCopyableBuilder<ImageMetadata.Builder, ImageMetadata> {
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ImageId")
            .getter(getter(ImageMetadata::imageId))
            .setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId")
                    .unmarshallLocationName("imageId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(ImageMetadata::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("name").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OwnerId")
            .getter(getter(ImageMetadata::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageOwnerId")
                    .unmarshallLocationName("imageOwnerId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(ImageMetadata::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageState")
                    .unmarshallLocationName("imageState").build()).build();

    private static final SdkField<String> IMAGE_OWNER_ALIAS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ImageOwnerAlias")
            .getter(getter(ImageMetadata::imageOwnerAlias))
            .setter(setter(Builder::imageOwnerAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageOwnerAlias")
                    .unmarshallLocationName("imageOwnerAlias").build()).build();

    private static final SdkField<String> CREATION_DATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CreationDate")
            .getter(getter(ImageMetadata::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate")
                    .unmarshallLocationName("creationDate").build()).build();

    private static final SdkField<String> DEPRECATION_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DeprecationTime")
            .getter(getter(ImageMetadata::deprecationTime))
            .setter(setter(Builder::deprecationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeprecationTime")
                    .unmarshallLocationName("deprecationTime").build()).build();

    private static final SdkField<Boolean> IMAGE_ALLOWED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ImageAllowed")
            .getter(getter(ImageMetadata::imageAllowed))
            .setter(setter(Builder::imageAllowed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageAllowed")
                    .unmarshallLocationName("imageAllowed").build()).build();

    private static final SdkField<Boolean> IS_PUBLIC_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsPublic")
            .getter(getter(ImageMetadata::isPublic))
            .setter(setter(Builder::isPublic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsPublic")
                    .unmarshallLocationName("isPublic").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_ID_FIELD, NAME_FIELD,
            OWNER_ID_FIELD, STATE_FIELD, IMAGE_OWNER_ALIAS_FIELD, CREATION_DATE_FIELD, DEPRECATION_TIME_FIELD,
            IMAGE_ALLOWED_FIELD, IS_PUBLIC_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String imageId;

    private final String name;

    private final String ownerId;

    private final String state;

    private final String imageOwnerAlias;

    private final String creationDate;

    private final String deprecationTime;

    private final Boolean imageAllowed;

    private final Boolean isPublic;

    private ImageMetadata(BuilderImpl builder) {
        this.imageId = builder.imageId;
        this.name = builder.name;
        this.ownerId = builder.ownerId;
        this.state = builder.state;
        this.imageOwnerAlias = builder.imageOwnerAlias;
        this.creationDate = builder.creationDate;
        this.deprecationTime = builder.deprecationTime;
        this.imageAllowed = builder.imageAllowed;
        this.isPublic = builder.isPublic;
    }

    /**
     * <p>
     * The ID of the AMI.
     * </p>
     * 
     * @return The ID of the AMI.
     */
    public final String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The name of the AMI.
     * </p>
     * 
     * @return The name of the AMI.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that owns the AMI.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that owns the AMI.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The current state of the AMI. If the state is <code>available</code>, the AMI is successfully registered and can
     * be used to launch an instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ImageState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the AMI. If the state is <code>available</code>, the AMI is successfully registered
     *         and can be used to launch an instance.
     * @see ImageState
     */
    public final ImageState state() {
        return ImageState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the AMI. If the state is <code>available</code>, the AMI is successfully registered and can
     * be used to launch an instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ImageState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the AMI. If the state is <code>available</code>, the AMI is successfully registered
     *         and can be used to launch an instance.
     * @see ImageState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The alias of the AMI owner.
     * </p>
     * <p>
     * Valid values: <code>amazon</code> | <code>aws-backup-vault</code> | <code>aws-marketplace</code>
     * </p>
     * 
     * @return The alias of the AMI owner.</p>
     *         <p>
     *         Valid values: <code>amazon</code> | <code>aws-backup-vault</code> | <code>aws-marketplace</code>
     */
    public final String imageOwnerAlias() {
        return imageOwnerAlias;
    }

    /**
     * <p>
     * The date and time the AMI was created.
     * </p>
     * 
     * @return The date and time the AMI was created.
     */
    public final String creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The deprecation date and time of the AMI, in UTC, in the following format:
     * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z.
     * </p>
     * 
     * @return The deprecation date and time of the AMI, in UTC, in the following format:
     *         <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z.
     */
    public final String deprecationTime() {
        return deprecationTime;
    }

    /**
     * <p>
     * If <code>true</code>, the AMI satisfies the criteria for Allowed AMIs and can be discovered and used in the
     * account. If <code>false</code>, the AMI can't be discovered or used in the account.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-allowed-amis.html">Control the discovery and use of
     * AMIs in Amazon EC2 with Allowed AMIs</a> in <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @return If <code>true</code>, the AMI satisfies the criteria for Allowed AMIs and can be discovered and used in
     *         the account. If <code>false</code>, the AMI can't be discovered or used in the account.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-allowed-amis.html">Control the discovery
     *         and use of AMIs in Amazon EC2 with Allowed AMIs</a> in <i>Amazon EC2 User Guide</i>.
     */
    public final Boolean imageAllowed() {
        return imageAllowed;
    }

    /**
     * <p>
     * Indicates whether the AMI has public launch permissions. A value of <code>true</code> means this AMI has public
     * launch permissions, while <code>false</code> means it has only implicit (AMI owner) or explicit (shared with your
     * account) launch permissions.
     * </p>
     * 
     * @return Indicates whether the AMI has public launch permissions. A value of <code>true</code> means this AMI has
     *         public launch permissions, while <code>false</code> means it has only implicit (AMI owner) or explicit
     *         (shared with your account) launch permissions.
     */
    public final Boolean isPublic() {
        return isPublic;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(imageOwnerAlias());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(deprecationTime());
        hashCode = 31 * hashCode + Objects.hashCode(imageAllowed());
        hashCode = 31 * hashCode + Objects.hashCode(isPublic());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageMetadata)) {
            return false;
        }
        ImageMetadata other = (ImageMetadata) obj;
        return Objects.equals(imageId(), other.imageId()) && Objects.equals(name(), other.name())
                && Objects.equals(ownerId(), other.ownerId()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(imageOwnerAlias(), other.imageOwnerAlias())
                && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(deprecationTime(), other.deprecationTime())
                && Objects.equals(imageAllowed(), other.imageAllowed()) && Objects.equals(isPublic(), other.isPublic());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImageMetadata").add("ImageId", imageId()).add("Name", name()).add("OwnerId", ownerId())
                .add("State", stateAsString()).add("ImageOwnerAlias", imageOwnerAlias()).add("CreationDate", creationDate())
                .add("DeprecationTime", deprecationTime()).add("ImageAllowed", imageAllowed()).add("IsPublic", isPublic())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "ImageOwnerAlias":
            return Optional.ofNullable(clazz.cast(imageOwnerAlias()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "DeprecationTime":
            return Optional.ofNullable(clazz.cast(deprecationTime()));
        case "ImageAllowed":
            return Optional.ofNullable(clazz.cast(imageAllowed()));
        case "IsPublic":
            return Optional.ofNullable(clazz.cast(isPublic()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ImageId", IMAGE_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("ImageOwnerId", OWNER_ID_FIELD);
        map.put("ImageState", STATE_FIELD);
        map.put("ImageOwnerAlias", IMAGE_OWNER_ALIAS_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        map.put("DeprecationTime", DEPRECATION_TIME_FIELD);
        map.put("ImageAllowed", IMAGE_ALLOWED_FIELD);
        map.put("IsPublic", IS_PUBLIC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageMetadata, T> g) {
        return obj -> g.apply((ImageMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImageMetadata> {
        /**
         * <p>
         * The ID of the AMI.
         * </p>
         * 
         * @param imageId
         *        The ID of the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The name of the AMI.
         * </p>
         * 
         * @param name
         *        The name of the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the Amazon Web Services account that owns the AMI.
         * </p>
         * 
         * @param ownerId
         *        The ID of the Amazon Web Services account that owns the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The current state of the AMI. If the state is <code>available</code>, the AMI is successfully registered and
         * can be used to launch an instance.
         * </p>
         * 
         * @param state
         *        The current state of the AMI. If the state is <code>available</code>, the AMI is successfully
         *        registered and can be used to launch an instance.
         * @see ImageState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the AMI. If the state is <code>available</code>, the AMI is successfully registered and
         * can be used to launch an instance.
         * </p>
         * 
         * @param state
         *        The current state of the AMI. If the state is <code>available</code>, the AMI is successfully
         *        registered and can be used to launch an instance.
         * @see ImageState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageState
         */
        Builder state(ImageState state);

        /**
         * <p>
         * The alias of the AMI owner.
         * </p>
         * <p>
         * Valid values: <code>amazon</code> | <code>aws-backup-vault</code> | <code>aws-marketplace</code>
         * </p>
         * 
         * @param imageOwnerAlias
         *        The alias of the AMI owner.</p>
         *        <p>
         *        Valid values: <code>amazon</code> | <code>aws-backup-vault</code> | <code>aws-marketplace</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageOwnerAlias(String imageOwnerAlias);

        /**
         * <p>
         * The date and time the AMI was created.
         * </p>
         * 
         * @param creationDate
         *        The date and time the AMI was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(String creationDate);

        /**
         * <p>
         * The deprecation date and time of the AMI, in UTC, in the following format:
         * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z.
         * </p>
         * 
         * @param deprecationTime
         *        The deprecation date and time of the AMI, in UTC, in the following format:
         *        <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deprecationTime(String deprecationTime);

        /**
         * <p>
         * If <code>true</code>, the AMI satisfies the criteria for Allowed AMIs and can be discovered and used in the
         * account. If <code>false</code>, the AMI can't be discovered or used in the account.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-allowed-amis.html">Control the discovery and
         * use of AMIs in Amazon EC2 with Allowed AMIs</a> in <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param imageAllowed
         *        If <code>true</code>, the AMI satisfies the criteria for Allowed AMIs and can be discovered and used
         *        in the account. If <code>false</code>, the AMI can't be discovered or used in the account.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-allowed-amis.html">Control the discovery
         *        and use of AMIs in Amazon EC2 with Allowed AMIs</a> in <i>Amazon EC2 User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageAllowed(Boolean imageAllowed);

        /**
         * <p>
         * Indicates whether the AMI has public launch permissions. A value of <code>true</code> means this AMI has
         * public launch permissions, while <code>false</code> means it has only implicit (AMI owner) or explicit
         * (shared with your account) launch permissions.
         * </p>
         * 
         * @param isPublic
         *        Indicates whether the AMI has public launch permissions. A value of <code>true</code> means this AMI
         *        has public launch permissions, while <code>false</code> means it has only implicit (AMI owner) or
         *        explicit (shared with your account) launch permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isPublic(Boolean isPublic);
    }

    static final class BuilderImpl implements Builder {
        private String imageId;

        private String name;

        private String ownerId;

        private String state;

        private String imageOwnerAlias;

        private String creationDate;

        private String deprecationTime;

        private Boolean imageAllowed;

        private Boolean isPublic;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageMetadata model) {
            imageId(model.imageId);
            name(model.name);
            ownerId(model.ownerId);
            state(model.state);
            imageOwnerAlias(model.imageOwnerAlias);
            creationDate(model.creationDate);
            deprecationTime(model.deprecationTime);
            imageAllowed(model.imageAllowed);
            isPublic(model.isPublic);
        }

        public final String getImageId() {
            return imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ImageState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getImageOwnerAlias() {
            return imageOwnerAlias;
        }

        public final void setImageOwnerAlias(String imageOwnerAlias) {
            this.imageOwnerAlias = imageOwnerAlias;
        }

        @Override
        public final Builder imageOwnerAlias(String imageOwnerAlias) {
            this.imageOwnerAlias = imageOwnerAlias;
            return this;
        }

        public final String getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getDeprecationTime() {
            return deprecationTime;
        }

        public final void setDeprecationTime(String deprecationTime) {
            this.deprecationTime = deprecationTime;
        }

        @Override
        public final Builder deprecationTime(String deprecationTime) {
            this.deprecationTime = deprecationTime;
            return this;
        }

        public final Boolean getImageAllowed() {
            return imageAllowed;
        }

        public final void setImageAllowed(Boolean imageAllowed) {
            this.imageAllowed = imageAllowed;
        }

        @Override
        public final Builder imageAllowed(Boolean imageAllowed) {
            this.imageAllowed = imageAllowed;
            return this;
        }

        public final Boolean getIsPublic() {
            return isPublic;
        }

        public final void setIsPublic(Boolean isPublic) {
            this.isPublic = isPublic;
        }

        @Override
        public final Builder isPublic(Boolean isPublic) {
            this.isPublic = isPublic;
            return this;
        }

        @Override
        public ImageMetadata build() {
            return new ImageMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
