/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetIpamResourceCidrsResponse extends Ec2Response implements
        ToCopyableBuilder<GetIpamResourceCidrsResponse.Builder, GetIpamResourceCidrsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(GetIpamResourceCidrsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final SdkField<List<IpamResourceCidr>> IPAM_RESOURCE_CIDRS_FIELD = SdkField
            .<List<IpamResourceCidr>> builder(MarshallingType.LIST)
            .memberName("IpamResourceCidrs")
            .getter(getter(GetIpamResourceCidrsResponse::ipamResourceCidrs))
            .setter(setter(Builder::ipamResourceCidrs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamResourceCidrSet")
                    .unmarshallLocationName("ipamResourceCidrSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<IpamResourceCidr> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpamResourceCidr::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            IPAM_RESOURCE_CIDRS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<IpamResourceCidr> ipamResourceCidrs;

    private GetIpamResourceCidrsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.ipamResourceCidrs = builder.ipamResourceCidrs;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the IpamResourceCidrs property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpamResourceCidrs() {
        return ipamResourceCidrs != null && !(ipamResourceCidrs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The resource CIDRs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpamResourceCidrs} method.
     * </p>
     * 
     * @return The resource CIDRs.
     */
    public final List<IpamResourceCidr> ipamResourceCidrs() {
        return ipamResourceCidrs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpamResourceCidrs() ? ipamResourceCidrs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIpamResourceCidrsResponse)) {
            return false;
        }
        GetIpamResourceCidrsResponse other = (GetIpamResourceCidrsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasIpamResourceCidrs() == other.hasIpamResourceCidrs()
                && Objects.equals(ipamResourceCidrs(), other.ipamResourceCidrs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetIpamResourceCidrsResponse").add("NextToken", nextToken())
                .add("IpamResourceCidrs", hasIpamResourceCidrs() ? ipamResourceCidrs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "IpamResourceCidrs":
            return Optional.ofNullable(clazz.cast(ipamResourceCidrs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("IpamResourceCidrSet", IPAM_RESOURCE_CIDRS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetIpamResourceCidrsResponse, T> g) {
        return obj -> g.apply((GetIpamResourceCidrsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetIpamResourceCidrsResponse> {
        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The resource CIDRs.
         * </p>
         * 
         * @param ipamResourceCidrs
         *        The resource CIDRs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamResourceCidrs(Collection<IpamResourceCidr> ipamResourceCidrs);

        /**
         * <p>
         * The resource CIDRs.
         * </p>
         * 
         * @param ipamResourceCidrs
         *        The resource CIDRs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamResourceCidrs(IpamResourceCidr... ipamResourceCidrs);

        /**
         * <p>
         * The resource CIDRs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.IpamResourceCidr.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.IpamResourceCidr#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.IpamResourceCidr.Builder#build()} is called immediately and
         * its result is passed to {@link #ipamResourceCidrs(List<IpamResourceCidr>)}.
         * 
         * @param ipamResourceCidrs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.IpamResourceCidr.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipamResourceCidrs(java.util.Collection<IpamResourceCidr>)
         */
        Builder ipamResourceCidrs(Consumer<IpamResourceCidr.Builder>... ipamResourceCidrs);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String nextToken;

        private List<IpamResourceCidr> ipamResourceCidrs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetIpamResourceCidrsResponse model) {
            super(model);
            nextToken(model.nextToken);
            ipamResourceCidrs(model.ipamResourceCidrs);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<IpamResourceCidr.Builder> getIpamResourceCidrs() {
            List<IpamResourceCidr.Builder> result = IpamResourceCidrSetCopier.copyToBuilder(this.ipamResourceCidrs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpamResourceCidrs(Collection<IpamResourceCidr.BuilderImpl> ipamResourceCidrs) {
            this.ipamResourceCidrs = IpamResourceCidrSetCopier.copyFromBuilder(ipamResourceCidrs);
        }

        @Override
        public final Builder ipamResourceCidrs(Collection<IpamResourceCidr> ipamResourceCidrs) {
            this.ipamResourceCidrs = IpamResourceCidrSetCopier.copy(ipamResourceCidrs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamResourceCidrs(IpamResourceCidr... ipamResourceCidrs) {
            ipamResourceCidrs(Arrays.asList(ipamResourceCidrs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamResourceCidrs(Consumer<IpamResourceCidr.Builder>... ipamResourceCidrs) {
            ipamResourceCidrs(Stream.of(ipamResourceCidrs).map(c -> IpamResourceCidr.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetIpamResourceCidrsResponse build() {
            return new GetIpamResourceCidrsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
