/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDeclarativePoliciesReportSummaryResponse extends Ec2Response implements
        ToCopyableBuilder<GetDeclarativePoliciesReportSummaryResponse.Builder, GetDeclarativePoliciesReportSummaryResponse> {
    private static final SdkField<String> REPORT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReportId")
            .getter(getter(GetDeclarativePoliciesReportSummaryResponse::reportId))
            .setter(setter(Builder::reportId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportId")
                    .unmarshallLocationName("reportId").build()).build();

    private static final SdkField<String> S3_BUCKET_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("S3Bucket")
            .getter(getter(GetDeclarativePoliciesReportSummaryResponse::s3Bucket))
            .setter(setter(Builder::s3Bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Bucket")
                    .unmarshallLocationName("s3Bucket").build()).build();

    private static final SdkField<String> S3_PREFIX_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("S3Prefix")
            .getter(getter(GetDeclarativePoliciesReportSummaryResponse::s3Prefix))
            .setter(setter(Builder::s3Prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Prefix")
                    .unmarshallLocationName("s3Prefix").build()).build();

    private static final SdkField<String> TARGET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TargetId")
            .getter(getter(GetDeclarativePoliciesReportSummaryResponse::targetId))
            .setter(setter(Builder::targetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetId")
                    .unmarshallLocationName("targetId").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime")
            .getter(getter(GetDeclarativePoliciesReportSummaryResponse::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime")
                    .unmarshallLocationName("startTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime")
            .getter(getter(GetDeclarativePoliciesReportSummaryResponse::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime")
                    .unmarshallLocationName("endTime").build()).build();

    private static final SdkField<Integer> NUMBER_OF_ACCOUNTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfAccounts")
            .getter(getter(GetDeclarativePoliciesReportSummaryResponse::numberOfAccounts))
            .setter(setter(Builder::numberOfAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfAccounts")
                    .unmarshallLocationName("numberOfAccounts").build()).build();

    private static final SdkField<Integer> NUMBER_OF_FAILED_ACCOUNTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfFailedAccounts")
            .getter(getter(GetDeclarativePoliciesReportSummaryResponse::numberOfFailedAccounts))
            .setter(setter(Builder::numberOfFailedAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfFailedAccounts")
                    .unmarshallLocationName("numberOfFailedAccounts").build()).build();

    private static final SdkField<List<AttributeSummary>> ATTRIBUTE_SUMMARIES_FIELD = SdkField
            .<List<AttributeSummary>> builder(MarshallingType.LIST)
            .memberName("AttributeSummaries")
            .getter(getter(GetDeclarativePoliciesReportSummaryResponse::attributeSummaries))
            .setter(setter(Builder::attributeSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeSummarySet")
                    .unmarshallLocationName("attributeSummarySet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<AttributeSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_ID_FIELD,
            S3_BUCKET_FIELD, S3_PREFIX_FIELD, TARGET_ID_FIELD, START_TIME_FIELD, END_TIME_FIELD, NUMBER_OF_ACCOUNTS_FIELD,
            NUMBER_OF_FAILED_ACCOUNTS_FIELD, ATTRIBUTE_SUMMARIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String reportId;

    private final String s3Bucket;

    private final String s3Prefix;

    private final String targetId;

    private final Instant startTime;

    private final Instant endTime;

    private final Integer numberOfAccounts;

    private final Integer numberOfFailedAccounts;

    private final List<AttributeSummary> attributeSummaries;

    private GetDeclarativePoliciesReportSummaryResponse(BuilderImpl builder) {
        super(builder);
        this.reportId = builder.reportId;
        this.s3Bucket = builder.s3Bucket;
        this.s3Prefix = builder.s3Prefix;
        this.targetId = builder.targetId;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.numberOfAccounts = builder.numberOfAccounts;
        this.numberOfFailedAccounts = builder.numberOfFailedAccounts;
        this.attributeSummaries = builder.attributeSummaries;
    }

    /**
     * <p>
     * The ID of the report.
     * </p>
     * 
     * @return The ID of the report.
     */
    public final String reportId() {
        return reportId;
    }

    /**
     * <p>
     * The name of the Amazon S3 bucket where the report is located.
     * </p>
     * 
     * @return The name of the Amazon S3 bucket where the report is located.
     */
    public final String s3Bucket() {
        return s3Bucket;
    }

    /**
     * <p>
     * The prefix for your S3 object.
     * </p>
     * 
     * @return The prefix for your S3 object.
     */
    public final String s3Prefix() {
        return s3Prefix;
    }

    /**
     * <p>
     * The root ID, organizational unit ID, or account ID.
     * </p>
     * <p>
     * Format:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For root: <code>r-ab12</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * For OU: <code>ou-ab12-cdef1234</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * For account: <code>123456789012</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The root ID, organizational unit ID, or account ID.</p>
     *         <p>
     *         Format:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For root: <code>r-ab12</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For OU: <code>ou-ab12-cdef1234</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For account: <code>123456789012</code>
     *         </p>
     *         </li>
     */
    public final String targetId() {
        return targetId;
    }

    /**
     * <p>
     * The time when the report generation started.
     * </p>
     * 
     * @return The time when the report generation started.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time when the report generation ended.
     * </p>
     * 
     * @return The time when the report generation ended.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The total number of accounts associated with the specified <code>targetId</code>.
     * </p>
     * 
     * @return The total number of accounts associated with the specified <code>targetId</code>.
     */
    public final Integer numberOfAccounts() {
        return numberOfAccounts;
    }

    /**
     * <p>
     * The number of accounts where attributes could not be retrieved in any Region.
     * </p>
     * 
     * @return The number of accounts where attributes could not be retrieved in any Region.
     */
    public final Integer numberOfFailedAccounts() {
        return numberOfFailedAccounts;
    }

    /**
     * For responses, this returns true if the service returned a value for the AttributeSummaries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttributeSummaries() {
        return attributeSummaries != null && !(attributeSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The attributes described in the report.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributeSummaries} method.
     * </p>
     * 
     * @return The attributes described in the report.
     */
    public final List<AttributeSummary> attributeSummaries() {
        return attributeSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reportId());
        hashCode = 31 * hashCode + Objects.hashCode(s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(s3Prefix());
        hashCode = 31 * hashCode + Objects.hashCode(targetId());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfAccounts());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfFailedAccounts());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributeSummaries() ? attributeSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeclarativePoliciesReportSummaryResponse)) {
            return false;
        }
        GetDeclarativePoliciesReportSummaryResponse other = (GetDeclarativePoliciesReportSummaryResponse) obj;
        return Objects.equals(reportId(), other.reportId()) && Objects.equals(s3Bucket(), other.s3Bucket())
                && Objects.equals(s3Prefix(), other.s3Prefix()) && Objects.equals(targetId(), other.targetId())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(numberOfAccounts(), other.numberOfAccounts())
                && Objects.equals(numberOfFailedAccounts(), other.numberOfFailedAccounts())
                && hasAttributeSummaries() == other.hasAttributeSummaries()
                && Objects.equals(attributeSummaries(), other.attributeSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDeclarativePoliciesReportSummaryResponse").add("ReportId", reportId())
                .add("S3Bucket", s3Bucket()).add("S3Prefix", s3Prefix()).add("TargetId", targetId())
                .add("StartTime", startTime()).add("EndTime", endTime()).add("NumberOfAccounts", numberOfAccounts())
                .add("NumberOfFailedAccounts", numberOfFailedAccounts())
                .add("AttributeSummaries", hasAttributeSummaries() ? attributeSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReportId":
            return Optional.ofNullable(clazz.cast(reportId()));
        case "S3Bucket":
            return Optional.ofNullable(clazz.cast(s3Bucket()));
        case "S3Prefix":
            return Optional.ofNullable(clazz.cast(s3Prefix()));
        case "TargetId":
            return Optional.ofNullable(clazz.cast(targetId()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "NumberOfAccounts":
            return Optional.ofNullable(clazz.cast(numberOfAccounts()));
        case "NumberOfFailedAccounts":
            return Optional.ofNullable(clazz.cast(numberOfFailedAccounts()));
        case "AttributeSummaries":
            return Optional.ofNullable(clazz.cast(attributeSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReportId", REPORT_ID_FIELD);
        map.put("S3Bucket", S3_BUCKET_FIELD);
        map.put("S3Prefix", S3_PREFIX_FIELD);
        map.put("TargetId", TARGET_ID_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("NumberOfAccounts", NUMBER_OF_ACCOUNTS_FIELD);
        map.put("NumberOfFailedAccounts", NUMBER_OF_FAILED_ACCOUNTS_FIELD);
        map.put("AttributeSummarySet", ATTRIBUTE_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDeclarativePoliciesReportSummaryResponse, T> g) {
        return obj -> g.apply((GetDeclarativePoliciesReportSummaryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDeclarativePoliciesReportSummaryResponse> {
        /**
         * <p>
         * The ID of the report.
         * </p>
         * 
         * @param reportId
         *        The ID of the report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportId(String reportId);

        /**
         * <p>
         * The name of the Amazon S3 bucket where the report is located.
         * </p>
         * 
         * @param s3Bucket
         *        The name of the Amazon S3 bucket where the report is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Bucket(String s3Bucket);

        /**
         * <p>
         * The prefix for your S3 object.
         * </p>
         * 
         * @param s3Prefix
         *        The prefix for your S3 object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Prefix(String s3Prefix);

        /**
         * <p>
         * The root ID, organizational unit ID, or account ID.
         * </p>
         * <p>
         * Format:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For root: <code>r-ab12</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * For OU: <code>ou-ab12-cdef1234</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * For account: <code>123456789012</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param targetId
         *        The root ID, organizational unit ID, or account ID.</p>
         *        <p>
         *        Format:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For root: <code>r-ab12</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For OU: <code>ou-ab12-cdef1234</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For account: <code>123456789012</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetId(String targetId);

        /**
         * <p>
         * The time when the report generation started.
         * </p>
         * 
         * @param startTime
         *        The time when the report generation started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The time when the report generation ended.
         * </p>
         * 
         * @param endTime
         *        The time when the report generation ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The total number of accounts associated with the specified <code>targetId</code>.
         * </p>
         * 
         * @param numberOfAccounts
         *        The total number of accounts associated with the specified <code>targetId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfAccounts(Integer numberOfAccounts);

        /**
         * <p>
         * The number of accounts where attributes could not be retrieved in any Region.
         * </p>
         * 
         * @param numberOfFailedAccounts
         *        The number of accounts where attributes could not be retrieved in any Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfFailedAccounts(Integer numberOfFailedAccounts);

        /**
         * <p>
         * The attributes described in the report.
         * </p>
         * 
         * @param attributeSummaries
         *        The attributes described in the report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeSummaries(Collection<AttributeSummary> attributeSummaries);

        /**
         * <p>
         * The attributes described in the report.
         * </p>
         * 
         * @param attributeSummaries
         *        The attributes described in the report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeSummaries(AttributeSummary... attributeSummaries);

        /**
         * <p>
         * The attributes described in the report.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.AttributeSummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.AttributeSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.AttributeSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #attributeSummaries(List<AttributeSummary>)}.
         * 
         * @param attributeSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.AttributeSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributeSummaries(java.util.Collection<AttributeSummary>)
         */
        Builder attributeSummaries(Consumer<AttributeSummary.Builder>... attributeSummaries);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String reportId;

        private String s3Bucket;

        private String s3Prefix;

        private String targetId;

        private Instant startTime;

        private Instant endTime;

        private Integer numberOfAccounts;

        private Integer numberOfFailedAccounts;

        private List<AttributeSummary> attributeSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeclarativePoliciesReportSummaryResponse model) {
            super(model);
            reportId(model.reportId);
            s3Bucket(model.s3Bucket);
            s3Prefix(model.s3Prefix);
            targetId(model.targetId);
            startTime(model.startTime);
            endTime(model.endTime);
            numberOfAccounts(model.numberOfAccounts);
            numberOfFailedAccounts(model.numberOfFailedAccounts);
            attributeSummaries(model.attributeSummaries);
        }

        public final String getReportId() {
            return reportId;
        }

        public final void setReportId(String reportId) {
            this.reportId = reportId;
        }

        @Override
        public final Builder reportId(String reportId) {
            this.reportId = reportId;
            return this;
        }

        public final String getS3Bucket() {
            return s3Bucket;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final String getS3Prefix() {
            return s3Prefix;
        }

        public final void setS3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
        }

        @Override
        public final Builder s3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
            return this;
        }

        public final String getTargetId() {
            return targetId;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        @Override
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Integer getNumberOfAccounts() {
            return numberOfAccounts;
        }

        public final void setNumberOfAccounts(Integer numberOfAccounts) {
            this.numberOfAccounts = numberOfAccounts;
        }

        @Override
        public final Builder numberOfAccounts(Integer numberOfAccounts) {
            this.numberOfAccounts = numberOfAccounts;
            return this;
        }

        public final Integer getNumberOfFailedAccounts() {
            return numberOfFailedAccounts;
        }

        public final void setNumberOfFailedAccounts(Integer numberOfFailedAccounts) {
            this.numberOfFailedAccounts = numberOfFailedAccounts;
        }

        @Override
        public final Builder numberOfFailedAccounts(Integer numberOfFailedAccounts) {
            this.numberOfFailedAccounts = numberOfFailedAccounts;
            return this;
        }

        public final List<AttributeSummary.Builder> getAttributeSummaries() {
            List<AttributeSummary.Builder> result = AttributeSummaryListCopier.copyToBuilder(this.attributeSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributeSummaries(Collection<AttributeSummary.BuilderImpl> attributeSummaries) {
            this.attributeSummaries = AttributeSummaryListCopier.copyFromBuilder(attributeSummaries);
        }

        @Override
        public final Builder attributeSummaries(Collection<AttributeSummary> attributeSummaries) {
            this.attributeSummaries = AttributeSummaryListCopier.copy(attributeSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeSummaries(AttributeSummary... attributeSummaries) {
            attributeSummaries(Arrays.asList(attributeSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeSummaries(Consumer<AttributeSummary.Builder>... attributeSummaries) {
            attributeSummaries(Stream.of(attributeSummaries).map(c -> AttributeSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetDeclarativePoliciesReportSummaryResponse build() {
            return new GetDeclarativePoliciesReportSummaryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
