/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a summary of the attached EBS volume status for an instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EbsStatusSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<EbsStatusSummary.Builder, EbsStatusSummary> {
    private static final SdkField<List<EbsStatusDetails>> DETAILS_FIELD = SdkField
            .<List<EbsStatusDetails>> builder(MarshallingType.LIST)
            .memberName("Details")
            .getter(getter(EbsStatusSummary::details))
            .setter(setter(Builder::details))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Details")
                    .unmarshallLocationName("details").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<EbsStatusDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(EbsStatusDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Status")
            .getter(getter(EbsStatusSummary::statusAsString))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETAILS_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<EbsStatusDetails> details;

    private final String status;

    private EbsStatusSummary(BuilderImpl builder) {
        this.details = builder.details;
        this.status = builder.status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Details property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDetails() {
        return details != null && !(details instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details about the attached EBS status check for an instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDetails} method.
     * </p>
     * 
     * @return Details about the attached EBS status check for an instance.
     */
    public final List<EbsStatusDetails> details() {
        return details;
    }

    /**
     * <p>
     * The current status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SummaryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status.
     * @see SummaryStatus
     */
    public final SummaryStatus status() {
        return SummaryStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SummaryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status.
     * @see SummaryStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDetails() ? details() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EbsStatusSummary)) {
            return false;
        }
        EbsStatusSummary other = (EbsStatusSummary) obj;
        return hasDetails() == other.hasDetails() && Objects.equals(details(), other.details())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EbsStatusSummary").add("Details", hasDetails() ? details() : null)
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Details":
            return Optional.ofNullable(clazz.cast(details()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Details", DETAILS_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EbsStatusSummary, T> g) {
        return obj -> g.apply((EbsStatusSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EbsStatusSummary> {
        /**
         * <p>
         * Details about the attached EBS status check for an instance.
         * </p>
         * 
         * @param details
         *        Details about the attached EBS status check for an instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(Collection<EbsStatusDetails> details);

        /**
         * <p>
         * Details about the attached EBS status check for an instance.
         * </p>
         * 
         * @param details
         *        Details about the attached EBS status check for an instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(EbsStatusDetails... details);

        /**
         * <p>
         * Details about the attached EBS status check for an instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.EbsStatusDetails.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.EbsStatusDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.EbsStatusDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #details(List<EbsStatusDetails>)}.
         * 
         * @param details
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.EbsStatusDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #details(java.util.Collection<EbsStatusDetails>)
         */
        Builder details(Consumer<EbsStatusDetails.Builder>... details);

        /**
         * <p>
         * The current status.
         * </p>
         * 
         * @param status
         *        The current status.
         * @see SummaryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SummaryStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status.
         * </p>
         * 
         * @param status
         *        The current status.
         * @see SummaryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SummaryStatus
         */
        Builder status(SummaryStatus status);
    }

    static final class BuilderImpl implements Builder {
        private List<EbsStatusDetails> details = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(EbsStatusSummary model) {
            details(model.details);
            status(model.status);
        }

        public final List<EbsStatusDetails.Builder> getDetails() {
            List<EbsStatusDetails.Builder> result = EbsStatusDetailsListCopier.copyToBuilder(this.details);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDetails(Collection<EbsStatusDetails.BuilderImpl> details) {
            this.details = EbsStatusDetailsListCopier.copyFromBuilder(details);
        }

        @Override
        public final Builder details(Collection<EbsStatusDetails> details) {
            this.details = EbsStatusDetailsListCopier.copy(details);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder details(EbsStatusDetails... details) {
            details(Arrays.asList(details));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder details(Consumer<EbsStatusDetails.Builder>... details) {
            details(Stream.of(details).map(c -> EbsStatusDetails.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SummaryStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public EbsStatusSummary build() {
            return new EbsStatusSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
