/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateIamInstanceProfileResponse extends Ec2Response implements
        ToCopyableBuilder<DisassociateIamInstanceProfileResponse.Builder, DisassociateIamInstanceProfileResponse> {
    private static final SdkField<IamInstanceProfileAssociation> IAM_INSTANCE_PROFILE_ASSOCIATION_FIELD = SdkField
            .<IamInstanceProfileAssociation> builder(MarshallingType.SDK_POJO)
            .memberName("IamInstanceProfileAssociation")
            .getter(getter(DisassociateIamInstanceProfileResponse::iamInstanceProfileAssociation))
            .setter(setter(Builder::iamInstanceProfileAssociation))
            .constructor(IamInstanceProfileAssociation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamInstanceProfileAssociation")
                    .unmarshallLocationName("iamInstanceProfileAssociation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(IAM_INSTANCE_PROFILE_ASSOCIATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final IamInstanceProfileAssociation iamInstanceProfileAssociation;

    private DisassociateIamInstanceProfileResponse(BuilderImpl builder) {
        super(builder);
        this.iamInstanceProfileAssociation = builder.iamInstanceProfileAssociation;
    }

    /**
     * <p>
     * Information about the IAM instance profile association.
     * </p>
     * 
     * @return Information about the IAM instance profile association.
     */
    public final IamInstanceProfileAssociation iamInstanceProfileAssociation() {
        return iamInstanceProfileAssociation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(iamInstanceProfileAssociation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateIamInstanceProfileResponse)) {
            return false;
        }
        DisassociateIamInstanceProfileResponse other = (DisassociateIamInstanceProfileResponse) obj;
        return Objects.equals(iamInstanceProfileAssociation(), other.iamInstanceProfileAssociation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisassociateIamInstanceProfileResponse")
                .add("IamInstanceProfileAssociation", iamInstanceProfileAssociation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IamInstanceProfileAssociation":
            return Optional.ofNullable(clazz.cast(iamInstanceProfileAssociation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IamInstanceProfileAssociation", IAM_INSTANCE_PROFILE_ASSOCIATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisassociateIamInstanceProfileResponse, T> g) {
        return obj -> g.apply((DisassociateIamInstanceProfileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DisassociateIamInstanceProfileResponse> {
        /**
         * <p>
         * Information about the IAM instance profile association.
         * </p>
         * 
         * @param iamInstanceProfileAssociation
         *        Information about the IAM instance profile association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamInstanceProfileAssociation(IamInstanceProfileAssociation iamInstanceProfileAssociation);

        /**
         * <p>
         * Information about the IAM instance profile association.
         * </p>
         * This is a convenience method that creates an instance of the {@link IamInstanceProfileAssociation.Builder}
         * avoiding the need to create one manually via {@link IamInstanceProfileAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IamInstanceProfileAssociation.Builder#build()} is called
         * immediately and its result is passed to {@link #iamInstanceProfileAssociation(IamInstanceProfileAssociation)}.
         * 
         * @param iamInstanceProfileAssociation
         *        a consumer that will call methods on {@link IamInstanceProfileAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamInstanceProfileAssociation(IamInstanceProfileAssociation)
         */
        default Builder iamInstanceProfileAssociation(
                Consumer<IamInstanceProfileAssociation.Builder> iamInstanceProfileAssociation) {
            return iamInstanceProfileAssociation(IamInstanceProfileAssociation.builder()
                    .applyMutation(iamInstanceProfileAssociation).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private IamInstanceProfileAssociation iamInstanceProfileAssociation;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateIamInstanceProfileResponse model) {
            super(model);
            iamInstanceProfileAssociation(model.iamInstanceProfileAssociation);
        }

        public final IamInstanceProfileAssociation.Builder getIamInstanceProfileAssociation() {
            return iamInstanceProfileAssociation != null ? iamInstanceProfileAssociation.toBuilder() : null;
        }

        public final void setIamInstanceProfileAssociation(IamInstanceProfileAssociation.BuilderImpl iamInstanceProfileAssociation) {
            this.iamInstanceProfileAssociation = iamInstanceProfileAssociation != null ? iamInstanceProfileAssociation.build()
                    : null;
        }

        @Override
        public final Builder iamInstanceProfileAssociation(IamInstanceProfileAssociation iamInstanceProfileAssociation) {
            this.iamInstanceProfileAssociation = iamInstanceProfileAssociation;
            return this;
        }

        @Override
        public DisassociateIamInstanceProfileResponse build() {
            return new DisassociateIamInstanceProfileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
