/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeVerifiedAccessEndpointsRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeVerifiedAccessEndpointsRequest.Builder, DescribeVerifiedAccessEndpointsRequest> {
    private static final SdkField<List<String>> VERIFIED_ACCESS_ENDPOINT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VerifiedAccessEndpointIds")
            .getter(getter(DescribeVerifiedAccessEndpointsRequest::verifiedAccessEndpointIds))
            .setter(setter(Builder::verifiedAccessEndpointIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessEndpointId")
                    .unmarshallLocationName("VerifiedAccessEndpointId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> VERIFIED_ACCESS_INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VerifiedAccessInstanceId")
            .getter(getter(DescribeVerifiedAccessEndpointsRequest::verifiedAccessInstanceId))
            .setter(setter(Builder::verifiedAccessInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessInstanceId")
                    .unmarshallLocationName("VerifiedAccessInstanceId").build()).build();

    private static final SdkField<String> VERIFIED_ACCESS_GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VerifiedAccessGroupId")
            .getter(getter(DescribeVerifiedAccessEndpointsRequest::verifiedAccessGroupId))
            .setter(setter(Builder::verifiedAccessGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessGroupId")
                    .unmarshallLocationName("VerifiedAccessGroupId").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults")
            .getter(getter(DescribeVerifiedAccessEndpointsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeVerifiedAccessEndpointsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeVerifiedAccessEndpointsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(DescribeVerifiedAccessEndpointsRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VERIFIED_ACCESS_ENDPOINT_IDS_FIELD, VERIFIED_ACCESS_INSTANCE_ID_FIELD, VERIFIED_ACCESS_GROUP_ID_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, FILTERS_FIELD, DRY_RUN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> verifiedAccessEndpointIds;

    private final String verifiedAccessInstanceId;

    private final String verifiedAccessGroupId;

    private final Integer maxResults;

    private final String nextToken;

    private final List<Filter> filters;

    private final Boolean dryRun;

    private DescribeVerifiedAccessEndpointsRequest(BuilderImpl builder) {
        super(builder);
        this.verifiedAccessEndpointIds = builder.verifiedAccessEndpointIds;
        this.verifiedAccessInstanceId = builder.verifiedAccessInstanceId;
        this.verifiedAccessGroupId = builder.verifiedAccessGroupId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.filters = builder.filters;
        this.dryRun = builder.dryRun;
    }

    /**
     * For responses, this returns true if the service returned a value for the VerifiedAccessEndpointIds property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasVerifiedAccessEndpointIds() {
        return verifiedAccessEndpointIds != null && !(verifiedAccessEndpointIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ID of the Verified Access endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVerifiedAccessEndpointIds} method.
     * </p>
     * 
     * @return The ID of the Verified Access endpoint.
     */
    public final List<String> verifiedAccessEndpointIds() {
        return verifiedAccessEndpointIds;
    }

    /**
     * <p>
     * The ID of the Verified Access instance.
     * </p>
     * 
     * @return The ID of the Verified Access instance.
     */
    public final String verifiedAccessInstanceId() {
        return verifiedAccessInstanceId;
    }

    /**
     * <p>
     * The ID of the Verified Access group.
     * </p>
     * 
     * @return The ID of the Verified Access group.
     */
    public final String verifiedAccessGroupId() {
        return verifiedAccessGroupId;
    }

    /**
     * <p>
     * The maximum number of results to return with a single call. To retrieve the remaining results, make another call
     * with the returned <code>nextToken</code> value.
     * </p>
     * 
     * @return The maximum number of results to return with a single call. To retrieve the remaining results, make
     *         another call with the returned <code>nextToken</code> value.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next page of results.
     * </p>
     * 
     * @return The token for the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more filters. Filter names and values are case-sensitive.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return One or more filters. Filter names and values are case-sensitive.
     */
    public final List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasVerifiedAccessEndpointIds() ? verifiedAccessEndpointIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(verifiedAccessInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(verifiedAccessGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVerifiedAccessEndpointsRequest)) {
            return false;
        }
        DescribeVerifiedAccessEndpointsRequest other = (DescribeVerifiedAccessEndpointsRequest) obj;
        return hasVerifiedAccessEndpointIds() == other.hasVerifiedAccessEndpointIds()
                && Objects.equals(verifiedAccessEndpointIds(), other.verifiedAccessEndpointIds())
                && Objects.equals(verifiedAccessInstanceId(), other.verifiedAccessInstanceId())
                && Objects.equals(verifiedAccessGroupId(), other.verifiedAccessGroupId())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeVerifiedAccessEndpointsRequest")
                .add("VerifiedAccessEndpointIds", hasVerifiedAccessEndpointIds() ? verifiedAccessEndpointIds() : null)
                .add("VerifiedAccessInstanceId", verifiedAccessInstanceId())
                .add("VerifiedAccessGroupId", verifiedAccessGroupId()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("Filters", hasFilters() ? filters() : null).add("DryRun", dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VerifiedAccessEndpointIds":
            return Optional.ofNullable(clazz.cast(verifiedAccessEndpointIds()));
        case "VerifiedAccessInstanceId":
            return Optional.ofNullable(clazz.cast(verifiedAccessInstanceId()));
        case "VerifiedAccessGroupId":
            return Optional.ofNullable(clazz.cast(verifiedAccessGroupId()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VerifiedAccessEndpointId", VERIFIED_ACCESS_ENDPOINT_IDS_FIELD);
        map.put("VerifiedAccessInstanceId", VERIFIED_ACCESS_INSTANCE_ID_FIELD);
        map.put("VerifiedAccessGroupId", VERIFIED_ACCESS_GROUP_ID_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Filter", FILTERS_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeVerifiedAccessEndpointsRequest, T> g) {
        return obj -> g.apply((DescribeVerifiedAccessEndpointsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeVerifiedAccessEndpointsRequest> {
        /**
         * <p>
         * The ID of the Verified Access endpoint.
         * </p>
         * 
         * @param verifiedAccessEndpointIds
         *        The ID of the Verified Access endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedAccessEndpointIds(Collection<String> verifiedAccessEndpointIds);

        /**
         * <p>
         * The ID of the Verified Access endpoint.
         * </p>
         * 
         * @param verifiedAccessEndpointIds
         *        The ID of the Verified Access endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedAccessEndpointIds(String... verifiedAccessEndpointIds);

        /**
         * <p>
         * The ID of the Verified Access instance.
         * </p>
         * 
         * @param verifiedAccessInstanceId
         *        The ID of the Verified Access instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedAccessInstanceId(String verifiedAccessInstanceId);

        /**
         * <p>
         * The ID of the Verified Access group.
         * </p>
         * 
         * @param verifiedAccessGroupId
         *        The ID of the Verified Access group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedAccessGroupId(String verifiedAccessGroupId);

        /**
         * <p>
         * The maximum number of results to return with a single call. To retrieve the remaining results, make another
         * call with the returned <code>nextToken</code> value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return with a single call. To retrieve the remaining results, make
         *        another call with the returned <code>nextToken</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * One or more filters. Filter names and values are case-sensitive.
         * </p>
         * 
         * @param filters
         *        One or more filters. Filter names and values are case-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters. Filter names and values are case-sensitive.
         * </p>
         * 
         * @param filters
         *        One or more filters. Filter names and values are case-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * One or more filters. Filter names and values are case-sensitive.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Filter.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Filter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Filter.Builder#build()}
         * is called immediately and its result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<String> verifiedAccessEndpointIds = DefaultSdkAutoConstructList.getInstance();

        private String verifiedAccessInstanceId;

        private String verifiedAccessGroupId;

        private Integer maxResults;

        private String nextToken;

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVerifiedAccessEndpointsRequest model) {
            super(model);
            verifiedAccessEndpointIds(model.verifiedAccessEndpointIds);
            verifiedAccessInstanceId(model.verifiedAccessInstanceId);
            verifiedAccessGroupId(model.verifiedAccessGroupId);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            filters(model.filters);
            dryRun(model.dryRun);
        }

        public final Collection<String> getVerifiedAccessEndpointIds() {
            if (verifiedAccessEndpointIds instanceof SdkAutoConstructList) {
                return null;
            }
            return verifiedAccessEndpointIds;
        }

        public final void setVerifiedAccessEndpointIds(Collection<String> verifiedAccessEndpointIds) {
            this.verifiedAccessEndpointIds = VerifiedAccessEndpointIdListCopier.copy(verifiedAccessEndpointIds);
        }

        @Override
        public final Builder verifiedAccessEndpointIds(Collection<String> verifiedAccessEndpointIds) {
            this.verifiedAccessEndpointIds = VerifiedAccessEndpointIdListCopier.copy(verifiedAccessEndpointIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder verifiedAccessEndpointIds(String... verifiedAccessEndpointIds) {
            verifiedAccessEndpointIds(Arrays.asList(verifiedAccessEndpointIds));
            return this;
        }

        public final String getVerifiedAccessInstanceId() {
            return verifiedAccessInstanceId;
        }

        public final void setVerifiedAccessInstanceId(String verifiedAccessInstanceId) {
            this.verifiedAccessInstanceId = verifiedAccessInstanceId;
        }

        @Override
        public final Builder verifiedAccessInstanceId(String verifiedAccessInstanceId) {
            this.verifiedAccessInstanceId = verifiedAccessInstanceId;
            return this;
        }

        public final String getVerifiedAccessGroupId() {
            return verifiedAccessGroupId;
        }

        public final void setVerifiedAccessGroupId(String verifiedAccessGroupId) {
            this.verifiedAccessGroupId = verifiedAccessGroupId;
        }

        @Override
        public final Builder verifiedAccessGroupId(String verifiedAccessGroupId) {
            this.verifiedAccessGroupId = verifiedAccessGroupId;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeVerifiedAccessEndpointsRequest build() {
            return new DescribeVerifiedAccessEndpointsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
