/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVolumeRequest extends Ec2Request implements
        ToCopyableBuilder<CreateVolumeRequest.Builder, CreateVolumeRequest> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone")
            .getter(getter(CreateVolumeRequest::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone")
                    .unmarshallLocationName("AvailabilityZone").build()).build();

    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Encrypted")
            .getter(getter(CreateVolumeRequest::encrypted))
            .setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted")
                    .unmarshallLocationName("encrypted").build()).build();

    private static final SdkField<Integer> IOPS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Iops")
            .getter(getter(CreateVolumeRequest::iops))
            .setter(setter(Builder::iops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops")
                    .unmarshallLocationName("Iops").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId")
            .getter(getter(CreateVolumeRequest::kmsKeyId))
            .setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId")
                    .unmarshallLocationName("KmsKeyId").build()).build();

    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OutpostArn")
            .getter(getter(CreateVolumeRequest::outpostArn))
            .setter(setter(Builder::outpostArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn")
                    .unmarshallLocationName("OutpostArn").build()).build();

    private static final SdkField<Integer> SIZE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Size")
            .getter(getter(CreateVolumeRequest::size))
            .setter(setter(Builder::size))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size")
                    .unmarshallLocationName("Size").build()).build();

    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SnapshotId")
            .getter(getter(CreateVolumeRequest::snapshotId))
            .setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId")
                    .unmarshallLocationName("SnapshotId").build()).build();

    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VolumeType")
            .getter(getter(CreateVolumeRequest::volumeTypeAsString))
            .setter(setter(Builder::volumeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeType")
                    .unmarshallLocationName("VolumeType").build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(CreateVolumeRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> MULTI_ATTACH_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MultiAttachEnabled")
            .getter(getter(CreateVolumeRequest::multiAttachEnabled))
            .setter(setter(Builder::multiAttachEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAttachEnabled")
                    .unmarshallLocationName("MultiAttachEnabled").build()).build();

    private static final SdkField<Integer> THROUGHPUT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Throughput")
            .getter(getter(CreateVolumeRequest::throughput))
            .setter(setter(Builder::throughput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Throughput")
                    .unmarshallLocationName("Throughput").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateVolumeRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<OperatorRequest> OPERATOR_FIELD = SdkField
            .<OperatorRequest> builder(MarshallingType.SDK_POJO)
            .memberName("Operator")
            .getter(getter(CreateVolumeRequest::operator))
            .setter(setter(Builder::operator))
            .constructor(OperatorRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator")
                    .unmarshallLocationName("Operator").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(CreateVolumeRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("dryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD,
            ENCRYPTED_FIELD, IOPS_FIELD, KMS_KEY_ID_FIELD, OUTPOST_ARN_FIELD, SIZE_FIELD, SNAPSHOT_ID_FIELD, VOLUME_TYPE_FIELD,
            TAG_SPECIFICATIONS_FIELD, MULTI_ATTACH_ENABLED_FIELD, THROUGHPUT_FIELD, CLIENT_TOKEN_FIELD, OPERATOR_FIELD,
            DRY_RUN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String availabilityZone;

    private final Boolean encrypted;

    private final Integer iops;

    private final String kmsKeyId;

    private final String outpostArn;

    private final Integer size;

    private final String snapshotId;

    private final String volumeType;

    private final List<TagSpecification> tagSpecifications;

    private final Boolean multiAttachEnabled;

    private final Integer throughput;

    private final String clientToken;

    private final OperatorRequest operator;

    private final Boolean dryRun;

    private CreateVolumeRequest(BuilderImpl builder) {
        super(builder);
        this.availabilityZone = builder.availabilityZone;
        this.encrypted = builder.encrypted;
        this.iops = builder.iops;
        this.kmsKeyId = builder.kmsKeyId;
        this.outpostArn = builder.outpostArn;
        this.size = builder.size;
        this.snapshotId = builder.snapshotId;
        this.volumeType = builder.volumeType;
        this.tagSpecifications = builder.tagSpecifications;
        this.multiAttachEnabled = builder.multiAttachEnabled;
        this.throughput = builder.throughput;
        this.clientToken = builder.clientToken;
        this.operator = builder.operator;
        this.dryRun = builder.dryRun;
    }

    /**
     * <p>
     * The ID of the Availability Zone in which to create the volume. For example, <code>us-east-1a</code>.
     * </p>
     * 
     * @return The ID of the Availability Zone in which to create the volume. For example, <code>us-east-1a</code>.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * Indicates whether the volume should be encrypted. The effect of setting the encryption state to <code>true</code>
     * depends on the volume origin (new or from a snapshot), starting encryption state, ownership, and whether
     * encryption by default is enabled. For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/work-with-ebs-encr.html#encryption-by-default">Encryption
     * by default</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     * <p>
     * Encrypted Amazon EBS volumes must be attached to instances that support Amazon EBS encryption. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption-requirements.html#ebs-encryption_supported_instances"
     * >Supported instance types</a>.
     * </p>
     * 
     * @return Indicates whether the volume should be encrypted. The effect of setting the encryption state to
     *         <code>true</code> depends on the volume origin (new or from a snapshot), starting encryption state,
     *         ownership, and whether encryption by default is enabled. For more information, see <a
     *         href="https://docs.aws.amazon.com/ebs/latest/userguide/work-with-ebs-encr.html#encryption-by-default"
     *         >Encryption by default</a> in the <i>Amazon EBS User Guide</i>.</p>
     *         <p>
     *         Encrypted Amazon EBS volumes must be attached to instances that support Amazon EBS encryption. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption-requirements.html#ebs-encryption_supported_instances"
     *         >Supported instance types</a>.
     */
    public final Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * The number of I/O operations per second (IOPS). For <code>gp3</code>, <code>io1</code>, and <code>io2</code>
     * volumes, this represents the number of IOPS that are provisioned for the volume. For <code>gp2</code> volumes,
     * this represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits
     * for bursting.
     * </p>
     * <p>
     * The following are the supported values for each volume type:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>gp3</code>: 3,000 - 16,000 IOPS
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>io1</code>: 100 - 64,000 IOPS
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>io2</code>: 100 - 256,000 IOPS
     * </p>
     * </li>
     * </ul>
     * <p>
     * For <code>io2</code> volumes, you can achieve up to 256,000 IOPS on <a
     * href="https://docs.aws.amazon.com/ec2/latest/instancetypes/ec2-nitro-instances.html">instances built on the Nitro
     * System</a>. On other instances, you can achieve performance up to 32,000 IOPS.
     * </p>
     * <p>
     * This parameter is required for <code>io1</code> and <code>io2</code> volumes. The default for <code>gp3</code>
     * volumes is 3,000 IOPS. This parameter is not supported for <code>gp2</code>, <code>st1</code>, <code>sc1</code>,
     * or <code>standard</code> volumes.
     * </p>
     * 
     * @return The number of I/O operations per second (IOPS). For <code>gp3</code>, <code>io1</code>, and
     *         <code>io2</code> volumes, this represents the number of IOPS that are provisioned for the volume. For
     *         <code>gp2</code> volumes, this represents the baseline performance of the volume and the rate at which
     *         the volume accumulates I/O credits for bursting.</p>
     *         <p>
     *         The following are the supported values for each volume type:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>gp3</code>: 3,000 - 16,000 IOPS
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>io1</code>: 100 - 64,000 IOPS
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>io2</code>: 100 - 256,000 IOPS
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <code>io2</code> volumes, you can achieve up to 256,000 IOPS on <a
     *         href="https://docs.aws.amazon.com/ec2/latest/instancetypes/ec2-nitro-instances.html">instances built on
     *         the Nitro System</a>. On other instances, you can achieve performance up to 32,000 IOPS.
     *         </p>
     *         <p>
     *         This parameter is required for <code>io1</code> and <code>io2</code> volumes. The default for
     *         <code>gp3</code> volumes is 3,000 IOPS. This parameter is not supported for <code>gp2</code>,
     *         <code>st1</code>, <code>sc1</code>, or <code>standard</code> volumes.
     */
    public final Integer iops() {
        return iops;
    }

    /**
     * <p>
     * The identifier of the KMS key to use for Amazon EBS encryption. If this parameter is not specified, your KMS key
     * for Amazon EBS is used. If <code>KmsKeyId</code> is specified, the encrypted state must be <code>true</code>.
     * </p>
     * <p>
     * You can specify the KMS key using any of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.
     * </p>
     * </li>
     * <li>
     * <p>
     * Key alias. For example, alias/ExampleAlias.
     * </p>
     * </li>
     * <li>
     * <p>
     * Key ARN. For example, arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.
     * </p>
     * </li>
     * <li>
     * <p>
     * Alias ARN. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Amazon Web Services authenticates the KMS key asynchronously. Therefore, if you specify an ID, alias, or ARN that
     * is not valid, the action can appear to complete, but eventually fails.
     * </p>
     * 
     * @return The identifier of the KMS key to use for Amazon EBS encryption. If this parameter is not specified, your
     *         KMS key for Amazon EBS is used. If <code>KmsKeyId</code> is specified, the encrypted state must be
     *         <code>true</code>.</p>
     *         <p>
     *         You can specify the KMS key using any of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Key alias. For example, alias/ExampleAlias.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Key ARN. For example, arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Alias ARN. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Amazon Web Services authenticates the KMS key asynchronously. Therefore, if you specify an ID, alias, or
     *         ARN that is not valid, the action can appear to complete, but eventually fails.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Outpost on which to create the volume.
     * </p>
     * <p>
     * If you intend to use a volume with an instance running on an outpost, then you must create the volume on the same
     * outpost as the instance. You can't use a volume created in an Amazon Web Services Region with an instance on an
     * Amazon Web Services outpost, or the other way around.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Outpost on which to create the volume.</p>
     *         <p>
     *         If you intend to use a volume with an instance running on an outpost, then you must create the volume on
     *         the same outpost as the instance. You can't use a volume created in an Amazon Web Services Region with an
     *         instance on an Amazon Web Services outpost, or the other way around.
     */
    public final String outpostArn() {
        return outpostArn;
    }

    /**
     * <p>
     * The size of the volume, in GiBs. You must specify either a snapshot ID or a volume size. If you specify a
     * snapshot, the default is the snapshot size. You can specify a volume size that is equal to or larger than the
     * snapshot size.
     * </p>
     * <p>
     * The following are the supported volumes sizes for each volume type:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>gp2</code> and <code>gp3</code>: 1 - 16,384 GiB
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>io1</code>: 4 - 16,384 GiB
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>io2</code>: 4 - 65,536 GiB
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>st1</code> and <code>sc1</code>: 125 - 16,384 GiB
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>standard</code>: 1 - 1024 GiB
     * </p>
     * </li>
     * </ul>
     * 
     * @return The size of the volume, in GiBs. You must specify either a snapshot ID or a volume size. If you specify a
     *         snapshot, the default is the snapshot size. You can specify a volume size that is equal to or larger than
     *         the snapshot size.</p>
     *         <p>
     *         The following are the supported volumes sizes for each volume type:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>gp2</code> and <code>gp3</code>: 1 - 16,384 GiB
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>io1</code>: 4 - 16,384 GiB
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>io2</code>: 4 - 65,536 GiB
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>st1</code> and <code>sc1</code>: 125 - 16,384 GiB
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>standard</code>: 1 - 1024 GiB
     *         </p>
     *         </li>
     */
    public final Integer size() {
        return size;
    }

    /**
     * <p>
     * The snapshot from which to create the volume. You must specify either a snapshot ID or a volume size.
     * </p>
     * 
     * @return The snapshot from which to create the volume. You must specify either a snapshot ID or a volume size.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * The volume type. This parameter can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * General Purpose SSD: <code>gp2</code> | <code>gp3</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Provisioned IOPS SSD: <code>io1</code> | <code>io2</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Throughput Optimized HDD: <code>st1</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Cold HDD: <code>sc1</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Magnetic: <code>standard</code>
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * Throughput Optimized HDD (<code>st1</code>) and Cold HDD (<code>sc1</code>) volumes can't be used as boot
     * volumes.
     * </p>
     * </important>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volume-types.html">Amazon
     * EBS volume types</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     * <p>
     * Default: <code>gp2</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #volumeType} will
     * return {@link VolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #volumeTypeAsString}.
     * </p>
     * 
     * @return The volume type. This parameter can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         General Purpose SSD: <code>gp2</code> | <code>gp3</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Provisioned IOPS SSD: <code>io1</code> | <code>io2</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Throughput Optimized HDD: <code>st1</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cold HDD: <code>sc1</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Magnetic: <code>standard</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <important>
     *         <p>
     *         Throughput Optimized HDD (<code>st1</code>) and Cold HDD (<code>sc1</code>) volumes can't be used as boot
     *         volumes.
     *         </p>
     *         </important>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volume-types.html">Amazon EBS volume types</a>
     *         in the <i>Amazon EBS User Guide</i>.
     *         </p>
     *         <p>
     *         Default: <code>gp2</code>
     * @see VolumeType
     */
    public final VolumeType volumeType() {
        return VolumeType.fromValue(volumeType);
    }

    /**
     * <p>
     * The volume type. This parameter can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * General Purpose SSD: <code>gp2</code> | <code>gp3</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Provisioned IOPS SSD: <code>io1</code> | <code>io2</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Throughput Optimized HDD: <code>st1</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Cold HDD: <code>sc1</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Magnetic: <code>standard</code>
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * Throughput Optimized HDD (<code>st1</code>) and Cold HDD (<code>sc1</code>) volumes can't be used as boot
     * volumes.
     * </p>
     * </important>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volume-types.html">Amazon
     * EBS volume types</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     * <p>
     * Default: <code>gp2</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #volumeType} will
     * return {@link VolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #volumeTypeAsString}.
     * </p>
     * 
     * @return The volume type. This parameter can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         General Purpose SSD: <code>gp2</code> | <code>gp3</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Provisioned IOPS SSD: <code>io1</code> | <code>io2</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Throughput Optimized HDD: <code>st1</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cold HDD: <code>sc1</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Magnetic: <code>standard</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <important>
     *         <p>
     *         Throughput Optimized HDD (<code>st1</code>) and Cold HDD (<code>sc1</code>) volumes can't be used as boot
     *         volumes.
     *         </p>
     *         </important>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volume-types.html">Amazon EBS volume types</a>
     *         in the <i>Amazon EBS User Guide</i>.
     *         </p>
     *         <p>
     *         Default: <code>gp2</code>
     * @see VolumeType
     */
    public final String volumeTypeAsString() {
        return volumeType;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagSpecifications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to apply to the volume during creation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagSpecifications} method.
     * </p>
     * 
     * @return The tags to apply to the volume during creation.
     */
    public final List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    /**
     * <p>
     * Indicates whether to enable Amazon EBS Multi-Attach. If you enable Multi-Attach, you can attach the volume to up
     * to 16 <a href="https://docs.aws.amazon.com/ec2/latest/instancetypes/ec2-nitro-instances.html">Instances built on
     * the Nitro System</a> in the same Availability Zone. This parameter is supported with <code>io1</code> and
     * <code>io2</code> volumes only. For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volumes-multi.html"> Amazon EBS Multi-Attach</a> in
     * the <i>Amazon EBS User Guide</i>.
     * </p>
     * 
     * @return Indicates whether to enable Amazon EBS Multi-Attach. If you enable Multi-Attach, you can attach the
     *         volume to up to 16 <a
     *         href="https://docs.aws.amazon.com/ec2/latest/instancetypes/ec2-nitro-instances.html">Instances built on
     *         the Nitro System</a> in the same Availability Zone. This parameter is supported with <code>io1</code> and
     *         <code>io2</code> volumes only. For more information, see <a
     *         href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volumes-multi.html"> Amazon EBS
     *         Multi-Attach</a> in the <i>Amazon EBS User Guide</i>.
     */
    public final Boolean multiAttachEnabled() {
        return multiAttachEnabled;
    }

    /**
     * <p>
     * The throughput to provision for a volume, with a maximum of 1,000 MiB/s.
     * </p>
     * <p>
     * This parameter is valid only for <code>gp3</code> volumes.
     * </p>
     * <p>
     * Valid Range: Minimum value of 125. Maximum value of 1000.
     * </p>
     * 
     * @return The throughput to provision for a volume, with a maximum of 1,000 MiB/s.</p>
     *         <p>
     *         This parameter is valid only for <code>gp3</code> volumes.
     *         </p>
     *         <p>
     *         Valid Range: Minimum value of 125. Maximum value of 1000.
     */
    public final Integer throughput() {
        return throughput;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensure
     * Idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensure Idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Reserved for internal use.
     * </p>
     * 
     * @return Reserved for internal use.
     */
    public final OperatorRequest operator() {
        return operator;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(outpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(size());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(volumeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSpecifications() ? tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(multiAttachEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(throughput());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(operator());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVolumeRequest)) {
            return false;
        }
        CreateVolumeRequest other = (CreateVolumeRequest) obj;
        return Objects.equals(availabilityZone(), other.availabilityZone()) && Objects.equals(encrypted(), other.encrypted())
                && Objects.equals(iops(), other.iops()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(outpostArn(), other.outpostArn()) && Objects.equals(size(), other.size())
                && Objects.equals(snapshotId(), other.snapshotId())
                && Objects.equals(volumeTypeAsString(), other.volumeTypeAsString())
                && hasTagSpecifications() == other.hasTagSpecifications()
                && Objects.equals(tagSpecifications(), other.tagSpecifications())
                && Objects.equals(multiAttachEnabled(), other.multiAttachEnabled())
                && Objects.equals(throughput(), other.throughput()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(operator(), other.operator()) && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateVolumeRequest").add("AvailabilityZone", availabilityZone()).add("Encrypted", encrypted())
                .add("Iops", iops()).add("KmsKeyId", kmsKeyId()).add("OutpostArn", outpostArn()).add("Size", size())
                .add("SnapshotId", snapshotId()).add("VolumeType", volumeTypeAsString())
                .add("TagSpecifications", hasTagSpecifications() ? tagSpecifications() : null)
                .add("MultiAttachEnabled", multiAttachEnabled()).add("Throughput", throughput())
                .add("ClientToken", clientToken()).add("Operator", operator()).add("DryRun", dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "Encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        case "Iops":
            return Optional.ofNullable(clazz.cast(iops()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "OutpostArn":
            return Optional.ofNullable(clazz.cast(outpostArn()));
        case "Size":
            return Optional.ofNullable(clazz.cast(size()));
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "VolumeType":
            return Optional.ofNullable(clazz.cast(volumeTypeAsString()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        case "MultiAttachEnabled":
            return Optional.ofNullable(clazz.cast(multiAttachEnabled()));
        case "Throughput":
            return Optional.ofNullable(clazz.cast(throughput()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Operator":
            return Optional.ofNullable(clazz.cast(operator()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("Encrypted", ENCRYPTED_FIELD);
        map.put("Iops", IOPS_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("OutpostArn", OUTPOST_ARN_FIELD);
        map.put("Size", SIZE_FIELD);
        map.put("SnapshotId", SNAPSHOT_ID_FIELD);
        map.put("VolumeType", VOLUME_TYPE_FIELD);
        map.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
        map.put("MultiAttachEnabled", MULTI_ATTACH_ENABLED_FIELD);
        map.put("Throughput", THROUGHPUT_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Operator", OPERATOR_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateVolumeRequest, T> g) {
        return obj -> g.apply((CreateVolumeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateVolumeRequest> {
        /**
         * <p>
         * The ID of the Availability Zone in which to create the volume. For example, <code>us-east-1a</code>.
         * </p>
         * 
         * @param availabilityZone
         *        The ID of the Availability Zone in which to create the volume. For example, <code>us-east-1a</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * Indicates whether the volume should be encrypted. The effect of setting the encryption state to
         * <code>true</code> depends on the volume origin (new or from a snapshot), starting encryption state,
         * ownership, and whether encryption by default is enabled. For more information, see <a
         * href="https://docs.aws.amazon.com/ebs/latest/userguide/work-with-ebs-encr.html#encryption-by-default"
         * >Encryption by default</a> in the <i>Amazon EBS User Guide</i>.
         * </p>
         * <p>
         * Encrypted Amazon EBS volumes must be attached to instances that support Amazon EBS encryption. For more
         * information, see <a href=
         * "https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption-requirements.html#ebs-encryption_supported_instances"
         * >Supported instance types</a>.
         * </p>
         * 
         * @param encrypted
         *        Indicates whether the volume should be encrypted. The effect of setting the encryption state to
         *        <code>true</code> depends on the volume origin (new or from a snapshot), starting encryption state,
         *        ownership, and whether encryption by default is enabled. For more information, see <a href=
         *        "https://docs.aws.amazon.com/ebs/latest/userguide/work-with-ebs-encr.html#encryption-by-default"
         *        >Encryption by default</a> in the <i>Amazon EBS User Guide</i>.</p>
         *        <p>
         *        Encrypted Amazon EBS volumes must be attached to instances that support Amazon EBS encryption. For
         *        more information, see <a href=
         *        "https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption-requirements.html#ebs-encryption_supported_instances"
         *        >Supported instance types</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * The number of I/O operations per second (IOPS). For <code>gp3</code>, <code>io1</code>, and <code>io2</code>
         * volumes, this represents the number of IOPS that are provisioned for the volume. For <code>gp2</code>
         * volumes, this represents the baseline performance of the volume and the rate at which the volume accumulates
         * I/O credits for bursting.
         * </p>
         * <p>
         * The following are the supported values for each volume type:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>gp3</code>: 3,000 - 16,000 IOPS
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>io1</code>: 100 - 64,000 IOPS
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>io2</code>: 100 - 256,000 IOPS
         * </p>
         * </li>
         * </ul>
         * <p>
         * For <code>io2</code> volumes, you can achieve up to 256,000 IOPS on <a
         * href="https://docs.aws.amazon.com/ec2/latest/instancetypes/ec2-nitro-instances.html">instances built on the
         * Nitro System</a>. On other instances, you can achieve performance up to 32,000 IOPS.
         * </p>
         * <p>
         * This parameter is required for <code>io1</code> and <code>io2</code> volumes. The default for
         * <code>gp3</code> volumes is 3,000 IOPS. This parameter is not supported for <code>gp2</code>,
         * <code>st1</code>, <code>sc1</code>, or <code>standard</code> volumes.
         * </p>
         * 
         * @param iops
         *        The number of I/O operations per second (IOPS). For <code>gp3</code>, <code>io1</code>, and
         *        <code>io2</code> volumes, this represents the number of IOPS that are provisioned for the volume. For
         *        <code>gp2</code> volumes, this represents the baseline performance of the volume and the rate at which
         *        the volume accumulates I/O credits for bursting.</p>
         *        <p>
         *        The following are the supported values for each volume type:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>gp3</code>: 3,000 - 16,000 IOPS
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>io1</code>: 100 - 64,000 IOPS
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>io2</code>: 100 - 256,000 IOPS
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For <code>io2</code> volumes, you can achieve up to 256,000 IOPS on <a
         *        href="https://docs.aws.amazon.com/ec2/latest/instancetypes/ec2-nitro-instances.html">instances built
         *        on the Nitro System</a>. On other instances, you can achieve performance up to 32,000 IOPS.
         *        </p>
         *        <p>
         *        This parameter is required for <code>io1</code> and <code>io2</code> volumes. The default for
         *        <code>gp3</code> volumes is 3,000 IOPS. This parameter is not supported for <code>gp2</code>,
         *        <code>st1</code>, <code>sc1</code>, or <code>standard</code> volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);

        /**
         * <p>
         * The identifier of the KMS key to use for Amazon EBS encryption. If this parameter is not specified, your KMS
         * key for Amazon EBS is used. If <code>KmsKeyId</code> is specified, the encrypted state must be
         * <code>true</code>.
         * </p>
         * <p>
         * You can specify the KMS key using any of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.
         * </p>
         * </li>
         * <li>
         * <p>
         * Key alias. For example, alias/ExampleAlias.
         * </p>
         * </li>
         * <li>
         * <p>
         * Key ARN. For example, arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.
         * </p>
         * </li>
         * <li>
         * <p>
         * Alias ARN. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Amazon Web Services authenticates the KMS key asynchronously. Therefore, if you specify an ID, alias, or ARN
         * that is not valid, the action can appear to complete, but eventually fails.
         * </p>
         * 
         * @param kmsKeyId
         *        The identifier of the KMS key to use for Amazon EBS encryption. If this parameter is not specified,
         *        your KMS key for Amazon EBS is used. If <code>KmsKeyId</code> is specified, the encrypted state must
         *        be <code>true</code>.</p>
         *        <p>
         *        You can specify the KMS key using any of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key alias. For example, alias/ExampleAlias.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key ARN. For example, arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Alias ARN. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Amazon Web Services authenticates the KMS key asynchronously. Therefore, if you specify an ID, alias,
         *        or ARN that is not valid, the action can appear to complete, but eventually fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Outpost on which to create the volume.
         * </p>
         * <p>
         * If you intend to use a volume with an instance running on an outpost, then you must create the volume on the
         * same outpost as the instance. You can't use a volume created in an Amazon Web Services Region with an
         * instance on an Amazon Web Services outpost, or the other way around.
         * </p>
         * 
         * @param outpostArn
         *        The Amazon Resource Name (ARN) of the Outpost on which to create the volume.</p>
         *        <p>
         *        If you intend to use a volume with an instance running on an outpost, then you must create the volume
         *        on the same outpost as the instance. You can't use a volume created in an Amazon Web Services Region
         *        with an instance on an Amazon Web Services outpost, or the other way around.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostArn(String outpostArn);

        /**
         * <p>
         * The size of the volume, in GiBs. You must specify either a snapshot ID or a volume size. If you specify a
         * snapshot, the default is the snapshot size. You can specify a volume size that is equal to or larger than the
         * snapshot size.
         * </p>
         * <p>
         * The following are the supported volumes sizes for each volume type:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>gp2</code> and <code>gp3</code>: 1 - 16,384 GiB
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>io1</code>: 4 - 16,384 GiB
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>io2</code>: 4 - 65,536 GiB
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>st1</code> and <code>sc1</code>: 125 - 16,384 GiB
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>standard</code>: 1 - 1024 GiB
         * </p>
         * </li>
         * </ul>
         * 
         * @param size
         *        The size of the volume, in GiBs. You must specify either a snapshot ID or a volume size. If you
         *        specify a snapshot, the default is the snapshot size. You can specify a volume size that is equal to
         *        or larger than the snapshot size.</p>
         *        <p>
         *        The following are the supported volumes sizes for each volume type:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>gp2</code> and <code>gp3</code>: 1 - 16,384 GiB
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>io1</code>: 4 - 16,384 GiB
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>io2</code>: 4 - 65,536 GiB
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>st1</code> and <code>sc1</code>: 125 - 16,384 GiB
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>standard</code>: 1 - 1024 GiB
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Integer size);

        /**
         * <p>
         * The snapshot from which to create the volume. You must specify either a snapshot ID or a volume size.
         * </p>
         * 
         * @param snapshotId
         *        The snapshot from which to create the volume. You must specify either a snapshot ID or a volume size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * The volume type. This parameter can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * General Purpose SSD: <code>gp2</code> | <code>gp3</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Provisioned IOPS SSD: <code>io1</code> | <code>io2</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Throughput Optimized HDD: <code>st1</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Cold HDD: <code>sc1</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Magnetic: <code>standard</code>
         * </p>
         * </li>
         * </ul>
         * <important>
         * <p>
         * Throughput Optimized HDD (<code>st1</code>) and Cold HDD (<code>sc1</code>) volumes can't be used as boot
         * volumes.
         * </p>
         * </important>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volume-types.html">Amazon EBS volume types</a> in
         * the <i>Amazon EBS User Guide</i>.
         * </p>
         * <p>
         * Default: <code>gp2</code>
         * </p>
         * 
         * @param volumeType
         *        The volume type. This parameter can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        General Purpose SSD: <code>gp2</code> | <code>gp3</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Provisioned IOPS SSD: <code>io1</code> | <code>io2</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Throughput Optimized HDD: <code>st1</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cold HDD: <code>sc1</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Magnetic: <code>standard</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <important>
         *        <p>
         *        Throughput Optimized HDD (<code>st1</code>) and Cold HDD (<code>sc1</code>) volumes can't be used as
         *        boot volumes.
         *        </p>
         *        </important>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volume-types.html">Amazon EBS volume
         *        types</a> in the <i>Amazon EBS User Guide</i>.
         *        </p>
         *        <p>
         *        Default: <code>gp2</code>
         * @see VolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder volumeType(String volumeType);

        /**
         * <p>
         * The volume type. This parameter can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * General Purpose SSD: <code>gp2</code> | <code>gp3</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Provisioned IOPS SSD: <code>io1</code> | <code>io2</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Throughput Optimized HDD: <code>st1</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Cold HDD: <code>sc1</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Magnetic: <code>standard</code>
         * </p>
         * </li>
         * </ul>
         * <important>
         * <p>
         * Throughput Optimized HDD (<code>st1</code>) and Cold HDD (<code>sc1</code>) volumes can't be used as boot
         * volumes.
         * </p>
         * </important>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volume-types.html">Amazon EBS volume types</a> in
         * the <i>Amazon EBS User Guide</i>.
         * </p>
         * <p>
         * Default: <code>gp2</code>
         * </p>
         * 
         * @param volumeType
         *        The volume type. This parameter can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        General Purpose SSD: <code>gp2</code> | <code>gp3</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Provisioned IOPS SSD: <code>io1</code> | <code>io2</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Throughput Optimized HDD: <code>st1</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cold HDD: <code>sc1</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Magnetic: <code>standard</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <important>
         *        <p>
         *        Throughput Optimized HDD (<code>st1</code>) and Cold HDD (<code>sc1</code>) volumes can't be used as
         *        boot volumes.
         *        </p>
         *        </important>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volume-types.html">Amazon EBS volume
         *        types</a> in the <i>Amazon EBS User Guide</i>.
         *        </p>
         *        <p>
         *        Default: <code>gp2</code>
         * @see VolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder volumeType(VolumeType volumeType);

        /**
         * <p>
         * The tags to apply to the volume during creation.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the volume during creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags to apply to the volume during creation.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the volume during creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags to apply to the volume during creation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.TagSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(java.util.Collection<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        /**
         * <p>
         * Indicates whether to enable Amazon EBS Multi-Attach. If you enable Multi-Attach, you can attach the volume to
         * up to 16 <a href="https://docs.aws.amazon.com/ec2/latest/instancetypes/ec2-nitro-instances.html">Instances
         * built on the Nitro System</a> in the same Availability Zone. This parameter is supported with
         * <code>io1</code> and <code>io2</code> volumes only. For more information, see <a
         * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volumes-multi.html"> Amazon EBS Multi-Attach</a>
         * in the <i>Amazon EBS User Guide</i>.
         * </p>
         * 
         * @param multiAttachEnabled
         *        Indicates whether to enable Amazon EBS Multi-Attach. If you enable Multi-Attach, you can attach the
         *        volume to up to 16 <a
         *        href="https://docs.aws.amazon.com/ec2/latest/instancetypes/ec2-nitro-instances.html">Instances built
         *        on the Nitro System</a> in the same Availability Zone. This parameter is supported with
         *        <code>io1</code> and <code>io2</code> volumes only. For more information, see <a
         *        href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volumes-multi.html"> Amazon EBS
         *        Multi-Attach</a> in the <i>Amazon EBS User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiAttachEnabled(Boolean multiAttachEnabled);

        /**
         * <p>
         * The throughput to provision for a volume, with a maximum of 1,000 MiB/s.
         * </p>
         * <p>
         * This parameter is valid only for <code>gp3</code> volumes.
         * </p>
         * <p>
         * Valid Range: Minimum value of 125. Maximum value of 1000.
         * </p>
         * 
         * @param throughput
         *        The throughput to provision for a volume, with a maximum of 1,000 MiB/s.</p>
         *        <p>
         *        This parameter is valid only for <code>gp3</code> volumes.
         *        </p>
         *        <p>
         *        Valid Range: Minimum value of 125. Maximum value of 1000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throughput(Integer throughput);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensure
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensure
         *        Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Reserved for internal use.
         * </p>
         * 
         * @param operator
         *        Reserved for internal use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operator(OperatorRequest operator);

        /**
         * <p>
         * Reserved for internal use.
         * </p>
         * This is a convenience method that creates an instance of the {@link OperatorRequest.Builder} avoiding the
         * need to create one manually via {@link OperatorRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OperatorRequest.Builder#build()} is called immediately and its
         * result is passed to {@link #operator(OperatorRequest)}.
         * 
         * @param operator
         *        a consumer that will call methods on {@link OperatorRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operator(OperatorRequest)
         */
        default Builder operator(Consumer<OperatorRequest.Builder> operator) {
            return operator(OperatorRequest.builder().applyMutation(operator).build());
        }

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String availabilityZone;

        private Boolean encrypted;

        private Integer iops;

        private String kmsKeyId;

        private String outpostArn;

        private Integer size;

        private String snapshotId;

        private String volumeType;

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private Boolean multiAttachEnabled;

        private Integer throughput;

        private String clientToken;

        private OperatorRequest operator;

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVolumeRequest model) {
            super(model);
            availabilityZone(model.availabilityZone);
            encrypted(model.encrypted);
            iops(model.iops);
            kmsKeyId(model.kmsKeyId);
            outpostArn(model.outpostArn);
            size(model.size);
            snapshotId(model.snapshotId);
            volumeType(model.volumeType);
            tagSpecifications(model.tagSpecifications);
            multiAttachEnabled(model.multiAttachEnabled);
            throughput(model.throughput);
            clientToken(model.clientToken);
            operator(model.operator);
            dryRun(model.dryRun);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final Integer getIops() {
            return iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getOutpostArn() {
            return outpostArn;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public final Integer getSize() {
            return size;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final String getVolumeType() {
            return volumeType;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        @Override
        public final Builder volumeType(VolumeType volumeType) {
            this.volumeType(volumeType == null ? null : volumeType.toString());
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getMultiAttachEnabled() {
            return multiAttachEnabled;
        }

        public final void setMultiAttachEnabled(Boolean multiAttachEnabled) {
            this.multiAttachEnabled = multiAttachEnabled;
        }

        @Override
        public final Builder multiAttachEnabled(Boolean multiAttachEnabled) {
            this.multiAttachEnabled = multiAttachEnabled;
            return this;
        }

        public final Integer getThroughput() {
            return throughput;
        }

        public final void setThroughput(Integer throughput) {
            this.throughput = throughput;
        }

        @Override
        public final Builder throughput(Integer throughput) {
            this.throughput = throughput;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final OperatorRequest.Builder getOperator() {
            return operator != null ? operator.toBuilder() : null;
        }

        public final void setOperator(OperatorRequest.BuilderImpl operator) {
            this.operator = operator != null ? operator.build() : null;
        }

        @Override
        public final Builder operator(OperatorRequest operator) {
            this.operator = operator;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVolumeRequest build() {
            return new CreateVolumeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
