/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Capacity Block extension. With an extension, you can extend the duration of time for an existing Capacity
 * Block.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CapacityBlockExtension implements SdkPojo, Serializable,
        ToCopyableBuilder<CapacityBlockExtension.Builder, CapacityBlockExtension> {
    private static final SdkField<String> CAPACITY_RESERVATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CapacityReservationId")
            .getter(getter(CapacityBlockExtension::capacityReservationId))
            .setter(setter(Builder::capacityReservationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationId")
                    .unmarshallLocationName("capacityReservationId").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceType")
            .getter(getter(CapacityBlockExtension::instanceType))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType")
                    .unmarshallLocationName("instanceType").build()).build();

    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstanceCount")
            .getter(getter(CapacityBlockExtension::instanceCount))
            .setter(setter(Builder::instanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount")
                    .unmarshallLocationName("instanceCount").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone")
            .getter(getter(CapacityBlockExtension::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone")
                    .unmarshallLocationName("availabilityZone").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZoneId")
            .getter(getter(CapacityBlockExtension::availabilityZoneId))
            .setter(setter(Builder::availabilityZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId")
                    .unmarshallLocationName("availabilityZoneId").build()).build();

    private static final SdkField<String> CAPACITY_BLOCK_EXTENSION_OFFERING_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CapacityBlockExtensionOfferingId")
            .getter(getter(CapacityBlockExtension::capacityBlockExtensionOfferingId))
            .setter(setter(Builder::capacityBlockExtensionOfferingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityBlockExtensionOfferingId")
                    .unmarshallLocationName("capacityBlockExtensionOfferingId").build()).build();

    private static final SdkField<Integer> CAPACITY_BLOCK_EXTENSION_DURATION_HOURS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("CapacityBlockExtensionDurationHours")
            .getter(getter(CapacityBlockExtension::capacityBlockExtensionDurationHours))
            .setter(setter(Builder::capacityBlockExtensionDurationHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("CapacityBlockExtensionDurationHours")
                    .unmarshallLocationName("capacityBlockExtensionDurationHours").build()).build();

    private static final SdkField<String> CAPACITY_BLOCK_EXTENSION_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CapacityBlockExtensionStatus")
            .getter(getter(CapacityBlockExtension::capacityBlockExtensionStatusAsString))
            .setter(setter(Builder::capacityBlockExtensionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityBlockExtensionStatus")
                    .unmarshallLocationName("capacityBlockExtensionStatus").build()).build();

    private static final SdkField<Instant> CAPACITY_BLOCK_EXTENSION_PURCHASE_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CapacityBlockExtensionPurchaseDate")
            .getter(getter(CapacityBlockExtension::capacityBlockExtensionPurchaseDate))
            .setter(setter(Builder::capacityBlockExtensionPurchaseDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityBlockExtensionPurchaseDate")
                    .unmarshallLocationName("capacityBlockExtensionPurchaseDate").build()).build();

    private static final SdkField<Instant> CAPACITY_BLOCK_EXTENSION_START_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CapacityBlockExtensionStartDate")
            .getter(getter(CapacityBlockExtension::capacityBlockExtensionStartDate))
            .setter(setter(Builder::capacityBlockExtensionStartDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityBlockExtensionStartDate")
                    .unmarshallLocationName("capacityBlockExtensionStartDate").build()).build();

    private static final SdkField<Instant> CAPACITY_BLOCK_EXTENSION_END_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CapacityBlockExtensionEndDate")
            .getter(getter(CapacityBlockExtension::capacityBlockExtensionEndDate))
            .setter(setter(Builder::capacityBlockExtensionEndDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityBlockExtensionEndDate")
                    .unmarshallLocationName("capacityBlockExtensionEndDate").build()).build();

    private static final SdkField<String> UPFRONT_FEE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("UpfrontFee")
            .getter(getter(CapacityBlockExtension::upfrontFee))
            .setter(setter(Builder::upfrontFee))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpfrontFee")
                    .unmarshallLocationName("upfrontFee").build()).build();

    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CurrencyCode")
            .getter(getter(CapacityBlockExtension::currencyCode))
            .setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode")
                    .unmarshallLocationName("currencyCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_RESERVATION_ID_FIELD,
            INSTANCE_TYPE_FIELD, INSTANCE_COUNT_FIELD, AVAILABILITY_ZONE_FIELD, AVAILABILITY_ZONE_ID_FIELD,
            CAPACITY_BLOCK_EXTENSION_OFFERING_ID_FIELD, CAPACITY_BLOCK_EXTENSION_DURATION_HOURS_FIELD,
            CAPACITY_BLOCK_EXTENSION_STATUS_FIELD, CAPACITY_BLOCK_EXTENSION_PURCHASE_DATE_FIELD,
            CAPACITY_BLOCK_EXTENSION_START_DATE_FIELD, CAPACITY_BLOCK_EXTENSION_END_DATE_FIELD, UPFRONT_FEE_FIELD,
            CURRENCY_CODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String capacityReservationId;

    private final String instanceType;

    private final Integer instanceCount;

    private final String availabilityZone;

    private final String availabilityZoneId;

    private final String capacityBlockExtensionOfferingId;

    private final Integer capacityBlockExtensionDurationHours;

    private final String capacityBlockExtensionStatus;

    private final Instant capacityBlockExtensionPurchaseDate;

    private final Instant capacityBlockExtensionStartDate;

    private final Instant capacityBlockExtensionEndDate;

    private final String upfrontFee;

    private final String currencyCode;

    private CapacityBlockExtension(BuilderImpl builder) {
        this.capacityReservationId = builder.capacityReservationId;
        this.instanceType = builder.instanceType;
        this.instanceCount = builder.instanceCount;
        this.availabilityZone = builder.availabilityZone;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.capacityBlockExtensionOfferingId = builder.capacityBlockExtensionOfferingId;
        this.capacityBlockExtensionDurationHours = builder.capacityBlockExtensionDurationHours;
        this.capacityBlockExtensionStatus = builder.capacityBlockExtensionStatus;
        this.capacityBlockExtensionPurchaseDate = builder.capacityBlockExtensionPurchaseDate;
        this.capacityBlockExtensionStartDate = builder.capacityBlockExtensionStartDate;
        this.capacityBlockExtensionEndDate = builder.capacityBlockExtensionEndDate;
        this.upfrontFee = builder.upfrontFee;
        this.currencyCode = builder.currencyCode;
    }

    /**
     * <p>
     * The reservation ID of the Capacity Block extension.
     * </p>
     * 
     * @return The reservation ID of the Capacity Block extension.
     */
    public final String capacityReservationId() {
        return capacityReservationId;
    }

    /**
     * <p>
     * The instance type of the Capacity Block extension.
     * </p>
     * 
     * @return The instance type of the Capacity Block extension.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The number of instances in the Capacity Block extension.
     * </p>
     * 
     * @return The number of instances in the Capacity Block extension.
     */
    public final Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * The Availability Zone of the Capacity Block extension.
     * </p>
     * 
     * @return The Availability Zone of the Capacity Block extension.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The Availability Zone ID of the Capacity Block extension.
     * </p>
     * 
     * @return The Availability Zone ID of the Capacity Block extension.
     */
    public final String availabilityZoneId() {
        return availabilityZoneId;
    }

    /**
     * <p>
     * The ID of the Capacity Block extension offering.
     * </p>
     * 
     * @return The ID of the Capacity Block extension offering.
     */
    public final String capacityBlockExtensionOfferingId() {
        return capacityBlockExtensionOfferingId;
    }

    /**
     * <p>
     * The duration of the Capacity Block extension in hours.
     * </p>
     * 
     * @return The duration of the Capacity Block extension in hours.
     */
    public final Integer capacityBlockExtensionDurationHours() {
        return capacityBlockExtensionDurationHours;
    }

    /**
     * <p>
     * The status of the Capacity Block extension. A Capacity Block extension can have one of the following statuses:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>payment-pending</code> - The Capacity Block extension payment is processing. If your payment can't be
     * processed within 12 hours, the Capacity Block extension is failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>payment-failed</code> - Payment for the Capacity Block extension request was not successful.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>payment-succeeded</code> - Payment for the Capacity Block extension request was successful. You receive an
     * invoice that reflects the one-time upfront payment. In the invoice, you can associate the paid amount with the
     * Capacity Block reservation ID.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #capacityBlockExtensionStatus} will return {@link CapacityBlockExtensionStatus#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #capacityBlockExtensionStatusAsString}.
     * </p>
     * 
     * @return The status of the Capacity Block extension. A Capacity Block extension can have one of the following
     *         statuses:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>payment-pending</code> - The Capacity Block extension payment is processing. If your payment can't
     *         be processed within 12 hours, the Capacity Block extension is failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>payment-failed</code> - Payment for the Capacity Block extension request was not successful.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>payment-succeeded</code> - Payment for the Capacity Block extension request was successful. You
     *         receive an invoice that reflects the one-time upfront payment. In the invoice, you can associate the paid
     *         amount with the Capacity Block reservation ID.
     *         </p>
     *         </li>
     * @see CapacityBlockExtensionStatus
     */
    public final CapacityBlockExtensionStatus capacityBlockExtensionStatus() {
        return CapacityBlockExtensionStatus.fromValue(capacityBlockExtensionStatus);
    }

    /**
     * <p>
     * The status of the Capacity Block extension. A Capacity Block extension can have one of the following statuses:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>payment-pending</code> - The Capacity Block extension payment is processing. If your payment can't be
     * processed within 12 hours, the Capacity Block extension is failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>payment-failed</code> - Payment for the Capacity Block extension request was not successful.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>payment-succeeded</code> - Payment for the Capacity Block extension request was successful. You receive an
     * invoice that reflects the one-time upfront payment. In the invoice, you can associate the paid amount with the
     * Capacity Block reservation ID.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #capacityBlockExtensionStatus} will return {@link CapacityBlockExtensionStatus#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #capacityBlockExtensionStatusAsString}.
     * </p>
     * 
     * @return The status of the Capacity Block extension. A Capacity Block extension can have one of the following
     *         statuses:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>payment-pending</code> - The Capacity Block extension payment is processing. If your payment can't
     *         be processed within 12 hours, the Capacity Block extension is failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>payment-failed</code> - Payment for the Capacity Block extension request was not successful.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>payment-succeeded</code> - Payment for the Capacity Block extension request was successful. You
     *         receive an invoice that reflects the one-time upfront payment. In the invoice, you can associate the paid
     *         amount with the Capacity Block reservation ID.
     *         </p>
     *         </li>
     * @see CapacityBlockExtensionStatus
     */
    public final String capacityBlockExtensionStatusAsString() {
        return capacityBlockExtensionStatus;
    }

    /**
     * <p>
     * The date when the Capacity Block extension was purchased.
     * </p>
     * 
     * @return The date when the Capacity Block extension was purchased.
     */
    public final Instant capacityBlockExtensionPurchaseDate() {
        return capacityBlockExtensionPurchaseDate;
    }

    /**
     * <p>
     * The start date of the Capacity Block extension.
     * </p>
     * 
     * @return The start date of the Capacity Block extension.
     */
    public final Instant capacityBlockExtensionStartDate() {
        return capacityBlockExtensionStartDate;
    }

    /**
     * <p>
     * The end date of the Capacity Block extension.
     * </p>
     * 
     * @return The end date of the Capacity Block extension.
     */
    public final Instant capacityBlockExtensionEndDate() {
        return capacityBlockExtensionEndDate;
    }

    /**
     * <p>
     * The total price to be paid up front.
     * </p>
     * 
     * @return The total price to be paid up front.
     */
    public final String upfrontFee() {
        return upfrontFee;
    }

    /**
     * <p>
     * The currency of the payment for the Capacity Block extension.
     * </p>
     * 
     * @return The currency of the payment for the Capacity Block extension.
     */
    public final String currencyCode() {
        return currencyCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(capacityBlockExtensionOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(capacityBlockExtensionDurationHours());
        hashCode = 31 * hashCode + Objects.hashCode(capacityBlockExtensionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(capacityBlockExtensionPurchaseDate());
        hashCode = 31 * hashCode + Objects.hashCode(capacityBlockExtensionStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(capacityBlockExtensionEndDate());
        hashCode = 31 * hashCode + Objects.hashCode(upfrontFee());
        hashCode = 31 * hashCode + Objects.hashCode(currencyCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityBlockExtension)) {
            return false;
        }
        CapacityBlockExtension other = (CapacityBlockExtension) obj;
        return Objects.equals(capacityReservationId(), other.capacityReservationId())
                && Objects.equals(instanceType(), other.instanceType()) && Objects.equals(instanceCount(), other.instanceCount())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(availabilityZoneId(), other.availabilityZoneId())
                && Objects.equals(capacityBlockExtensionOfferingId(), other.capacityBlockExtensionOfferingId())
                && Objects.equals(capacityBlockExtensionDurationHours(), other.capacityBlockExtensionDurationHours())
                && Objects.equals(capacityBlockExtensionStatusAsString(), other.capacityBlockExtensionStatusAsString())
                && Objects.equals(capacityBlockExtensionPurchaseDate(), other.capacityBlockExtensionPurchaseDate())
                && Objects.equals(capacityBlockExtensionStartDate(), other.capacityBlockExtensionStartDate())
                && Objects.equals(capacityBlockExtensionEndDate(), other.capacityBlockExtensionEndDate())
                && Objects.equals(upfrontFee(), other.upfrontFee()) && Objects.equals(currencyCode(), other.currencyCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CapacityBlockExtension").add("CapacityReservationId", capacityReservationId())
                .add("InstanceType", instanceType()).add("InstanceCount", instanceCount())
                .add("AvailabilityZone", availabilityZone()).add("AvailabilityZoneId", availabilityZoneId())
                .add("CapacityBlockExtensionOfferingId", capacityBlockExtensionOfferingId())
                .add("CapacityBlockExtensionDurationHours", capacityBlockExtensionDurationHours())
                .add("CapacityBlockExtensionStatus", capacityBlockExtensionStatusAsString())
                .add("CapacityBlockExtensionPurchaseDate", capacityBlockExtensionPurchaseDate())
                .add("CapacityBlockExtensionStartDate", capacityBlockExtensionStartDate())
                .add("CapacityBlockExtensionEndDate", capacityBlockExtensionEndDate()).add("UpfrontFee", upfrontFee())
                .add("CurrencyCode", currencyCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CapacityReservationId":
            return Optional.ofNullable(clazz.cast(capacityReservationId()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "InstanceCount":
            return Optional.ofNullable(clazz.cast(instanceCount()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "AvailabilityZoneId":
            return Optional.ofNullable(clazz.cast(availabilityZoneId()));
        case "CapacityBlockExtensionOfferingId":
            return Optional.ofNullable(clazz.cast(capacityBlockExtensionOfferingId()));
        case "CapacityBlockExtensionDurationHours":
            return Optional.ofNullable(clazz.cast(capacityBlockExtensionDurationHours()));
        case "CapacityBlockExtensionStatus":
            return Optional.ofNullable(clazz.cast(capacityBlockExtensionStatusAsString()));
        case "CapacityBlockExtensionPurchaseDate":
            return Optional.ofNullable(clazz.cast(capacityBlockExtensionPurchaseDate()));
        case "CapacityBlockExtensionStartDate":
            return Optional.ofNullable(clazz.cast(capacityBlockExtensionStartDate()));
        case "CapacityBlockExtensionEndDate":
            return Optional.ofNullable(clazz.cast(capacityBlockExtensionEndDate()));
        case "UpfrontFee":
            return Optional.ofNullable(clazz.cast(upfrontFee()));
        case "CurrencyCode":
            return Optional.ofNullable(clazz.cast(currencyCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CapacityReservationId", CAPACITY_RESERVATION_ID_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("InstanceCount", INSTANCE_COUNT_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("AvailabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        map.put("CapacityBlockExtensionOfferingId", CAPACITY_BLOCK_EXTENSION_OFFERING_ID_FIELD);
        map.put("CapacityBlockExtensionDurationHours", CAPACITY_BLOCK_EXTENSION_DURATION_HOURS_FIELD);
        map.put("CapacityBlockExtensionStatus", CAPACITY_BLOCK_EXTENSION_STATUS_FIELD);
        map.put("CapacityBlockExtensionPurchaseDate", CAPACITY_BLOCK_EXTENSION_PURCHASE_DATE_FIELD);
        map.put("CapacityBlockExtensionStartDate", CAPACITY_BLOCK_EXTENSION_START_DATE_FIELD);
        map.put("CapacityBlockExtensionEndDate", CAPACITY_BLOCK_EXTENSION_END_DATE_FIELD);
        map.put("UpfrontFee", UPFRONT_FEE_FIELD);
        map.put("CurrencyCode", CURRENCY_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapacityBlockExtension, T> g) {
        return obj -> g.apply((CapacityBlockExtension) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CapacityBlockExtension> {
        /**
         * <p>
         * The reservation ID of the Capacity Block extension.
         * </p>
         * 
         * @param capacityReservationId
         *        The reservation ID of the Capacity Block extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationId(String capacityReservationId);

        /**
         * <p>
         * The instance type of the Capacity Block extension.
         * </p>
         * 
         * @param instanceType
         *        The instance type of the Capacity Block extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The number of instances in the Capacity Block extension.
         * </p>
         * 
         * @param instanceCount
         *        The number of instances in the Capacity Block extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * The Availability Zone of the Capacity Block extension.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone of the Capacity Block extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The Availability Zone ID of the Capacity Block extension.
         * </p>
         * 
         * @param availabilityZoneId
         *        The Availability Zone ID of the Capacity Block extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneId(String availabilityZoneId);

        /**
         * <p>
         * The ID of the Capacity Block extension offering.
         * </p>
         * 
         * @param capacityBlockExtensionOfferingId
         *        The ID of the Capacity Block extension offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityBlockExtensionOfferingId(String capacityBlockExtensionOfferingId);

        /**
         * <p>
         * The duration of the Capacity Block extension in hours.
         * </p>
         * 
         * @param capacityBlockExtensionDurationHours
         *        The duration of the Capacity Block extension in hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityBlockExtensionDurationHours(Integer capacityBlockExtensionDurationHours);

        /**
         * <p>
         * The status of the Capacity Block extension. A Capacity Block extension can have one of the following
         * statuses:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>payment-pending</code> - The Capacity Block extension payment is processing. If your payment can't be
         * processed within 12 hours, the Capacity Block extension is failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>payment-failed</code> - Payment for the Capacity Block extension request was not successful.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>payment-succeeded</code> - Payment for the Capacity Block extension request was successful. You receive
         * an invoice that reflects the one-time upfront payment. In the invoice, you can associate the paid amount with
         * the Capacity Block reservation ID.
         * </p>
         * </li>
         * </ul>
         * 
         * @param capacityBlockExtensionStatus
         *        The status of the Capacity Block extension. A Capacity Block extension can have one of the following
         *        statuses:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>payment-pending</code> - The Capacity Block extension payment is processing. If your payment
         *        can't be processed within 12 hours, the Capacity Block extension is failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>payment-failed</code> - Payment for the Capacity Block extension request was not successful.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>payment-succeeded</code> - Payment for the Capacity Block extension request was successful. You
         *        receive an invoice that reflects the one-time upfront payment. In the invoice, you can associate the
         *        paid amount with the Capacity Block reservation ID.
         *        </p>
         *        </li>
         * @see CapacityBlockExtensionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityBlockExtensionStatus
         */
        Builder capacityBlockExtensionStatus(String capacityBlockExtensionStatus);

        /**
         * <p>
         * The status of the Capacity Block extension. A Capacity Block extension can have one of the following
         * statuses:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>payment-pending</code> - The Capacity Block extension payment is processing. If your payment can't be
         * processed within 12 hours, the Capacity Block extension is failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>payment-failed</code> - Payment for the Capacity Block extension request was not successful.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>payment-succeeded</code> - Payment for the Capacity Block extension request was successful. You receive
         * an invoice that reflects the one-time upfront payment. In the invoice, you can associate the paid amount with
         * the Capacity Block reservation ID.
         * </p>
         * </li>
         * </ul>
         * 
         * @param capacityBlockExtensionStatus
         *        The status of the Capacity Block extension. A Capacity Block extension can have one of the following
         *        statuses:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>payment-pending</code> - The Capacity Block extension payment is processing. If your payment
         *        can't be processed within 12 hours, the Capacity Block extension is failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>payment-failed</code> - Payment for the Capacity Block extension request was not successful.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>payment-succeeded</code> - Payment for the Capacity Block extension request was successful. You
         *        receive an invoice that reflects the one-time upfront payment. In the invoice, you can associate the
         *        paid amount with the Capacity Block reservation ID.
         *        </p>
         *        </li>
         * @see CapacityBlockExtensionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityBlockExtensionStatus
         */
        Builder capacityBlockExtensionStatus(CapacityBlockExtensionStatus capacityBlockExtensionStatus);

        /**
         * <p>
         * The date when the Capacity Block extension was purchased.
         * </p>
         * 
         * @param capacityBlockExtensionPurchaseDate
         *        The date when the Capacity Block extension was purchased.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityBlockExtensionPurchaseDate(Instant capacityBlockExtensionPurchaseDate);

        /**
         * <p>
         * The start date of the Capacity Block extension.
         * </p>
         * 
         * @param capacityBlockExtensionStartDate
         *        The start date of the Capacity Block extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityBlockExtensionStartDate(Instant capacityBlockExtensionStartDate);

        /**
         * <p>
         * The end date of the Capacity Block extension.
         * </p>
         * 
         * @param capacityBlockExtensionEndDate
         *        The end date of the Capacity Block extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityBlockExtensionEndDate(Instant capacityBlockExtensionEndDate);

        /**
         * <p>
         * The total price to be paid up front.
         * </p>
         * 
         * @param upfrontFee
         *        The total price to be paid up front.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upfrontFee(String upfrontFee);

        /**
         * <p>
         * The currency of the payment for the Capacity Block extension.
         * </p>
         * 
         * @param currencyCode
         *        The currency of the payment for the Capacity Block extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currencyCode(String currencyCode);
    }

    static final class BuilderImpl implements Builder {
        private String capacityReservationId;

        private String instanceType;

        private Integer instanceCount;

        private String availabilityZone;

        private String availabilityZoneId;

        private String capacityBlockExtensionOfferingId;

        private Integer capacityBlockExtensionDurationHours;

        private String capacityBlockExtensionStatus;

        private Instant capacityBlockExtensionPurchaseDate;

        private Instant capacityBlockExtensionStartDate;

        private Instant capacityBlockExtensionEndDate;

        private String upfrontFee;

        private String currencyCode;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityBlockExtension model) {
            capacityReservationId(model.capacityReservationId);
            instanceType(model.instanceType);
            instanceCount(model.instanceCount);
            availabilityZone(model.availabilityZone);
            availabilityZoneId(model.availabilityZoneId);
            capacityBlockExtensionOfferingId(model.capacityBlockExtensionOfferingId);
            capacityBlockExtensionDurationHours(model.capacityBlockExtensionDurationHours);
            capacityBlockExtensionStatus(model.capacityBlockExtensionStatus);
            capacityBlockExtensionPurchaseDate(model.capacityBlockExtensionPurchaseDate);
            capacityBlockExtensionStartDate(model.capacityBlockExtensionStartDate);
            capacityBlockExtensionEndDate(model.capacityBlockExtensionEndDate);
            upfrontFee(model.upfrontFee);
            currencyCode(model.currencyCode);
        }

        public final String getCapacityReservationId() {
            return capacityReservationId;
        }

        public final void setCapacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
        }

        @Override
        public final Builder capacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final String getCapacityBlockExtensionOfferingId() {
            return capacityBlockExtensionOfferingId;
        }

        public final void setCapacityBlockExtensionOfferingId(String capacityBlockExtensionOfferingId) {
            this.capacityBlockExtensionOfferingId = capacityBlockExtensionOfferingId;
        }

        @Override
        public final Builder capacityBlockExtensionOfferingId(String capacityBlockExtensionOfferingId) {
            this.capacityBlockExtensionOfferingId = capacityBlockExtensionOfferingId;
            return this;
        }

        public final Integer getCapacityBlockExtensionDurationHours() {
            return capacityBlockExtensionDurationHours;
        }

        public final void setCapacityBlockExtensionDurationHours(Integer capacityBlockExtensionDurationHours) {
            this.capacityBlockExtensionDurationHours = capacityBlockExtensionDurationHours;
        }

        @Override
        public final Builder capacityBlockExtensionDurationHours(Integer capacityBlockExtensionDurationHours) {
            this.capacityBlockExtensionDurationHours = capacityBlockExtensionDurationHours;
            return this;
        }

        public final String getCapacityBlockExtensionStatus() {
            return capacityBlockExtensionStatus;
        }

        public final void setCapacityBlockExtensionStatus(String capacityBlockExtensionStatus) {
            this.capacityBlockExtensionStatus = capacityBlockExtensionStatus;
        }

        @Override
        public final Builder capacityBlockExtensionStatus(String capacityBlockExtensionStatus) {
            this.capacityBlockExtensionStatus = capacityBlockExtensionStatus;
            return this;
        }

        @Override
        public final Builder capacityBlockExtensionStatus(CapacityBlockExtensionStatus capacityBlockExtensionStatus) {
            this.capacityBlockExtensionStatus(capacityBlockExtensionStatus == null ? null : capacityBlockExtensionStatus
                    .toString());
            return this;
        }

        public final Instant getCapacityBlockExtensionPurchaseDate() {
            return capacityBlockExtensionPurchaseDate;
        }

        public final void setCapacityBlockExtensionPurchaseDate(Instant capacityBlockExtensionPurchaseDate) {
            this.capacityBlockExtensionPurchaseDate = capacityBlockExtensionPurchaseDate;
        }

        @Override
        public final Builder capacityBlockExtensionPurchaseDate(Instant capacityBlockExtensionPurchaseDate) {
            this.capacityBlockExtensionPurchaseDate = capacityBlockExtensionPurchaseDate;
            return this;
        }

        public final Instant getCapacityBlockExtensionStartDate() {
            return capacityBlockExtensionStartDate;
        }

        public final void setCapacityBlockExtensionStartDate(Instant capacityBlockExtensionStartDate) {
            this.capacityBlockExtensionStartDate = capacityBlockExtensionStartDate;
        }

        @Override
        public final Builder capacityBlockExtensionStartDate(Instant capacityBlockExtensionStartDate) {
            this.capacityBlockExtensionStartDate = capacityBlockExtensionStartDate;
            return this;
        }

        public final Instant getCapacityBlockExtensionEndDate() {
            return capacityBlockExtensionEndDate;
        }

        public final void setCapacityBlockExtensionEndDate(Instant capacityBlockExtensionEndDate) {
            this.capacityBlockExtensionEndDate = capacityBlockExtensionEndDate;
        }

        @Override
        public final Builder capacityBlockExtensionEndDate(Instant capacityBlockExtensionEndDate) {
            this.capacityBlockExtensionEndDate = capacityBlockExtensionEndDate;
            return this;
        }

        public final String getUpfrontFee() {
            return upfrontFee;
        }

        public final void setUpfrontFee(String upfrontFee) {
            this.upfrontFee = upfrontFee;
        }

        @Override
        public final Builder upfrontFee(String upfrontFee) {
            this.upfrontFee = upfrontFee;
            return this;
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public CapacityBlockExtension build() {
            return new CapacityBlockExtension(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
