/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AllocateIpamPoolCidrResponse extends Ec2Response implements
        ToCopyableBuilder<AllocateIpamPoolCidrResponse.Builder, AllocateIpamPoolCidrResponse> {
    private static final SdkField<IpamPoolAllocation> IPAM_POOL_ALLOCATION_FIELD = SdkField
            .<IpamPoolAllocation> builder(MarshallingType.SDK_POJO)
            .memberName("IpamPoolAllocation")
            .getter(getter(AllocateIpamPoolCidrResponse::ipamPoolAllocation))
            .setter(setter(Builder::ipamPoolAllocation))
            .constructor(IpamPoolAllocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPoolAllocation")
                    .unmarshallLocationName("ipamPoolAllocation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPAM_POOL_ALLOCATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final IpamPoolAllocation ipamPoolAllocation;

    private AllocateIpamPoolCidrResponse(BuilderImpl builder) {
        super(builder);
        this.ipamPoolAllocation = builder.ipamPoolAllocation;
    }

    /**
     * <p>
     * Information about the allocation created.
     * </p>
     * 
     * @return Information about the allocation created.
     */
    public final IpamPoolAllocation ipamPoolAllocation() {
        return ipamPoolAllocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ipamPoolAllocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllocateIpamPoolCidrResponse)) {
            return false;
        }
        AllocateIpamPoolCidrResponse other = (AllocateIpamPoolCidrResponse) obj;
        return Objects.equals(ipamPoolAllocation(), other.ipamPoolAllocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AllocateIpamPoolCidrResponse").add("IpamPoolAllocation", ipamPoolAllocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpamPoolAllocation":
            return Optional.ofNullable(clazz.cast(ipamPoolAllocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IpamPoolAllocation", IPAM_POOL_ALLOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AllocateIpamPoolCidrResponse, T> g) {
        return obj -> g.apply((AllocateIpamPoolCidrResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, AllocateIpamPoolCidrResponse> {
        /**
         * <p>
         * Information about the allocation created.
         * </p>
         * 
         * @param ipamPoolAllocation
         *        Information about the allocation created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamPoolAllocation(IpamPoolAllocation ipamPoolAllocation);

        /**
         * <p>
         * Information about the allocation created.
         * </p>
         * This is a convenience method that creates an instance of the {@link IpamPoolAllocation.Builder} avoiding the
         * need to create one manually via {@link IpamPoolAllocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IpamPoolAllocation.Builder#build()} is called immediately and its
         * result is passed to {@link #ipamPoolAllocation(IpamPoolAllocation)}.
         * 
         * @param ipamPoolAllocation
         *        a consumer that will call methods on {@link IpamPoolAllocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipamPoolAllocation(IpamPoolAllocation)
         */
        default Builder ipamPoolAllocation(Consumer<IpamPoolAllocation.Builder> ipamPoolAllocation) {
            return ipamPoolAllocation(IpamPoolAllocation.builder().applyMutation(ipamPoolAllocation).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private IpamPoolAllocation ipamPoolAllocation;

        private BuilderImpl() {
        }

        private BuilderImpl(AllocateIpamPoolCidrResponse model) {
            super(model);
            ipamPoolAllocation(model.ipamPoolAllocation);
        }

        public final IpamPoolAllocation.Builder getIpamPoolAllocation() {
            return ipamPoolAllocation != null ? ipamPoolAllocation.toBuilder() : null;
        }

        public final void setIpamPoolAllocation(IpamPoolAllocation.BuilderImpl ipamPoolAllocation) {
            this.ipamPoolAllocation = ipamPoolAllocation != null ? ipamPoolAllocation.build() : null;
        }

        @Override
        public final Builder ipamPoolAllocation(IpamPoolAllocation ipamPoolAllocation) {
            this.ipamPoolAllocation = ipamPoolAllocation;
            return this;
        }

        @Override
        public AllocateIpamPoolCidrResponse build() {
            return new AllocateIpamPoolCidrResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
