/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NativeApplicationOidcOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NativeApplicationOidcOptions> {
    private static final SdkField<String> PUBLIC_SIGNING_KEY_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicSigningKeyEndpoint").getter(NativeApplicationOidcOptions.getter(NativeApplicationOidcOptions::publicSigningKeyEndpoint)).setter(NativeApplicationOidcOptions.setter(Builder::publicSigningKeyEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicSigningKeyEndpoint").unmarshallLocationName("publicSigningKeyEndpoint").build()}).build();
    private static final SdkField<String> ISSUER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Issuer").getter(NativeApplicationOidcOptions.getter(NativeApplicationOidcOptions::issuer)).setter(NativeApplicationOidcOptions.setter(Builder::issuer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Issuer").unmarshallLocationName("issuer").build()}).build();
    private static final SdkField<String> AUTHORIZATION_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthorizationEndpoint").getter(NativeApplicationOidcOptions.getter(NativeApplicationOidcOptions::authorizationEndpoint)).setter(NativeApplicationOidcOptions.setter(Builder::authorizationEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationEndpoint").unmarshallLocationName("authorizationEndpoint").build()}).build();
    private static final SdkField<String> TOKEN_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TokenEndpoint").getter(NativeApplicationOidcOptions.getter(NativeApplicationOidcOptions::tokenEndpoint)).setter(NativeApplicationOidcOptions.setter(Builder::tokenEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenEndpoint").unmarshallLocationName("tokenEndpoint").build()}).build();
    private static final SdkField<String> USER_INFO_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserInfoEndpoint").getter(NativeApplicationOidcOptions.getter(NativeApplicationOidcOptions::userInfoEndpoint)).setter(NativeApplicationOidcOptions.setter(Builder::userInfoEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserInfoEndpoint").unmarshallLocationName("userInfoEndpoint").build()}).build();
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientId").getter(NativeApplicationOidcOptions.getter(NativeApplicationOidcOptions::clientId)).setter(NativeApplicationOidcOptions.setter(Builder::clientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").unmarshallLocationName("clientId").build()}).build();
    private static final SdkField<String> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scope").getter(NativeApplicationOidcOptions.getter(NativeApplicationOidcOptions::scope)).setter(NativeApplicationOidcOptions.setter(Builder::scope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").unmarshallLocationName("scope").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUBLIC_SIGNING_KEY_ENDPOINT_FIELD, ISSUER_FIELD, AUTHORIZATION_ENDPOINT_FIELD, TOKEN_ENDPOINT_FIELD, USER_INFO_ENDPOINT_FIELD, CLIENT_ID_FIELD, SCOPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NativeApplicationOidcOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String publicSigningKeyEndpoint;
    private final String issuer;
    private final String authorizationEndpoint;
    private final String tokenEndpoint;
    private final String userInfoEndpoint;
    private final String clientId;
    private final String scope;

    private NativeApplicationOidcOptions(BuilderImpl builder) {
        this.publicSigningKeyEndpoint = builder.publicSigningKeyEndpoint;
        this.issuer = builder.issuer;
        this.authorizationEndpoint = builder.authorizationEndpoint;
        this.tokenEndpoint = builder.tokenEndpoint;
        this.userInfoEndpoint = builder.userInfoEndpoint;
        this.clientId = builder.clientId;
        this.scope = builder.scope;
    }

    public final String publicSigningKeyEndpoint() {
        return this.publicSigningKeyEndpoint;
    }

    public final String issuer() {
        return this.issuer;
    }

    public final String authorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public final String tokenEndpoint() {
        return this.tokenEndpoint;
    }

    public final String userInfoEndpoint() {
        return this.userInfoEndpoint;
    }

    public final String clientId() {
        return this.clientId;
    }

    public final String scope() {
        return this.scope;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.publicSigningKeyEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.issuer());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.userInfoEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.scope());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NativeApplicationOidcOptions)) {
            return false;
        }
        NativeApplicationOidcOptions other = (NativeApplicationOidcOptions)obj;
        return Objects.equals(this.publicSigningKeyEndpoint(), other.publicSigningKeyEndpoint()) && Objects.equals(this.issuer(), other.issuer()) && Objects.equals(this.authorizationEndpoint(), other.authorizationEndpoint()) && Objects.equals(this.tokenEndpoint(), other.tokenEndpoint()) && Objects.equals(this.userInfoEndpoint(), other.userInfoEndpoint()) && Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.scope(), other.scope());
    }

    public final String toString() {
        return ToString.builder((String)"NativeApplicationOidcOptions").add("PublicSigningKeyEndpoint", (Object)this.publicSigningKeyEndpoint()).add("Issuer", (Object)this.issuer()).add("AuthorizationEndpoint", (Object)this.authorizationEndpoint()).add("TokenEndpoint", (Object)this.tokenEndpoint()).add("UserInfoEndpoint", (Object)this.userInfoEndpoint()).add("ClientId", (Object)this.clientId()).add("Scope", (Object)this.scope()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PublicSigningKeyEndpoint": {
                return Optional.ofNullable(clazz.cast(this.publicSigningKeyEndpoint()));
            }
            case "Issuer": {
                return Optional.ofNullable(clazz.cast(this.issuer()));
            }
            case "AuthorizationEndpoint": {
                return Optional.ofNullable(clazz.cast(this.authorizationEndpoint()));
            }
            case "TokenEndpoint": {
                return Optional.ofNullable(clazz.cast(this.tokenEndpoint()));
            }
            case "UserInfoEndpoint": {
                return Optional.ofNullable(clazz.cast(this.userInfoEndpoint()));
            }
            case "ClientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "Scope": {
                return Optional.ofNullable(clazz.cast(this.scope()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("PublicSigningKeyEndpoint", PUBLIC_SIGNING_KEY_ENDPOINT_FIELD);
        map.put("Issuer", ISSUER_FIELD);
        map.put("AuthorizationEndpoint", AUTHORIZATION_ENDPOINT_FIELD);
        map.put("TokenEndpoint", TOKEN_ENDPOINT_FIELD);
        map.put("UserInfoEndpoint", USER_INFO_ENDPOINT_FIELD);
        map.put("ClientId", CLIENT_ID_FIELD);
        map.put("Scope", SCOPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NativeApplicationOidcOptions, T> g) {
        return obj -> g.apply((NativeApplicationOidcOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String publicSigningKeyEndpoint;
        private String issuer;
        private String authorizationEndpoint;
        private String tokenEndpoint;
        private String userInfoEndpoint;
        private String clientId;
        private String scope;

        private BuilderImpl() {
        }

        private BuilderImpl(NativeApplicationOidcOptions model) {
            this.publicSigningKeyEndpoint(model.publicSigningKeyEndpoint);
            this.issuer(model.issuer);
            this.authorizationEndpoint(model.authorizationEndpoint);
            this.tokenEndpoint(model.tokenEndpoint);
            this.userInfoEndpoint(model.userInfoEndpoint);
            this.clientId(model.clientId);
            this.scope(model.scope);
        }

        public final String getPublicSigningKeyEndpoint() {
            return this.publicSigningKeyEndpoint;
        }

        public final void setPublicSigningKeyEndpoint(String publicSigningKeyEndpoint) {
            this.publicSigningKeyEndpoint = publicSigningKeyEndpoint;
        }

        @Override
        public final Builder publicSigningKeyEndpoint(String publicSigningKeyEndpoint) {
            this.publicSigningKeyEndpoint = publicSigningKeyEndpoint;
            return this;
        }

        public final String getIssuer() {
            return this.issuer;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final String getAuthorizationEndpoint() {
            return this.authorizationEndpoint;
        }

        public final void setAuthorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
        }

        @Override
        public final Builder authorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
            return this;
        }

        public final String getTokenEndpoint() {
            return this.tokenEndpoint;
        }

        public final void setTokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
        }

        @Override
        public final Builder tokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
            return this;
        }

        public final String getUserInfoEndpoint() {
            return this.userInfoEndpoint;
        }

        public final void setUserInfoEndpoint(String userInfoEndpoint) {
            this.userInfoEndpoint = userInfoEndpoint;
        }

        @Override
        public final Builder userInfoEndpoint(String userInfoEndpoint) {
            this.userInfoEndpoint = userInfoEndpoint;
            return this;
        }

        public final String getClientId() {
            return this.clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final String getScope() {
            return this.scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public NativeApplicationOidcOptions build() {
            return new NativeApplicationOidcOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NativeApplicationOidcOptions> {
        public Builder publicSigningKeyEndpoint(String var1);

        public Builder issuer(String var1);

        public Builder authorizationEndpoint(String var1);

        public Builder tokenEndpoint(String var1);

        public Builder userInfoEndpoint(String var1);

        public Builder clientId(String var1);

        public Builder scope(String var1);
    }
}

