/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.BundleIdStringListCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeBundleTasksRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DescribeBundleTasksRequest> {
    private static final SdkField<List<String>> BUNDLE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BundleIds").getter(DescribeBundleTasksRequest.getter(DescribeBundleTasksRequest::bundleIds)).setter(DescribeBundleTasksRequest.setter(Builder::bundleIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BundleId").unmarshallLocationName("BundleId").build(), ListTrait.builder().memberLocationName("BundleId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BundleId").unmarshallLocationName("BundleId").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(DescribeBundleTasksRequest.getter(DescribeBundleTasksRequest::dryRun)).setter(DescribeBundleTasksRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("dryRun").build()}).build();
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(DescribeBundleTasksRequest.getter(DescribeBundleTasksRequest::filters)).setter(DescribeBundleTasksRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build(), ListTrait.builder().memberLocationName("Filter").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUNDLE_IDS_FIELD, DRY_RUN_FIELD, FILTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeBundleTasksRequest.memberNameToFieldInitializer();
    private final List<String> bundleIds;
    private final Boolean dryRun;
    private final List<Filter> filters;

    private DescribeBundleTasksRequest(BuilderImpl builder) {
        super(builder);
        this.bundleIds = builder.bundleIds;
        this.dryRun = builder.dryRun;
        this.filters = builder.filters;
    }

    public final boolean hasBundleIds() {
        return this.bundleIds != null && !(this.bundleIds instanceof SdkAutoConstructList);
    }

    public final List<String> bundleIds() {
        return this.bundleIds;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<Filter> filters() {
        return this.filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBundleIds() ? this.bundleIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBundleTasksRequest)) {
            return false;
        }
        DescribeBundleTasksRequest other = (DescribeBundleTasksRequest)((Object)obj);
        return this.hasBundleIds() == other.hasBundleIds() && Objects.equals(this.bundleIds(), other.bundleIds()) && Objects.equals(this.dryRun(), other.dryRun()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeBundleTasksRequest").add("BundleIds", this.hasBundleIds() ? this.bundleIds() : null).add("DryRun", (Object)this.dryRun()).add("Filters", this.hasFilters() ? this.filters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BundleIds": {
                return Optional.ofNullable(clazz.cast(this.bundleIds()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BundleId", BUNDLE_IDS_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("Filter", FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeBundleTasksRequest, T> g) {
        return obj -> g.apply((DescribeBundleTasksRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<String> bundleIds = DefaultSdkAutoConstructList.getInstance();
        private Boolean dryRun;
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBundleTasksRequest model) {
            super(model);
            this.bundleIds(model.bundleIds);
            this.dryRun(model.dryRun);
            this.filters(model.filters);
        }

        public final Collection<String> getBundleIds() {
            if (this.bundleIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.bundleIds;
        }

        public final void setBundleIds(Collection<String> bundleIds) {
            this.bundleIds = BundleIdStringListCopier.copy(bundleIds);
        }

        @Override
        public final Builder bundleIds(Collection<String> bundleIds) {
            this.bundleIds = BundleIdStringListCopier.copy(bundleIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bundleIds(String ... bundleIds) {
            this.bundleIds(Arrays.asList(bundleIds));
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeBundleTasksRequest build() {
            return new DescribeBundleTasksRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeBundleTasksRequest> {
        public Builder bundleIds(Collection<String> var1);

        public Builder bundleIds(String ... var1);

        public Builder dryRun(Boolean var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

