/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetIpamDiscoveredAccountsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, GetIpamDiscoveredAccountsRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(GetIpamDiscoveredAccountsRequest.getter(GetIpamDiscoveredAccountsRequest::dryRun)).setter(GetIpamDiscoveredAccountsRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> IPAM_RESOURCE_DISCOVERY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamResourceDiscoveryId").getter(GetIpamDiscoveredAccountsRequest.getter(GetIpamDiscoveredAccountsRequest::ipamResourceDiscoveryId)).setter(GetIpamDiscoveredAccountsRequest.setter(Builder::ipamResourceDiscoveryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamResourceDiscoveryId").unmarshallLocationName("IpamResourceDiscoveryId").build()}).build();
    private static final SdkField<String> DISCOVERY_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DiscoveryRegion").getter(GetIpamDiscoveredAccountsRequest.getter(GetIpamDiscoveredAccountsRequest::discoveryRegion)).setter(GetIpamDiscoveredAccountsRequest.setter(Builder::discoveryRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscoveryRegion").unmarshallLocationName("DiscoveryRegion").build()}).build();
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(GetIpamDiscoveredAccountsRequest.getter(GetIpamDiscoveredAccountsRequest::filters)).setter(GetIpamDiscoveredAccountsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build(), ListTrait.builder().memberLocationName("Filter").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetIpamDiscoveredAccountsRequest.getter(GetIpamDiscoveredAccountsRequest::nextToken)).setter(GetIpamDiscoveredAccountsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetIpamDiscoveredAccountsRequest.getter(GetIpamDiscoveredAccountsRequest::maxResults)).setter(GetIpamDiscoveredAccountsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").unmarshallLocationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, IPAM_RESOURCE_DISCOVERY_ID_FIELD, DISCOVERY_REGION_FIELD, FILTERS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetIpamDiscoveredAccountsRequest.memberNameToFieldInitializer();
    private final Boolean dryRun;
    private final String ipamResourceDiscoveryId;
    private final String discoveryRegion;
    private final List<Filter> filters;
    private final String nextToken;
    private final Integer maxResults;

    private GetIpamDiscoveredAccountsRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.ipamResourceDiscoveryId = builder.ipamResourceDiscoveryId;
        this.discoveryRegion = builder.discoveryRegion;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String ipamResourceDiscoveryId() {
        return this.ipamResourceDiscoveryId;
    }

    public final String discoveryRegion() {
        return this.discoveryRegion;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<Filter> filters() {
        return this.filters;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamResourceDiscoveryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.discoveryRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIpamDiscoveredAccountsRequest)) {
            return false;
        }
        GetIpamDiscoveredAccountsRequest other = (GetIpamDiscoveredAccountsRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.ipamResourceDiscoveryId(), other.ipamResourceDiscoveryId()) && Objects.equals(this.discoveryRegion(), other.discoveryRegion()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"GetIpamDiscoveredAccountsRequest").add("DryRun", (Object)this.dryRun()).add("IpamResourceDiscoveryId", (Object)this.ipamResourceDiscoveryId()).add("DiscoveryRegion", (Object)this.discoveryRegion()).add("Filters", this.hasFilters() ? this.filters() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "IpamResourceDiscoveryId": {
                return Optional.ofNullable(clazz.cast(this.ipamResourceDiscoveryId()));
            }
            case "DiscoveryRegion": {
                return Optional.ofNullable(clazz.cast(this.discoveryRegion()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("IpamResourceDiscoveryId", IPAM_RESOURCE_DISCOVERY_ID_FIELD);
        map.put("DiscoveryRegion", DISCOVERY_REGION_FIELD);
        map.put("Filter", FILTERS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetIpamDiscoveredAccountsRequest, T> g) {
        return obj -> g.apply((GetIpamDiscoveredAccountsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private String ipamResourceDiscoveryId;
        private String discoveryRegion;
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIpamDiscoveredAccountsRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.ipamResourceDiscoveryId(model.ipamResourceDiscoveryId);
            this.discoveryRegion(model.discoveryRegion);
            this.filters(model.filters);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getIpamResourceDiscoveryId() {
            return this.ipamResourceDiscoveryId;
        }

        public final void setIpamResourceDiscoveryId(String ipamResourceDiscoveryId) {
            this.ipamResourceDiscoveryId = ipamResourceDiscoveryId;
        }

        @Override
        public final Builder ipamResourceDiscoveryId(String ipamResourceDiscoveryId) {
            this.ipamResourceDiscoveryId = ipamResourceDiscoveryId;
            return this;
        }

        public final String getDiscoveryRegion() {
            return this.discoveryRegion;
        }

        public final void setDiscoveryRegion(String discoveryRegion) {
            this.discoveryRegion = discoveryRegion;
        }

        @Override
        public final Builder discoveryRegion(String discoveryRegion) {
            this.discoveryRegion = discoveryRegion;
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetIpamDiscoveredAccountsRequest build() {
            return new GetIpamDiscoveredAccountsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetIpamDiscoveredAccountsRequest> {
        public Builder dryRun(Boolean var1);

        public Builder ipamResourceDiscoveryId(String var1);

        public Builder discoveryRegion(String var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

