/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum KeyFormat {
    PEM("pem"),
    PPK("ppk"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, KeyFormat> VALUE_MAP;
    private final String value;

    private KeyFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static KeyFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<KeyFormat> knownValues() {
        EnumSet<KeyFormat> knownValues = EnumSet.allOf(KeyFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(KeyFormat.class, KeyFormat::toString);
    }
}

