/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.InstanceTypeListCopier;
import software.amazon.awssdk.services.ec2.model.ProductDescriptionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSpotPriceHistoryRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DescribeSpotPriceHistoryRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(DescribeSpotPriceHistoryRequest.getter(DescribeSpotPriceHistoryRequest::dryRun)).setter(DescribeSpotPriceHistoryRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("dryRun").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(DescribeSpotPriceHistoryRequest.getter(DescribeSpotPriceHistoryRequest::startTime)).setter(DescribeSpotPriceHistoryRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").unmarshallLocationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(DescribeSpotPriceHistoryRequest.getter(DescribeSpotPriceHistoryRequest::endTime)).setter(DescribeSpotPriceHistoryRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").unmarshallLocationName("endTime").build()}).build();
    private static final SdkField<List<String>> INSTANCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceTypes").getter(DescribeSpotPriceHistoryRequest.getter(DescribeSpotPriceHistoryRequest::instanceTypesAsStrings)).setter(DescribeSpotPriceHistoryRequest.setter(Builder::instanceTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").unmarshallLocationName("InstanceType").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PRODUCT_DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProductDescriptions").getter(DescribeSpotPriceHistoryRequest.getter(DescribeSpotPriceHistoryRequest::productDescriptions)).setter(DescribeSpotPriceHistoryRequest.setter(Builder::productDescriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductDescription").unmarshallLocationName("ProductDescription").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(DescribeSpotPriceHistoryRequest.getter(DescribeSpotPriceHistoryRequest::filters)).setter(DescribeSpotPriceHistoryRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build(), ListTrait.builder().memberLocationName("Filter").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build()}).build()).build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(DescribeSpotPriceHistoryRequest.getter(DescribeSpotPriceHistoryRequest::availabilityZone)).setter(DescribeSpotPriceHistoryRequest.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("availabilityZone").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeSpotPriceHistoryRequest.getter(DescribeSpotPriceHistoryRequest::maxResults)).setter(DescribeSpotPriceHistoryRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").unmarshallLocationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeSpotPriceHistoryRequest.getter(DescribeSpotPriceHistoryRequest::nextToken)).setter(DescribeSpotPriceHistoryRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, START_TIME_FIELD, END_TIME_FIELD, INSTANCE_TYPES_FIELD, PRODUCT_DESCRIPTIONS_FIELD, FILTERS_FIELD, AVAILABILITY_ZONE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeSpotPriceHistoryRequest.memberNameToFieldInitializer();
    private final Boolean dryRun;
    private final Instant startTime;
    private final Instant endTime;
    private final List<String> instanceTypes;
    private final List<String> productDescriptions;
    private final List<Filter> filters;
    private final String availabilityZone;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeSpotPriceHistoryRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.instanceTypes = builder.instanceTypes;
        this.productDescriptions = builder.productDescriptions;
        this.filters = builder.filters;
        this.availabilityZone = builder.availabilityZone;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final List<InstanceType> instanceTypes() {
        return InstanceTypeListCopier.copyStringToEnum(this.instanceTypes);
    }

    public final boolean hasInstanceTypes() {
        return this.instanceTypes != null && !(this.instanceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> instanceTypesAsStrings() {
        return this.instanceTypes;
    }

    public final boolean hasProductDescriptions() {
        return this.productDescriptions != null && !(this.productDescriptions instanceof SdkAutoConstructList);
    }

    public final List<String> productDescriptions() {
        return this.productDescriptions;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<Filter> filters() {
        return this.filters;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceTypes() ? this.instanceTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProductDescriptions() ? this.productDescriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSpotPriceHistoryRequest)) {
            return false;
        }
        DescribeSpotPriceHistoryRequest other = (DescribeSpotPriceHistoryRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && this.hasInstanceTypes() == other.hasInstanceTypes() && Objects.equals(this.instanceTypesAsStrings(), other.instanceTypesAsStrings()) && this.hasProductDescriptions() == other.hasProductDescriptions() && Objects.equals(this.productDescriptions(), other.productDescriptions()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeSpotPriceHistoryRequest").add("DryRun", (Object)this.dryRun()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("InstanceTypes", this.hasInstanceTypes() ? this.instanceTypesAsStrings() : null).add("ProductDescriptions", this.hasProductDescriptions() ? this.productDescriptions() : null).add("Filters", this.hasFilters() ? this.filters() : null).add("AvailabilityZone", (Object)this.availabilityZone()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "InstanceTypes": {
                return Optional.ofNullable(clazz.cast(this.instanceTypesAsStrings()));
            }
            case "ProductDescriptions": {
                return Optional.ofNullable(clazz.cast(this.productDescriptions()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("InstanceType", INSTANCE_TYPES_FIELD);
        map.put("ProductDescription", PRODUCT_DESCRIPTIONS_FIELD);
        map.put("Filter", FILTERS_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeSpotPriceHistoryRequest, T> g) {
        return obj -> g.apply((DescribeSpotPriceHistoryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private Instant startTime;
        private Instant endTime;
        private List<String> instanceTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> productDescriptions = DefaultSdkAutoConstructList.getInstance();
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();
        private String availabilityZone;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSpotPriceHistoryRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.instanceTypesWithStrings(model.instanceTypes);
            this.productDescriptions(model.productDescriptions);
            this.filters(model.filters);
            this.availabilityZone(model.availabilityZone);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Collection<String> getInstanceTypes() {
            if (this.instanceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instanceTypes;
        }

        public final void setInstanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = InstanceTypeListCopier.copy(instanceTypes);
        }

        @Override
        public final Builder instanceTypesWithStrings(Collection<String> instanceTypes) {
            this.instanceTypes = InstanceTypeListCopier.copy(instanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypesWithStrings(String ... instanceTypes) {
            this.instanceTypesWithStrings(Arrays.asList(instanceTypes));
            return this;
        }

        @Override
        public final Builder instanceTypes(Collection<InstanceType> instanceTypes) {
            this.instanceTypes = InstanceTypeListCopier.copyEnumToString(instanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypes(InstanceType ... instanceTypes) {
            this.instanceTypes(Arrays.asList(instanceTypes));
            return this;
        }

        public final Collection<String> getProductDescriptions() {
            if (this.productDescriptions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.productDescriptions;
        }

        public final void setProductDescriptions(Collection<String> productDescriptions) {
            this.productDescriptions = ProductDescriptionListCopier.copy(productDescriptions);
        }

        @Override
        public final Builder productDescriptions(Collection<String> productDescriptions) {
            this.productDescriptions = ProductDescriptionListCopier.copy(productDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productDescriptions(String ... productDescriptions) {
            this.productDescriptions(Arrays.asList(productDescriptions));
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeSpotPriceHistoryRequest build() {
            return new DescribeSpotPriceHistoryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSpotPriceHistoryRequest> {
        public Builder dryRun(Boolean var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder instanceTypesWithStrings(Collection<String> var1);

        public Builder instanceTypesWithStrings(String ... var1);

        public Builder instanceTypes(Collection<InstanceType> var1);

        public Builder instanceTypes(InstanceType ... var1);

        public Builder productDescriptions(Collection<String> var1);

        public Builder productDescriptions(String ... var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder availabilityZone(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

