/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesModificationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesModificationsResponse;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesModification;

public class DescribeReservedInstancesModificationsPublisher
implements SdkPublisher<DescribeReservedInstancesModificationsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeReservedInstancesModificationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeReservedInstancesModificationsPublisher(Ec2AsyncClient client, DescribeReservedInstancesModificationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeReservedInstancesModificationsPublisher(Ec2AsyncClient client, DescribeReservedInstancesModificationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeReservedInstancesModificationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeReservedInstancesModificationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ReservedInstancesModification> reservedInstancesModifications() {
        Function<DescribeReservedInstancesModificationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.reservedInstancesModifications() != null) {
                return response.reservedInstancesModifications().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeReservedInstancesModificationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeReservedInstancesModificationsResponseFetcher
    implements AsyncPageFetcher<DescribeReservedInstancesModificationsResponse> {
        private DescribeReservedInstancesModificationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedInstancesModificationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeReservedInstancesModificationsResponse> nextPage(DescribeReservedInstancesModificationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedInstancesModificationsPublisher.this.client.describeReservedInstancesModifications(DescribeReservedInstancesModificationsPublisher.this.firstRequest);
            }
            return DescribeReservedInstancesModificationsPublisher.this.client.describeReservedInstancesModifications((DescribeReservedInstancesModificationsRequest)((Object)DescribeReservedInstancesModificationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

