/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.PortRange;
import software.amazon.awssdk.services.ec2.model.PortRangeListCopier;
import software.amazon.awssdk.services.ec2.model.ProtocolIntListCopier;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FirewallStatelessRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FirewallStatelessRule> {
    private static final SdkField<String> RULE_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleGroupArn").getter(FirewallStatelessRule.getter(FirewallStatelessRule::ruleGroupArn)).setter(FirewallStatelessRule.setter(Builder::ruleGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupArn").unmarshallLocationName("ruleGroupArn").build()}).build();
    private static final SdkField<List<String>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Sources").getter(FirewallStatelessRule.getter(FirewallStatelessRule::sources)).setter(FirewallStatelessRule.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceSet").unmarshallLocationName("sourceSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Destinations").getter(FirewallStatelessRule.getter(FirewallStatelessRule::destinations)).setter(FirewallStatelessRule.setter(Builder::destinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationSet").unmarshallLocationName("destinationSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<PortRange>> SOURCE_PORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SourcePorts").getter(FirewallStatelessRule.getter(FirewallStatelessRule::sourcePorts)).setter(FirewallStatelessRule.setter(Builder::sourcePorts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePortSet").unmarshallLocationName("sourcePortSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PortRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<PortRange>> DESTINATION_PORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DestinationPorts").getter(FirewallStatelessRule.getter(FirewallStatelessRule::destinationPorts)).setter(FirewallStatelessRule.setter(Builder::destinationPorts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPortSet").unmarshallLocationName("destinationPortSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PortRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<Integer>> PROTOCOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Protocols").getter(FirewallStatelessRule.getter(FirewallStatelessRule::protocols)).setter(FirewallStatelessRule.setter(Builder::protocols)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtocolSet").unmarshallLocationName("protocolSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> RULE_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleAction").getter(FirewallStatelessRule.getter(FirewallStatelessRule::ruleAction)).setter(FirewallStatelessRule.setter(Builder::ruleAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleAction").unmarshallLocationName("ruleAction").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Priority").getter(FirewallStatelessRule.getter(FirewallStatelessRule::priority)).setter(FirewallStatelessRule.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").unmarshallLocationName("priority").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_GROUP_ARN_FIELD, SOURCES_FIELD, DESTINATIONS_FIELD, SOURCE_PORTS_FIELD, DESTINATION_PORTS_FIELD, PROTOCOLS_FIELD, RULE_ACTION_FIELD, PRIORITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FirewallStatelessRule.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String ruleGroupArn;
    private final List<String> sources;
    private final List<String> destinations;
    private final List<PortRange> sourcePorts;
    private final List<PortRange> destinationPorts;
    private final List<Integer> protocols;
    private final String ruleAction;
    private final Integer priority;

    private FirewallStatelessRule(BuilderImpl builder) {
        this.ruleGroupArn = builder.ruleGroupArn;
        this.sources = builder.sources;
        this.destinations = builder.destinations;
        this.sourcePorts = builder.sourcePorts;
        this.destinationPorts = builder.destinationPorts;
        this.protocols = builder.protocols;
        this.ruleAction = builder.ruleAction;
        this.priority = builder.priority;
    }

    public final String ruleGroupArn() {
        return this.ruleGroupArn;
    }

    public final boolean hasSources() {
        return this.sources != null && !(this.sources instanceof SdkAutoConstructList);
    }

    public final List<String> sources() {
        return this.sources;
    }

    public final boolean hasDestinations() {
        return this.destinations != null && !(this.destinations instanceof SdkAutoConstructList);
    }

    public final List<String> destinations() {
        return this.destinations;
    }

    public final boolean hasSourcePorts() {
        return this.sourcePorts != null && !(this.sourcePorts instanceof SdkAutoConstructList);
    }

    public final List<PortRange> sourcePorts() {
        return this.sourcePorts;
    }

    public final boolean hasDestinationPorts() {
        return this.destinationPorts != null && !(this.destinationPorts instanceof SdkAutoConstructList);
    }

    public final List<PortRange> destinationPorts() {
        return this.destinationPorts;
    }

    public final boolean hasProtocols() {
        return this.protocols != null && !(this.protocols instanceof SdkAutoConstructList);
    }

    public final List<Integer> protocols() {
        return this.protocols;
    }

    public final String ruleAction() {
        return this.ruleAction;
    }

    public final Integer priority() {
        return this.priority;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSources() ? this.sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinations() ? this.destinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourcePorts() ? this.sourcePorts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinationPorts() ? this.destinationPorts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProtocols() ? this.protocols() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirewallStatelessRule)) {
            return false;
        }
        FirewallStatelessRule other = (FirewallStatelessRule)obj;
        return Objects.equals(this.ruleGroupArn(), other.ruleGroupArn()) && this.hasSources() == other.hasSources() && Objects.equals(this.sources(), other.sources()) && this.hasDestinations() == other.hasDestinations() && Objects.equals(this.destinations(), other.destinations()) && this.hasSourcePorts() == other.hasSourcePorts() && Objects.equals(this.sourcePorts(), other.sourcePorts()) && this.hasDestinationPorts() == other.hasDestinationPorts() && Objects.equals(this.destinationPorts(), other.destinationPorts()) && this.hasProtocols() == other.hasProtocols() && Objects.equals(this.protocols(), other.protocols()) && Objects.equals(this.ruleAction(), other.ruleAction()) && Objects.equals(this.priority(), other.priority());
    }

    public final String toString() {
        return ToString.builder((String)"FirewallStatelessRule").add("RuleGroupArn", (Object)this.ruleGroupArn()).add("Sources", this.hasSources() ? this.sources() : null).add("Destinations", this.hasDestinations() ? this.destinations() : null).add("SourcePorts", this.hasSourcePorts() ? this.sourcePorts() : null).add("DestinationPorts", this.hasDestinationPorts() ? this.destinationPorts() : null).add("Protocols", this.hasProtocols() ? this.protocols() : null).add("RuleAction", (Object)this.ruleAction()).add("Priority", (Object)this.priority()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleGroupArn": {
                return Optional.ofNullable(clazz.cast(this.ruleGroupArn()));
            }
            case "Sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
            case "Destinations": {
                return Optional.ofNullable(clazz.cast(this.destinations()));
            }
            case "SourcePorts": {
                return Optional.ofNullable(clazz.cast(this.sourcePorts()));
            }
            case "DestinationPorts": {
                return Optional.ofNullable(clazz.cast(this.destinationPorts()));
            }
            case "Protocols": {
                return Optional.ofNullable(clazz.cast(this.protocols()));
            }
            case "RuleAction": {
                return Optional.ofNullable(clazz.cast(this.ruleAction()));
            }
            case "Priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RuleGroupArn", RULE_GROUP_ARN_FIELD);
        map.put("SourceSet", SOURCES_FIELD);
        map.put("DestinationSet", DESTINATIONS_FIELD);
        map.put("SourcePortSet", SOURCE_PORTS_FIELD);
        map.put("DestinationPortSet", DESTINATION_PORTS_FIELD);
        map.put("ProtocolSet", PROTOCOLS_FIELD);
        map.put("RuleAction", RULE_ACTION_FIELD);
        map.put("Priority", PRIORITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FirewallStatelessRule, T> g) {
        return obj -> g.apply((FirewallStatelessRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ruleGroupArn;
        private List<String> sources = DefaultSdkAutoConstructList.getInstance();
        private List<String> destinations = DefaultSdkAutoConstructList.getInstance();
        private List<PortRange> sourcePorts = DefaultSdkAutoConstructList.getInstance();
        private List<PortRange> destinationPorts = DefaultSdkAutoConstructList.getInstance();
        private List<Integer> protocols = DefaultSdkAutoConstructList.getInstance();
        private String ruleAction;
        private Integer priority;

        private BuilderImpl() {
        }

        private BuilderImpl(FirewallStatelessRule model) {
            this.ruleGroupArn(model.ruleGroupArn);
            this.sources(model.sources);
            this.destinations(model.destinations);
            this.sourcePorts(model.sourcePorts);
            this.destinationPorts(model.destinationPorts);
            this.protocols(model.protocols);
            this.ruleAction(model.ruleAction);
            this.priority(model.priority);
        }

        public final String getRuleGroupArn() {
            return this.ruleGroupArn;
        }

        public final void setRuleGroupArn(String ruleGroupArn) {
            this.ruleGroupArn = ruleGroupArn;
        }

        @Override
        public final Builder ruleGroupArn(String ruleGroupArn) {
            this.ruleGroupArn = ruleGroupArn;
            return this;
        }

        public final Collection<String> getSources() {
            if (this.sources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sources;
        }

        public final void setSources(Collection<String> sources) {
            this.sources = ValueStringListCopier.copy(sources);
        }

        @Override
        public final Builder sources(Collection<String> sources) {
            this.sources = ValueStringListCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(String ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        public final Collection<String> getDestinations() {
            if (this.destinations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.destinations;
        }

        public final void setDestinations(Collection<String> destinations) {
            this.destinations = ValueStringListCopier.copy(destinations);
        }

        @Override
        public final Builder destinations(Collection<String> destinations) {
            this.destinations = ValueStringListCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(String ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        public final List<PortRange.Builder> getSourcePorts() {
            List<PortRange.Builder> result = PortRangeListCopier.copyToBuilder(this.sourcePorts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourcePorts(Collection<PortRange.BuilderImpl> sourcePorts) {
            this.sourcePorts = PortRangeListCopier.copyFromBuilder(sourcePorts);
        }

        @Override
        public final Builder sourcePorts(Collection<PortRange> sourcePorts) {
            this.sourcePorts = PortRangeListCopier.copy(sourcePorts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourcePorts(PortRange ... sourcePorts) {
            this.sourcePorts(Arrays.asList(sourcePorts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourcePorts(Consumer<PortRange.Builder> ... sourcePorts) {
            this.sourcePorts(Stream.of(sourcePorts).map(c -> (PortRange)((PortRange.Builder)PortRange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PortRange.Builder> getDestinationPorts() {
            List<PortRange.Builder> result = PortRangeListCopier.copyToBuilder(this.destinationPorts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinationPorts(Collection<PortRange.BuilderImpl> destinationPorts) {
            this.destinationPorts = PortRangeListCopier.copyFromBuilder(destinationPorts);
        }

        @Override
        public final Builder destinationPorts(Collection<PortRange> destinationPorts) {
            this.destinationPorts = PortRangeListCopier.copy(destinationPorts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationPorts(PortRange ... destinationPorts) {
            this.destinationPorts(Arrays.asList(destinationPorts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationPorts(Consumer<PortRange.Builder> ... destinationPorts) {
            this.destinationPorts(Stream.of(destinationPorts).map(c -> (PortRange)((PortRange.Builder)PortRange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<Integer> getProtocols() {
            if (this.protocols instanceof SdkAutoConstructList) {
                return null;
            }
            return this.protocols;
        }

        public final void setProtocols(Collection<Integer> protocols) {
            this.protocols = ProtocolIntListCopier.copy(protocols);
        }

        @Override
        public final Builder protocols(Collection<Integer> protocols) {
            this.protocols = ProtocolIntListCopier.copy(protocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocols(Integer ... protocols) {
            this.protocols(Arrays.asList(protocols));
            return this;
        }

        public final String getRuleAction() {
            return this.ruleAction;
        }

        public final void setRuleAction(String ruleAction) {
            this.ruleAction = ruleAction;
        }

        @Override
        public final Builder ruleAction(String ruleAction) {
            this.ruleAction = ruleAction;
            return this;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public FirewallStatelessRule build() {
            return new FirewallStatelessRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FirewallStatelessRule> {
        public Builder ruleGroupArn(String var1);

        public Builder sources(Collection<String> var1);

        public Builder sources(String ... var1);

        public Builder destinations(Collection<String> var1);

        public Builder destinations(String ... var1);

        public Builder sourcePorts(Collection<PortRange> var1);

        public Builder sourcePorts(PortRange ... var1);

        public Builder sourcePorts(Consumer<PortRange.Builder> ... var1);

        public Builder destinationPorts(Collection<PortRange> var1);

        public Builder destinationPorts(PortRange ... var1);

        public Builder destinationPorts(Consumer<PortRange.Builder> ... var1);

        public Builder protocols(Collection<Integer> var1);

        public Builder protocols(Integer ... var1);

        public Builder ruleAction(String var1);

        public Builder priority(Integer var1);
    }
}

