/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.FilterPortRange;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PathFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PathFilter> {
    private static final SdkField<String> SOURCE_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceAddress").getter(PathFilter.getter(PathFilter::sourceAddress)).setter(PathFilter.setter(Builder::sourceAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceAddress").unmarshallLocationName("sourceAddress").build()}).build();
    private static final SdkField<FilterPortRange> SOURCE_PORT_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourcePortRange").getter(PathFilter.getter(PathFilter::sourcePortRange)).setter(PathFilter.setter(Builder::sourcePortRange)).constructor(FilterPortRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePortRange").unmarshallLocationName("sourcePortRange").build()}).build();
    private static final SdkField<String> DESTINATION_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationAddress").getter(PathFilter.getter(PathFilter::destinationAddress)).setter(PathFilter.setter(Builder::destinationAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationAddress").unmarshallLocationName("destinationAddress").build()}).build();
    private static final SdkField<FilterPortRange> DESTINATION_PORT_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationPortRange").getter(PathFilter.getter(PathFilter::destinationPortRange)).setter(PathFilter.setter(Builder::destinationPortRange)).constructor(FilterPortRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPortRange").unmarshallLocationName("destinationPortRange").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ADDRESS_FIELD, SOURCE_PORT_RANGE_FIELD, DESTINATION_ADDRESS_FIELD, DESTINATION_PORT_RANGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PathFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String sourceAddress;
    private final FilterPortRange sourcePortRange;
    private final String destinationAddress;
    private final FilterPortRange destinationPortRange;

    private PathFilter(BuilderImpl builder) {
        this.sourceAddress = builder.sourceAddress;
        this.sourcePortRange = builder.sourcePortRange;
        this.destinationAddress = builder.destinationAddress;
        this.destinationPortRange = builder.destinationPortRange;
    }

    public final String sourceAddress() {
        return this.sourceAddress;
    }

    public final FilterPortRange sourcePortRange() {
        return this.sourcePortRange;
    }

    public final String destinationAddress() {
        return this.destinationAddress;
    }

    public final FilterPortRange destinationPortRange() {
        return this.destinationPortRange;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourcePortRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPortRange());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PathFilter)) {
            return false;
        }
        PathFilter other = (PathFilter)obj;
        return Objects.equals(this.sourceAddress(), other.sourceAddress()) && Objects.equals(this.sourcePortRange(), other.sourcePortRange()) && Objects.equals(this.destinationAddress(), other.destinationAddress()) && Objects.equals(this.destinationPortRange(), other.destinationPortRange());
    }

    public final String toString() {
        return ToString.builder((String)"PathFilter").add("SourceAddress", (Object)this.sourceAddress()).add("SourcePortRange", (Object)this.sourcePortRange()).add("DestinationAddress", (Object)this.destinationAddress()).add("DestinationPortRange", (Object)this.destinationPortRange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceAddress": {
                return Optional.ofNullable(clazz.cast(this.sourceAddress()));
            }
            case "SourcePortRange": {
                return Optional.ofNullable(clazz.cast(this.sourcePortRange()));
            }
            case "DestinationAddress": {
                return Optional.ofNullable(clazz.cast(this.destinationAddress()));
            }
            case "DestinationPortRange": {
                return Optional.ofNullable(clazz.cast(this.destinationPortRange()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SourceAddress", SOURCE_ADDRESS_FIELD);
        map.put("SourcePortRange", SOURCE_PORT_RANGE_FIELD);
        map.put("DestinationAddress", DESTINATION_ADDRESS_FIELD);
        map.put("DestinationPortRange", DESTINATION_PORT_RANGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PathFilter, T> g) {
        return obj -> g.apply((PathFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceAddress;
        private FilterPortRange sourcePortRange;
        private String destinationAddress;
        private FilterPortRange destinationPortRange;

        private BuilderImpl() {
        }

        private BuilderImpl(PathFilter model) {
            this.sourceAddress(model.sourceAddress);
            this.sourcePortRange(model.sourcePortRange);
            this.destinationAddress(model.destinationAddress);
            this.destinationPortRange(model.destinationPortRange);
        }

        public final String getSourceAddress() {
            return this.sourceAddress;
        }

        public final void setSourceAddress(String sourceAddress) {
            this.sourceAddress = sourceAddress;
        }

        @Override
        public final Builder sourceAddress(String sourceAddress) {
            this.sourceAddress = sourceAddress;
            return this;
        }

        public final FilterPortRange.Builder getSourcePortRange() {
            return this.sourcePortRange != null ? this.sourcePortRange.toBuilder() : null;
        }

        public final void setSourcePortRange(FilterPortRange.BuilderImpl sourcePortRange) {
            this.sourcePortRange = sourcePortRange != null ? sourcePortRange.build() : null;
        }

        @Override
        public final Builder sourcePortRange(FilterPortRange sourcePortRange) {
            this.sourcePortRange = sourcePortRange;
            return this;
        }

        public final String getDestinationAddress() {
            return this.destinationAddress;
        }

        public final void setDestinationAddress(String destinationAddress) {
            this.destinationAddress = destinationAddress;
        }

        @Override
        public final Builder destinationAddress(String destinationAddress) {
            this.destinationAddress = destinationAddress;
            return this;
        }

        public final FilterPortRange.Builder getDestinationPortRange() {
            return this.destinationPortRange != null ? this.destinationPortRange.toBuilder() : null;
        }

        public final void setDestinationPortRange(FilterPortRange.BuilderImpl destinationPortRange) {
            this.destinationPortRange = destinationPortRange != null ? destinationPortRange.build() : null;
        }

        @Override
        public final Builder destinationPortRange(FilterPortRange destinationPortRange) {
            this.destinationPortRange = destinationPortRange;
            return this;
        }

        public PathFilter build() {
            return new PathFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PathFilter> {
        public Builder sourceAddress(String var1);

        public Builder sourcePortRange(FilterPortRange var1);

        default public Builder sourcePortRange(Consumer<FilterPortRange.Builder> sourcePortRange) {
            return this.sourcePortRange((FilterPortRange)((FilterPortRange.Builder)FilterPortRange.builder().applyMutation(sourcePortRange)).build());
        }

        public Builder destinationAddress(String var1);

        public Builder destinationPortRange(FilterPortRange var1);

        default public Builder destinationPortRange(Consumer<FilterPortRange.Builder> destinationPortRange) {
            return this.destinationPortRange((FilterPortRange)((FilterPortRange.Builder)FilterPortRange.builder().applyMutation(destinationPortRange)).build());
        }
    }
}

