/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.IpPrefixListCopier;
import software.amazon.awssdk.services.ec2.model.Ipv6AddressListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UnassignIpv6AddressesRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, UnassignIpv6AddressesRequest> {
    private static final SdkField<List<String>> IPV6_PREFIXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ipv6Prefixes").getter(UnassignIpv6AddressesRequest.getter(UnassignIpv6AddressesRequest::ipv6Prefixes)).setter(UnassignIpv6AddressesRequest.setter(Builder::ipv6Prefixes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Prefix").unmarshallLocationName("Ipv6Prefix").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceId").getter(UnassignIpv6AddressesRequest.getter(UnassignIpv6AddressesRequest::networkInterfaceId)).setter(UnassignIpv6AddressesRequest.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").unmarshallLocationName("networkInterfaceId").build()}).build();
    private static final SdkField<List<String>> IPV6_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ipv6Addresses").getter(UnassignIpv6AddressesRequest.getter(UnassignIpv6AddressesRequest::ipv6Addresses)).setter(UnassignIpv6AddressesRequest.setter(Builder::ipv6Addresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Addresses").unmarshallLocationName("ipv6Addresses").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPV6_PREFIXES_FIELD, NETWORK_INTERFACE_ID_FIELD, IPV6_ADDRESSES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UnassignIpv6AddressesRequest.memberNameToFieldInitializer();
    private final List<String> ipv6Prefixes;
    private final String networkInterfaceId;
    private final List<String> ipv6Addresses;

    private UnassignIpv6AddressesRequest(BuilderImpl builder) {
        super(builder);
        this.ipv6Prefixes = builder.ipv6Prefixes;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.ipv6Addresses = builder.ipv6Addresses;
    }

    public final boolean hasIpv6Prefixes() {
        return this.ipv6Prefixes != null && !(this.ipv6Prefixes instanceof SdkAutoConstructList);
    }

    public final List<String> ipv6Prefixes() {
        return this.ipv6Prefixes;
    }

    public final String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public final boolean hasIpv6Addresses() {
        return this.ipv6Addresses != null && !(this.ipv6Addresses instanceof SdkAutoConstructList);
    }

    public final List<String> ipv6Addresses() {
        return this.ipv6Addresses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpv6Prefixes() ? this.ipv6Prefixes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpv6Addresses() ? this.ipv6Addresses() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnassignIpv6AddressesRequest)) {
            return false;
        }
        UnassignIpv6AddressesRequest other = (UnassignIpv6AddressesRequest)((Object)obj);
        return this.hasIpv6Prefixes() == other.hasIpv6Prefixes() && Objects.equals(this.ipv6Prefixes(), other.ipv6Prefixes()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && this.hasIpv6Addresses() == other.hasIpv6Addresses() && Objects.equals(this.ipv6Addresses(), other.ipv6Addresses());
    }

    public final String toString() {
        return ToString.builder((String)"UnassignIpv6AddressesRequest").add("Ipv6Prefixes", this.hasIpv6Prefixes() ? this.ipv6Prefixes() : null).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("Ipv6Addresses", this.hasIpv6Addresses() ? this.ipv6Addresses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Ipv6Prefixes": {
                return Optional.ofNullable(clazz.cast(this.ipv6Prefixes()));
            }
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "Ipv6Addresses": {
                return Optional.ofNullable(clazz.cast(this.ipv6Addresses()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Ipv6Prefix", IPV6_PREFIXES_FIELD);
        map.put("NetworkInterfaceId", NETWORK_INTERFACE_ID_FIELD);
        map.put("Ipv6Addresses", IPV6_ADDRESSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UnassignIpv6AddressesRequest, T> g) {
        return obj -> g.apply((UnassignIpv6AddressesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<String> ipv6Prefixes = DefaultSdkAutoConstructList.getInstance();
        private String networkInterfaceId;
        private List<String> ipv6Addresses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UnassignIpv6AddressesRequest model) {
            super(model);
            this.ipv6Prefixes(model.ipv6Prefixes);
            this.networkInterfaceId(model.networkInterfaceId);
            this.ipv6Addresses(model.ipv6Addresses);
        }

        public final Collection<String> getIpv6Prefixes() {
            if (this.ipv6Prefixes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ipv6Prefixes;
        }

        public final void setIpv6Prefixes(Collection<String> ipv6Prefixes) {
            this.ipv6Prefixes = IpPrefixListCopier.copy(ipv6Prefixes);
        }

        @Override
        public final Builder ipv6Prefixes(Collection<String> ipv6Prefixes) {
            this.ipv6Prefixes = IpPrefixListCopier.copy(ipv6Prefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Prefixes(String ... ipv6Prefixes) {
            this.ipv6Prefixes(Arrays.asList(ipv6Prefixes));
            return this;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final Collection<String> getIpv6Addresses() {
            if (this.ipv6Addresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ipv6Addresses;
        }

        public final void setIpv6Addresses(Collection<String> ipv6Addresses) {
            this.ipv6Addresses = Ipv6AddressListCopier.copy(ipv6Addresses);
        }

        @Override
        public final Builder ipv6Addresses(Collection<String> ipv6Addresses) {
            this.ipv6Addresses = Ipv6AddressListCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(String ... ipv6Addresses) {
            this.ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UnassignIpv6AddressesRequest build() {
            return new UnassignIpv6AddressesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UnassignIpv6AddressesRequest> {
        public Builder ipv6Prefixes(Collection<String> var1);

        public Builder ipv6Prefixes(String ... var1);

        public Builder networkInterfaceId(String var1);

        public Builder ipv6Addresses(Collection<String> var1);

        public Builder ipv6Addresses(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

