/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesId;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesModificationResult;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesModificationResultListCopier;
import software.amazon.awssdk.services.ec2.model.ReservedIntancesIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReservedInstancesModification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReservedInstancesModification> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(ReservedInstancesModification.getter(ReservedInstancesModification::clientToken)).setter(ReservedInstancesModification.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("clientToken").build()}).build();
    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateDate").getter(ReservedInstancesModification.getter(ReservedInstancesModification::createDate)).setter(ReservedInstancesModification.setter(Builder::createDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").unmarshallLocationName("createDate").build()}).build();
    private static final SdkField<Instant> EFFECTIVE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EffectiveDate").getter(ReservedInstancesModification.getter(ReservedInstancesModification::effectiveDate)).setter(ReservedInstancesModification.setter(Builder::effectiveDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EffectiveDate").unmarshallLocationName("effectiveDate").build()}).build();
    private static final SdkField<List<ReservedInstancesModificationResult>> MODIFICATION_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ModificationResults").getter(ReservedInstancesModification.getter(ReservedInstancesModification::modificationResults)).setter(ReservedInstancesModification.setter(Builder::modificationResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModificationResultSet").unmarshallLocationName("modificationResultSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReservedInstancesModificationResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<ReservedInstancesId>> RESERVED_INSTANCES_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReservedInstancesIds").getter(ReservedInstancesModification.getter(ReservedInstancesModification::reservedInstancesIds)).setter(ReservedInstancesModification.setter(Builder::reservedInstancesIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstancesSet").unmarshallLocationName("reservedInstancesSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReservedInstancesId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> RESERVED_INSTANCES_MODIFICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservedInstancesModificationId").getter(ReservedInstancesModification.getter(ReservedInstancesModification::reservedInstancesModificationId)).setter(ReservedInstancesModification.setter(Builder::reservedInstancesModificationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstancesModificationId").unmarshallLocationName("reservedInstancesModificationId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ReservedInstancesModification.getter(ReservedInstancesModification::status)).setter(ReservedInstancesModification.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(ReservedInstancesModification.getter(ReservedInstancesModification::statusMessage)).setter(ReservedInstancesModification.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").unmarshallLocationName("statusMessage").build()}).build();
    private static final SdkField<Instant> UPDATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdateDate").getter(ReservedInstancesModification.getter(ReservedInstancesModification::updateDate)).setter(ReservedInstancesModification.setter(Builder::updateDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateDate").unmarshallLocationName("updateDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, CREATE_DATE_FIELD, EFFECTIVE_DATE_FIELD, MODIFICATION_RESULTS_FIELD, RESERVED_INSTANCES_IDS_FIELD, RESERVED_INSTANCES_MODIFICATION_ID_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, UPDATE_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReservedInstancesModification.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String clientToken;
    private final Instant createDate;
    private final Instant effectiveDate;
    private final List<ReservedInstancesModificationResult> modificationResults;
    private final List<ReservedInstancesId> reservedInstancesIds;
    private final String reservedInstancesModificationId;
    private final String status;
    private final String statusMessage;
    private final Instant updateDate;

    private ReservedInstancesModification(BuilderImpl builder) {
        this.clientToken = builder.clientToken;
        this.createDate = builder.createDate;
        this.effectiveDate = builder.effectiveDate;
        this.modificationResults = builder.modificationResults;
        this.reservedInstancesIds = builder.reservedInstancesIds;
        this.reservedInstancesModificationId = builder.reservedInstancesModificationId;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.updateDate = builder.updateDate;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Instant createDate() {
        return this.createDate;
    }

    public final Instant effectiveDate() {
        return this.effectiveDate;
    }

    public final boolean hasModificationResults() {
        return this.modificationResults != null && !(this.modificationResults instanceof SdkAutoConstructList);
    }

    public final List<ReservedInstancesModificationResult> modificationResults() {
        return this.modificationResults;
    }

    public final boolean hasReservedInstancesIds() {
        return this.reservedInstancesIds != null && !(this.reservedInstancesIds instanceof SdkAutoConstructList);
    }

    public final List<ReservedInstancesId> reservedInstancesIds() {
        return this.reservedInstancesIds;
    }

    public final String reservedInstancesModificationId() {
        return this.reservedInstancesModificationId;
    }

    public final String status() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final Instant updateDate() {
        return this.updateDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.effectiveDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModificationResults() ? this.modificationResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReservedInstancesIds() ? this.reservedInstancesIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedInstancesModificationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstancesModification)) {
            return false;
        }
        ReservedInstancesModification other = (ReservedInstancesModification)obj;
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.createDate(), other.createDate()) && Objects.equals(this.effectiveDate(), other.effectiveDate()) && this.hasModificationResults() == other.hasModificationResults() && Objects.equals(this.modificationResults(), other.modificationResults()) && this.hasReservedInstancesIds() == other.hasReservedInstancesIds() && Objects.equals(this.reservedInstancesIds(), other.reservedInstancesIds()) && Objects.equals(this.reservedInstancesModificationId(), other.reservedInstancesModificationId()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.updateDate(), other.updateDate());
    }

    public final String toString() {
        return ToString.builder((String)"ReservedInstancesModification").add("ClientToken", (Object)this.clientToken()).add("CreateDate", (Object)this.createDate()).add("EffectiveDate", (Object)this.effectiveDate()).add("ModificationResults", this.hasModificationResults() ? this.modificationResults() : null).add("ReservedInstancesIds", this.hasReservedInstancesIds() ? this.reservedInstancesIds() : null).add("ReservedInstancesModificationId", (Object)this.reservedInstancesModificationId()).add("Status", (Object)this.status()).add("StatusMessage", (Object)this.statusMessage()).add("UpdateDate", (Object)this.updateDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "CreateDate": {
                return Optional.ofNullable(clazz.cast(this.createDate()));
            }
            case "EffectiveDate": {
                return Optional.ofNullable(clazz.cast(this.effectiveDate()));
            }
            case "ModificationResults": {
                return Optional.ofNullable(clazz.cast(this.modificationResults()));
            }
            case "ReservedInstancesIds": {
                return Optional.ofNullable(clazz.cast(this.reservedInstancesIds()));
            }
            case "ReservedInstancesModificationId": {
                return Optional.ofNullable(clazz.cast(this.reservedInstancesModificationId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "UpdateDate": {
                return Optional.ofNullable(clazz.cast(this.updateDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("CreateDate", CREATE_DATE_FIELD);
        map.put("EffectiveDate", EFFECTIVE_DATE_FIELD);
        map.put("ModificationResultSet", MODIFICATION_RESULTS_FIELD);
        map.put("ReservedInstancesSet", RESERVED_INSTANCES_IDS_FIELD);
        map.put("ReservedInstancesModificationId", RESERVED_INSTANCES_MODIFICATION_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("UpdateDate", UPDATE_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReservedInstancesModification, T> g) {
        return obj -> g.apply((ReservedInstancesModification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clientToken;
        private Instant createDate;
        private Instant effectiveDate;
        private List<ReservedInstancesModificationResult> modificationResults = DefaultSdkAutoConstructList.getInstance();
        private List<ReservedInstancesId> reservedInstancesIds = DefaultSdkAutoConstructList.getInstance();
        private String reservedInstancesModificationId;
        private String status;
        private String statusMessage;
        private Instant updateDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstancesModification model) {
            this.clientToken(model.clientToken);
            this.createDate(model.createDate);
            this.effectiveDate(model.effectiveDate);
            this.modificationResults(model.modificationResults);
            this.reservedInstancesIds(model.reservedInstancesIds);
            this.reservedInstancesModificationId(model.reservedInstancesModificationId);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.updateDate(model.updateDate);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final Instant getEffectiveDate() {
            return this.effectiveDate;
        }

        public final void setEffectiveDate(Instant effectiveDate) {
            this.effectiveDate = effectiveDate;
        }

        @Override
        public final Builder effectiveDate(Instant effectiveDate) {
            this.effectiveDate = effectiveDate;
            return this;
        }

        public final List<ReservedInstancesModificationResult.Builder> getModificationResults() {
            List<ReservedInstancesModificationResult.Builder> result = ReservedInstancesModificationResultListCopier.copyToBuilder(this.modificationResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModificationResults(Collection<ReservedInstancesModificationResult.BuilderImpl> modificationResults) {
            this.modificationResults = ReservedInstancesModificationResultListCopier.copyFromBuilder(modificationResults);
        }

        @Override
        public final Builder modificationResults(Collection<ReservedInstancesModificationResult> modificationResults) {
            this.modificationResults = ReservedInstancesModificationResultListCopier.copy(modificationResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modificationResults(ReservedInstancesModificationResult ... modificationResults) {
            this.modificationResults(Arrays.asList(modificationResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modificationResults(Consumer<ReservedInstancesModificationResult.Builder> ... modificationResults) {
            this.modificationResults(Stream.of(modificationResults).map(c -> (ReservedInstancesModificationResult)((ReservedInstancesModificationResult.Builder)ReservedInstancesModificationResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ReservedInstancesId.Builder> getReservedInstancesIds() {
            List<ReservedInstancesId.Builder> result = ReservedIntancesIdsCopier.copyToBuilder(this.reservedInstancesIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReservedInstancesIds(Collection<ReservedInstancesId.BuilderImpl> reservedInstancesIds) {
            this.reservedInstancesIds = ReservedIntancesIdsCopier.copyFromBuilder(reservedInstancesIds);
        }

        @Override
        public final Builder reservedInstancesIds(Collection<ReservedInstancesId> reservedInstancesIds) {
            this.reservedInstancesIds = ReservedIntancesIdsCopier.copy(reservedInstancesIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesIds(ReservedInstancesId ... reservedInstancesIds) {
            this.reservedInstancesIds(Arrays.asList(reservedInstancesIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesIds(Consumer<ReservedInstancesId.Builder> ... reservedInstancesIds) {
            this.reservedInstancesIds(Stream.of(reservedInstancesIds).map(c -> (ReservedInstancesId)((ReservedInstancesId.Builder)ReservedInstancesId.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getReservedInstancesModificationId() {
            return this.reservedInstancesModificationId;
        }

        public final void setReservedInstancesModificationId(String reservedInstancesModificationId) {
            this.reservedInstancesModificationId = reservedInstancesModificationId;
        }

        @Override
        public final Builder reservedInstancesModificationId(String reservedInstancesModificationId) {
            this.reservedInstancesModificationId = reservedInstancesModificationId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Instant getUpdateDate() {
            return this.updateDate;
        }

        public final void setUpdateDate(Instant updateDate) {
            this.updateDate = updateDate;
        }

        @Override
        public final Builder updateDate(Instant updateDate) {
            this.updateDate = updateDate;
            return this;
        }

        public ReservedInstancesModification build() {
            return new ReservedInstancesModification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReservedInstancesModification> {
        public Builder clientToken(String var1);

        public Builder createDate(Instant var1);

        public Builder effectiveDate(Instant var1);

        public Builder modificationResults(Collection<ReservedInstancesModificationResult> var1);

        public Builder modificationResults(ReservedInstancesModificationResult ... var1);

        public Builder modificationResults(Consumer<ReservedInstancesModificationResult.Builder> ... var1);

        public Builder reservedInstancesIds(Collection<ReservedInstancesId> var1);

        public Builder reservedInstancesIds(ReservedInstancesId ... var1);

        public Builder reservedInstancesIds(Consumer<ReservedInstancesId.Builder> ... var1);

        public Builder reservedInstancesModificationId(String var1);

        public Builder status(String var1);

        public Builder statusMessage(String var1);

        public Builder updateDate(Instant var1);
    }
}

