/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AcceptAddressTransferResponse extends Ec2Response implements
        ToCopyableBuilder<AcceptAddressTransferResponse.Builder, AcceptAddressTransferResponse> {
    private static final SdkField<AddressTransfer> ADDRESS_TRANSFER_FIELD = SdkField
            .<AddressTransfer> builder(MarshallingType.SDK_POJO)
            .memberName("AddressTransfer")
            .getter(getter(AcceptAddressTransferResponse::addressTransfer))
            .setter(setter(Builder::addressTransfer))
            .constructor(AddressTransfer::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressTransfer")
                    .unmarshallLocationName("addressTransfer").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_TRANSFER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AddressTransfer addressTransfer;

    private AcceptAddressTransferResponse(BuilderImpl builder) {
        super(builder);
        this.addressTransfer = builder.addressTransfer;
    }

    /**
     * <p>
     * An Elastic IP address transfer.
     * </p>
     * 
     * @return An Elastic IP address transfer.
     */
    public final AddressTransfer addressTransfer() {
        return addressTransfer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(addressTransfer());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptAddressTransferResponse)) {
            return false;
        }
        AcceptAddressTransferResponse other = (AcceptAddressTransferResponse) obj;
        return Objects.equals(addressTransfer(), other.addressTransfer());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AcceptAddressTransferResponse").add("AddressTransfer", addressTransfer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AddressTransfer":
            return Optional.ofNullable(clazz.cast(addressTransfer()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AddressTransfer", ADDRESS_TRANSFER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AcceptAddressTransferResponse, T> g) {
        return obj -> g.apply((AcceptAddressTransferResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, AcceptAddressTransferResponse> {
        /**
         * <p>
         * An Elastic IP address transfer.
         * </p>
         * 
         * @param addressTransfer
         *        An Elastic IP address transfer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressTransfer(AddressTransfer addressTransfer);

        /**
         * <p>
         * An Elastic IP address transfer.
         * </p>
         * This is a convenience method that creates an instance of the {@link AddressTransfer.Builder} avoiding the
         * need to create one manually via {@link AddressTransfer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AddressTransfer.Builder#build()} is called immediately and its
         * result is passed to {@link #addressTransfer(AddressTransfer)}.
         * 
         * @param addressTransfer
         *        a consumer that will call methods on {@link AddressTransfer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addressTransfer(AddressTransfer)
         */
        default Builder addressTransfer(Consumer<AddressTransfer.Builder> addressTransfer) {
            return addressTransfer(AddressTransfer.builder().applyMutation(addressTransfer).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private AddressTransfer addressTransfer;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptAddressTransferResponse model) {
            super(model);
            addressTransfer(model.addressTransfer);
        }

        public final AddressTransfer.Builder getAddressTransfer() {
            return addressTransfer != null ? addressTransfer.toBuilder() : null;
        }

        public final void setAddressTransfer(AddressTransfer.BuilderImpl addressTransfer) {
            this.addressTransfer = addressTransfer != null ? addressTransfer.build() : null;
        }

        @Override
        public final Builder addressTransfer(AddressTransfer addressTransfer) {
            this.addressTransfer = addressTransfer;
            return this;
        }

        @Override
        public AcceptAddressTransferResponse build() {
            return new AcceptAddressTransferResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
